/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.io.FileUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMISerializer;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.project.nature.NatureUtils;

public class QVTOBuilder
extends IncrementalProjectBuilder {
    public static final String SAVE_AST_XMI = "internal.save.xmi";
    private static final List<BuildListener> ourListeners = new Vector<BuildListener>();
    private QVTOBuilderConfig myConfig;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(this.getProject().getFullPath().toString(), 1);
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            this.incrementalBuild(monitor);
        }
        QVTOBuilder.fireBuildEvent();
        monitor.worked(1);
        IProject[] projectDependencies = this.getConfig().getProjectDependencies(true);
        monitor.done();
        return projectDependencies;
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.rebuildAll(monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if ("qvto".equals(proxy.requestFullPath().getFileExtension())) {
                        proxy.requestResource().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    }
                    return false;
                }
                return true;
            }
        }, 2);
    }

    private void incrementalBuild(IProgressMonitor monitor) throws CoreException {
        boolean needsRebuild = this.hasQVTModification(this.getProject());
        if (!needsRebuild) {
            IProject[] referencedProjects = this.getConfig().getProjectDependencies(true);
            int i = 0;
            while (i < referencedProjects.length) {
                IProject refProject = referencedProjects[i];
                boolean bl = needsRebuild = !refProject.isAccessible() || this.hasQVTModification(refProject);
                if (needsRebuild) break;
                ++i;
            }
        }
        if (needsRebuild) {
            this.rebuildAll(monitor);
        }
    }

    private boolean hasQVTModification(final IProject project) throws CoreException {
        IResourceDelta delta = this.getDelta(project);
        final boolean[] rebuild = new boolean[1];
        if (delta != null) {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if ((delta.getFlags() & 0x1000) != 0 && 2 == delta.getResource().getType()) {
                        IContainer srcContainer = QVTOBuilderConfig.getConfig(project).getSourceContainer();
                        if (delta.getMovedFromPath().equals((Object)srcContainer.getFullPath())) {
                            try {
                                QVTOBuilderConfig config = QVTOBuilderConfig.getConfig(project);
                                config.setSourceContainer((IContainer)((IFolder)delta.getResource()));
                                config.save();
                            }
                            catch (CoreException e) {
                                QvtPlugin.log((IStatus)e.getStatus());
                            }
                        }
                    }
                    if (delta.getResource().getType() == 1) {
                        IPath projectRelativePath = delta.getResource().getProjectRelativePath();
                        if (".project".equals(projectRelativePath.toString()) || "plugin.xml".equals(projectRelativePath.toString()) || "META-INF/MANIFEST.MF".equals(projectRelativePath.toString())) {
                            rebuild[0] = true;
                            return false;
                        }
                        if ("qvto".equals(projectRelativePath.getFileExtension())) {
                            rebuild[0] = true;
                            return false;
                        }
                        IFile mappingsFile = MetamodelURIMappingHelper.getMappingFileHandle((IProject)project);
                        if (mappingsFile != null && mappingsFile.exists() && projectRelativePath.equals((Object)mappingsFile.getProjectRelativePath())) {
                            rebuild[0] = true;
                            return false;
                        }
                        String fileNameExt = delta.getResource().getProjectRelativePath().getFileExtension();
                        if ("ecore".equals(fileNameExt)) {
                            rebuild[0] = true;
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        return rebuild[0];
    }

    private void rebuildAll(IProgressMonitor monitor) throws CoreException {
        CompiledUnit[] units;
        IFile[] files = this.collectFiles();
        monitor.worked(1);
        try {
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setGenerateCompletionData(false);
            EclipseFile[] sources = new EclipseFile[files.length];
            int i = 0;
            while (i < sources.length) {
                sources[i] = new EclipseFile(files[i]);
                ++i;
            }
            WorkspaceUnitResolver resolver = WorkspaceUnitResolver.getResolver(this.getProject());
            QVTOCompiler compiler = new QVTOCompiler((UnitResolver)resolver);
            List allUnits = ResolverUtils.findAllUnits((UnitProvider)resolver);
            units = compiler.compile(allUnits.toArray(new UnitProxy[allUnits.size()]), options, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.shouldSaveXMI()) {
                ResourceSet metamodelResourceSet = compiler.getResourceSet();
                EPackage.Registry registry = MetamodelURIMappingHelper.mappingsToEPackageRegistry((IProject)this.getProject(), (ResourceSet)metamodelResourceSet);
                ExeXMISerializer.saveUnitXMI((CompiledUnit[])units, (EPackage.Registry)(registry != null ? registry : EPackage.Registry.INSTANCE));
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(QvtPlugin.createErrorStatus((Exception)e));
        }
        int i = 0;
        while (i < units.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            CompiledUnit nextUnit = units[i];
            URI sourceURI = nextUnit.getURI();
            IFile sourceFile = URIUtils.getFile((URI)sourceURI);
            sourceFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            List messages = nextUnit.getProblems();
            for (QvtMessage nextMessage : messages) {
                this.createQvtMarker(sourceFile, nextMessage);
            }
            ++i;
        }
    }

    private void createQvtMarker(IFile curFile, QvtMessage e) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("charStart", e.getOffset());
        attributes.put("charEnd", e.getOffset() + e.getLength());
        attributes.put("message", e.getMessage());
        attributes.put("severity", e.getSeverity());
        if (e.getLineNum() >= 0) {
            attributes.put("lineNumber", e.getLineNum());
        }
        try {
            IMarker marker = curFile.createMarker("org.eclipse.m2m.qvt.oml.project.QVTOProblem");
            marker.setAttributes(attributes);
        }
        catch (CoreException e1) {
            Logger.getLogger().log(Logger.WARNING, "QVTOBuilder: failed to create marker", e1);
        }
    }

    private QVTOBuilderConfig getConfig() throws CoreException {
        if (this.myConfig == null) {
            this.myConfig = QVTOBuilderConfig.getConfig(this.getProject());
        }
        return this.myConfig;
    }

    private IFile[] collectFiles() throws CoreException {
        final ArrayList result = new ArrayList();
        this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IContainer srcContainer = null;
        try {
            srcContainer = QVTOBuilderConfig.getConfig(this.getProject()).getSourceContainer();
        }
        catch (CoreException e) {
            QvtPlugin.log((IStatus)e.getStatus());
        }
        if (srcContainer == null || !srcContainer.exists()) {
            return new IFile[0];
        }
        srcContainer.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if (!"qvto".equals(proxy.requestFullPath().getFileExtension())) {
                        return false;
                    }
                    IFile file = (IFile)proxy.requestResource();
                    result.add(file);
                    return false;
                }
                return true;
            }
        }, 2);
        return result.toArray(new IFile[result.size()]);
    }

    public static String getFileContents(IFile file) {
        try {
            return FileUtil.getStreamContents((InputStream)file.getContents(), (String)file.getCharset());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void addBuildListener(BuildListener l) {
        ourListeners.add(l);
    }

    public static void removeBuildListener(BuildListener l) {
        ourListeners.remove(l);
    }

    private static void fireBuildEvent() {
        for (BuildListener l : ourListeners) {
            l.buildPerformed();
        }
    }

    private boolean shouldSaveXMI() {
        try {
            ICommand buildCommand = NatureUtils.findCommand(this.getProject(), "org.eclipse.m2m.qvt.oml.project.QVTOBuilder");
            if (buildCommand != null) {
                Map arguments = buildCommand.getArguments();
                Object strValue = arguments.get(SAVE_AST_XMI);
                return Boolean.valueOf(String.valueOf(strValue));
            }
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e);
        }
        return false;
    }

    public static interface BuildListener {
        public void buildPerformed();
    }
}

