/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;

public class QvtEngine {
    private static Map<IProject, QvtEngine> ourEnginesMap = new HashMap<IProject, QvtEngine>();
    private QVTOCompiler myCompiler;
    private IProject myProject;
    private final UnitResolver myImportResolver;

    public static QvtEngine getInstance(IResource resource) {
        IProject project = resource.getProject();
        QvtEngine engine = ourEnginesMap.get(project);
        if (engine == null) {
            engine = new QvtEngine(project);
        }
        return engine;
    }

    private QvtEngine(IProject project) {
        this.myProject = project;
        UnitResolverFactory resolverFactory = UnitResolverFactory.Registry.INSTANCE.getFactory((Object)this.myProject);
        this.myImportResolver = resolverFactory.getResolver(URIUtils.getResourceURI((IResource)this.myProject));
        this.reset(null);
    }

    public CompiledUnit compileUnit(UnitProxy source, QvtCompilerOptions options, Monitor monitor) throws MdaException {
        return this.myCompiler.compile(source, options, monitor);
    }

    public CompiledUnit compileUnit(UnitProxy source, Monitor monitor) throws MdaException {
        return this.myCompiler.compile(source, null, monitor);
    }

    public QVTOCompiler getQVTOCompiler() {
        return this.myCompiler;
    }

    private void reset(QvtCompilerOptions options) {
        this.myCompiler = new QVTOCompiler(this.myImportResolver);
        if (options != null) {
            this.myCompiler.getKernel().setMetamodelResourceSet(options.getMetamodelResourceSet());
        }
    }
}

