/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.AbstractGenericAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelParameterExtent {
    private static final int INITIAL_EXTENT_SIZE = 150;
    private static final int PURGE_LIMIT_SIZE = 300;
    private int myCountAddedAfterPurge = 0;
    private final List<EObject> myInitialEObjects;
    private final List<EObject> myAdditionalEObjects;
    private final ModelParameter myModelParameter;
    private final Map<EObject, EObject> myInitialObj2ContainerMap;
    private Resource myInMemoryResource;
    private ResourceSet myResourceSet;

    public ModelParameterExtent() {
        this((ResourceSet)null);
    }

    public ModelParameterExtent(ResourceSet rs) {
        this(Collections.emptyList(), rs, null);
    }

    public ModelParameterExtent(ModelParameterExtent extentToCopy) {
        this(new ArrayList<EObject>(EcoreUtil.copyAll(extentToCopy.getRootObjects())), extentToCopy.getResourceSet(), extentToCopy.getModelParameter());
    }

    public ModelParameterExtent(List<EObject> initialEObjs, ResourceSet rs, ModelParameter modelParameter) {
        this.myResourceSet = rs;
        this.myInitialEObjects = new ArrayList<EObject>(initialEObjs);
        this.myAdditionalEObjects = new ArrayList<EObject>(150);
        this.myModelParameter = modelParameter;
        if (this.isReadonly()) {
            for (EObject eObj : this.myInitialEObjects) {
                eObj.eAdapters().add((Object)new ReadonlyExtentAdapter());
            }
        }
        Map<EObject, EObject> containerMap = null;
        if (this.myInitialEObjects != null && !this.myInitialEObjects.isEmpty()) {
            for (EObject nextInitialRoot : this.myInitialEObjects) {
                if (nextInitialRoot.eContainer() == null) continue;
                if (containerMap == null) {
                    containerMap = new HashMap();
                }
                containerMap.put(nextInitialRoot, nextInitialRoot.eContainer());
            }
        }
        this.myInitialObj2ContainerMap = containerMap != null ? containerMap : Collections.emptyMap();
    }

    private Resource getInMemoryResource(boolean createOnDemand) {
        if (this.myInMemoryResource == null) {
            if (!createOnDemand) {
                return null;
            }
            this.myInMemoryResource = new ExtentResource();
            if (this.myResourceSet == null) {
                for (EObject obj : this.myInitialEObjects) {
                    if (obj.eResource() == null || obj.eResource().getResourceSet() == null) continue;
                    this.myResourceSet = obj.eResource().getResourceSet();
                    break;
                }
            }
            if (this.myResourceSet != null) {
                this.myResourceSet.getResources().add((Object)this.myInMemoryResource);
            }
        }
        return this.myInMemoryResource;
    }

    private ResourceSet getResourceSet() {
        return this.myResourceSet;
    }

    private ModelParameter getModelParameter() {
        return this.myModelParameter;
    }

    public static void throwIfReadonlyExtent(EObject eObj) {
        Adapter adapter = EcoreUtil.getAdapter((List)eObj.eAdapters(), ReadonlyExtentAdapter.class);
        if (adapter != null) {
            ModelParameter modelParameter = ((ReadonlyExtentAdapter)adapter).getModelParameterExtent().myModelParameter;
            throw new RuntimeException(NLS.bind((String)EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ReadOnlyInputModel, (Object)(String.valueOf(modelParameter.getName()) + " : " + QvtOperationalTypesUtil.getTypeFullName(modelParameter.getEType()))));
        }
    }

    public void guardAddObject(EObject eObject) {
        if (eObject != null && this.isReadonly()) {
            throw new RuntimeException(NLS.bind((String)EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ReadOnlyInputModel, (Object)(String.valueOf(this.myModelParameter.getName()) + " : " + QvtOperationalTypesUtil.getTypeFullName(this.myModelParameter.getEType()))));
        }
        this.addObject(eObject);
    }

    public void addObject(EObject eObject) {
        if (eObject != null) {
            this.myAdditionalEObjects.add(eObject);
            this.getInMemoryResource(true).getContents().add((Object)eObject);
            if (++this.myCountAddedAfterPurge == 300) {
                this.purgeContents();
                this.myCountAddedAfterPurge = 0;
            }
        }
    }

    public List<EObject> getInitialObjects() {
        return this.myInitialEObjects;
    }

    public List<EObject> getRootObjects() {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (EObject eObj : this.myInitialEObjects) {
            EObject eContainer = eObj.eContainer();
            if (eContainer != null && eContainer != this.myInitialObj2ContainerMap.get(eObj)) continue;
            objects.add(eObj);
        }
        for (EObject eObj : this.myAdditionalEObjects) {
            if (eObj.eContainer() != null) continue;
            objects.add(eObj);
        }
        return objects;
    }

    public List<Object> getAllObjects() {
        this.purgeContents();
        ArrayList<Object> objects = new ArrayList<Object>();
        ModelParameterExtent.getAllObjects(this.myInitialEObjects, objects);
        ModelParameterExtent.getAllObjects(this.myAdditionalEObjects, objects);
        return objects;
    }

    private static void getAllObjects(Collection<EObject> rootObjs, Collection<Object> result) {
        for (EObject nextRoot : rootObjs) {
            result.add(nextRoot);
            TreeIterator iterContents = EcoreUtil.getAllProperContents((EObject)nextRoot, (boolean)false);
            while (iterContents.hasNext()) {
                result.add(iterContents.next());
            }
        }
    }

    public ModelExtentContents getContents() {
        this.purgeContents();
        ArrayList<EObject> initialObjects = new ArrayList<EObject>(this.myInitialEObjects);
        ArrayList<EObject> allRootObjects = new ArrayList<EObject>(this.myAdditionalEObjects);
        allRootObjects.addAll(initialObjects);
        Resource inMemoryResource = this.getInMemoryResource(false);
        if (inMemoryResource != null) {
            for (EObject obj : inMemoryResource.getContents()) {
                if (obj.eContainer() != null || allRootObjects.contains(obj)) continue;
                allRootObjects.add(obj);
            }
        }
        for (EObject obj : allRootObjects) {
            if (!(((InternalEObject)obj).eDirectResource() instanceof ExtentResource)) continue;
            ((InternalEObject)obj).eSetResource(null, null);
        }
        return new ExtentContents(initialObjects, allRootObjects);
    }

    public boolean removeElement(EObject element) {
        this.purgeContents();
        ModelParameterExtent.delete(this.getRootObjects(), element);
        if (!this.myInitialEObjects.remove(element)) {
            this.myAdditionalEObjects.remove(element);
        }
        return true;
    }

    public String toString() {
        return this.myInitialEObjects.isEmpty() ? super.toString() : this.myInitialEObjects.toString();
    }

    public void dispose() {
        if (this.isReadonly()) {
            for (EObject eObj : this.myInitialEObjects) {
                Adapter adapter = EcoreUtil.getAdapter((List)eObj.eAdapters(), ReadonlyExtentAdapter.class);
                if (adapter == null) continue;
                eObj.eAdapters().remove((Object)adapter);
            }
        }
    }

    private boolean isReadonly() {
        return this.myModelParameter != null && this.myModelParameter.getKind() == DirectionKind.IN;
    }

    private void purgeContents() {
        this.purgeContents(this.myInitialEObjects, false);
        this.purgeContents(this.myAdditionalEObjects, true);
    }

    private void purgeContents(List<EObject> elements, boolean isResetResource) {
        ArrayList<EObject> result = null;
        for (EObject nextElement : elements) {
            EObject eContainer = nextElement.eContainer();
            if (eContainer == null || elements == this.myInitialEObjects && eContainer == this.myInitialObj2ContainerMap.get(nextElement)) {
                if (result == null) {
                    result = new ArrayList<EObject>(elements.size());
                }
                result.add(nextElement);
                continue;
            }
            InternalEObject internElement = (InternalEObject)nextElement;
            if (!isResetResource || !(internElement.eDirectResource() instanceof ExtentResource)) continue;
            internElement.eSetResource(null, null);
        }
        elements.clear();
        if (result != null) {
            elements.addAll(result);
        }
    }

    public static void delete(List<EObject> rootEObjects, EObject eObject) {
        HashSet<Object> eObjects = new HashSet<Object>();
        HashSet<InternalEObject> crossResourceEObjects = new HashSet<InternalEObject>();
        eObjects.add(eObject);
        TreeIterator j = eObject.eAllContents();
        while (j.hasNext()) {
            InternalEObject internalEObject = (InternalEObject)j.next();
            if (internalEObject.eDirectResource() != null) {
                crossResourceEObjects.add(internalEObject);
                continue;
            }
            eObjects.add(internalEObject);
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll(eObjects, rootEObjects);
        for (Map.Entry entry : usages.entrySet()) {
            EObject deletedEObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                if (eObjects.contains(setting.getEObject()) || !setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)deletedEObject);
            }
        }
        EcoreUtil.remove((EObject)eObject);
        for (EObject eObject2 : crossResourceEObjects) {
            EcoreUtil.remove((EObject)eObject2.eContainer(), (EStructuralFeature)eObject2.eContainmentFeature(), (Object)eObject2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtentContents
    implements ModelExtentContents {
        private final List<EObject> myInitialObjects;
        private final List<EObject> myRootObjects;

        private ExtentContents(List<EObject> initialObjects, List<EObject> allRootObjects) {
            this.myInitialObjects = Collections.unmodifiableList(initialObjects);
            this.myRootObjects = Collections.unmodifiableList(allRootObjects);
        }

        @Override
        public List<EObject> getInitialElements() {
            return this.myInitialObjects;
        }

        @Override
        public List<EObject> getAllRootElements() {
            return this.myRootObjects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtentResource
    extends ResourceImpl {
        private static int ourExtentId = 0;

        ExtentResource() {
            this.setURI(URI.createURI((String)("extent:/" + ++ourExtentId)));
            this.setTrackingModification(false);
        }

        public boolean eNotificationRequired() {
            return false;
        }

        public EList<EObject> getContents() {
            if (this.contents == null) {
                this.contents = new ContentsImpl();
            }
            return this.contents;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ContentsImpl
        extends ResourceImpl.ContentsEList<EObject> {
            private static final long serialVersionUID = 2958909849409879855L;

            private ContentsImpl() {
                super((ResourceImpl)ExtentResource.this);
            }

            protected boolean isUnique() {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadonlyExtentAdapter
    extends AbstractGenericAdapter<ReadonlyExtentAdapter> {
        public ModelParameterExtent getModelParameterExtent() {
            return ModelParameterExtent.this;
        }

        public boolean isAdapterForType(Object type) {
            return ReadonlyExtentAdapter.class == type;
        }

        public boolean equals(Object obj) {
            return obj instanceof ReadonlyExtentAdapter;
        }

        public int hashCode() {
            return ReadonlyExtentAdapter.class.hashCode();
        }
    }
}

