/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTExtentMap;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.IntermediatePropertyModelAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTStackTraceElement;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackTraceBuilder;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.library.EObjectEStructuralFeaturePair;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalEvaluationEnv
extends EcoreEvaluationEnvironment {
    public static final int MAX_STACK_DEPTH = 300;
    private QvtOperationalEvaluationEnv myRootEnv;
    private Internal myInternal;
    private ImperativeOperation myOperation;
    private final List<Object> myOperationArgs;
    private Object myOperationSelf;
    private final Map<String, Object> myBindings;
    private final int myStackDepth;

    protected QvtOperationalEvaluationEnv(IContext context, QvtOperationalEvaluationEnv parent) {
        super((EvaluationEnvironment)parent);
        if (parent == null) {
            this.myRootEnv = this;
            this.myInternal = new RootInternal(context);
            this.myStackDepth = 1;
        } else {
            this.myRootEnv = parent.myRootEnv;
            this.myInternal = new Internal();
            this.myStackDepth = parent.myStackDepth + 1;
        }
        this.myBindings = new HashMap<String, Object>();
        this.myOperationArgs = new ArrayList<Object>();
    }

    public QvtOperationalEvaluationEnv getRoot() {
        return this.myRootEnv;
    }

    public int getDepth() {
        return this.myStackDepth;
    }

    public ModuleInstance getThisOfType(Module module) {
        ThisInstanceResolver thisResolver = this.internalEnv().getThisResolver();
        assert (thisResolver != null);
        return thisResolver.getThisInstanceOf(module);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (InternalEvaluationEnv.class == adapterType) {
            return adapterType.cast(this.internalEnv());
        }
        return (T)super.getAdapter(adapterType);
    }

    private Internal internalEnv() {
        return this.myInternal;
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object object) {
        return new QVTExtentMap(this);
    }

    public List<Object> getOperationArgs() {
        return this.myOperationArgs;
    }

    public void setOperationSelf(Object source) {
        this.myOperationSelf = source;
    }

    public Object getOperationSelf() {
        return this.myOperationSelf;
    }

    public IContext getContext() {
        return this.internalEnv().getContext();
    }

    public boolean overrides(EOperation operation, int opcode) {
        return CallHandler.Access.hasHandler(operation);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        CallHandler callHandler = CallHandler.Access.getHandler(operation);
        if (callHandler != null) {
            if (source == null || source == this.getInvalidResult()) {
                return this.getInvalidResult();
            }
            Module targetModule = QvtOperationalParserUtil.getOwningModule(operation);
            ModuleInstance targetModuleInstance = this.getThisOfType(targetModule);
            assert (targetModuleInstance != null);
            return callHandler.invoke(targetModuleInstance, source, args, this);
        }
        return super.callOperation(operation, opcode, source, args);
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EObject eTarget;
        if (target instanceof ModuleInstance) {
            ModuleInstance moduleTarget = (ModuleInstance)target;
            target = moduleTarget.getThisInstanceOf(moduleTarget.getModule());
        }
        EStructuralFeature resolvedProperty = property;
        if (property instanceof ContextualProperty) {
            IntermediatePropertyModelAdapter.ShadowEntry shadow = IntermediatePropertyModelAdapter.getPropertyHolder((EObject)property.getEContainingClass(), (ContextualProperty)property, target);
            target = shadow.getPropertyRuntimeOwner(target);
            resolvedProperty = shadow.getProperty();
        }
        if (target instanceof Tuple && target instanceof EObject) {
            EObject etarget = (EObject)target;
            resolvedProperty = etarget.eClass().getEStructuralFeature(property.getName());
            if (resolvedProperty == null) {
                return null;
            }
        } else if (property.getEType() instanceof CollectionType && target instanceof EObject && (eTarget = (EObject)target).eClass().getEAllStructuralFeatures().contains((Object)property)) {
            return eTarget.eGet(property, true);
        }
        return super.navigateProperty(resolvedProperty, qualifiers, target);
    }

    public QvtOperationalEvaluationEnv getParent() {
        return (QvtOperationalEvaluationEnv)super.getParent();
    }

    public Object getValueOf(String name) {
        Object result = this.myBindings.get(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).value;
        }
        return result;
    }

    public EClassifier getTypeOf(String name) {
        Object result = this.myBindings.get(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).type;
        }
        return null;
    }

    public boolean isOclInvalid(Object value) {
        return this.getInvalidResult() == value;
    }

    public void copyVariableValueFrom(QvtOperationalEvaluationEnv fromEnv, String varName, String targetVarName) {
        Object sourceValue = fromEnv.getValueOf(varName);
        this.replace(targetVarName, sourceValue);
    }

    public void replace(String name, Object value) {
        this.myBindings.put(name, value);
    }

    public void replace(String name, Object value, EClassifier declaredType) {
        if (declaredType != null) {
            this.replace(name, new TypedBinding(value, declaredType));
        } else {
            this.replace(name, value);
        }
    }

    public void add(String name, Object value) {
        if ("this".equals(name)) {
            Object thisValue = value;
            if (thisValue != null && thisValue.getClass() == TypedBinding.class) {
                thisValue = ((TypedBinding)thisValue).value;
            }
            if (thisValue instanceof ModuleInstance) {
                this.internalEnv().setThisResolver((ModuleInstance)thisValue);
            }
        }
        if (this.myBindings.containsKey(name)) {
            String message = NLS.bind((String)"The name: ({0})  already has a binding: ({1})", (Object)name, (Object)this.myBindings.get(name));
            throw new IllegalArgumentException(message);
        }
        this.myBindings.put(name, value);
    }

    public void add(String name, Object value, EClassifier declaredType) {
        if (declaredType != null) {
            this.add(name, new TypedBinding(value, declaredType));
        } else {
            this.add(name, value);
        }
    }

    public Object remove(String name) {
        Object result = this.myBindings.remove(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).value;
        }
        return result;
    }

    public void clear() {
        this.myBindings.clear();
    }

    public String toString() {
        return this.myBindings.toString();
    }

    public Set<String> getNames() {
        return this.myBindings.keySet();
    }

    public boolean isKindOf(Object object, EClassifier classifier) {
        if (classifier instanceof AnyType) {
            return !(object instanceof Collection);
        }
        if (classifier == QvtOperationalStdLibrary.INSTANCE.getElementType() && object instanceof EObject) {
            return QVTUMLReflection.isUserModelElement((EClassifier)((EObject)object).eClass());
        }
        if (classifier.eClass().getEPackage() == EcorePackage.eINSTANCE && classifier.eClass().getClassifierID() == EcorePackage.eINSTANCE.getCollectionType().getClassifierID()) {
            return object instanceof Collection;
        }
        return super.isKindOf(object, classifier);
    }

    public EObject createInstance(EClassifier type, ModelParameter modelParam) {
        ModelParameterExtent targetExtent;
        EClass impl;
        if (!(type instanceof EClass)) {
            this.internalEnv().throwQVTException(new QvtRuntimeException("Expected EClass, got " + type));
        }
        if (!QvtOperationalUtil.isInstantiable(impl = (EClass)type)) {
            this.internalEnv().throwQVTException(new QvtRuntimeException("Cannot instantiate type " + impl.getName()));
        }
        EObject newObject = impl.getEPackage().getEFactoryInstance().create(impl);
        TransformationInstance mainTransfInstance = this.internalEnv().getCurrentTransformation();
        if (mainTransfInstance == null) {
            assert (modelParam == null);
            return newObject;
        }
        if (modelParam == null) {
            targetExtent = this.getDefaultInstantiationExtent((EClassifier)impl);
        } else {
            OperationalTransformation targetTransf = (OperationalTransformation)modelParam.eContainer();
            assert (targetTransf != null);
            TransformationInstance targetThis = mainTransfInstance;
            if (mainTransfInstance.getTransformation() != targetTransf) {
                targetThis = (TransformationInstance)mainTransfInstance.getThisInstanceOf(targetTransf);
            }
            ModelInstance model = targetThis.getModel(modelParam);
            assert (model != null);
            targetExtent = model.getExtent();
        }
        if (this.isReadonlyGuardEnabled()) {
            targetExtent.guardAddObject(newObject);
        } else {
            targetExtent.addObject(newObject);
        }
        return newObject;
    }

    public ModelParameterExtent getDefaultInstantiationExtent(EClassifier type) {
        TransformationInstance mainTransfInstance = this.internalEnv().getCurrentTransformation();
        if (mainTransfInstance != null) {
            EList<ModelParameter> modelParameters;
            ModelParameter modelParam;
            ModelInstance model;
            if (IntermediateClassFactory.isIntermediateClass(type)) {
                TransformationInstance.InternalTransformation internTransf = mainTransfInstance.getAdapter(TransformationInstance.InternalTransformation.class);
                ModelInstance intermExtent = internTransf.getIntermediateExtent();
                if (intermExtent != null) {
                    return intermExtent.getExtent();
                }
            } else if (QVTUMLReflection.isUserModelElement(type) && (model = mainTransfInstance.getModel(modelParam = QvtOperationalModuleEnv.findModelParameter(type, DirectionKind.OUT, modelParameters = mainTransfInstance.getTransformation().getModelParameter()))) != null) {
                return model.getExtent();
            }
        }
        return this.internalEnv().getUnboundExtent();
    }

    public void callSetter(EObject target, EStructuralFeature eStructuralFeature, Object exprValue, boolean valueIsUndefined, boolean isReset) {
        if (this.getInvalidResult() == target) {
            return;
        }
        EObject owner = target;
        if (target instanceof ModuleInstance) {
            ModuleInstance moduleTarget = (ModuleInstance)target;
            owner = moduleTarget.getThisInstanceOf(moduleTarget.getModule());
        }
        if (eStructuralFeature instanceof ContextualProperty) {
            IntermediatePropertyModelAdapter.ShadowEntry shadow = IntermediatePropertyModelAdapter.getPropertyHolder((EObject)eStructuralFeature.getEContainingClass(), (ContextualProperty)eStructuralFeature, owner);
            owner = shadow.getPropertyRuntimeOwner(owner);
            eStructuralFeature = shadow.getProperty();
        }
        if (this.isReadonlyGuardEnabled()) {
            this.checkReadonlyGuard(eStructuralFeature, exprValue, owner);
        }
        if (eStructuralFeature.getEType() instanceof CollectionType) {
            Collection currentValues = (Collection)owner.eGet(eStructuralFeature);
            if (currentValues == null) {
                CollectionType collectionType = (CollectionType)eStructuralFeature.getEType();
                currentValues = CollectionUtil.createNewCollection((CollectionKind)collectionType.getKind());
                owner.eSet(eStructuralFeature, (Object)currentValues);
            }
            if (isReset) {
                currentValues.clear();
            }
            if (exprValue instanceof Collection) {
                Collection newVal = (Collection)exprValue;
                for (Object nextElement : newVal) {
                    if (nextElement == this.getInvalidResult() || nextElement == null) continue;
                    currentValues.add(nextElement);
                }
            } else if (exprValue != this.getInvalidResult() && exprValue != null) {
                currentValues.add(exprValue);
            }
            return;
        }
        Class expectedType = eStructuralFeature.getEType().getInstanceClass();
        if (FeatureMapUtil.isMany((EObject)owner, (EStructuralFeature)eStructuralFeature)) {
            List featureValues = (List)owner.eGet(eStructuralFeature);
            if (isReset) {
                featureValues.clear();
            }
            if (exprValue instanceof Collection) {
                for (Object element : (Collection)exprValue) {
                    if (element == null) continue;
                    featureValues.add(this.ensureTypeCompatibility(element, expectedType));
                }
            } else if (!valueIsUndefined) {
                featureValues.add(this.ensureTypeCompatibility(exprValue, expectedType));
            }
        } else if (!valueIsUndefined || this.acceptsNullValue(expectedType)) {
            if (exprValue instanceof Collection) {
                for (Object element : (Collection)exprValue) {
                    if (element == null) continue;
                    owner.eSet(eStructuralFeature, this.ensureTypeCompatibility(element, expectedType));
                    break;
                }
            } else {
                owner.eSet(eStructuralFeature, this.ensureTypeCompatibility(exprValue, expectedType));
            }
        } else {
            owner.eUnset(eStructuralFeature);
        }
    }

    private boolean isReadonlyGuardEnabled() {
        return this.getContext().getSessionData() != null && this.getContext().getSessionData().getValue(QVTEvaluationOptions.FLAG_READONLY_GUARD_ENABLED) == Boolean.TRUE;
    }

    private void checkReadonlyGuard(EStructuralFeature eStructuralFeature, Object exprValue, EObject owner) {
        EObject auxParent = owner;
        while (auxParent != null) {
            ModelParameterExtent.throwIfReadonlyExtent(auxParent);
            auxParent = auxParent.eContainer();
        }
        if (eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment()) {
            ArrayList<EObject> assignedObjects = new ArrayList<EObject>();
            if (exprValue instanceof EObject) {
                assignedObjects.add((EObject)exprValue);
            } else if (exprValue instanceof Collection) {
                for (Object element : (Collection)exprValue) {
                    if (!(element instanceof EObject)) continue;
                    assignedObjects.add((EObject)element);
                }
            }
            Iterator iterator = assignedObjects.iterator();
            while (iterator.hasNext()) {
                EObject eObj;
                auxParent = eObj = (EObject)iterator.next();
                while (auxParent != null) {
                    ModelParameterExtent.throwIfReadonlyExtent(auxParent);
                    auxParent = auxParent.eContainer();
                }
            }
        }
    }

    private Object ensureTypeCompatibility(Object value, Class<?> expectedType) {
        if ((expectedType == Double.class || expectedType == Double.TYPE) && value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value == QvtOperationalUtil.getOclInvalid()) {
            return null;
        }
        if (expectedType != null) {
            return NumberConversions.convertNumber(value, expectedType);
        }
        return value;
    }

    private boolean acceptsNullValue(Class<?> type) {
        if (type == null) {
            return true;
        }
        return !type.isPrimitive();
    }

    public QvtOperationalEvaluationEnv cloneEvaluationEnv() {
        QvtOperationalEvaluationEnv env = new QvtOperationalEvaluationEnv(this.getContext(), this.getParent());
        return this.copyEnv(env);
    }

    public QvtOperationalEvaluationEnv createDeferredExecutionEnvironment() {
        QvtOperationalEvaluationEnv parent;
        parent = this.getRoot() == this ? (parent = null) : this.getRoot();
        QvtOperationalEvaluationEnv result = new QvtOperationalEvaluationEnv(this.getContext(), parent);
        return this.copyEnv(result);
    }

    private QvtOperationalEvaluationEnv copyEnv(QvtOperationalEvaluationEnv env) {
        env.myInternal = this.internalEnv().clone();
        env.myOperationArgs.addAll(this.myOperationArgs);
        env.myOperationSelf = this.myOperationSelf;
        env.myOperation = this.myOperation;
        env.myBindings.putAll(this.myBindings);
        return env;
    }

    public void setOperation(ImperativeOperation myOperation) {
        this.myOperation = myOperation;
    }

    public ImperativeOperation getOperation() {
        return this.myOperation;
    }

    private void saveThrownException(QvtRuntimeException exception) {
        assert (exception != null);
        QvtOperationalEvaluationEnv rootEnv = this.getRoot();
        Internal internRootEnv = rootEnv.internalEnv();
        assert (internRootEnv instanceof RootInternal) : "Internal env of root evaluation env must be RootInternal";
        RootInternal root = (RootInternal)internRootEnv;
        root.myException = exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Internal
    implements InternalEvaluationEnv {
        private ThisInstanceResolver myThisResolver;
        private EObject myCurrentIP;

        Internal() {
        }

        Internal(Internal another) {
            this();
            this.myThisResolver = another.myThisResolver;
            this.myCurrentIP = another.myCurrentIP;
        }

        IContext getContext() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getContext();
        }

        public Internal clone() {
            return new Internal(this);
        }

        @Override
        public QvtRuntimeException getException() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getException();
        }

        @Override
        public void setException(QvtRuntimeException exception) {
            QvtOperationalEvaluationEnv.this.saveThrownException(exception);
        }

        @Override
        public TransformationInstance getCurrentTransformation() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getCurrentTransformation();
        }

        @Override
        public ModuleInstance getCurrentModule() {
            return this.myThisResolver instanceof ModuleInstance ? (ModuleInstance)this.myThisResolver : null;
        }

        @Override
        public ModelParameterExtent getUnboundExtent() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getUnboundExtent();
        }

        @Override
        public void setThisResolver(ThisInstanceResolver thisResolver) {
            this.myThisResolver = thisResolver;
        }

        @Override
        public ThisInstanceResolver getThisResolver() {
            return this.myThisResolver;
        }

        @Override
        public Object getInvalid() {
            return QvtOperationalEvaluationEnv.this.getInvalidResult();
        }

        @Override
        public EObjectEStructuralFeaturePair getLastAssignmentLvalueEval() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getLastAssignmentLvalueEval();
        }

        @Override
        public void setLastAssignmentLvalueEval(EObjectEStructuralFeaturePair lvalue) {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().setLastAssignmentLvalueEval(lvalue);
        }

        @Override
        public void processDeferredTasks() {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().processDeferredTasks();
        }

        @Override
        public boolean isDeferredExecution() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().isDeferredExecution();
        }

        @Override
        public void addDeferredTask(Runnable task) {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().addDeferredTask(task);
        }

        @Override
        public Trace getTraces() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getTraces();
        }

        @Override
        public EObject setCurrentIP(EObject currentIPObject) {
            EObject prevValue = this.myCurrentIP;
            this.myCurrentIP = currentIPObject;
            return prevValue;
        }

        @Override
        public EObject getCurrentIP() {
            return this.myCurrentIP;
        }

        @Override
        public void throwQVTException(QvtRuntimeException exception) throws QvtRuntimeException {
            try {
                QvtOperationalEvaluationEnv.this.saveThrownException(exception);
                exception.setStackQvtTrace(this.getStackTraceElements());
            }
            catch (Exception e) {
                QvtPlugin.log(QvtPlugin.createErrorStatus("Failed to build QVT stack trace", e));
            }
            throw exception;
        }

        @Override
        public List<QVTStackTraceElement> getStackTraceElements() {
            return new QvtStackTraceBuilder(QvtOperationalEvaluationEnv.this).buildStackTrace();
        }
    }

    private class RootInternal
    extends Internal {
        private IContext myContext;
        private List<Runnable> myDeferredTasks;
        private EObjectEStructuralFeaturePair myLastAssignLvalue;
        private ModelParameterExtent myUnboundExtent;
        private TransformationInstance myThisTransformation;
        private boolean myIsDefferedExecution;
        private QvtRuntimeException myException;
        private Trace myTraces;

        RootInternal(IContext context) {
            assert (context != null);
            this.myContext = context;
            this.myIsDefferedExecution = false;
            this.myTraces = TraceFactory.eINSTANCE.createTrace();
        }

        RootInternal(RootInternal another) {
            super(another);
            this.myLastAssignLvalue = another.myLastAssignLvalue;
            this.myDeferredTasks = another.myDeferredTasks;
            this.myContext = another.myContext;
            this.myUnboundExtent = another.myUnboundExtent;
            this.myThisTransformation = another.myThisTransformation;
            this.myIsDefferedExecution = another.myIsDefferedExecution;
            this.myException = another.myException;
        }

        IContext getContext() {
            return this.myContext;
        }

        public QvtRuntimeException getException() {
            return this.myException;
        }

        public TransformationInstance getCurrentTransformation() {
            return this.myThisTransformation;
        }

        public void setThisResolver(ThisInstanceResolver thisResolver) {
            if (thisResolver instanceof TransformationInstance) {
                this.myThisTransformation = (TransformationInstance)thisResolver;
            }
            super.setThisResolver(thisResolver);
        }

        public Internal clone() {
            return new RootInternal(this);
        }

        public ModelParameterExtent getUnboundExtent() {
            if (this.myUnboundExtent == null) {
                this.myUnboundExtent = new ModelParameterExtent();
            }
            return this.myUnboundExtent;
        }

        public void addDeferredTask(Runnable task) {
            if (this.myDeferredTasks == null) {
                this.myDeferredTasks = new ArrayList<Runnable>();
            }
            this.myDeferredTasks.add(task);
        }

        public EObjectEStructuralFeaturePair getLastAssignmentLvalueEval() {
            return this.myLastAssignLvalue;
        }

        public void setLastAssignmentLvalueEval(EObjectEStructuralFeaturePair lvalue) {
            this.myLastAssignLvalue = lvalue;
        }

        public void processDeferredTasks() {
            if (this.myDeferredTasks != null) {
                try {
                    this.myIsDefferedExecution = true;
                    ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
                    for (Runnable task : tasksCopy) {
                        task.run();
                    }
                }
                finally {
                    this.myIsDefferedExecution = false;
                }
            }
        }

        public boolean isDeferredExecution() {
            return this.myIsDefferedExecution;
        }

        public Trace getTraces() {
            return this.myTraces;
        }
    }

    private static class TypedBinding {
        final Object value;
        final EClassifier type;

        private TypedBinding(Object value, EClassifier type) {
            this.value = value;
            this.type = type;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.type != null) {
                buf.append(this.type).append(" : ");
            }
            buf.append(this.value);
            return buf.toString();
        }
    }
}

