/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNode;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNodeAccess;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.BasicLineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMIExtensionEncoder;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.osgi.util.NLS;

class DefaultExtensionDecoder
implements ExeXMIExtensionEncoder {
    private static final String OFFSET_DELIMITER = ",";
    private static final NodeHelper AST_HELPER = new ASTNodeHelper();
    private static final NodeHelper AST_SYNTHETIC_HELPER = new SyntheticNodeHelper();
    private static final Set<EClass> synteticASTTypes = new HashSet<EClass>(Arrays.asList(EcorePackage.eINSTANCE.getEAttribute(), EcorePackage.eINSTANCE.getEReference(), EcorePackage.eINSTANCE.getEClass(), ExpressionsPackage.eINSTANCE.getLibrary(), ExpressionsPackage.eINSTANCE.getOperationalTransformation(), ExpressionsPackage.eINSTANCE.getContextualProperty()));

    DefaultExtensionDecoder() {
    }

    public void decodeASTNodeOffsets(Resource res, String data) throws ExeXMIExtensionEncoder.CorruptedExtensionData {
        StringTokenizer tokenizer = new StringTokenizer(data, OFFSET_DELIMITER);
        TreeIterator nextRootContentsIt = res.getAllContents();
        int prevStartPos = 0;
        while (nextRootContentsIt.hasNext()) {
            EObject next = (EObject)nextRootContentsIt.next();
            NodeHelper nodeHelper = DefaultExtensionDecoder.getNodeHelper(next, false);
            if (nodeHelper == null) continue;
            int startPos = -1;
            int endPos = -1;
            int i = 0;
            while (i < 2) {
                block11: {
                    block8: {
                        int nextInt;
                        String nextToken;
                        int sign;
                        block10: {
                            char firstChar;
                            block9: {
                                sign = 1;
                                if (!tokenizer.hasMoreTokens()) break block8;
                                nextToken = tokenizer.nextToken();
                                firstChar = nextToken.charAt(0);
                                if (firstChar != '-') break block9;
                                nextToken = nextToken.substring(1);
                                sign = -1;
                                break block10;
                            }
                            if (firstChar == '.') break block11;
                        }
                        try {
                            nextInt = sign * Integer.parseInt(nextToken, 16) + prevStartPos;
                        }
                        catch (NumberFormatException e) {
                            throw new ExeXMIExtensionEncoder.CorruptedExtensionData(NLS.bind((String)"Invalid offset format ({0})", (Object)e.toString()));
                        }
                        if (i == 0) {
                            startPos = nextInt;
                            prevStartPos = nextInt;
                        } else {
                            endPos = nextInt;
                        }
                        break block11;
                    }
                    throw new ExeXMIExtensionEncoder.CorruptedExtensionData("Missing offset data for existing AST Node");
                }
                ++i;
            }
            if (startPos < 0 || endPos < 0) continue;
            nodeHelper.setPositions(next, startPos, endPos);
        }
        if (tokenizer.hasMoreTokens()) {
            throw new ExeXMIExtensionEncoder.CorruptedExtensionData("Too many offsets data existing AST Nodes");
        }
    }

    public String encodeASTNodeOffsets(Resource res) {
        StringBuilder buf = new StringBuilder(1024);
        int prevStartPos = 0;
        int count = 0;
        int[] startEndPositions = new int[2];
        TreeIterator nextRootContentsIt = res.getAllContents();
        while (nextRootContentsIt.hasNext()) {
            EObject next = (EObject)nextRootContentsIt.next();
            NodeHelper nodeHelper = DefaultExtensionDecoder.getNodeHelper(next, true);
            if (nodeHelper == null) continue;
            if (count > 0) {
                buf.append(OFFSET_DELIMITER);
            }
            nodeHelper.getPositions(next, startEndPositions);
            int startPos = startEndPositions[0];
            int endPos = startEndPositions[1];
            if (startPos >= 0 && endPos >= 0) {
                int len = endPos - startPos;
                int prevOffsetDelta = startPos - prevStartPos;
                this.encodeInt(prevOffsetDelta, buf);
                buf.append(OFFSET_DELIMITER);
                this.encodeInt(len, buf);
                prevStartPos = startPos;
            } else {
                buf.append('.').append(OFFSET_DELIMITER).append('.');
            }
            ++count;
        }
        return buf.toString();
    }

    public int[] decodeLineBreakOffsets(String encodedOffsetData) throws ExeXMIExtensionEncoder.CorruptedExtensionData {
        StringTokenizer tokenizer = new StringTokenizer(encodedOffsetData, OFFSET_DELIMITER);
        int[] result = null;
        int i = 0;
        int prevOffset = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (result == null) {
                int count;
                try {
                    count = Integer.parseInt(nextToken, 16);
                }
                catch (NumberFormatException e) {
                    throw new ExeXMIExtensionEncoder.CorruptedExtensionData(NLS.bind((String)"Invalid offset format ({0})", (Object)e.toString()));
                }
                result = new int[count];
                continue;
            }
            int nextOffset = Integer.parseInt(nextToken, 16);
            result[i++] = prevOffset + nextOffset;
            prevOffset = nextOffset;
        }
        return result;
    }

    public String encodeLineBreakOffsets(Resource res) {
        int[] lineOffsets = null;
        for (EObject nextRoot : res.getContents()) {
            LineNumberProvider lineNumProvider;
            IModuleSourceInfo srcInfo;
            if (!(nextRoot instanceof Module) || (srcInfo = ASTBindingHelper.getModuleSourceBinding((Module)nextRoot)) == null || !((lineNumProvider = srcInfo.getLineNumberProvider()) instanceof BasicLineNumberProvider)) continue;
            BasicLineNumberProvider basicProvider = (BasicLineNumberProvider)lineNumProvider;
            lineOffsets = basicProvider.lineBreakOffsets();
        }
        if (lineOffsets == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append(Integer.toHexString(lineOffsets.length)).append(OFFSET_DELIMITER);
        int count = 0;
        int prevOffset = 0;
        int[] nArray = lineOffsets;
        int n = lineOffsets.length;
        int n2 = 0;
        while (n2 < n) {
            int offset = nArray[n2];
            if (count > 0) {
                buf.append(OFFSET_DELIMITER);
            }
            buf.append(Integer.toHexString(offset -= prevOffset));
            prevOffset = offset;
            ++count;
            ++n2;
        }
        return buf.toString();
    }

    private static NodeHelper getNodeHelper(EObject astElement, boolean encodingPhase) {
        if (astElement instanceof ASTNode) {
            return AST_HELPER;
        }
        if (synteticASTTypes.contains(astElement.eClass())) {
            if (ASTSyntheticNodeAccess.getASTNode(astElement) == null) {
                ASTSyntheticNodeAccess.createASTNode(astElement);
            }
            return AST_SYNTHETIC_HELPER;
        }
        return null;
    }

    private void encodeInt(int value, StringBuilder buf) {
        if (value < 0) {
            buf.append('-');
            value = -value;
        }
        buf.append(Integer.toHexString(value));
    }

    private static class ASTNodeHelper
    implements NodeHelper {
        private ASTNodeHelper() {
        }

        public Character getPrefixChar() {
            return null;
        }

        public void getPositions(EObject node, int[] startEndPositions) {
            ASTNode astNode = (ASTNode)node;
            startEndPositions[0] = astNode.getStartPosition();
            startEndPositions[1] = astNode.getEndPosition();
        }

        public void setPositions(EObject node, int startPos, int endPos) {
            ASTNode astNode = (ASTNode)node;
            astNode.setStartPosition(startPos);
            astNode.setEndPosition(endPos);
        }
    }

    private static interface NodeHelper {
        public Character getPrefixChar();

        public void setPositions(EObject var1, int var2, int var3);

        public void getPositions(EObject var1, int[] var2);
    }

    private static class SyntheticNodeHelper
    implements NodeHelper {
        static final Character PREFIX = new Character('+');

        private SyntheticNodeHelper() {
        }

        public Character getPrefixChar() {
            return PREFIX;
        }

        public void getPositions(EObject node, int[] startEndPositions) {
            ASTSyntheticNode syntheticNode = ASTSyntheticNodeAccess.getASTNode(node);
            startEndPositions[0] = syntheticNode.getStartPosition();
            startEndPositions[1] = syntheticNode.getEndPosition();
        }

        public void setPositions(EObject node, int startPos, int endPos) {
            ASTSyntheticNode syntheticNode = ASTSyntheticNodeAccess.getASTNode(node);
            syntheticNode.setStartPosition(startPos);
            syntheticNode.setEndPosition(endPos);
        }
    }
}

