/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTParsingOptions;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExternalUnitElementsProvider;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParser;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalValidationVisitor;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.WorkspaceMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.BasicLineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.EPackageRegistryBasedURIResourceMap;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMISerializer;
import org.eclipse.m2m.internal.qvt.oml.compiler.LegacyResolverSupport;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerKernel;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLexer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTOCompiler {
    private static final String NAMESPACE_SEP = String.valueOf('.');
    private final Map<URI, CompiledUnit> fSource2Compiled = new HashMap<URI, CompiledUnit>();
    private final Stack<DependencyPathElement> fDependencyWalkPath = new Stack();
    private final UnitResolver fUnitResolver;
    private final QvtCompilerKernel myKernel;
    private final ResourceSet resourceSet;
    private ResourceSetImpl fExeXMIResourceSet;
    private boolean fUseCompiledXMI = false;

    public static QVTOCompiler createCompilerWithHistory(UnitResolver importResolver, ResourceSet metamodelResourceSet) {
        return new QVTOCompiler(importResolver, metamodelResourceSet){

            protected void afterCompileCleanup() {
            }

            public void cleanup() {
                super.cleanup();
                this.afterCompileCleanup();
            }
        };
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIResourceMap((Map)new EPackageRegistryBasedURIResourceMap(resourceSet.getURIConverter()));
        return resourceSet;
    }

    public QVTOCompiler(UnitResolver unitResolver, IMetamodelRegistryProvider metamodelRegistryProvider) {
        Map uriResourceMap;
        this.fUnitResolver = unitResolver;
        this.myKernel = new QvtCompilerKernel(metamodelRegistryProvider);
        this.resourceSet = metamodelRegistryProvider instanceof WorkspaceMetamodelRegistryProvider ? ((WorkspaceMetamodelRegistryProvider)metamodelRegistryProvider).getResolutionResourceSet() : new ResourceSetImpl();
        this.fExeXMIResourceSet = CompiledUnit.createResourceSet();
        if (this.getResourceSet() instanceof ResourceSetImpl && (uriResourceMap = ((ResourceSetImpl)this.getResourceSet()).getURIResourceMap()) != null) {
            this.fExeXMIResourceSet.setURIResourceMap(new HashMap(uriResourceMap));
        }
    }

    public QVTOCompiler(UnitResolver importResolver) {
        this(importResolver, (IMetamodelRegistryProvider)new WorkspaceMetamodelRegistryProvider(QVTOCompiler.createResourceSet()));
    }

    public QVTOCompiler(UnitResolver importResolver, ResourceSet metamodelResourceSet) {
        this(importResolver, (IMetamodelRegistryProvider)(metamodelResourceSet != null ? new WorkspaceMetamodelRegistryProvider(metamodelResourceSet) : new WorkspaceMetamodelRegistryProvider()));
    }

    public void setUseCompiledXMI(boolean flag) {
        this.fUseCompiledXMI = flag;
    }

    public CompiledUnit[] compile(UnitProxy[] sources, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        if (options == null) {
            options = this.getDefaultOptions();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CompiledUnit[] result = new CompiledUnit[sources.length];
        try {
            monitor.beginTask("", sources.length);
            int i = 0;
            UnitProxy[] unitProxyArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                UnitProxy nextSource = unitProxyArray[n2];
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.setTaskName(nextSource.getURI().toString());
                result[i++] = this.compileSingleFile(nextSource, options, monitor);
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            this.fDependencyWalkPath.clear();
            this.afterCompileCleanup();
            monitor.done();
        }
        return result;
    }

    public CompiledUnit compile(String qualifiedName, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        UnitProxy unit = this.getImportResolver().resolveUnit(qualifiedName);
        if (unit == null) {
            throw new MdaException("Unresolved unit: " + qualifiedName);
        }
        return this.compile(unit, options, monitor);
    }

    public CompiledUnit compile(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (options == null) {
            options = this.getDefaultOptions();
        }
        try {
            CompiledUnit compiledUnit = this.compileSingleFile(source, options, monitor);
            return compiledUnit;
        }
        finally {
            this.fDependencyWalkPath.clear();
            this.afterCompileCleanup();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CSTParseResult parse(UnitProxy source, QvtCompilerOptions options) throws ParserException {
        CSTParseResult cSTParseResult;
        Reader reader = null;
        UnitCS unitCS = null;
        try {
            reader = this.createReader(source);
            QvtOperationalFileEnv env = new QvtOperationalEnvFactory().createEnvironment(source.getURI(), this.myKernel);
            if (options.isEnableCSTModelToken()) {
                env.setOption(QVTParsingOptions.ENABLE_CSTMODEL_TOKENS, true);
            }
            QvtOperationalParser qvtParser = new QvtOperationalParser();
            unitCS = qvtParser.parse(reader, source.getName(), env);
            CSTParseResult result = new CSTParseResult();
            result.unitCS = unitCS;
            result.env = env;
            result.parser = qvtParser.getParser();
            cSTParseResult = result;
            if (reader == null) return cSTParseResult;
        }
        catch (IOException e) {
            try {
                String ioErrorMessage = NLS.bind((String)CompilerMessages.sourceReadingIOError, (Object)source.getURI());
                throw new ParserException(ioErrorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            reader.close();
            return cSTParseResult;
        }
        catch (IOException iOException) {}
        return cSTParseResult;
    }

    public static Reader getContentReader(UnitProxy unit) throws IOException {
        UnitContents contents = unit.getContents();
        if (!(contents instanceof UnitContents.CSTContents)) {
            throw new IllegalArgumentException("unit has no CST stream");
        }
        UnitContents.CSTContents cst = (UnitContents.CSTContents)contents;
        return cst.getContents();
    }

    protected Reader createReader(UnitProxy unit) throws IOException {
        return QVTOCompiler.getContentReader(unit);
    }

    protected CSTAnalysisResult analyze(CSTParseResult parseResult, ExternalUnitElementsProvider externalUnitElementsProvider, QvtCompilerOptions options) {
        QvtOperationalFileEnv env = parseResult.env;
        env.setQvtCompilerOptions(options);
        CSTAnalysisResult result = new CSTAnalysisResult();
        try {
            QvtOperationalVisitorCS visitor = this.createAnalyzer(parseResult.parser, options);
            UnitCS unitCS = parseResult.unitCS;
            if (!unitCS.getModules().isEmpty()) {
                MappingModuleCS topModuleCS = (MappingModuleCS)unitCS.getModules().get(0);
                Module module = visitor.visitMappingModule(topModuleCS, externalUnitElementsProvider.getImporter(), env, externalUnitElementsProvider, this.getResourceSet());
                result.modules = Collections.singletonList(module);
            }
        }
        catch (SemanticException e) {
            env.reportError(e.getLocalizedMessage(), 0, 0);
        }
        if (result.modules != null) {
            for (Module nextModule : result.modules) {
                if (!options.isReportErrors()) continue;
                env.setCheckForDuplicateErrors(true);
                QvtOperationalValidationVisitor validation = new QvtOperationalValidationVisitor(env);
                validation.visitModule(nextModule);
                env.setCheckForDuplicateErrors(false);
            }
        }
        return result;
    }

    protected QvtOperationalVisitorCS createAnalyzer(AbstractQVTParser parser, QvtCompilerOptions options) {
        return new QvtOperationalVisitorCS(parser, options);
    }

    protected UnitResolver getImportResolver() {
        return this.fUnitResolver;
    }

    protected void afterCompileCleanup() {
        this.fSource2Compiled.clear();
        this.fDependencyWalkPath.clear();
        this.fExeXMIResourceSet.getResources().clear();
    }

    protected void onCompilationUnitFinished(CompiledUnit unit) {
    }

    private CompiledUnit compileSingleFile(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        CompiledUnit nextResult = null;
        try {
            nextResult = this.doCompile(source, options, monitor);
        }
        catch (ParserException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new MdaException(cause.getMessage(), cause);
        }
        catch (IOException e) {
            throw new MdaException(e.getMessage(), (Throwable)e);
        }
        return nextResult;
    }

    private CompiledUnit doCompile(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws ParserException, IOException {
        if (this.fSource2Compiled.containsKey(source.getURI())) {
            return this.fSource2Compiled.get(source.getURI());
        }
        monitor = new SubProgressMonitor(monitor, 1);
        monitor.beginTask(source.getURI().toString(), 3);
        List compiledImports = null;
        DependencyPathElement dependencyElement = new DependencyPathElement(source);
        try {
            CompiledUnit binXMIUnit;
            this.fDependencyWalkPath.push(dependencyElement);
            if (this.fUseCompiledXMI && (binXMIUnit = this.getCompiledExeXMIUnit(source)) != null) {
                this.fSource2Compiled.put(source.getURI(), binXMIUnit);
                CompiledUnit compiledUnit = binXMIUnit;
                return compiledUnit;
            }
            if (source.getContentType() != 0) {
                CompiledUnit loadBlackboxUnit = this.loadBlackboxUnit(source);
                this.fSource2Compiled.put(source.getURI(), loadBlackboxUnit);
                monitor.worked(1);
                CompiledUnit compiledUnit = loadBlackboxUnit;
                return compiledUnit;
            }
            CSTParseResult parseResult = this.parse(source, options);
            monitor.worked(1);
            QvtOperationalFileEnv env = parseResult.env;
            dependencyElement.importerEnv = env;
            UnitCS unitCS = parseResult.unitCS;
            UnitResolverImpl unitResolver = new UnitResolverImpl(source);
            List<ImportCS> allUnitImportsCS = parseResult.getImports();
            for (ImportCS nextImportCS : allUnitImportsCS) {
                String importQNameStr = QVTOCompiler.getQualifiedName(nextImportCS);
                if (importQNameStr == null || importQNameStr.length() == 0) continue;
                EList importedUnitQName = nextImportCS.getPathNameCS().getSequenceOfNames();
                UnitProxy importedUnit = this.resolveImportedUnit(source, importQNameStr);
                CompiledUnit compiledImport = null;
                if (importedUnit != null) {
                    dependencyElement.currentProcessedImport = nextImportCS;
                    DependencyPathElement importerDependencyElement = this.findDependencyElement(importedUnit);
                    if (importerDependencyElement != null) {
                        ImportCS importedCS = importerDependencyElement.currentProcessedImport;
                        if (env != importerDependencyElement.importerEnv) {
                            QVTOCompiler.reportCyclicImportError(nextImportCS, importedCS, importerDependencyElement.importerEnv);
                        }
                        QVTOCompiler.reportCyclicImportError(importedCS, nextImportCS, env);
                        continue;
                    }
                    compiledImport = this.doCompile(importedUnit, options, monitor);
                } else {
                    String notFoundMessage = NLS.bind((String)CompilerMessages.importedCompilationUnitNotFound, (Object)QvtOperationalParserUtil.getStringRepresentation(nextImportCS.getPathNameCS(), NAMESPACE_SEP));
                    env.reportError(notFoundMessage, (CSTNode)nextImportCS.getPathNameCS());
                }
                if (compiledImport == null) continue;
                if (!compiledImport.getErrors().isEmpty()) {
                    if (importedUnit.getContentType() == 0) {
                        String errorInImportMessage = NLS.bind((String)CompilerMessages.importHasCompilationError, (Object)QvtOperationalParserUtil.getStringRepresentation(nextImportCS.getPathNameCS()));
                        env.reportError(errorInImportMessage, (CSTNode)nextImportCS.getPathNameCS());
                    } else {
                        String rootMessage = compiledImport.getErrors().get(0).getMessage();
                        env.reportError(rootMessage, (CSTNode)nextImportCS.getPathNameCS());
                    }
                }
                if (compiledImports == null) {
                    compiledImports = new UniqueEList();
                }
                compiledImports.add(compiledImport);
                unitResolver.addUnit((List<String>)importedUnitQName, compiledImport);
            }
            monitor.worked(1);
            CSTAnalysisResult analysisResult = this.analyze(parseResult, unitResolver, options);
            if (options.isSourceLineNumbersEnabled()) {
                this.addSourceLineNumberInfo(parseResult.parser, analysisResult, source);
            }
            this.checkForDupImports(allUnitImportsCS, env);
            env.close();
            CompiledUnit result = this.createCompiledUnit(source, env);
            result.fUnitCST = unitCS;
            if (compiledImports != null) {
                result.setImports(compiledImports);
            }
            this.fSource2Compiled.put(source.getURI(), result);
            if (result.getURI().isPlatformResource()) {
                this.onCompilationUnitFinished(result);
            }
            monitor.worked(1);
            CompiledUnit compiledUnit = result;
            return compiledUnit;
        }
        finally {
            this.fDependencyWalkPath.pop();
            monitor.done();
        }
    }

    private CompiledUnit getCompiledExeXMIUnit(UnitProxy source) {
        URI xmiURI = ExeXMISerializer.toXMIUnitURI(source.getURI());
        if (URIConverter.INSTANCE.exists(xmiURI, null)) {
            Long srcTStamp = (Long)URIConverter.INSTANCE.getAttributes(source.getURI(), null).get("timeStamp");
            Long binTStamp = (Long)URIConverter.INSTANCE.getAttributes(xmiURI, null).get("timeStamp");
            if (binTStamp == null || srcTStamp != null && binTStamp.equals(srcTStamp)) {
                return new CompiledUnit(this.fExeXMIResourceSet.getResource(xmiURI, true), this.fSource2Compiled);
            }
        }
        return null;
    }

    private CompiledUnit createCompiledUnit(UnitProxy unit, QvtOperationalFileEnv env) {
        Resource resource = env.getTypeResolver().getResource();
        resource.setURI(ExeXMISerializer.toXMIUnitURI(unit.getURI()));
        this.fExeXMIResourceSet.getResources().add((Object)resource);
        List<String> qualifiedName = QVTOCompiler.getQualifiedNameSegments(unit);
        return new CompiledUnit(qualifiedName, unit.getURI(), Collections.singletonList(env));
    }

    private static List<String> getQualifiedNameSegments(UnitProxy unit) {
        List<String> qualifiedName = null;
        String namespace = unit.getNamespace();
        if (namespace != null) {
            String[] segments = ResolverUtils.getNameSegments(namespace);
            qualifiedName = new ArrayList<String>(segments.length + 1);
            qualifiedName.addAll(Arrays.asList(segments));
            qualifiedName.add(unit.getName());
        } else {
            qualifiedName = Collections.singletonList(unit.getName());
        }
        return qualifiedName;
    }

    public QvtCompilerKernel getKernel() {
        return this.myKernel;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void cleanup() {
        for (Resource res : this.getResourceSet().getResources()) {
            res.unload();
        }
    }

    private void addSourceLineNumberInfo(AbstractQVTParser parser, CSTAnalysisResult analysisResult, UnitProxy source) {
        URI sourceURI;
        QvtOpLexer lexer = parser.getLexer();
        if (lexer != null && (sourceURI = source.getURI()) != null && analysisResult.modules != null) {
            for (Module module : analysisResult.modules) {
                ASTBindingHelper.createModuleSourceBinding((EObject)module, sourceURI, new BasicLineNumberProvider(lexer));
            }
        }
    }

    private static String getQualifiedName(ImportCS importCS) {
        if (importCS.getPathNameCS() != null) {
            EList sequenceOfNames = importCS.getPathNameCS().getSequenceOfNames();
            return QvtOperationalParserUtil.getStringRepresentation((List<String>)sequenceOfNames, NAMESPACE_SEP);
        }
        return null;
    }

    private CompiledUnit loadBlackboxUnit(UnitProxy unit) throws IOException {
        UnitContents.ModelContents contents = (UnitContents.ModelContents)unit.getContents();
        List<EObject> topElements = contents.loadElements(this.getResourceSet().getPackageRegistry());
        ArrayList<QvtOperationalModuleEnv> modelEnvs = new ArrayList<QvtOperationalModuleEnv>(topElements.size());
        for (EObject nextElement : topElements) {
            QvtOperationalModuleEnv nextEnv = ASTBindingHelper.getEnvironment(nextElement, QvtOperationalModuleEnv.class);
            if (nextEnv == null) continue;
            nextEnv.clearProblems();
            modelEnvs.add(nextEnv);
        }
        CompiledUnit compiledUnit = new CompiledUnit(QVTOCompiler.getQualifiedNameSegments(unit), unit.getURI(), modelEnvs);
        Diagnostic loadProblems = contents.getProblems();
        if (loadProblems != null) {
            compiledUnit.addProblem(new QvtMessage(loadProblems.getMessage()));
        }
        return compiledUnit;
    }

    private QvtCompilerOptions getDefaultOptions() {
        QvtCompilerOptions options = new QvtCompilerOptions();
        options.setGenerateCompletionData(false);
        return options;
    }

    private UnitProxy resolveImportedUnit(UnitProxy importingUnit, String unitQualifiedName) {
        String namespace;
        UnitResolver resolver = importingUnit.getResolver();
        UnitProxy unit = resolver.resolveUnit(unitQualifiedName);
        if (unit == null && (namespace = importingUnit.getNamespace()) != null && !unitQualifiedName.contains(NAMESPACE_SEP)) {
            unit = resolver.resolveUnit(String.valueOf(namespace) + NAMESPACE_SEP + unitQualifiedName);
        }
        if (unit == null && resolver instanceof LegacyResolverSupport) {
            LegacyResolverSupport legacyResolver = (LegacyResolverSupport)resolver;
            unit = legacyResolver.resolveUnit(importingUnit, unitQualifiedName);
        }
        return unit;
    }

    private List<String> getImportQName(ImportCS importCS) {
        PathNameCS pathNameCS = importCS.getPathNameCS();
        if (pathNameCS != null && !pathNameCS.getSequenceOfNames().isEmpty()) {
            return pathNameCS.getSequenceOfNames();
        }
        return null;
    }

    private void checkForDupImports(List<ImportCS> imports, QvtOperationalEnv env) {
        ArrayList<List<String>> checkedImports = new ArrayList<List<String>>(imports.size());
        LinkedList<ImportCS> dupImports = new LinkedList<ImportCS>();
        ListIterator<ImportCS> it = imports.listIterator();
        while (it.hasNext()) {
            ImportCS nextImportCS = it.next();
            List<String> checkedQName = this.getImportQName(nextImportCS);
            if (checkedQName == null) continue;
            if (checkedImports.contains(checkedQName)) {
                dupImports.add(nextImportCS);
                continue;
            }
            checkedImports.add(checkedQName);
        }
        for (ImportCS nextDupImport : dupImports) {
            PathNameCS problemCS = nextDupImport.getPathNameCS();
            env.reportWarning(NLS.bind((String)CompilerMessages.compilationUnitAlreadyImported, (Object)QvtOperationalParserUtil.getStringRepresentation(problemCS, NAMESPACE_SEP)), (CSTNode)problemCS);
        }
    }

    private static void reportCyclicImportError(ImportCS from, ImportCS to, QvtOperationalEnv env) {
        PathNameCS fromQNameCS = from.getPathNameCS();
        PathNameCS toQNameCS = to.getPathNameCS();
        String message = NLS.bind((String)CompilerMessages.cyclicImportError, (Object)QvtOperationalParserUtil.getStringRepresentation(fromQNameCS, NAMESPACE_SEP), (Object)QvtOperationalParserUtil.getStringRepresentation(toQNameCS, NAMESPACE_SEP));
        env.reportError(message, (CSTNode)toQNameCS);
    }

    static void clearITokens(CSTNode node) {
        node.setStartToken(null);
        node.setEndToken(null);
        TreeIterator it = node.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof CSTNode)) continue;
            CSTNode nextCST = (CSTNode)next;
            nextCST.setStartToken(null);
            nextCST.setEndToken(null);
        }
    }

    private DependencyPathElement findDependencyElement(UnitProxy source) {
        for (DependencyPathElement element : this.fDependencyWalkPath) {
            if (!source.equals(element.importer)) continue;
            return element;
        }
        return null;
    }

    protected static class CSTAnalysisResult {
        List<Module> modules;
        List<ModelType> modelTypes;

        protected CSTAnalysisResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CSTParseResult {
        public UnitCS unitCS;
        public QvtOperationalFileEnv env;
        public AbstractQVTParser parser;

        List<ImportCS> getImports() {
            if (this.unitCS != null) {
                return QvtOperationalParserUtil.getImports(this.unitCS);
            }
            return Collections.emptyList();
        }
    }

    private static class DependencyPathElement {
        final UnitProxy importer;
        ImportCS currentProcessedImport;
        QvtOperationalEnv importerEnv;

        public DependencyPathElement(UnitProxy importer) {
            this.importer = importer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnitResolverImpl
    implements ExternalUnitElementsProvider {
        private final Map<List<String>, CompiledUnit> qName2CU = new HashMap<List<String>, CompiledUnit>(5);
        private final UnitProxy source;

        private UnitResolverImpl(UnitProxy importer) {
            this.source = importer;
        }

        void addUnit(List<String> qualifiedName, CompiledUnit unit) {
            this.qName2CU.put(qualifiedName, unit);
        }

        @Override
        public URI getImporter() {
            return this.source.getURI();
        }

        @Override
        public List<QvtOperationalModuleEnv> getModules(List<String> importedUnitQualifiedName) {
            if (importedUnitQualifiedName == null) {
                return null;
            }
            CompiledUnit compiledUnit = this.qName2CU.get(importedUnitQualifiedName);
            if (compiledUnit != null) {
                return compiledUnit.getModuleEnvironments();
            }
            return null;
        }
    }
}

