/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionContextImpl
implements ResolutionContext {
    private URI fURI;

    public ResolutionContextImpl(URI contextURI) {
        if (contextURI == null) {
            throw new IllegalArgumentException();
        }
        this.fURI = contextURI;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            if (adapterType == IProject.class) {
                if (this.fURI.isPlatformResource()) {
                    String wsFullPath = this.fURI.toPlatformString(true);
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(wsFullPath);
                    if (resource != null) {
                        return adapterType.cast(resource.getProject());
                    }
                }
            } else if (adapterType == Bundle.class && this.fURI.isPlatformPlugin() && this.fURI.segmentCount() > 1) {
                String bundleID = this.fURI.segment(1);
                Bundle bundle = Platform.getBundle((String)bundleID);
                return bundle != null ? (T)adapterType.cast(bundle) : null;
            }
        }
        return null;
    }

    public String toString() {
        return "Resolution context (" + this.fURI.toString() + ")";
    }
}

