/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaMethodHandlerFactory;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaModuleLoader;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.ModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBlackboxProvider
extends AbstractBlackboxProvider {
    private static final String PROVIDER_ID = "Java";
    private static final String EXTENSION_POINT = "javaBlackboxUnits";
    private static final String CLASS_NAME_SEPARATOR = ".";
    private static final String UNIT_ELEM = "unit";
    private static final String LIBRARY_ELEM = "library";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String DESC_ATTR = "description";
    private static final String METAMODEL_ELEM = "metamodel";
    private static final String NSURI_ATTR = "nsURI";
    private final Map<String, Descriptor> fDescriptorMap = EMFPlugin.IS_ECLIPSE_RUNNING ? this.readDescriptors() : Collections.emptyMap();

    @Override
    public AbstractCompilationUnitDescriptor getModuleDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        return this.fDescriptorMap.get(qualifiedName);
    }

    @Override
    protected String getProviderID() {
        return PROVIDER_ID;
    }

    @Override
    public List<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext resolutionContext) {
        ArrayList<Descriptor> result = new ArrayList<Descriptor>(this.fDescriptorMap.size());
        result.addAll(this.fDescriptorMap.values());
        return Collections.unmodifiableList(result);
    }

    @Override
    public CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor descriptor, LoadContext loadContext) throws BlackboxException {
        if (!(descriptor instanceof Descriptor)) {
            throw new IllegalArgumentException("Invalid descriptor");
        }
        Descriptor libDescriptor = (Descriptor)descriptor;
        JavaModuleLoader javaModuleLoader = this.createJavaModuleLoader();
        BasicDiagnostic errors = null;
        LinkedList<QvtOperationalModuleEnv> loadedModules = new LinkedList<QvtOperationalModuleEnv>();
        for (ModuleHandle nextModuleHandle : libDescriptor.fModules) {
            Diagnostic diagnostic = javaModuleLoader.loadModule(nextModuleHandle);
            if (DiagnosticUtil.isSuccess(diagnostic)) {
                QvtOperationalModuleEnv nextModuleEnv = javaModuleLoader.getLoadedModule();
                nextModuleEnv.getTypeResolver().getResource().setURI(descriptor.getURI());
                loadedModules.add(nextModuleEnv);
                if (diagnostic.getSeverity() == 0) continue;
                QvtPlugin.logDiagnostic(diagnostic);
                continue;
            }
            if (errors == null) {
                String message = NLS.bind(JavaBlackboxMessages.BlackboxUnitLoadFailed, descriptor.getQualifiedName());
                errors = DiagnosticUtil.createErrorDiagnostic(message);
            }
            errors.add(diagnostic);
        }
        if (errors != null) {
            assert (errors.getSeverity() == 4);
            throw new BlackboxException((Diagnostic)errors);
        }
        return this.createCompilationUnit(loadedModules);
    }

    private JavaModuleLoader createJavaModuleLoader() {
        return new JavaModuleLoader(){
            JavaMethodHandlerFactory handlerFactory;

            @Override
            protected void loadModule(QvtOperationalModuleEnv moduleEnv, final Class<?> javaModuleClass) {
                this.handlerFactory = new JavaMethodHandlerFactory((OCLStandardLibrary<EClassifier>)moduleEnv.getOCLStandardLibrary());
                Module module = moduleEnv.getModuleContextType();
                ASTBindingHelper.createCST2ASTBinding((CSTNode)CSTFactory.eINSTANCE.createLibraryCS(), module, moduleEnv);
                JavaBlackboxProvider.this.setInstanceAdapterFactory(module, new AbstractBlackboxProvider.InstanceAdapterFactory(){

                    public Object createAdapter(EObject moduleInstance) {
                        try {
                            return javaModuleClass.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new IllegalArgumentException("Illegal adapter instance", e);
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalArgumentException("Illegal adapter instance", e);
                        }
                    }
                });
            }

            @Override
            protected void loadOperation(EOperation operation, Method javaOperation) {
                JavaBlackboxProvider.this.setOperationHandler(operation, this.handlerFactory.createHandler(javaOperation), true);
            }
        };
    }

    private Map<String, Descriptor> readDescriptors() {
        IConfigurationElement[] configs;
        HashMap<String, Descriptor> providers = new HashMap<String, Descriptor>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", EXTENSION_POINT);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Descriptor descriptor = this.createDescriptor(element);
                String id = descriptor.getQualifiedName();
                if (!providers.containsKey(id)) {
                    providers.put(id, descriptor);
                } else {
                    String message = NLS.bind(JavaBlackboxMessages.UnitAlreadyRegisteredContributionIgnored, id, descriptor.getContributorId());
                    QvtPlugin.error(message);
                }
            }
            catch (IllegalArgumentException e) {
                QvtPlugin.error("Failed to read java black-box definition: " + e.getMessage());
            }
            ++n2;
        }
        return providers;
    }

    private Descriptor createDescriptor(IConfigurationElement configurationElement) throws IllegalArgumentException {
        if (UNIT_ELEM.equals(configurationElement.getName())) {
            String name = configurationElement.getAttribute(NAME_ATTR);
            String namespace = configurationElement.getAttribute(NAMESPACE_ATTR);
            if (namespace == null) {
                configurationElement.getContributor().getName();
            }
            String description = configurationElement.getAttribute(DESC_ATTR);
            String qualifiedName = String.valueOf(namespace) + CLASS_NAME_SEPARATOR + name;
            return new Descriptor(configurationElement, qualifiedName, description);
        }
        if (LIBRARY_ELEM.equals(configurationElement.getName())) {
            return new Descriptor(configurationElement, JavaBlackboxProvider.deriveQualifiedNameFromSimpleDefinition(configurationElement), null);
        }
        throw new IllegalArgumentException("Unsupported configuration element " + configurationElement);
    }

    private static String getPackageNameFromJavaClass(String className) {
        int lastSeparatorPos = className.lastIndexOf(CLASS_NAME_SEPARATOR);
        if (lastSeparatorPos < 0) {
            return null;
        }
        return className.substring(0, lastSeparatorPos);
    }

    private static String deriveQualifiedNameFromSimpleDefinition(IConfigurationElement moduleElement) {
        String className = moduleElement.getAttribute(CLASS_ATTR);
        String name = moduleElement.getAttribute(NAME_ATTR);
        if (name == null) {
            return className;
        }
        String packageName = JavaBlackboxProvider.getPackageNameFromJavaClass(className);
        if (packageName == null) {
            return name;
        }
        return String.valueOf(packageName) + CLASS_NAME_SEPARATOR + name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Descriptor
    extends AbstractCompilationUnitDescriptor {
        private List<ModuleHandle> fModules;
        private String fContributingBundleId;

        Descriptor(IConfigurationElement configurationElement, String unitQualifiedName, String description) {
            super(JavaBlackboxProvider.this, unitQualifiedName, unitQualifiedName);
            this.fModules = Collections.emptyList();
            this.fContributingBundleId = configurationElement.getContributor().getName();
            if (configurationElement.getName().equals(JavaBlackboxProvider.LIBRARY_ELEM)) {
                this.addModuleHandle(configurationElement);
            } else {
                IConfigurationElement[] libraries;
                IConfigurationElement[] iConfigurationElementArray = libraries = configurationElement.getChildren(JavaBlackboxProvider.LIBRARY_ELEM);
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement moduleElement = iConfigurationElementArray[n2];
                    this.addModuleHandle(moduleElement);
                    ++n2;
                }
            }
        }

        String getContributorId() {
            return this.fContributingBundleId;
        }

        private void addModuleHandle(IConfigurationElement moduleElement) {
            if (this.fModules.isEmpty()) {
                this.fModules = new LinkedList<ModuleHandle>();
            }
            String bundleId = moduleElement.getContributor().getName();
            String className = moduleElement.getAttribute(JavaBlackboxProvider.CLASS_ATTR);
            String moduleName = moduleElement.getAttribute(JavaBlackboxProvider.NAME_ATTR);
            if (moduleName == null) {
                moduleName = this.getSimpleNameFromJavaClass(className);
            }
            ModuleHandle moduleHandle = new ModuleHandle(bundleId, className, moduleName, this.readUsedPackagesNsURIs(moduleElement));
            this.fModules.add(moduleHandle);
        }

        private List<String> readUsedPackagesNsURIs(IConfigurationElement moduleConfigElement) {
            ArrayList<String> uris = new ArrayList<String>(3);
            IConfigurationElement[] iConfigurationElementArray = moduleConfigElement.getChildren(JavaBlackboxProvider.METAMODEL_ELEM);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement nextElement = iConfigurationElementArray[n2];
                String nsURI = nextElement.getAttribute(JavaBlackboxProvider.NSURI_ATTR);
                if (nsURI != null) {
                    uris.add(nsURI);
                }
                ++n2;
            }
            return uris;
        }

        private String getSimpleNameFromJavaClass(String className) {
            int lastSeparatorPos = className.lastIndexOf(JavaBlackboxProvider.CLASS_NAME_SEPARATOR);
            if (lastSeparatorPos < 0) {
                return className;
            }
            return className.substring(lastSeparatorPos + 1);
        }
    }
}

