/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaMethodHandlerFactory {
    private static int FAILURE_COUNT_TOLERANCE = 5;
    private final Object fOclInvalid;

    JavaMethodHandlerFactory(OCLStandardLibrary<EClassifier> oclStdLib) {
        this.fOclInvalid = oclStdLib.getOclInvalid();
    }

    CallHandler createHandler(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        Operation opAnnotation = method.getAnnotation(Operation.class);
        return new Handler(method, opAnnotation != null && opAnnotation.contextual());
    }

    private Object getInvalidResult() {
        return this.fOclInvalid;
    }

    private class Handler
    implements CallHandler {
        private Method fMethod;
        private Class<?>[] fCachedParamTypes;
        private Object[] fArgs;
        private boolean fIsContextual;
        private boolean fRequiresNumConversion;
        private int fFatalErrorCount;

        Handler(Method method, boolean isContextual) {
            assert (method != null);
            this.fMethod = method;
            this.fCachedParamTypes = this.fMethod.getParameterTypes();
            this.fIsContextual = isContextual;
            this.fRequiresNumConversion = this.requiresNumberConversion();
            this.fFatalErrorCount = 0;
        }

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            try {
                if (this.isDisabled()) {
                    Object object = JavaMethodHandlerFactory.this.getInvalidResult();
                    return object;
                }
                Object[] actualArgs = this.prepareArguments(source, args, evalEnv);
                Object javaCallSource = null;
                boolean isStatic = Modifier.isStatic(this.fMethod.getModifiers());
                if (!isStatic) {
                    Class<?> moduleJavaClass = this.fMethod.getDeclaringClass();
                    javaCallSource = module.getAdapter(moduleJavaClass);
                    assert (javaCallSource != null);
                }
                Object object = this.fMethod.invoke(javaCallSource, actualArgs);
                return object;
            }
            catch (IllegalArgumentException e) {
                ++this.fFatalErrorCount;
                QvtPlugin.error(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod), e);
                Object object = CallHandlerAdapter.getInvalidResult(evalEnv);
                return object;
            }
            catch (IllegalAccessException e) {
                ++this.fFatalErrorCount;
                QvtPlugin.error(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod), e);
                Object object = CallHandlerAdapter.getInvalidResult(evalEnv);
                return object;
            }
            catch (InvocationTargetException e) {
                ++this.fFatalErrorCount;
                QvtPlugin.error(NLS.bind(JavaBlackboxMessages.MethodInvocationError, this.fMethod), e);
                Object object = CallHandlerAdapter.getInvalidResult(evalEnv);
                return object;
            }
            finally {
                this.clearArguments();
            }
        }

        boolean isDisabled() {
            return this.fFatalErrorCount > FAILURE_COUNT_TOLERANCE;
        }

        private Object[] prepareArguments(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (this.fIsContextual) {
                if (this.fArgs == null) {
                    this.fArgs = new Object[args.length + 1];
                }
                this.fArgs[0] = source;
            } else if (this.fArgs == null) {
                this.fArgs = new Object[args.length];
            }
            int destPos = this.fIsContextual ? 1 : 0;
            int i = 0;
            while (i < args.length) {
                Object nextArg = args[i];
                if (nextArg == JavaMethodHandlerFactory.this.getInvalidResult()) {
                    nextArg = null;
                }
                if (this.fRequiresNumConversion) {
                    nextArg = NumberConversions.convertNumber(nextArg, this.fCachedParamTypes[destPos]);
                }
                this.fArgs[destPos++] = nextArg;
                ++i;
            }
            return this.fArgs != null ? this.fArgs : args;
        }

        private void clearArguments() {
            if (this.fArgs != null) {
                Arrays.fill(this.fArgs, null);
            }
        }

        private boolean requiresNumberConversion() {
            assert (this.fMethod != null);
            Class<?>[] classArray = this.fMethod.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paramType = classArray[n2];
                if (Number.class.isAssignableFrom(paramType)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

