/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.Java2QVTTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.ModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.OperationBuilder;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaModuleLoader {
    private BasicDiagnostic fDiagnostics = null;
    private QvtOperationalModuleEnv fEnv;
    private OperationBuilder fOperBuilder;

    JavaModuleLoader() {
    }

    public QvtOperationalModuleEnv getLoadedModule() {
        return this.fEnv;
    }

    public Diagnostic getDiagnostics() {
        return this.fDiagnostics != null ? this.fDiagnostics : Diagnostic.OK_INSTANCE;
    }

    public Diagnostic loadModule(ModuleHandle moduleHandle) {
        Class<?> javaClass;
        this.fDiagnostics = DiagnosticUtil.createRootDiagnostic(NLS.bind(JavaBlackboxMessages.LoadModuleDiagnostics, moduleHandle));
        try {
            javaClass = moduleHandle.getModuleJavaClass();
            if (!JavaModuleLoader.isModuleClassValid(javaClass)) {
                this.fDiagnostics.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.InvalidJavaClassForModule, javaClass, moduleHandle)));
                return this.fDiagnostics;
            }
        }
        catch (ClassNotFoundException e) {
            this.fDiagnostics.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.ModuleJavaClassNotFound, moduleHandle.getSimpleName()), e));
            return this.fDiagnostics;
        }
        Library module = QvtOperationalStdLibrary.createLibrary(moduleHandle.getSimpleName());
        this.fEnv = QvtOperationalEnvFactory.INSTANCE.createModuleEnvironment(module);
        this.loadModule(this.fEnv, javaClass);
        Java2QVTTypeResolver typeResolver = new Java2QVTTypeResolver(this.fEnv, JavaModuleLoader.resolvePackages(moduleHandle.getUsedPackages(), (DiagnosticChain)this.fDiagnostics));
        this.fOperBuilder = new OperationBuilder(typeResolver);
        Method[] methodArray = javaClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isLibraryOperation(method)) {
                EOperation operation = this.fOperBuilder.buildOperation(method);
                Diagnostic operationStatus = this.fOperBuilder.getDiagnostics();
                if (DiagnosticUtil.isSuccess(operationStatus)) {
                    this.loadOperation(operation, method);
                }
                if (operationStatus.getSeverity() != 0) {
                    this.fDiagnostics.add(operationStatus);
                }
            }
            ++n2;
        }
        return this.fDiagnostics;
    }

    protected abstract void loadModule(QvtOperationalModuleEnv var1, Class<?> var2);

    protected abstract void loadOperation(EOperation var1, Method var2);

    private boolean isLibraryOperation(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isModuleClassValid(Class<?> javaClass) {
        Class[] noParams = new Class[]{};
        try {
            Constructor<?> constructor = javaClass.getDeclaredConstructor(noParams);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return Modifier.isPublic(javaClass.getModifiers());
    }

    private static List<EPackage> resolvePackages(List<String> nsURIs, DiagnosticChain diagnosticChain) {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>(nsURIs.size());
        for (String nextURI : nsURIs) {
            EPackage resolvedPackage = registry.getEPackage(nextURI);
            if (resolvedPackage != null) {
                ePackages.add(resolvedPackage);
                continue;
            }
            diagnosticChain.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.UnresolvedMetamodelURI, nextURI)));
        }
        return ePackages;
    }
}

