/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleHandle {
    private final String bundleId;
    private final String className;
    private final String simpleName;
    private final List<String> usedPackages;

    ModuleHandle(String bundleId, String className, String moduleName, List<String> usedPackages) {
        if (bundleId == null || className == null || usedPackages == null) {
            throw new IllegalArgumentException();
        }
        this.bundleId = bundleId;
        this.className = className;
        this.simpleName = moduleName;
        this.usedPackages = Collections.unmodifiableList(new ArrayList<String>(usedPackages));
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public List<String> getUsedPackages() {
        return this.usedPackages;
    }

    public Class<?> getModuleJavaClass() throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)this.bundleId);
        if (bundle != null) {
            return bundle.loadClass(this.className);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.simpleName) + " - " + this.className + "(bundle=" + this.bundleId + ")";
    }
}

