/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;

public class CompilerUtils {
    public static Diagnostic createProblemDiagnostic(URI uri, QvtMessage problem) {
        int qvtSeverity = problem.getSeverity();
        int diagnosticSeverity = qvtSeverity == 2 ? 4 : 2;
        String source = uri.toString();
        String message = problem.getMessage();
        if (problem.getLineNum() >= 0) {
            message = String.valueOf(message) + " (at:" + problem.getLineNum() + ")";
        }
        return new BasicDiagnostic(diagnosticSeverity, source, 0, message, null);
    }

    public static Diagnostic createUnitProblemDiagnostic(CompiledUnit unit) {
        if (unit.getProblems().isEmpty()) {
            return Diagnostic.OK_INSTANCE;
        }
        URI uri = unit.getURI();
        List<QvtMessage> problems = unit.getProblems();
        ArrayList<Diagnostic> children = new ArrayList<Diagnostic>(problems.size());
        int errorCount = 0;
        int warnCount = 0;
        for (QvtMessage problem : unit.getProblems()) {
            if (problem.getSeverity() == 2) {
                ++errorCount;
            } else if (problem.getSeverity() == 1) {
                ++warnCount;
            }
            children.add(CompilerUtils.createProblemDiagnostic(uri, problem));
        }
        String mainMessage = NLS.bind("Unit diagnostic - {0} errors, warnings {1}", errorCount, warnCount);
        BasicDiagnostic unitDiagnostic = new BasicDiagnostic(uri.toString(), 0, children, mainMessage, null);
        return unitDiagnostic;
    }

    static Monitor createMonitor(Monitor monitor, int ticks) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            if (monitor instanceof IProgressMonitor) {
                return new BasicMonitor.EclipseSubProgress((IProgressMonitor)monitor, ticks);
            }
            return new BasicMonitor.EclipseSubProgress(BasicMonitor.toIProgressMonitor((Monitor)monitor), ticks);
        }
        return monitor;
    }

    static void throwOperationCanceled() throws RuntimeException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            throw new OperationCanceledException();
        }
        throw new RuntimeException("Operation canceled");
    }

    static Monitor createNullMonitor() {
        return new BasicMonitor();
    }
}

