/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerKernel;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtAssertionFailed;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackOverFlowError;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

public final class TransformationExecutor {
    private URI fURI;
    private EPackage.Registry fPackageRegistry;
    private CompiledUnit fCompiledUnit;
    private QvtCompilerKernel fCompilerKernel;
    private ExecutionDiagnostic fLoadDiagnostic;
    private OperationalTransformation fTransformation;

    public TransformationExecutor(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("null transformation URI");
        }
        this.fURI = uri;
    }

    public TransformationExecutor(URI uri, EPackage.Registry registry) {
        this(uri);
        if (registry == null) {
            throw new IllegalArgumentException("null package registry");
        }
        this.fPackageRegistry = registry;
    }

    public Diagnostic loadTransformation() {
        if (this.fLoadDiagnostic == null) {
            this.doLoad();
        }
        return this.fLoadDiagnostic;
    }

    public ExecutionDiagnostic execute(ExecutionContext executionContext, ModelExtent ... modelParameters) {
        if (executionContext == null) {
            throw new IllegalArgumentException();
        }
        this.checkLegalModelParams(modelParameters);
        this.loadTransformation();
        if (!TransformationExecutor.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
            return this.fLoadDiagnostic;
        }
        try {
            return this.doExecute(modelParameters, TransformationExecutor.createInternalContext(executionContext));
        }
        catch (QvtRuntimeException e) {
            return TransformationExecutor.createExecutionFailure(e);
        }
    }

    private ExecutionDiagnostic doExecute(ModelExtent[] args, IContext context) {
        QvtOperationalEnvFactory factory = this.getEnvironmentFactory();
        QvtOperationalEvaluationEnv evaluationEnv = factory.createEvaluationEnvironment(context, null);
        ExecutionDiagnostic modelParamsDiagnostic = this.initArguments(evaluationEnv, this.fTransformation, args);
        if (modelParamsDiagnostic.getSeverity() != 0) {
            return modelParamsDiagnostic;
        }
        QvtOperationalFileEnv rootEnv = factory.createEnvironment(this.fCompiledUnit.getURI(), this.fCompilerKernel);
        EvaluationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> evaluator = factory.createEvaluationVisitor(rootEnv, (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)evaluationEnv, null);
        assert (evaluator instanceof InternalEvaluator) : "expecting InternalEvaluator implementation";
        InternalEvaluator rawEvaluator = (InternalEvaluator)evaluator;
        rawEvaluator.execute(this.fTransformation);
        List<Object> resultArgs = evaluationEnv.getOperationArgs();
        int i = 0;
        for (Object nextResultArg : resultArgs) {
            ModelInstance modelInstance = (ModelInstance)nextResultArg;
            ModelParameterExtent extent = modelInstance.getExtent();
            List<EObject> allRootElements = extent.getContents().getAllRootElements();
            try {
                args[i++].setContents(allRootElements);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return new ExecutionDiagnostic(4, 140, NLS.bind(Messages.ReadOnlyExtentModificationError, i - 1));
            }
        }
        return ExecutionDiagnostic.OK_INSTANCE;
    }

    private void doLoad() {
        this.fLoadDiagnostic = ExecutionDiagnostic.OK_INSTANCE;
        UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(this.fURI);
        if (unit == null) {
            this.fLoadDiagnostic = new ExecutionDiagnostic(4, 200, NLS.bind(Messages.UnitNotFoundError, this.fURI));
            return;
        }
        QVTOCompiler compiler = this.createCompiler(unit.getResolver());
        try {
            this.fCompiledUnit = compiler.compile(unit, null, null);
            this.fCompilerKernel = compiler.getKernel();
            this.fLoadDiagnostic = TransformationExecutor.createCompilationDiagnostic(this.fCompiledUnit);
        }
        catch (MdaException e) {
            this.fLoadDiagnostic = new ExecutionDiagnostic(4, 200, NLS.bind(Messages.FailedToCompileUnitError, this.fURI));
            this.fLoadDiagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        if (this.fCompiledUnit != null && this.fLoadDiagnostic.getSeverity() == 0) {
            ExecutionDiagnostic validForExecution;
            this.fTransformation = this.getTransformation();
            if (this.fTransformation == null) {
                this.fLoadDiagnostic = new ExecutionDiagnostic(4, 200, NLS.bind(Messages.NotTransformationInUnitError, this.fURI));
            }
            if ((validForExecution = TransformationExecutor.checkIsExecutable(this.fTransformation)).getSeverity() != 0) {
                this.fLoadDiagnostic = validForExecution;
            }
        }
    }

    private ExecutionDiagnostic initArguments(QvtOperationalEvaluationEnv evalEnv, OperationalTransformation transformationModel, ModelExtent[] args) {
        EList<ModelParameter> modelParameters = transformationModel.getModelParameter();
        if (modelParameters.size() != args.length) {
            return new ExecutionDiagnostic(4, 140, NLS.bind(Messages.InvalidModelParameterCountError, args.length, modelParameters.size()));
        }
        ExecutionDiagnostic result = ExecutionDiagnostic.OK_INSTANCE;
        ArrayList<ModelParameterExtent> extents = new ArrayList<ModelParameterExtent>(args.length);
        int argCount = 0;
        for (ModelParameter modelParam : modelParameters) {
            ModelExtent nextArg = args[argCount++];
            ModelParameterExtent nextExtent = modelParam.getKind() != DirectionKind.OUT ? new ModelParameterExtent(nextArg.getContents(), null, modelParam) : new ModelParameterExtent();
            extents.add(nextExtent);
        }
        List<ModelInstance> modelArgs = ModelParameterHelper.createModelArguments(transformationModel, extents);
        evalEnv.getOperationArgs().addAll(modelArgs);
        return result;
    }

    private static ExecutionDiagnostic checkIsExecutable(OperationalTransformation transformation) {
        EList operations = transformation.getEOperations();
        for (EOperation oper : operations) {
            if (!(oper instanceof ImperativeOperation) || !"main".equals(oper.getName())) continue;
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        return new ExecutionDiagnostic(4, 130, NLS.bind(Messages.NoTransformationEntryPointError, transformation.getName()));
    }

    private OperationalTransformation getTransformation() {
        List<Module> allModules = this.fCompiledUnit.getModules();
        for (Module module : allModules) {
            if (!(module instanceof OperationalTransformation)) continue;
            return (OperationalTransformation)module;
        }
        return null;
    }

    private QvtOperationalEnvFactory getEnvironmentFactory() {
        return new QvtOperationalEnvFactory();
    }

    private static ExecutionDiagnostic createExecutionFailure(QvtRuntimeException qvtRuntimeException) {
        int code = 0;
        int severity = 4;
        String message = qvtRuntimeException.getLocalizedMessage();
        Object[] data = null;
        if (qvtRuntimeException instanceof QvtAssertionFailed) {
            code = 100;
        } else if (qvtRuntimeException instanceof QvtInterruptedExecutionException) {
            code = 110;
            severity = 8;
        } else {
            code = 120;
            if (!(qvtRuntimeException instanceof QvtStackOverFlowError)) {
                data = new Object[]{qvtRuntimeException};
            } else {
                message = Messages.StackTraceOverFlowError;
            }
        }
        if (message == null) {
            message = NLS.bind(Messages.QVTRuntimeExceptionCaught, qvtRuntimeException.getClass().getName());
        }
        ExecutionDiagnostic diagnostic = new ExecutionDiagnostic(severity, code, message, data);
        diagnostic.setStackTrace(qvtRuntimeException.getQvtStackTrace());
        return diagnostic;
    }

    private void checkLegalModelParams(ModelExtent[] extents) throws IllegalArgumentException {
        if (extents == null) {
            throw new IllegalArgumentException("Null model parameters");
        }
        int i = 0;
        while (i < extents.length) {
            if (extents[i] == null) {
                throw new IllegalArgumentException("Null model parameter[" + i + "]");
            }
            ++i;
        }
    }

    private static ExecutionDiagnostic createCompilationDiagnostic(CompiledUnit compiledUnit) {
        List<QvtMessage> errors = compiledUnit.getErrors();
        if (errors.isEmpty()) {
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        URI uri = compiledUnit.getURI();
        ExecutionDiagnostic mainDiagnostic = new ExecutionDiagnostic(4, 130, NLS.bind(Messages.CompilationErrorsFoundInUnit, uri.toString()));
        for (QvtMessage message : errors) {
            mainDiagnostic.add(CompilerUtils.createProblemDiagnostic(uri, message));
        }
        return mainDiagnostic;
    }

    private static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity == 0 || severity == 2 || severity == 1;
    }

    private static IContext createInternalContext(ExecutionContext executionContext) {
        Context ctx = new Context();
        ctx.setLog(executionContext.getLog());
        ctx.setMonitor(executionContext.getMonitor());
        for (String key : executionContext.getConfigPropertyNames()) {
            Object value = executionContext.getConfigProperty(key);
            ctx.setConfigProperty(key, value);
        }
        return ctx;
    }

    public String toString() {
        return "QVTO-Executor: " + this.fURI;
    }

    private QVTOCompiler createCompiler(UnitResolver unitResolver) {
        if (this.fPackageRegistry == null) {
            return new QVTOCompiler(unitResolver);
        }
        return QVTOCompiler.createCompiler(unitResolver, this.fPackageRegistry);
    }
}

