/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.GenericsResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.ocl.AbstractTypeChecker;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.TemplateParameterType;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeCheckerImpl
extends AbstractTypeChecker<EClassifier, EOperation, EStructuralFeature, EParameter> {
    private final GenericsResolver fGenericResolver;
    private final OCLStandardLibrary<EClassifier> fOCLStdlib;

    TypeCheckerImpl(QVTOEnvironment env) {
        super((Environment)env);
        this.fGenericResolver = new GenericsResolver(env);
        this.fOCLStdlib = this.getEnvironment().getOCLStandardLibrary();
    }

    protected QVTOEnvironment getEnvironment() {
        return (QVTOEnvironment)super.getEnvironment();
    }

    public EOperation findMostSpecificOperationMatching(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        OCLStandardLibrary lib;
        if (args == null) {
            args = Collections.emptyList();
        }
        UMLReflection uml = this.getEnvironment().getUMLReflection();
        List operations = this.getOperations(owner);
        List matches = null;
        for (EOperation oper : operations) {
            if (!name.equals(uml.getName((Object)oper)) || !this.matchArgs(owner, uml.getParameters((Object)oper), args)) continue;
            if (matches == null) {
                matches = new UniqueEList(3);
            }
            matches.add(oper);
        }
        if (matches != null) {
            if (matches.size() == 1) {
                return (EOperation)matches.get(0);
            }
            if (!matches.isEmpty()) {
                return this.getMostSpecificOperation(matches, args);
            }
        }
        if (owner == (lib = this.getEnvironment().getOCLStandardLibrary()).getOclVoid() || owner == lib.getOclInvalid()) {
            return this.findOperationForVoidOrInvalid(owner, name, args);
        }
        return null;
    }

    public EStructuralFeature findAttribute(EClassifier owner, String name) {
        EStructuralFeature aliasedProperty;
        EStructuralFeature property = (EStructuralFeature)super.findAttribute((Object)owner, name);
        if (property == null && (aliasedProperty = this.getEnvironment().lookupPropertyAlias(owner, name)) != null) {
            String originalName = aliasedProperty.getName();
            return (EStructuralFeature)super.findAttribute((Object)owner, originalName);
        }
        return property;
    }

    public boolean isStandardLibraryFeature(EClassifier owner, Object feature) {
        if (feature instanceof EOperation && this.isQVTOperation((EOperation)feature)) {
            return false;
        }
        return super.isStandardLibraryFeature((Object)owner, feature);
    }

    protected org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> resolveCollectionType(CollectionKind kind, EClassifier elementType) {
        return (org.eclipse.ocl.types.CollectionType)TypeUtil.resolveCollectionType((Environment)this.getEnvironment(), (CollectionKind)kind, (Object)elementType);
    }

    protected TupleType<EOperation, EStructuralFeature> resolveTupleType(EList<? extends TypedElement<EClassifier>> parts) {
        return (TupleType)TypeUtil.resolveTupleType((Environment)this.getEnvironment(), parts);
    }

    protected EClassifier resolve(EClassifier type) {
        return (EClassifier)TypeUtil.resolveType((Environment)this.getEnvironment(), (Object)type);
    }

    protected EClassifier resolveGenericType(EClassifier owner, EClassifier paramType, EClassifier argType) {
        CollectionType collectionType;
        if (paramType instanceof TemplateParameterType) {
            if (owner.eClass() == ImperativeOCLPackage.eINSTANCE.getDictionaryType()) {
                DictionaryType dictionaryType = (DictionaryType)owner;
                if (this.getQVTEnvironment().getQVTStandardLibrary().getKeyT() == paramType) {
                    return dictionaryType.getKeyType();
                }
            }
            return argType;
        }
        EClassifier result = (EClassifier)super.resolveGenericType((Object)owner, (Object)paramType, (Object)argType);
        EClass listMetaType = ImperativeOCLPackage.eINSTANCE.getListType();
        if (owner.eClass() == listMetaType && this.fOCLStdlib.getT() == result && (collectionType = (CollectionType)owner).getElementType() == this.fOCLStdlib.getOclVoid()) {
            return (EClassifier)this.fOCLStdlib.getOclVoid();
        }
        return result;
    }

    public EClassifier getResultType(Object problemObject, EClassifier owner, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
        if (this.isQVTOperation(operation)) {
            return this.fGenericResolver.resolveOperationReturnType(owner, operation, args);
        }
        return (EClassifier)super.getResultType(problemObject, (Object)owner, (Object)operation, args);
    }

    public int getRelationship(EClassifier type1, EClassifier type2) {
        if (type1 == type2) {
            return 1;
        }
        boolean isList1 = type1 instanceof ListType;
        boolean isList2 = type2 instanceof ListType;
        if (isList1 || isList2) {
            org.eclipse.ocl.types.CollectionType col2;
            if (isList1 && isList2) {
                ListType list1 = (ListType)type1;
                ListType list2 = (ListType)type2;
                return this.getRelationship((EClassifier)list1.getElementType(), (EClassifier)list2.getElementType());
            }
            if (!isList1 && type1 instanceof org.eclipse.ocl.types.CollectionType) {
                org.eclipse.ocl.types.CollectionType col1 = (org.eclipse.ocl.types.CollectionType)type1;
                if (col1.eClass() == EcorePackage.eINSTANCE.getCollectionType() && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((ListType)type2).getElementType()), (Object)((EClassifier)col1.getElementType()))) {
                    return 4;
                }
            } else if (!isList2 && type2 instanceof org.eclipse.ocl.types.CollectionType && (col2 = (org.eclipse.ocl.types.CollectionType)type2).eClass() == EcorePackage.eINSTANCE.getCollectionType() && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((ListType)type1).getElementType()), (Object)((EClassifier)col2.getElementType()))) {
                return 2;
            }
            if (this.isVoidOrInvalid(type1) || this.isVoidOrInvalid(type2)) {
                return super.getRelationship((Object)type1, (Object)type2);
            }
            return 8;
        }
        boolean isDict1 = type1 instanceof DictionaryType;
        boolean isDict2 = type2 instanceof DictionaryType;
        if (isDict1 || isDict2) {
            if (isDict1 && isDict2) {
                int keyRelShip;
                DictionaryType dict1 = (DictionaryType)type1;
                DictionaryType dict2 = (DictionaryType)type2;
                int elementRelShip = this.getRelationship((EClassifier)dict1.getElementType(), (EClassifier)dict2.getElementType());
                if (elementRelShip != (keyRelShip = this.getRelationship(dict1.getKeyType(), dict2.getKeyType()))) {
                    if ((keyRelShip & 3) != 0 && (elementRelShip & 3) != 0) {
                        return 2;
                    }
                    if ((keyRelShip & 5) != 0 && (elementRelShip & 5) != 0) {
                        return 4;
                    }
                    return elementRelShip;
                }
                return elementRelShip;
            }
            if (!isDict1) {
                if (type1.eClass() == EcorePackage.eINSTANCE.getCollectionType()) {
                    org.eclipse.ocl.types.CollectionType col1 = (org.eclipse.ocl.types.CollectionType)type1;
                    if (TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((DictionaryType)type2).getElementType()), (Object)((EClassifier)col1.getElementType()))) {
                        return 4;
                    }
                }
                if (this.isVoidOrInvalid(type1)) {
                    return super.getRelationship((Object)type1, (Object)type2);
                }
                return 8;
            }
            if (!isDict2) {
                if (type2.eClass() == EcorePackage.eINSTANCE.getCollectionType()) {
                    org.eclipse.ocl.types.CollectionType col2 = (org.eclipse.ocl.types.CollectionType)type1;
                    if (TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((DictionaryType)type1).getElementType()), (Object)((EClassifier)col2.getElementType()))) {
                        return 2;
                    }
                }
                if (this.isVoidOrInvalid(type2)) {
                    return super.getRelationship((Object)type1, (Object)type2);
                }
                return 8;
            }
        }
        return super.getRelationship((Object)type1, (Object)type2);
    }

    public EClassifier commonSuperType(Object problemObject, EClassifier type1, EClassifier type2) {
        EClassifier implictBaseClassifier;
        if (type1 != null) {
            type1 = (EClassifier)this.getEnvironment().getUMLReflection().asOCLType((Object)type1);
        }
        if (type2 != null) {
            type2 = (EClassifier)this.getEnvironment().getUMLReflection().asOCLType((Object)type2);
        }
        if (ObjectUtil.equal((Object)type1, (Object)type2)) {
            return type2;
        }
        if (type1 == this.fOCLStdlib.getT()) {
            return type2;
        }
        if (type2 == this.fOCLStdlib.getT()) {
            return type1;
        }
        if (type1 == this.fOCLStdlib.getOclVoid() || type1 == this.fOCLStdlib.getOclInvalid()) {
            return type2;
        }
        if (type2 == this.fOCLStdlib.getOclVoid() || type2 == this.fOCLStdlib.getOclInvalid()) {
            return type1;
        }
        if (type1 == this.fOCLStdlib.getOclAny() && !(type2 instanceof org.eclipse.ocl.types.CollectionType)) {
            return type1;
        }
        if (type2 == this.fOCLStdlib.getOclAny() && !(type1 instanceof org.eclipse.ocl.types.CollectionType)) {
            return type2;
        }
        if ((type1 == this.fOCLStdlib.getInteger() || type1 == this.fOCLStdlib.getUnlimitedNatural()) && type2 == this.fOCLStdlib.getReal()) {
            return type2;
        }
        if ((type2 == this.fOCLStdlib.getInteger() || type2 == this.fOCLStdlib.getUnlimitedNatural()) && type1 == this.fOCLStdlib.getReal()) {
            return type1;
        }
        if (type1 instanceof org.eclipse.ocl.types.CollectionType && type2 instanceof org.eclipse.ocl.types.CollectionType) {
            org.eclipse.ocl.types.CollectionType ct1 = (org.eclipse.ocl.types.CollectionType)type1;
            org.eclipse.ocl.types.CollectionType ct2 = (org.eclipse.ocl.types.CollectionType)type2;
            CollectionKind commonKind = this.commonSuperType(ct1.getKind(), ct2.getKind());
            EClassifier resultElementType = this.commonSuperType(problemObject, (EClassifier)ct1.getElementType(), (EClassifier)ct2.getElementType());
            return (EClassifier)this.resolveCollectionType(commonKind, resultElementType);
        }
        if (type1 instanceof MessageType && type2 instanceof MessageType) {
            return (EClassifier)this.fOCLStdlib.getOclMessage();
        }
        if (type1 instanceof TypeType && type2 instanceof TypeType) {
            return (EClassifier)this.fOCLStdlib.getOclType();
        }
        if (type1 instanceof TupleType || type2 instanceof TupleType) {
            if (!(type1 instanceof TupleType) || !(type2 instanceof TupleType)) {
                String message = NLS.bind(ValidationMessages.TupleTypeMismatch, this.getName(type1), this.getName(type2));
                this.error(message, "commonSuperType", problemObject);
                return null;
            }
            List props1 = this.getUMLReflection().getAttributes((Object)type1);
            List props2 = this.getUMLReflection().getAttributes((Object)type2);
            if (props1.size() != props2.size()) {
                String message = NLS.bind(ValidationMessages.TupleFieldNumMismatch, this.getName(type1), this.getName(type2));
                this.error(message, "commonSuperType", problemObject);
                return null;
            }
            BasicEList tupleParts = new BasicEList();
            for (EStructuralFeature prop1 : props1) {
                boolean found = false;
                for (EStructuralFeature prop2 : props2) {
                    if (!this.getUMLReflection().getName((Object)prop1).equals(this.getUMLReflection().getName((Object)prop2))) continue;
                    EClassifier resultElementType = this.commonSuperType(problemObject, this.resolve((EClassifier)this.getUMLReflection().getOCLType((Object)prop1)), this.resolve((EClassifier)this.getUMLReflection().getOCLType((Object)prop2)));
                    found = true;
                    Variable var = this.getEnvironment().getOCLFactory().createVariable();
                    this.getUMLReflection().setName((TypedElement)var, this.getName(prop1));
                    this.getUMLReflection().setType((TypedElement)var, (Object)resultElementType);
                    tupleParts.add((Object)var);
                    break;
                }
                if (found) continue;
                String message = NLS.bind(ValidationMessages.TupleFieldNotFound, new Object[]{this.getName(type1), this.getName(prop1), this.getName(type2)});
                this.error(message, "commonSuperType", problemObject);
                return null;
            }
            return (EClassifier)this.resolveTupleType((EList<? extends TypedElement<EClassifier>>)tupleParts);
        }
        if (type1 instanceof PredefinedType || type2 instanceof PredefinedType) {
            if (!(type1 instanceof org.eclipse.ocl.types.CollectionType) && !(type2 instanceof org.eclipse.ocl.types.CollectionType)) {
                return (EClassifier)this.getEnvironment().getOCLStandardLibrary().getOclAny();
            }
            String message = NLS.bind(ValidationMessages.TypeMismatchNoCommonType, this.getName(type1), this.getName(type2));
            this.error(message, "commonSuperType", problemObject);
            return null;
        }
        EClassifier result = (EClassifier)this.getUMLReflection().getCommonSuperType((Object)type1, (Object)type2);
        if (result == null && (implictBaseClassifier = this.getImplicitRootClass()) != null && this.getUMLReflection().isClass((Object)type1) && this.getUMLReflection().isClass((Object)type2)) {
            result = implictBaseClassifier;
        }
        if (result == null) {
            String message = NLS.bind(ValidationMessages.TypeMismatchNoCommonType, this.getName(type1), this.getName(type2));
            this.error(message, "commonSuperType", problemObject);
            return null;
        }
        return result;
    }

    EOperation getMostSpecificOperation(List<EOperation> matchingOpers, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        if (matchingOpers == null || matchingOpers.isEmpty()) {
            return null;
        }
        List ambiguous = null;
        EOperation mostSpecific = null;
        int i = 0;
        for (EOperation nextOper : matchingOpers) {
            if (i++ == 0) {
                mostSpecific = nextOper;
                continue;
            }
            Relation nextOperRelation = this.getMoreSpecificByParameters(mostSpecific, nextOper, args);
            if (nextOperRelation == null) continue;
            if (nextOperRelation == Relation.IDENTICAL) {
                Relation ownerRelation = this.getMoreSpecificType((EClassifier)this.getUMLReflection().getOwningClassifier((Object)mostSpecific), (EClassifier)this.getUMLReflection().getOwningClassifier((Object)nextOper));
                if (Relation.IDENTICAL == ownerRelation) {
                    EOperation overriding = TypeCheckerImpl.selectOverridingOperation(mostSpecific, nextOper);
                    if (overriding != null) {
                        mostSpecific = overriding;
                    } else {
                        Module resolvingModule = this.getEnvironment().getModuleContextType();
                        if (resolvingModule != null) {
                            Module owningModule = QvtOperationalParserUtil.getOwningModule(mostSpecific);
                            Module nextOwningModule = QvtOperationalParserUtil.getOwningModule(nextOper);
                            if (owningModule == null || nextOwningModule == null) {
                                if (owningModule != null) {
                                    mostSpecific = nextOper;
                                }
                                nextOperRelation = Relation.AMBIGUOUS;
                            } else if (owningModule != resolvingModule && nextOwningModule != resolvingModule) {
                                nextOperRelation = Relation.AMBIGUOUS;
                            } else if (nextOwningModule == resolvingModule) {
                                mostSpecific = nextOper;
                            }
                        }
                    }
                } else if (Relation.LESS == ownerRelation) {
                    mostSpecific = nextOper;
                } else if (ownerRelation == null) {
                    continue;
                }
            } else if (nextOperRelation == Relation.LESS) {
                mostSpecific = nextOper;
            }
            if (nextOperRelation != Relation.AMBIGUOUS) continue;
            if (ambiguous == null) {
                ambiguous = new UniqueEList();
            }
            ambiguous.add(mostSpecific);
            ambiguous.add(nextOper);
        }
        if (ambiguous != null) {
            throw new AmbiguousLookupException(ValidationMessages.AmbiguousOperationLookup, ambiguous);
        }
        return mostSpecific != null ? mostSpecific : matchingOpers.get(0);
    }

    private static EOperation selectOverridingOperation(EOperation o1, EOperation o2) {
        if (o1 instanceof ImperativeOperation) {
            ImperativeOperation imp1 = (ImperativeOperation)o1;
            if (o2 != null && imp1.getOverridden() == o2) {
                return o1;
            }
        }
        if (o2 instanceof ImperativeOperation) {
            ImperativeOperation imp2 = (ImperativeOperation)o2;
            if (o1 != null && imp2.getOverridden() == o1) {
                return o2;
            }
        }
        return null;
    }

    private Relation getMoreSpecificByParameters(EOperation o1, EOperation o2, List<? extends TypedElement<EClassifier>> args) {
        if (o1 == o2) {
            return Relation.IDENTICAL;
        }
        EList params1 = o1.getEParameters();
        EList params2 = o2.getEParameters();
        assert (params1.size() == params2.size());
        if (params1.isEmpty()) {
            return Relation.IDENTICAL;
        }
        Relation resultParamRel = null;
        int i = 0;
        for (EParameter nextParam : params1) {
            EParameter nextParam2 = (EParameter)params2.get(i);
            Relation nextParamRel = this.getMoreSpecificType(nextParam.getEType(), nextParam2.getEType());
            if (nextParamRel == null) {
                return null;
            }
            if (nextParamRel == Relation.UNRELATED) {
                TypedElement<EClassifier> actualArg = args.get(i);
                OCLStandardLibrary oclStdLibrary = this.getEnvironment().getOCLStandardLibrary();
                if (oclStdLibrary.getOclVoid() == actualArg.getType() || oclStdLibrary.getOclInvalid() == actualArg.getType()) {
                    return Relation.AMBIGUOUS;
                }
                return null;
            }
            if (i++ == 0) {
                resultParamRel = nextParamRel;
                continue;
            }
            if (resultParamRel == nextParamRel || resultParamRel == Relation.IDENTICAL || nextParamRel == Relation.IDENTICAL) continue;
            return Relation.AMBIGUOUS;
        }
        return resultParamRel;
    }

    private Relation getMoreSpecificType(EClassifier t1, EClassifier t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        int relationship = this.getRelationship(t1, t2);
        switch (relationship) {
            case 2: {
                return Relation.MORE;
            }
            case 4: {
                return Relation.LESS;
            }
            case 1: {
                return Relation.IDENTICAL;
            }
        }
        return Relation.UNRELATED;
    }

    private EOperation findOperationForVoidOrInvalid(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        EClassifier argType;
        EOperation result = null;
        if (args.size() == 1 && (argType = (EClassifier)args.get(0).getType()) != owner) {
            result = this.findMostSpecificOperationMatching(argType, name, args);
        }
        return result;
    }

    private boolean isQVTOperation(EOperation operation) {
        return QvtOperationalParserUtil.getOwningModule(operation) != null;
    }

    private boolean isVoidOrInvalid(EClassifier type1) {
        return type1 == this.fOCLStdlib.getOclVoid() || type1 == this.fOCLStdlib.getOclInvalid();
    }

    private QVTOEnvironment getQVTEnvironment() {
        return this.getEnvironment();
    }

    private void error(String problemMessage, String problemContext, Object problemObject) {
        ((BasicEnvironment)OCLUtil.getAdapter((Environment)this.getEnvironment(), BasicEnvironment.class)).utilityError(problemMessage, problemContext, problemObject);
    }

    private String getName(Object element) {
        return element == null ? null : this.getUMLReflection().getName(element);
    }

    private EClassifier getImplicitRootClass() {
        EClassifier result = (EClassifier)ParsingOptions.getValue((Environment)this.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.getEnvironment()));
        if (result != null && !this.getEnvironment().getUMLReflection().isClass((Object)result)) {
            result = null;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Relation {
        MORE,
        LESS,
        IDENTICAL,
        AMBIGUOUS,
        UNRELATED;

    }
}

