/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.Arrays;
import lpg.lpgjavaruntime.IntSegmentedTuple;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOLexer;

class BasicLineNumberProvider
implements LineNumberProvider {
    private int[] fLineEnds;

    BasicLineNumberProvider(int[] lineEnds) {
        this.fLineEnds = (int[])lineEnds.clone();
    }

    BasicLineNumberProvider(QVTOLexer lexer) {
        IntSegmentedTuple lineOffsets = lexer.getLineOffsets();
        int[] lines = new int[lineOffsets.size()];
        boolean containsNegative = false;
        boolean isSorted = true;
        int i = 0;
        while (i < lines.length) {
            lines[i] = lineOffsets.get(i);
            if (lines[i] < 0) {
                containsNegative = true;
            }
            if (i == lines.length - 1) break;
            int next = lineOffsets.get(i + 1);
            if (lines[i] >= next) {
                isSorted = false;
                break;
            }
            ++i;
        }
        if (!isSorted) {
            Arrays.sort(lines);
        }
        if (containsNegative) {
            int negativeCount = 0;
            int i2 = 0;
            while (i2 < lines.length) {
                if (lines[i2] >= 0) break;
                ++negativeCount;
                ++i2;
            }
            int[] newLines = new int[lines.length - negativeCount];
            System.arraycopy(lines, negativeCount, newLines, 0, lines.length - negativeCount);
            lines = newLines;
        }
        this.fLineEnds = lines;
    }

    int[] lineBreakOffsets() {
        return (int[])this.fLineEnds.clone();
    }

    public int getLineEnd(int lineNumber) {
        return this.getLineEndInt(lineNumber - 1);
    }

    public int getLineCount() {
        return this.fLineEnds.length;
    }

    public int getLineNumber(int offset) {
        if (offset < 0) {
            return -1;
        }
        return this.getLineNumberInt(offset) + 1;
    }

    private int getLineEndInt(int lineNumber) {
        if (lineNumber >= 0 && lineNumber < this.fLineEnds.length) {
            return this.fLineEnds[lineNumber];
        }
        return -1;
    }

    public int getLineNumberInt(int offset) {
        int index = this.searchLineForOffset(offset);
        return index < 0 ? -index : (index == 0 ? 1 : index);
    }

    private int searchLineForOffset(int offset) {
        int low = 0;
        int high = this.fLineEnds.length;
        while (high > low) {
            int mid = (high + low) / 2;
            int mid_element = this.fLineEnds[mid];
            if (offset == mid_element) {
                return mid;
            }
            if (offset < mid_element) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -low;
    }
}

