/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.ExecEnv;
import org.eclipse.m2m.atl.engine.vm.NativeOperation;
import org.eclipse.m2m.atl.engine.vm.NativeStackFrame;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;

public abstract class StackFrame
extends ASMOclAny {
    public static ASMOclType myType = new ASMOclSimpleType("StackFrame", StackFrame.getOclAnyType());
    private ExecEnv execEnv;
    private Operation operation;
    private List args;
    protected Debugger debugger;
    private StackFrame parent = null;

    public StackFrame(ASMOclType myType, ExecEnv execEnv, Operation operation, List args) {
        super(myType);
        this.execEnv = execEnv;
        this.operation = operation;
        this.args = args;
        this.debugger = execEnv.getDebugger();
    }

    public StackFrame enterFrame(Operation op, List enterArgs) {
        StackFrame ret = null;
        ret = op instanceof ASMOperation ? new ASMStackFrame(this.execEnv, (ASMOperation)op, enterArgs) : new NativeStackFrame(this.execEnv, (NativeOperation)op, enterArgs);
        ret.setParent(this);
        this.debugger.enter(ret);
        this.execEnv.push(ret);
        return ret;
    }

    public StackFrame getParent() {
        return this.parent;
    }

    public void setParent(StackFrame parent) {
        this.parent = parent;
    }

    public ASMOclAny leaveFrame() {
        this.debugger.leave(this);
        return null;
    }

    public ExecEnv getExecEnv() {
        return this.execEnv;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public ASMModel getModel(String name) {
        return this.execEnv.getModel(name);
    }

    public Map getModels() {
        return this.execEnv.getModels();
    }

    public void printStackTrace() {
        this.printStackTrace(null, null);
    }

    public void printStackTrace(Exception e) {
        this.printStackTrace(null, e);
    }

    public void printStackTrace(String msg) {
        this.printStackTrace(msg, null);
    }

    public void printStackTrace(String msg, Exception e) {
        this.debugger.error(this, msg, e);
    }

    public List getArgs() {
        return this.args;
    }

    public ASMSequence getStack() {
        ASMSequence ret = new ASMSequence(this.execEnv.getStack());
        return ret;
    }

    public String getOpName() {
        return this.operation.getName();
    }
}

