/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm.asm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.ui.vm.Messages;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.engine.vm.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;

public class ASMFactory
extends ModelFactory {
    public static final String MODEL_FACTORY_NAME = "ASM";
    public static final String OPTION_MODEL_HANDLER = "modelHandlerName";
    public static final String OPTION_MODEL_NAME = "modelName";
    public static final String OPTION_MODEL_PATH = "path";
    public static final String OPTION_NEW_MODEL = "newModel";
    private static Map<String, ASMModelWrapper> metametamodels;
    private static Map<String, ASMModelWrapper> builtin;
    private static AtlModelHandler defaultModelHandler;
    private Map<AtlModelHandler, ModelLoader> modelLoaders;

    public ASMFactory() {
        metametamodels = new HashMap<String, ASMModelWrapper>();
        builtin = new HashMap<String, ASMModelWrapper>();
        defaultModelHandler = AtlModelHandler.getDefault((String)"EMF");
        this.modelLoaders = new HashMap<AtlModelHandler, ModelLoader>();
    }

    public String getDefaultExtractorName() {
        return MODEL_FACTORY_NAME;
    }

    public String getDefaultInjectorName() {
        return MODEL_FACTORY_NAME;
    }

    public IModel newModel(IReferenceModel referenceModel, Map<String, Object> options) {
        String modelName = (String)options.get(OPTION_MODEL_NAME);
        String path = (String)options.get(OPTION_MODEL_PATH);
        boolean newModel = "true".equals(options.get(OPTION_NEW_MODEL).toString());
        return new ASMModelWrapper((ASMModelWrapper)referenceModel, this, ((ASMModelWrapper)referenceModel).getModelLoader(), modelName, path, newModel);
    }

    public IReferenceModel newReferenceModel(Map<String, Object> options) {
        String modelHandlerName = (String)options.get(OPTION_MODEL_HANDLER);
        String modelName = (String)options.get(OPTION_MODEL_NAME);
        String path = (String)options.get(OPTION_MODEL_PATH);
        if (path != null && path.startsWith("#")) {
            return ASMFactory.getMetametamodel(modelHandlerName);
        }
        return new ASMModelWrapper(ASMFactory.getMetametamodel(modelHandlerName), this, this.getModelLoader(this.getModelHandler(modelHandlerName)), modelName, path, false);
    }

    private AtlModelHandler getModelHandler(String modelHandlerName) {
        AtlModelHandler modelHandler = null;
        modelHandler = modelHandlerName != null ? AtlModelHandler.getDefault((String)modelHandlerName) : defaultModelHandler;
        return modelHandler;
    }

    private ModelLoader getModelLoader(AtlModelHandler handler) {
        ModelLoader ml = this.modelLoaders.get(handler);
        if (ml == null) {
            ml = handler.createModelLoader();
            this.modelLoaders.put(handler, ml);
        }
        return ml;
    }

    public IModel newModel(IReferenceModel referenceModel) throws ATLCoreException {
        throw new ATLCoreException(Messages.getString("ASMFactory.MISSING_PARAMS"));
    }

    public IReferenceModel newReferenceModel() throws ATLCoreException {
        throw new ATLCoreException(Messages.getString("ASMFactory.MISSING_PARAMS"));
    }

    public IReferenceModel getBuiltInResource(String name) {
        if (builtin.get(name) == null) {
            ModelLoader ml = this.getModelLoader(defaultModelHandler);
            ASMModelWrapper metamodel = new ASMModelWrapper(ml.getBuiltInMetaModel(name), ml);
            builtin.put(name, metamodel);
        }
        return builtin.get(name);
    }

    public static ASMModelWrapper getMetametamodel(String modelHandlerName) {
        if (metametamodels.get(modelHandlerName) == null) {
            AtlModelHandler amh = AtlModelHandler.getDefault((String)modelHandlerName);
            ModelLoader ml = amh.createModelLoader();
            ASMModelWrapper metametamodel = new ASMModelWrapper(ml.getMOF(), ml);
            metametamodels.put(modelHandlerName, metametamodel);
        }
        return metametamodels.get(modelHandlerName);
    }

    public IReferenceModel getMetametamodel() {
        return ASMFactory.getMetametamodel("EMF");
    }
}

