/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterPropertyPage;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlPreview;
import org.eclipse.m2m.atl.adt.ui.preferences.ModifyDialogTabPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AtlCodeFormatterPropertiesTabPage
extends ModifyDialogTabPage {
    private AtlPreview fPreview;
    private Table preferencesTable;
    private TableColumn valueColumn;
    private final IDialogSettings fDialogSettings;

    public AtlCodeFormatterPropertiesTabPage(Map<String, String> workingValues) {
        this.setWorkingValues(workingValues);
        this.fDialogSettings = AtlUIPlugin.getDefault().getDialogSettings();
    }

    public Table getPreferencesTable() {
        return this.preferencesTable;
    }

    public TableColumn[] getEditableColumns() {
        return new TableColumn[]{this.valueColumn};
    }

    @Override
    public AtlPreview getPreview() {
        return this.fPreview;
    }

    @Override
    protected void initializePage() {
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        AtlCodeFormatterPropertiesTabPage.createLabel(numColumns, composite, "Properties (click on a value to change it, except for built-in profiles):");
        this.preferencesTable = new Table(composite, 2048);
        this.preferencesTable.setHeaderVisible(true);
        TableColumn propertyColumn = new TableColumn(this.preferencesTable, 0);
        propertyColumn.setWidth(75);
        propertyColumn.setText("Property");
        this.valueColumn = new TableColumn(this.preferencesTable, 0);
        this.valueColumn.setText("Value");
        this.valueColumn.setAlignment(0x1000000);
        this.valueColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (AtlCodeFormatterPropertiesTabPage.this.valueColumn.getWidth() < 50) {
                    AtlCodeFormatterPropertiesTabPage.this.valueColumn.setWidth(50);
                }
            }
        });
        GridData gd = AtlCodeFormatterPropertiesTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.preferencesTable.setLayoutData((Object)gd);
    }

    @Override
    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        AtlCodeFormatterPropertiesTabPage.createLabel(numColumns - 1, composite, "Preview:");
        this.fShowInvisibleButton = new Button(composite, 32);
        this.fShowInvisibleButton.setText("Show invisible characters");
        this.fShowInvisibleButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.fShowInvisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AtlCodeFormatterPropertiesTabPage.this.fPreview.showInvisibleCharacters(AtlCodeFormatterPropertiesTabPage.this.fShowInvisibleButton.getSelection());
                AtlCodeFormatterPropertiesTabPage.this.fDialogSettings.put(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY, AtlCodeFormatterPropertiesTabPage.this.fShowInvisibleButton.getSelection());
                AtlCodeFormatterPropertiesTabPage.this.doUpdatePreview();
            }
        });
        this.fPreview = this.doCreateAtlPreview(composite);
        this.fDefaultFocusManager.add(this.fPreview.getControl());
        GridData gd = AtlCodeFormatterPropertiesTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fPreview.getControl().setLayoutData((Object)gd);
        this.fPreview.setText("-- @nsURI MM1 = http://www.my.site/path/to/my/MM1\n-- @path MM2 = /MyProject/MM2.ecore\n\nmodule MyModule;\n\ncreate OUT: MM1 from IN: MM2;\n\n--- This is a special helper comment\nhelper def: simpleHelper: String =\nlet letVar : String = 'A first let variable' in\nlet letVar2 : String = 'Another let variable' in\n\tif true then\n\t\t\tletVar\n\t\telse\n\t\t\tletVar2\n\t\tendif\n\tand\n\ttrue;\n\nhelper def: simpleParametersHelper(t1: String, t2: Integer, t3: Integer):\n\t\tSequence(TupleType(a: Integer, b: String)) =\n\tt1 <= 'This is a string'\n\tand\n\tt2 = 5 / 1-- A comment\n\t; -- Another comment\n\nhelper context String def: simpleContextHelper(t1: String, t2: Integer): OclAny =\n\tt1 = 't1'\n\tand\n\tt2 = 5 + 1;\n\n-- This is a normal comment\n--- This is a special rule comment\nrule MyRule {\n\tfrom\n\t\tinput2: MM1!MyClass in IN (\n\t\t\ttrue\n\t\t)\n\tto\n\t\toutput: MM2!MyClass2 (\n\t\t\tname <- input.name -> toString(),\n\t\t\tabstract <- false\n\t\t),\n\t\toutput2: MM2!MyClass2 (\n\t\t\tname <- 'Test'\n\t\t)\n\tdo {\n\t\t\n\t}\n}\n");
        boolean selected = this.fDialogSettings.getBoolean(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY);
        this.fPreview.showInvisibleCharacters(selected);
        this.fShowInvisibleButton.setSelection(selected);
        return composite;
    }

    @Override
    protected void doUpdatePreview() {
        boolean showInvisible = this.isShowInvisible();
        this.fPreview.showInvisibleCharacters(showInvisible);
        this.fShowInvisibleButton.setSelection(showInvisible);
        this.fPreview.updateEditor();
    }

    private boolean isShowInvisible() {
        return this.fDialogSettings.getBoolean(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY);
    }

    @Override
    protected AtlPreview doCreateAtlPreview(Composite parent) {
        AtlPreview preview = new AtlPreview(this.fWorkingValues, parent);
        return preview;
    }

    @Override
    public void updateTab(boolean enabled) {
        if (!this.preferencesTable.isDisposed()) {
            this.preferencesTable.setEnabled(enabled);
        }
        boolean selected = this.fDialogSettings.getBoolean(AtlCodeFormatterPropertyPage.SHOW_INVISIBLE_PREFERENCE_KEY);
        this.fPreview.showInvisibleCharacters(selected);
        this.getShowInvisibleButton().setSelection(selected);
        this.fPreview.updateEditor();
    }
}

