/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.m2m.atl.adt.ui.common.WorkspaceFileDialog;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.ui.ATLCoreUIPlugin;
import org.eclipse.m2m.atl.core.ui.Messages;
import org.eclipse.m2m.atl.core.ui.launch.MainAtlTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedTab
extends AbstractLaunchConfigurationTab {
    public static final String OPTION_DERIVED = "OPTION_DERIVED";
    public static final String OPTION_CLEAR = "OPTION_CLEAR";
    public static final String OPTION_CONTENT_TYPE = "OPTION_CONTENT_TYPE";
    static final String SUPERIMPOSE = "SUPERIMPOSE";
    private Composite container;
    private Group groupSuperimpose;
    private Table tableSuperimpose;
    private Button buttonSuperimpose;
    private Button buttonRemoveSuperimpose;
    private Group groupOthersInformation;
    private Combo atlVMs;
    private Text debuggerPortText;
    private Map<String, Button> buttonArray = new HashMap<String, Button>();
    private Map<String, String> baseOptions = new LinkedHashMap<String, String>();
    private Map<String, String> defaultValues = new HashMap<String, String>();

    public AdvancedTab() {
        this.baseOptions.put(OPTION_DERIVED, "Set generated files as derived");
        this.baseOptions.put(OPTION_CLEAR, "Clear console before launch");
        this.baseOptions.put(OPTION_CONTENT_TYPE, "Output model content types detection");
        this.defaultValues.put(OPTION_DERIVED, "true");
        this.defaultValues.put(OPTION_CLEAR, "false");
        this.defaultValues.put(OPTION_CONTENT_TYPE, "false");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.groupSuperimpose = new Group(this.container, 0);
        this.buttonSuperimpose = new Button((Composite)this.groupSuperimpose, 0x1000000);
        this.tableSuperimpose = new Table((Composite)this.groupSuperimpose, 67584);
        this.buttonRemoveSuperimpose = new Button((Composite)this.groupSuperimpose, 0x1000000);
        this.groupOthersInformation = new Group(this.container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        GridData gd3 = new GridData(768);
        this.groupOthersInformation.setLayoutData((Object)gd3);
        this.container.setLayout((Layout)layout);
        this.groupSuperimpose.setLayoutData((Object)new GridData(1808));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupSuperimpose.setLayout((Layout)groupLayout);
        this.groupSuperimpose.setText(Messages.getString("AdvancedTab.SUPERIMPOSE"));
        this.buttonSuperimpose.setText(Messages.getString("AdvancedTab.ADD"));
        this.buttonSuperimpose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AdvancedTab.this.addPath(AdvancedTab.this.tableSuperimpose);
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonRemoveSuperimpose.setText(Messages.getString("AdvancedTab.REMOVE"));
        this.buttonRemoveSuperimpose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AdvancedTab.this.removePath(AdvancedTab.this.tableSuperimpose);
                AdvancedTab.this.buttonRemoveSuperimpose.setEnabled(false);
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonRemoveSuperimpose.setEnabled(false);
        this.tableSuperimpose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTab.this.buttonRemoveSuperimpose.setEnabled(AdvancedTab.this.tableSuperimpose.getSelectionIndex() > -1);
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.tableSuperimpose.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tableSuperimpose.setLinesVisible(true);
        this.tableSuperimpose.setHeaderVisible(true);
        TableColumn superimposeName = new TableColumn(this.tableSuperimpose, 16384);
        superimposeName.setText(Messages.getString("AdvancedTab.SUPERIMPOSE"));
        this.buttonSuperimpose.setLayoutData((Object)new GridData(768));
        this.buttonRemoveSuperimpose.setLayoutData((Object)new GridData(770));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 3;
        this.tableSuperimpose.setLayoutData((Object)gd);
        this.groupOthersInformation.setText(Messages.getString("MainAtlTab.OTHERSPARAMETERS"));
        Composite groupATLVMs = new Composite((Composite)this.groupOthersInformation, 32);
        Label atlVMLabel = new Label(groupATLVMs, 0);
        atlVMLabel.setText(Messages.getString("AdvancedTab.ATLVM"));
        atlVMLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.atlVMs = new Combo(groupATLVMs, 8);
        this.atlVMs.setLayoutData((Object)new GridData(768));
        this.atlVMs.setItems(CoreService.getLaunchersNames((String)this.getLaunchConfigurationDialog().getMode()));
        this.atlVMs.select(0);
        this.atlVMs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdvancedTab.this.buildCheckButtons();
                AdvancedTab.this.container.layout();
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        if (this.isDebug()) {
            Label debuggerPortLabel = new Label(groupATLVMs, 0);
            debuggerPortLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            debuggerPortLabel.setText(Messages.getString("AdvancedTab.DEBUGGER_PORT"));
            this.debuggerPortText = new Text(groupATLVMs, 2048);
            this.debuggerPortText.setLayoutData((Object)new GridData(768));
            this.debuggerPortText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AdvancedTab.this.updateLaunchConfigurationDialog();
                }
            });
        }
        groupATLVMs.setLayout((Layout)new GridLayout(2, false));
        groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupOthersInformation.setLayout((Layout)groupLayout);
        this.container.layout();
        this.container.pack();
        this.setControl((Control)this.container);
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
            int i = 0;
            while (i < tabs.length) {
                if (tabs[i] instanceof MainAtlTab) {
                    MainAtlTab mainTab = (MainAtlTab)tabs[i];
                    mainTab.launcherNameChanged(this.getLauncherName());
                    mainTab.superimposedChanged(this.createSuperimposedList());
                }
                ++i;
            }
        }
        super.updateLaunchConfigurationDialog();
    }

    private Map<String, String> getCheckButtonsValues() {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String optionId : this.buttonArray.keySet()) {
            String optionValue = Boolean.valueOf(this.buttonArray.get(optionId).getSelection()).toString();
            options.put(optionId, optionValue);
        }
        return options;
    }

    private void buildCheckButtons() {
        Iterator<Button> iterator = this.buttonArray.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.buttonArray = new HashMap<String, Button>();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.putAll(this.baseOptions);
        options.putAll(CoreService.getLauncherOptions((String)this.atlVMs.getItem(this.atlVMs.getSelectionIndex()), (String)this.getLaunchConfigurationDialog().getMode()));
        for (Map.Entry option : options.entrySet()) {
            Button newCheckButton = new Button((Composite)this.groupOthersInformation, 32);
            newCheckButton.setLayoutData((Object)new GridData(1808));
            newCheckButton.setText((String)option.getValue());
            newCheckButton.setSelection(this.getDefaultValue((String)option.getKey()));
            newCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvancedTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.buttonArray.put((String)option.getKey(), newCheckButton);
        }
    }

    private boolean getDefaultValue(String key) {
        String value = this.defaultValues.get(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public String getName() {
        return Messages.getString("ATLLaunchConstants.ADVANCED");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            List superimpose = configuration.getAttribute("Superimpose", Collections.EMPTY_LIST);
            this.tableSuperimpose.removeAll();
            for (String mName : superimpose) {
                TableItem item = new TableItem(this.tableSuperimpose, 0);
                item.setText(mName);
            }
            if (this.isDebug()) {
                String port = configuration.getAttribute("Port", Integer.valueOf(6060).toString());
                this.debuggerPortText.setText(port);
            }
            int item = 0;
            while (item < this.atlVMs.getItems().length) {
                if (this.atlVMs.getItem(item).equals(CoreService.getCompatibleLauncherName((String)configuration.getAttribute("ATL VM", "EMF-specific VM")))) {
                    this.atlVMs.select(item);
                }
                ++item;
            }
            this.defaultValues.putAll(configuration.getAttribute("Options", Collections.emptyMap()));
            this.buildCheckButtons();
        }
        catch (CoreException e) {
            this.tableSuperimpose.removeAll();
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private List<String> createSuperimposedList() {
        ArrayList<String> superimpose = new ArrayList<String>();
        int i = 0;
        while (i < this.tableSuperimpose.getItemCount()) {
            TableItem ti = this.tableSuperimpose.getItem(i);
            superimpose.add(ti.getText());
            ++i;
        }
        return superimpose;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.defaultValues = this.getCheckButtonsValues();
        configuration.setAttribute("Superimpose", this.createSuperimposedList());
        configuration.setAttribute("Options", this.defaultValues);
        configuration.setAttribute("ATL VM", this.atlVMs.getItem(this.atlVMs.getSelectionIndex()));
        if (this.isDebug()) {
            configuration.setAttribute("Port", this.debuggerPortText.getText());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean canSave() {
        if (this.isDebug()) {
            String port = this.debuggerPortText.getText();
            try {
                Integer.valueOf(port);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.getString("AdvancedTab.DEBUG_PORT"));
                return false;
            }
        }
        if (this.tableSuperimpose.getItemCount() != 0) {
            int i = 0;
            while (i < this.tableSuperimpose.getItemCount()) {
                if (this.tableSuperimpose.getItem(i).getText().equals("")) {
                    this.setErrorMessage(Messages.getString("AdvancedTab.GIVEPATHSUPERIMPOSE"));
                    return false;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public Image getImage() {
        return ATLCoreUIPlugin.getImage("atl_logo.gif");
    }

    private void addPath(Table table) {
        WorkspaceFileDialog dialog = new WorkspaceFileDialog(this.getShell(), new String[]{"asm"});
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result != null && result instanceof IFile) {
            IFile currentFile = (IFile)result;
            TableItem item = new TableItem(table, 0);
            item.setText(currentFile.getFullPath().toString());
        }
    }

    private void removePath(Table table) {
        int index = table.getSelectionIndex();
        if (index == -1) {
            AdvancedTab.messageBox(this.container.getShell(), Messages.getString("AdvancedTab.CHOOSEENTRY"));
            return;
        }
        table.remove(index);
    }

    private String getLauncherName() {
        return this.atlVMs.getItem(this.atlVMs.getSelectionIndex());
    }

    public static void messageBox(Shell shell, String textToDisplay) {
        MessageBox msgBox = new MessageBox(shell, 65568);
        msgBox.setText(Messages.getString("AdvancedTab.ERROR"));
        msgBox.setMessage(textToDisplay);
        msgBox.open();
    }

    private boolean isDebug() {
        return this.getLaunchConfigurationDialog().getMode().equals("debug");
    }
}

