/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclParametrizedType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;

public abstract class ASMCollection
extends ASMOclAny {
    public static ASMOclType myType = ASMOclParametrizedType.getASMOclParametrizedType("Collection", ASMCollection.getOclAnyType(), ASMCollection.getOclAnyType());

    public ASMCollection(ASMOclType type) {
        super(type);
    }

    public abstract Iterator iterator();

    public abstract Collection collection();

    public ASMOclAny get(StackFrame frame, String name) {
        frame.printStackTrace("ERROR: Collections do not have properties, use ->collect()");
        return null;
    }

    public int size() {
        return this.collection().size();
    }

    public abstract void add(ASMOclAny var1);

    public static ASMInteger size(StackFrame frame, ASMCollection self) {
        return new ASMInteger(self.collection().size());
    }

    public static ASMBoolean includes(StackFrame frame, ASMCollection self, ASMOclAny o) {
        return new ASMBoolean(self.collection().contains(o));
    }

    public static ASMBoolean excludes(StackFrame frame, ASMCollection self, ASMOclAny o) {
        return new ASMBoolean(!self.collection().contains(o));
    }

    public static ASMInteger count(StackFrame frame, ASMCollection self, ASMOclAny object) {
        int ret = 0;
        Collection c = self.collection();
        if (c instanceof Set) {
            ret = c.contains(object) ? 1 : 0;
        } else {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                ASMOclAny o = (ASMOclAny)i.next();
                if (!object.equals(o)) continue;
                ++ret;
            }
        }
        return new ASMInteger(ret);
    }

    public static ASMBoolean includesAll(StackFrame frame, ASMCollection self, ASMCollection o) {
        return new ASMBoolean(self.collection().containsAll(o.collection()));
    }

    public static ASMBoolean excludesAll(StackFrame frame, ASMCollection self, ASMCollection o) {
        boolean ret = true;
        Iterator i = o.iterator();
        while (i.hasNext()) {
            boolean bl = ret = ret && !self.collection().contains(i.next());
        }
        return new ASMBoolean(ret);
    }

    public static ASMBoolean isEmpty(StackFrame frame, ASMCollection self) {
        return new ASMBoolean(self.collection().size() == 0);
    }

    public static ASMBoolean notEmpty(StackFrame frame, ASMCollection self) {
        return new ASMBoolean(self.collection().size() != 0);
    }

    public static ASMOclAny sum(StackFrame frame, ASMCollection self) {
        ASMOclAny ret = null;
        Iterator i = self.iterator();
        while (i.hasNext()) {
            ASMOclAny o = (ASMOclAny)i.next();
            if (ret == null) {
                ret = o;
                continue;
            }
            Operation oper = ((ASMExecEnv)frame.getExecEnv()).getOperation(ret.getType(), "+");
            ArrayList<ASMOclAny> arguments = new ArrayList<ASMOclAny>();
            arguments.add(ret);
            arguments.add(o);
            if (oper != null) {
                ret = oper.exec(frame.enterFrame(oper, arguments));
                continue;
            }
            frame.printStackTrace("ERROR: could not find operation + on " + ret.getType() + " having supertypes: " + ret.getType().getSupertypes());
        }
        return ret;
    }

    public static ASMBag asBag(StackFrame frame, ASMCollection self) {
        return new ASMBag(self.collection());
    }

    public static ASMSequence asSequence(StackFrame frame, ASMCollection self) {
        return new ASMSequence(self.collection());
    }

    public static ASMSet asSet(StackFrame frame, ASMCollection self) {
        return new ASMSet(self.collection());
    }
}

