/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests.etl;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfModelFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.epsilon.etl.execute.context.EtlContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.BigMDE2016CGTests;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.FamiliesPackage;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Persons.PersonsPackage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BigMDE2016ETLTests
extends TestCase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Families2Persons_ETL() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                EtlModule transformationLauncher = new EtlModule();
                EmfModelFactory zmodelFactory = EmfModelFactory.getInstance();
                String etlpath = "src/org/eclipse/qvtd/doc/bigmde2016/tests/etl/Families2Persons.etl";
                File file = new File(etlpath);
                transformationLauncher.parse(file);
                EmfModel familiesModel = new EmfModel();
                familiesModel.setName("Families");
                familiesModel.setMetamodelFileBased(false);
                familiesModel.setMetamodelUri(FamiliesPackage.eINSTANCE.getNsURI());
                familiesModel.setResource((Resource)new XMIResourceImpl());
                EmfModelFactory.AccessMode.READ_ONLY.applyTo(familiesModel);
                List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
                familiesModel.getResource().getContents().clear();
                familiesModel.getResource().getContents().addAll(rootObjects);
                EmfModel personsModel = new EmfModel();
                personsModel.setName("Persons");
                personsModel.setMetamodelFileBased(false);
                personsModel.setMetamodelUri(PersonsPackage.eINSTANCE.getNsURI());
                personsModel.setResource((Resource)new XMIResourceImpl());
                EmfModelFactory.AccessMode.WRITE_ONLY.applyTo(personsModel);
                transformationLauncher.getContext().getModelRepository().addModel((IModel)familiesModel);
                transformationLauncher.getContext().getModelRepository().addModel((IModel)personsModel);
                logger.printf("%9d, ", 10 * testSize);
                BigMDE2016CGTests.garbageCollect();
                long startTime = System.nanoTime();
                transformationLauncher.execute();
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                Resource personsResource = personsModel.getResource();
                @NonNull EList rootObjects2 = personsResource.getContents();
                assert (rootObjects2.size() == 9 * testSize);
                transformationLauncher.getImports().clear();
                transformationLauncher.getDeclaredOperations().clear();
                transformationLauncher.getOperations().clear();
                transformationLauncher.getDeclaredPost().clear();
                transformationLauncher.getDeclaredPre().clear();
                transformationLauncher.getPost().clear();
                transformationLauncher.getPre().clear();
                transformationLauncher.getDeclaredTransformationRules().clear();
                transformationLauncher.getTransformationRules().clear();
                transformationLauncher.setContext((IEolContext)new EtlContext());
                transformationLauncher.getContext().getModelRepository().dispose();
                transformationLauncher.getContext().dispose();
                ++n2;
            }
        }
        finally {
            logger.dispose();
        }
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

