/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.exe2016.tests.etl;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfModelFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.epsilon.etl.execute.context.EtlContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.doc.exe2016.tests.AbstractEXE2016CGTests;
import org.eclipse.qvtd.doc.exe2016.tests.DoublyLinkedListGenerator;
import org.eclipse.qvtd.doc.exe2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.DoublyLinkedList;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.DoublylinkedlistPackage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EXE2016_ETL_Tests
extends AbstractEXE2016CGTests {
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Forward2Reverse_ETL() throws Exception {
        DoublyLinkedListGenerator doublyLinkedListGenerator = new DoublyLinkedListGenerator();
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        try {
            int[] tests = PrintAndLog.getTestSizes();
            boolean isFirst = true;
            int[] nArray = tests;
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                if (isFirst) {
                    isFirst = false;
                    testSize = 500;
                }
                EtlModule transformationLauncher = new EtlModule();
                EmfModelFactory modelFactory = EmfModelFactory.getInstance();
                String etlpath = "src/org/eclipse/qvtd/doc/exe2016/tests/etl/Forward2Reverse.etl";
                File file = new File(etlpath);
                transformationLauncher.parse(file);
                EmfModel forwardListModel = new EmfModel();
                forwardListModel.setName("ForwardList");
                forwardListModel.setMetamodelFileBased(false);
                forwardListModel.setMetamodelUri(DoublylinkedlistPackage.eINSTANCE.getNsURI());
                forwardListModel.setResource((Resource)new XMIResourceImpl());
                EmfModelFactory.AccessMode.READ_ONLY.applyTo(forwardListModel);
                List<@NonNull EObject> rootObjects = doublyLinkedListGenerator.createDoublyLinkedListModel(testSize);
                forwardListModel.getResource().getContents().clear();
                forwardListModel.getResource().getContents().addAll(rootObjects);
                EmfModel reverseListModel = new EmfModel();
                reverseListModel.setName("ReverseList");
                reverseListModel.setMetamodelFileBased(false);
                reverseListModel.setMetamodelUri(DoublylinkedlistPackage.eINSTANCE.getNsURI());
                reverseListModel.setResource((Resource)new XMIResourceImpl());
                EmfModelFactory.AccessMode.WRITE_ONLY.applyTo(reverseListModel);
                reverseListModel.setStoredOnDisposal(false);
                transformationLauncher.getContext().getModelRepository().addModel((IModel)forwardListModel);
                transformationLauncher.getContext().getModelRepository().addModel((IModel)reverseListModel);
                logger.printf("%9d, ", testSize);
                EXE2016_ETL_Tests.garbageCollect();
                long startTime = System.nanoTime();
                transformationLauncher.execute();
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                Resource reverseListResource = reverseListModel.getResource();
                @NonNull EList rootObjects2 = reverseListResource.getContents();
                Iterator<@NonNull E> it = rootObjects2.iterator();
                Object rootObject = it.next();
                assert (!it.hasNext());
                assert (((DoublyLinkedList)rootObject).getOwnedElements().size() == testSize - 1);
                doublyLinkedListGenerator.checkModel((DoublyLinkedList)rootObject, testSize);
                transformationLauncher.getContext().getModelRepository().dispose();
                transformationLauncher.getContext().dispose();
                transformationLauncher.getImports().clear();
                transformationLauncher.getDeclaredOperations().clear();
                transformationLauncher.getOperations().clear();
                transformationLauncher.getDeclaredPost().clear();
                transformationLauncher.getDeclaredPre().clear();
                transformationLauncher.getPost().clear();
                transformationLauncher.getPre().clear();
                transformationLauncher.getDeclaredTransformationRules().clear();
                transformationLauncher.getTransformationRules().clear();
                transformationLauncher.setContext((IEolContext)new EtlContext());
                ++n2;
            }
        }
        finally {
            logger.dispose();
        }
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

