/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.CheckedConditionWeightComparator;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.NavigationEdgeSorter;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiNodeVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatementPart;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SpeculateStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.ExpressionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeLibraryHelper;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class BasicPartition2Mapping
extends AbstractPartition2Mapping {
    protected final @NonNull RegionAnalysis regionAnalysis;
    private @Nullable Map<@NonNull Node, @NonNull Set<@NonNull Node>> node2precedingNodeClosure = null;
    private final @NonNull List<@NonNull Node> headNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> guardNodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Node, @NonNull VariableDeclaration> node2variable = new HashMap<Node, VariableDeclaration>();
    private final @NonNull ReachabilityForest reachabilityForest;
    private final @NonNull CheckedConditionAnalysis checkedConditionAnalysis;

    public BasicPartition2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Mapping mapping, @NonNull MappingPartitionAnalysis<?> partitionAnalysis) {
        super(visitor, mapping, (Partition)partitionAnalysis.getPartition());
        StringBuilder s;
        this.regionAnalysis = this.scheduleManager.getRegionAnalysis(QVTscheduleUtil.getRegion((Partition)this.partition));
        this.reachabilityForest = partitionAnalysis.getReachabilityForest();
        this.checkedConditionAnalysis = new CheckedConditionAnalysis(partitionAnalysis, this.scheduleManager);
        this.addTrace((Element)mapping, (GraphStringBuilder.GraphElement)this.partition);
        StringBuilder stringBuilder = s = TransformationPartitioner.PROPERTY_OBSERVE.isActive() ? new StringBuilder() : null;
        if (s != null) {
            s.append("[" + this.partition.getPassRangeText() + "] " + this.partition.getName());
        }
        this.checkedConditionAnalysis.computeCheckedPropertyDatums(s);
        if (s != null) {
            TransformationPartitioner.PROPERTY_OBSERVE.println(s.toString());
        }
    }

    public void addVariable(@NonNull Node node, @NonNull VariableDeclaration variableDeclaration) {
        VariableDeclaration oldVariableDeclaration = this.node2variable.put(node, variableDeclaration);
        assert (oldVariableDeclaration == null);
        this.addTrace((Element)variableDeclaration, (GraphStringBuilder.GraphElement)node);
    }

    public @Nullable VariableDeclaration basicGetVariable(@NonNull Node node) {
        return this.node2variable.get(node);
    }

    private void createAddStatements() {
        if (this.connection2variable != null) {
            ArrayList<@NonNull K> connections = new ArrayList(this.connection2variable.keySet());
            Collections.sort(connections, NameUtil.NAMEABLE_COMPARATOR);
            for (NodeConnection connection : connections) {
                Node sourceNode = connection.getSource(this.partition);
                OCLExpression variableExpression = this.createVariableExp(sourceNode);
                ConnectionVariable connectionVariable = (ConnectionVariable)this.connection2variable.get(connection);
                assert (connectionVariable != null);
                AddStatement addStatement = this.createAddStatement(connectionVariable, variableExpression);
                this.addTrace((Element)addStatement, (GraphStringBuilder.GraphElement)sourceNode);
            }
        }
    }

    private void createCallStatements(@NonNull Map<@NonNull Partition, @NonNull Map<@NonNull Node, @NonNull Node>> calls) {
        ArrayList<@NonNull MappingCall> mappingStatements = new ArrayList<MappingCall>();
        HashMap<@NonNull LoopVariable, @NonNull OCLExpression> loopVariables = null;
        for (Map.Entry<Partition, Map<Node, Node>> entry : calls.entrySet()) {
            @NonNull Partition calledPartition = entry.getKey();
            AbstractPartition2Mapping calledRegion2Mapping = this.visitor.getPartition2Mapping(calledPartition);
            ArrayList<@NonNull MappingParameterBinding> mappingParameterBindings = new ArrayList<MappingParameterBinding>();
            for (Map.Entry<Node, Node> entry2 : entry.getValue().entrySet()) {
                @NonNull Node sourceNode = entry2.getKey();
                @NonNull Node targetNode = entry2.getValue();
                OCLExpression sourceExpression = this.createVariableExp(sourceNode);
                Type type = sourceExpression.getType();
                if (type instanceof CollectionType) {
                    if (loopVariables == null) {
                        loopVariables = new HashMap<LoopVariable, OCLExpression>();
                    }
                    Type elementType = ((CollectionType)type).getElementType();
                    assert (elementType != null);
                    LoopVariable loopVariable = this.helper.createLoopVariable(this.getSafeName("loop" + loopVariables.size()), elementType);
                    loopVariables.put(loopVariable, sourceExpression);
                    MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                    mappingParameterBindings.add((MappingParameterBinding)this.helper.createLoopParameterBinding((GuardParameter)guardVariable, loopVariable));
                    continue;
                }
                MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createSimpleParameterBinding((SimpleParameter)guardVariable, sourceExpression));
            }
            Collections.sort(mappingParameterBindings, QVTimperativeUtil.MappingParameterBindingComparator.INSTANCE);
            MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingParameterBindings);
            if (loopVariables != null) {
                for (Map.Entry loopEntry : loopVariables.entrySet()) {
                    @NonNull LoopVariable loopVariable = (LoopVariable)loopEntry.getKey();
                    @NonNull OCLExpression loopSource = (OCLExpression)loopEntry.getValue();
                    mappingCallStatement = this.helper.createMappingLoop(loopSource, loopVariable, (MappingStatement)mappingCallStatement);
                }
            }
            mappingStatements.add(mappingCallStatement);
        }
        this.mapping.getOwnedStatements().addAll(mappingStatements);
    }

    private void createAssignedValues(@NonNull Iterable<@NonNull NavigableEdge> sortedRealizedEdges) {
        for (NavigableEdge edge : sortedRealizedEdges) {
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            if (sourceNode.isOld() && !sourceNode.isConstant()) {
                this.getVariableDeclaration(sourceNode);
            }
            if (!targetNode.isOld() || targetNode.isConstant()) continue;
            this.getVariableDeclaration(targetNode);
        }
    }

    private @NonNull CheckStatement createCheckStatement(@NonNull OCLExpression booleanExpression) {
        CheckStatement checkStatement = this.helper.createCheckStatement(booleanExpression);
        this.mapping.getOwnedStatements().add((Object)checkStatement);
        return checkStatement;
    }

    private void createCheckStatement(@NonNull OCLExpression firstExpression, @NonNull String operatorName, @NonNull OCLExpression secondExpression, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull GraphStringBuilder.GraphElement graphElement) {
        OperationCallExp booleanExpression = this.helper.createOperationCallExp(firstExpression, operatorName, new OCLExpression[]{secondExpression});
        this.addTrace((Element)booleanExpression, graphElement);
        CheckStatement checkStatement = this.createCheckStatement((OCLExpression)booleanExpression);
        this.addTrace((Element)checkStatement, graphElement);
    }

    private @NonNull DeclareStatement createCheckedDeclareStatement(@NonNull String name, @NonNull OCLExpression sourceExp, @NonNull Type requiredType) {
        String safeName = this.getSafeName(name);
        DeclareStatement castStatement = this.helper.createDeclareStatement(safeName, requiredType, true, sourceExp);
        this.mapping.getOwnedStatements().add((Object)castStatement);
        return castStatement;
    }

    private void createClassSetStatement(@Nullable StringBuilder s, @NonNull NavigableEdge edge) {
        if (edge instanceof NavigationEdge) {
            boolean isPartial;
            OCLExpression valueExpression;
            Property setProperty;
            VariableDeclaration slotVariable;
            NavigationEdge navigationEdge = (NavigationEdge)edge;
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
            boolean isNotify = this.connectionManager.isHazardousWrite(s, navigationEdge);
            if (property.isIsImplicit()) {
                slotVariable = this.getVariableDeclaration(targetNode);
                setProperty = QVTrelationUtil.getOpposite((Property)property);
                valueExpression = this.createVariableExp(sourceNode);
                isPartial = setProperty.isIsMany();
            } else {
                slotVariable = this.getVariableDeclaration(sourceNode);
                setProperty = property;
                valueExpression = this.createVariableExp(targetNode);
                isPartial = edge.isPartial();
            }
            if (!sourceNode.isStrict()) {
                SetStatement setStatement = this.helper.createSetStatement(slotVariable, setProperty, valueExpression, isPartial, isNotify);
                this.mapping.getOwnedStatements().add((Object)setStatement);
                this.addTrace((Element)setStatement, (GraphStringBuilder.GraphElement)edge);
            } else {
                assert (!property.isIsImplicit());
                assert (!isPartial);
                NewStatement newStatement = (NewStatement)slotVariable;
                NewStatementPart newStatementPart = this.helper.createNewStatementPart(setProperty, valueExpression);
                newStatement.getOwnedParts().add((Object)newStatementPart);
                this.addTrace((Element)newStatementPart, (GraphStringBuilder.GraphElement)edge);
            }
        }
    }

    @NonNull VariableExp createContextVariableExp() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        ImperativeTransformation iTransformation = this.visitor.getImperativeTransformation();
        Parameter contextVariable = QVTbaseUtil.getContextVariable((StandardLibrary)standardLibrary, (Transformation)iTransformation);
        return this.helper.createVariableExp((VariableDeclaration)contextVariable);
    }

    private @NonNull DeclareStatement createDeclareStatement(@NonNull Node node, @NonNull OCLExpression initExpression) {
        boolean isRequired;
        Class variableType = node.getClassDatum().getPrimaryClass();
        assert (variableType != null);
        boolean bl = isRequired = !node.isConditional() && node.isRequired();
        if (initExpression.isIsRequired()) {
            isRequired = true;
        }
        String safeName = this.getSafeName(node);
        DeclareStatement newVariable = this.helper.createDeclareStatement(safeName, (Type)variableType, isRequired, initExpression);
        EList ownedStatements = this.mapping.getOwnedStatements();
        int i = ownedStatements.size();
        while (--i >= 0) {
            Statement statement = (Statement)ownedStatements.get(i);
            if (!(statement instanceof SetStatement) && !(statement instanceof NewStatement)) break;
        }
        ownedStatements.add(i + 1, newVariable);
        this.addVariable(node, (VariableDeclaration)newVariable);
        return newVariable;
    }

    private @NonNull GuardParameter createGuardParameter(@NonNull Node guardNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)guardNode);
        Class variableType = guardNode.getClassDatum().getPrimaryClass();
        TypedModel iTypedModel = (TypedModel)ClassUtil.nonNullState((Object)this.visitor.getQVTiTypedModel(classDatum.getReferredTypedModel()));
        GuardParameter guardParameter = this.helper.createGuardParameter(this.getSafeName(guardNode), iTypedModel, (Type)variableType, true);
        Property successProperty = null;
        Rule2TraceGroup rule2traceGroup = this.regionAnalysis.basicGetRule2TraceGroup();
        if (rule2traceGroup != null) {
            Node localSuccessNode;
            Role localSuccessEdgeRole;
            NavigableEdge localSuccessEdge;
            Node globalSuccessNode;
            Role globalSuccessEdgeRole;
            NavigableEdge globalSuccessEdge;
            Element2MiddleProperty relation2globalSuccessProperty = rule2traceGroup.basicGetRelation2GlobalSuccessProperty();
            Property globalSuccessProperty = null;
            if (relation2globalSuccessProperty != null && (globalSuccessEdge = guardNode.getOutgoingNavigableEdge(globalSuccessProperty = relation2globalSuccessProperty.getTraceProperty())) != null && (globalSuccessEdgeRole = this.partition.getRole((Edge)globalSuccessEdge)) != null && (globalSuccessNode = QVTscheduleUtil.getTargetNode((Edge)globalSuccessEdge)).isSuccess() && !globalSuccessEdgeRole.isPredicated()) {
                assert (globalSuccessEdgeRole.isRealized());
                successProperty = globalSuccessProperty;
            }
            Property localSuccessProperty = null;
            Element2MiddleProperty relation2localSuccessProperty = rule2traceGroup.basicGetRelation2LocalSuccessProperty();
            if (relation2localSuccessProperty != null && (localSuccessEdge = guardNode.getOutgoingNavigableEdge(localSuccessProperty = relation2localSuccessProperty.getTraceProperty())) != null && (localSuccessEdgeRole = this.partition.getRole((Edge)localSuccessEdge)) != null && (localSuccessNode = QVTscheduleUtil.getTargetNode((Edge)localSuccessEdge)).isSuccess() && !localSuccessEdgeRole.isPredicated()) {
                assert (localSuccessEdgeRole.isRealized());
                assert (successProperty == null);
                successProperty = localSuccessProperty;
            }
        }
        if (successProperty != null) {
            guardParameter.setSuccessProperty(successProperty);
        }
        this.mapping.getOwnedMappingParameters().add((Object)guardParameter);
        this.addVariable(guardNode, (VariableDeclaration)guardParameter);
        return guardParameter;
    }

    private void createHeadAndGuardNodeVariables() {
        HashSet<@NonNull Region> headCallingRegions = new HashSet<Region>();
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Partition)this.partition)) {
            if (headNode.isDependency() || headNode.isThis()) continue;
            Node bestHeadNode = null;
            Iterable<@NonNull Node> callingSources = this.connectionManager.getPassedBindingSources(headNode);
            if (!Iterables.isEmpty(callingSources)) {
                bestHeadNode = headNode;
            }
            for (Node callingSource : callingSources) {
                headCallingRegions.add(QVTscheduleUtil.getOwningRegion((Node)callingSource));
            }
            if (bestHeadNode != null) {
                this.headNodes.add(bestHeadNode);
                continue;
            }
            CompilerUtil.addPartitionError(this.visitor.getProblemHandler(), this.partition, "No best head", new Object[0]);
        }
        this.guardNodes.addAll(this.headNodes);
        Collections.sort(this.guardNodes, NameUtil.NAMEABLE_COMPARATOR);
        boolean isStrict = false;
        for (Node guardNode : this.guardNodes) {
            if (guardNode.isDependency()) continue;
            this.createGuardParameter(guardNode);
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)guardNode)) {
                Node targetNode;
                Role role;
                if (edge.isSuccess() || (role = this.partition.getRole(edge)) == null || !role.isOld() || !(targetNode = QVTscheduleUtil.getTargetNode((Edge)edge)).isDataType()) continue;
                isStrict = true;
            }
            NodeConnection connection = guardNode.getIncomingConnection();
            if (connection == null) continue;
            int lastProducer = connection.getLastPass();
            int lastConsumer = this.partition.getLastPass();
            if (lastConsumer > lastProducer) continue;
            isStrict = true;
        }
        this.mapping.setIsStrict(isStrict);
        this.createAppendParameters();
    }

    private void createObservedProperties() {
        Set<@NonNull PropertyDatum> allCheckedPropertyDatums = this.checkedConditionAnalysis.getAllCheckedPropertyDatums();
        if (!allCheckedPropertyDatums.isEmpty()) {
            for (Statement asStatement : this.mapping.getOwnedStatements()) {
                if (!(asStatement instanceof ObservableStatement)) continue;
                EList observedProperties = ((ObservableStatement)asStatement).getObservedProperties();
                for (EObject eObject : new TreeIterable((EObject)asStatement, false)) {
                    if (!(eObject instanceof NavigationCallExp)) continue;
                    boolean allCheckedPropertyDatumsContainsPropertyDatum = false;
                    NavigationCallExp navigationCallExp = (NavigationCallExp)eObject;
                    Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
                    for (GraphStringBuilder.GraphElement graphElement : this.getTrace((Element)navigationCallExp)) {
                        if (!(graphElement instanceof NavigationEdge)) continue;
                        for (PropertyDatum propertyDatum : this.scheduleManager.getPropertyDatums((NavigationEdge)graphElement)) {
                            if (!allCheckedPropertyDatums.contains(propertyDatum)) continue;
                            allCheckedPropertyDatumsContainsPropertyDatum = true;
                            int n = this.mapping.getFirstPass();
                        }
                    }
                    if (!allCheckedPropertyDatumsContainsPropertyDatum || observedProperties.contains(property)) continue;
                    observedProperties.add(property);
                }
            }
        }
    }

    public <T extends Operation> @NonNull T createOperation(@NonNull T operation) {
        Operation newOperation = this.visitor.create(operation);
        assert (newOperation != null);
        return (T)newOperation;
    }

    private void createPatternMatch() {
        OldEdgeSchedule oldSchedule = new OldEdgeSchedule();
        Iterable<@NonNull CheckedCondition> checkedConditions = oldSchedule.analyze();
        oldSchedule.synthesize(checkedConditions);
    }

    private void createPropertyAssignments(@NonNull Iterable<@NonNull NavigableEdge> sortedRealizedEdges) {
        StringBuilder s;
        StringBuilder stringBuilder = s = TransformationPartitioner.PROPERTY_NOTIFY.isActive() ? new StringBuilder() : null;
        if (s != null) {
            s.append("[" + this.partition.getPassRangeText() + "] " + this.partition.getName());
        }
        HashMap<@NonNull Node, @NonNull ArrayList<@NonNull NavigationEdge>> classAssignments = null;
        for (NavigableEdge edge : sortedRealizedEdges) {
            ArrayList<NavigationEdge> edges;
            if (!(edge instanceof NavigationEdge) || edge instanceof KeyPartEdge) continue;
            NavigationEdge navigationEdge = (NavigationEdge)edge;
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            if (targetNode.isSuccess()) continue;
            if (targetNode.isDataType()) {
                VariableDeclaration asVariable = this.getVariableDeclaration(sourceNode);
                Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
                QVTs2QVTiNodeVisitor expressionCreator = new QVTs2QVTiNodeVisitor(this);
                OCLExpression valueExp = expressionCreator.getExpression(targetNode);
                boolean isNotify = this.connectionManager.isHazardousWrite(s, navigationEdge);
                boolean isPartial = edge.isPartial();
                if (!sourceNode.isStrict()) {
                    SetStatement setStatement = this.helper.createSetStatement(asVariable, property, valueExp, isPartial, isNotify);
                    this.mapping.getOwnedStatements().add((Object)setStatement);
                    this.addTrace((Element)setStatement, (GraphStringBuilder.GraphElement)edge);
                    continue;
                }
                assert (!isPartial);
                NewStatement newStatement = (NewStatement)asVariable;
                NewStatementPart newStatementPart = this.helper.createNewStatementPart(property, valueExp);
                newStatement.getOwnedParts().add((Object)newStatementPart);
                this.addTrace((Element)newStatementPart, (GraphStringBuilder.GraphElement)edge);
                continue;
            }
            if (classAssignments == null) {
                classAssignments = new HashMap<Node, ArrayList<NavigationEdge>>();
            }
            if ((edges = (ArrayList<NavigationEdge>)classAssignments.get(sourceNode)) == null) {
                edges = new ArrayList<NavigationEdge>();
                classAssignments.put(sourceNode, edges);
            }
            edges.add(navigationEdge);
        }
        if (classAssignments != null) {
            this.pruneClassAssignments(classAssignments);
            HashSet<@NonNull E> classAssignmentEdges = new HashSet();
            for (List values : classAssignments.values()) {
                classAssignmentEdges.addAll(values);
            }
            for (NavigableEdge edge : sortedRealizedEdges) {
                if (!classAssignmentEdges.contains(edge)) continue;
                this.createClassSetStatement(s, edge);
            }
        }
        if (s != null) {
            TransformationPartitioner.PROPERTY_NOTIFY.println(s.toString());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createRealizedVariables() {
        @NonNull ArrayList sortedNodes = Lists.newArrayList((Iterable)this.partition.getPartialNodes());
        Collections.sort(sortedNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node node : sortedNodes) {
            Role nodeRole = this.partition.getRole(node);
            if (nodeRole == null || !nodeRole.isNew() || !node.isClass()) continue;
            OCLExpression constructor = null;
            if (node.isOperation()) {
                if (node instanceof KeyedValueNode) {
                    KeyedValueNode keyedValueNode = (KeyedValueNode)node;
                    ClassDatum classDatum = keyedValueNode.getClassDatumValue();
                    assert (classDatum != null);
                    Function function = this.visitor.getKeyFunction(classDatum);
                    VariableExp thisExp = this.createContextVariableExp();
                    HashMap<@NonNull PropertyDatum, @NonNull OCLExpression> propertyDatum2expression = new HashMap<PropertyDatum, OCLExpression>();
                    for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                        if (!(edge instanceof KeyPartEdge)) continue;
                        KeyPartEdge keyPartEdge = (KeyPartEdge)edge;
                        PropertyDatum propertyDatum = QVTscheduleUtil.getReferredPart((KeyPartEdge)keyPartEdge);
                        Node partNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                        OCLExpression partExpression = this.getExpression(partNode);
                        propertyDatum2expression.put(propertyDatum, partExpression);
                    }
                    ArrayList<@NonNull OCLExpression> asArguments = new ArrayList<OCLExpression>();
                    for (PropertyDatum propertyDatum : QVTscheduleUtil.getOwnedPropertyDatums((ClassDatum)classDatum)) {
                        if (!propertyDatum.isKey()) continue;
                        OCLExpression asArgument = (OCLExpression)propertyDatum2expression.get(propertyDatum);
                        if (asArgument == null) {
                            asArgument = this.helper.createInvalidExpression();
                        }
                        asArguments.add(asArgument);
                    }
                    constructor = this.helper.createOperationCallExp((OCLExpression)thisExp, (Operation)function, asArguments);
                    this.addTrace((Element)constructor, (GraphStringBuilder.GraphElement)node);
                }
                if (constructor == null) {
                    QVTs2QVTiNodeVisitor expressionCreator = new QVTs2QVTiNodeVisitor(this);
                    constructor = (OCLExpression)((OperationCallExp)node.getOriginatingElement()).accept((Visitor)expressionCreator);
                    this.addTrace((Element)constructor, (GraphStringBuilder.GraphElement)node);
                }
            }
            ClassDatum classDatum = node.getClassDatum();
            TypedModel pTypedModel = classDatum.getReferredTypedModel();
            TypedModel iTypedModel = (TypedModel)ClassUtil.nonNullState((Object)this.visitor.getQVTiTypedModel(pTypedModel));
            NewStatement newStatement = this.helper.createNewStatement(this.getSafeName(node), iTypedModel, (Type)classDatum.getPrimaryClass());
            newStatement.setOwnedExpression(constructor);
            newStatement.setIsContained(node.isContained());
            this.mapping.getOwnedStatements().add((Object)newStatement);
            this.addVariable(node, (VariableDeclaration)newStatement);
        }
    }

    private @NonNull SpeculateStatement createSpeculateStatement(@NonNull Iterable<@NonNull OCLExpression> speculateExpressions, @NonNull Iterable<@NonNull Edge> speculatedEdges) {
        SpeculateStatement speculateStatement = this.helper.createSpeculateStatement(speculateExpressions);
        this.mapping.getOwnedStatements().add((Object)speculateStatement);
        for (Edge speculatedEdge : speculatedEdges) {
            this.addTrace((Element)speculateStatement, (GraphStringBuilder.GraphElement)speculatedEdge);
        }
        return speculateStatement;
    }

    private @NonNull OCLExpression createVariableExp(@NonNull Node node) {
        if (node.isNullLiteral()) {
            NullLiteralExp nullLiteralExp = this.helper.createNullLiteralExp();
            this.addTrace((Element)nullLiteralExp, (GraphStringBuilder.GraphElement)node);
            return nullLiteralExp;
        }
        VariableDeclaration variable = this.getVariableDeclaration(node);
        return PivotUtil.createVariableExp((VariableDeclaration)variable);
    }

    protected @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges() {
        HashSet<@NonNull NavigableEdge> oldEdges = new HashSet<NavigableEdge>();
        for (Edge edge : this.partition.getPartialEdges()) {
            assert (!edge.isCast());
            Role edgeRole = this.partition.getRole(edge);
            assert (edgeRole != null);
            if (!edgeRole.isOld() || !edge.isNavigation()) continue;
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Role sourceNodeRole = this.partition.getRole(sourceNode);
            assert (sourceNodeRole != null);
            if (!sourceNodeRole.isOld()) continue;
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            Role targetNodeRole = this.partition.getRole(targetNode);
            assert (targetNodeRole != null);
            if (!targetNodeRole.isOld()) continue;
            oldEdges.add((NavigableEdge)edge);
        }
        return oldEdges;
    }

    public @NonNull OCLExpression getExpression(@NonNull Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        if (variable == null) {
            QVTs2QVTiNodeVisitor expressionCreator = new QVTs2QVTiNodeVisitor(this);
            OCLExpression targetExpression = expressionCreator.getExpression(node);
            if (node.isConditional()) {
                return targetExpression;
            }
            variable = this.createDeclareStatement(node, targetExpression);
        }
        return this.helper.createVariableExp(variable);
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return this.guardNodes;
    }

    @Override
    public @NonNull MappingParameter getGuardVariable(@NonNull Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        assert (variable != null);
        return (MappingParameter)variable;
    }

    public @NonNull QVTimperativeHelper getHelper() {
        return this.helper;
    }

    public @NonNull Partition getPartition() {
        return this.partition;
    }

    public @NonNull Set<@NonNull Node> getPrecedingNodes(@NonNull Node targetNode) {
        Set<Node> precedingNodes;
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> node2precedingNodeClosure2 = this.node2precedingNodeClosure;
        if (node2precedingNodeClosure2 == null) {
            this.node2precedingNodeClosure = node2precedingNodeClosure2 = new HashMap<Node, Set<Node>>();
        }
        if ((precedingNodes = node2precedingNodeClosure2.get(targetNode)) == null) {
            precedingNodes = new HashSet<Node>();
            node2precedingNodeClosure2.put(targetNode, precedingNodes);
            precedingNodes.add(targetNode);
            for (Node sourceNode : this.reachabilityForest.getPredecessorsClosure(targetNode)) {
                precedingNodes.addAll(this.getPrecedingNodes(sourceNode));
            }
        }
        assert (precedingNodes.size() > 0);
        return precedingNodes;
    }

    public @NonNull QVTruntimeLibraryHelper getQVTruntimeLibraryHelper() {
        return this.scheduleManager.getQVTruntimeLibraryHelper();
    }

    public @NonNull ReachabilityForest getReachabilityForest() {
        return this.reachabilityForest;
    }

    protected @NonNull Iterable<@NonNull NavigableEdge> getSortedAssignments() {
        ArrayList<@NonNull NavigableEdge> navigableEdges = new ArrayList<NavigableEdge>();
        for (Edge edge : this.partition.getPartialEdges()) {
            Role edgeRole;
            if (!edge.isNavigation() || (edgeRole = this.partition.getRole(edge)) == null || !edgeRole.isRealized()) continue;
            navigableEdges.add((NavigableEdge)edge);
        }
        return NavigationEdgeSorter.getSortedAssignments(navigableEdges);
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.scheduleManager.getStandardLibrary();
    }

    protected @NonNull VariableDeclaration getVariableDeclaration(@NonNull Node node) {
        VariableDeclaration variable = this.node2variable.get(node);
        if (variable == null) {
            QVTs2QVTiNodeVisitor expressionCreator = new QVTs2QVTiNodeVisitor(this);
            OCLExpression targetExpression = expressionCreator.getExpression(node);
            variable = this.createDeclareStatement(node, targetExpression);
        }
        return variable;
    }

    private boolean isInfallible() {
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = this.regionAnalysis.getPartitionedTransformationAnalysis();
        AbstractFallibilityAnalysis fallibilityAnalysis = partitionedTransformationAnalysis.getFallibilityAnalysis(this.partition);
        return fallibilityAnalysis.isInfallible();
    }

    private boolean isTerminating() {
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = this.regionAnalysis.getPartitionedTransformationAnalysis();
        AbstractFallibilityAnalysis fallibilityAnalysis = partitionedTransformationAnalysis.getFallibilityAnalysis(this.partition);
        return fallibilityAnalysis.isTerminating();
    }

    private void pruneClassAssignments(@NonNull Map<@NonNull Node, @NonNull List<@NonNull NavigationEdge>> classAssignments) {
        for (Node sourceNode : new ArrayList<Node>(classAssignments.keySet())) {
            List<@NonNull NavigationEdge> forwardEdges = classAssignments.get(sourceNode);
            assert (forwardEdges != null);
            int iForward = forwardEdges.size() - 1;
            while (iForward >= 0) {
                NavigationEdge forwardEdge = forwardEdges.get(iForward);
                Node targetNode = forwardEdge.getEdgeTarget();
                List<@NonNull NavigationEdge> reverseEdges = classAssignments.get(targetNode);
                if (reverseEdges != null) {
                    int iReverse = reverseEdges.size() - 1;
                    while (iReverse >= 0) {
                        NavigationEdge reverseEdge = reverseEdges.get(iReverse);
                        if (sourceNode == reverseEdge.getEdgeTarget()) {
                            Property forwardProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)forwardEdge);
                            Property reverseProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)reverseEdge);
                            if (forwardProperty.getOpposite() == reverseProperty) {
                                if (forwardProperty.isIsImplicit()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (reverseProperty.isIsImplicit()) {
                                    reverseEdges.remove(reverseEdge);
                                } else if (sourceNode.isDependency()) {
                                    forwardEdges.remove(forwardEdge);
                                } else if (targetNode.isDependency()) {
                                    reverseEdges.remove(reverseEdge);
                                } else {
                                    reverseEdges.remove(reverseEdge);
                                }
                            }
                        }
                        --iReverse;
                    }
                }
                --iForward;
            }
        }
    }

    public void removeVariable(@NonNull Node node) {
        VariableDeclaration oldVariableDeclaration = this.node2variable.remove(node);
        assert (oldVariableDeclaration != null);
    }

    @Override
    public void synthesizeCallStatements() {
        HashMap<@NonNull Partition, @NonNull HashMap<@NonNull K, @NonNull V>> calls = null;
        for (Partition calledPartition : this.connectionManager.getCallableChildren(this.partition)) {
            HashMap<Node, Node> source2target;
            if (calls == null) {
                calls = new HashMap();
            }
            if ((source2target = (HashMap<Node, Node>)calls.get(calledPartition)) == null) {
                source2target = new HashMap<Node, Node>();
                calls.put(calledPartition, source2target);
            }
            AbstractPartition2Mapping calledRegion2Mapping = this.visitor.getPartition2Mapping(calledPartition);
            for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
                Node oldNode;
                for (Node callingNode : this.connectionManager.getPassedBindingSources(calledGuardNode)) {
                    if (this.partition.getRole(callingNode) == null) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
                for (Node callingNode : this.connectionManager.getUsedBindingSources(calledGuardNode)) {
                    if (this.partition.getRole(callingNode) == null) continue;
                    oldNode = source2target.put(callingNode, calledGuardNode);
                    assert (oldNode == null);
                }
            }
        }
        if (calls != null) {
            this.createCallStatements(calls);
        }
    }

    @Override
    public void synthesizeLocalStatements() {
        this.createHeadAndGuardNodeVariables();
        this.createPatternMatch();
        Iterable<@NonNull NavigableEdge> sortedRealizedEdges = this.getSortedAssignments();
        this.createAssignedValues(sortedRealizedEdges);
        this.createRealizedVariables();
        this.createPropertyAssignments(sortedRealizedEdges);
        this.createAddStatements();
        this.checkTrace();
        this.createObservedProperties();
    }

    @Override
    public @NonNull String toString() {
        return String.valueOf(this.partition);
    }

    private class OldEdgeSchedule {
        private @NonNull List<@NonNull Edge> edgeSchedule = new ArrayList<Edge>();
        private final @NonNull Set<@NonNull Edge> scheduledEdges = new HashSet<Edge>();
        private final @NonNull Set<@NonNull Node> scheduledNodes;

        public OldEdgeSchedule() {
            this.scheduledNodes = Sets.newHashSet((Iterable)QVTscheduleUtil.getHeadNodes((Partition)BasicPartition2Mapping.this.partition));
        }

        private void addEdge(@NonNull Edge edge) {
            assert (!edge.isConditional());
            assert (BasicPartition2Mapping.this.partition.getRole(edge) != null);
            if (this.scheduledEdges.add(edge)) {
                Node targetNode;
                Role targetNodeRole;
                Node sourceNode;
                Role sourceNodeRole;
                NavigationEdge oppositeEdge = null;
                if (edge instanceof NavigationEdge && (oppositeEdge = ((NavigationEdge)edge).getOppositeEdge()) != null) {
                    boolean wasAdded = this.scheduledEdges.add((Edge)oppositeEdge);
                    assert (wasAdded);
                }
                if ((sourceNodeRole = BasicPartition2Mapping.this.partition.getRole(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) != null && !sourceNode.isDependency() && (targetNodeRole = BasicPartition2Mapping.this.partition.getRole(targetNode = QVTscheduleUtil.getTargetNode((Edge)edge))) != null && !targetNode.isDependency()) {
                    this.addNode(sourceNode);
                    this.addNode(targetNode);
                    this.edgeSchedule.add(edge);
                }
            }
        }

        private void addNode(@NonNull Node targetNode) {
            Iterable<Edge> reachingEdges;
            int size;
            assert (BasicPartition2Mapping.this.partition.getRole(targetNode) != null);
            if (this.scheduledNodes.add(targetNode) && (size = Iterables.size(reachingEdges = BasicPartition2Mapping.this.reachabilityForest.getReachingEdges(targetNode))) > 0) {
                if (size == 1) {
                    Edge edge = reachingEdges.iterator().next();
                    assert (!edge.isPartial());
                    if (!edge.isConditional()) {
                        this.addEdge(edge);
                    }
                } else {
                    ArrayList<@NonNull Node> sourceNodes = new ArrayList<Node>();
                    for (Edge edge : reachingEdges) {
                        assert (!edge.isPartial());
                        if (edge.isConditional()) continue;
                        sourceNodes.add(QVTscheduleUtil.getSourceNode((Edge)edge));
                    }
                    if (sourceNodes.size() > 1) {
                        Collections.sort(sourceNodes, BasicPartition2Mapping.this.reachabilityForest.getNodeCostComparator());
                    }
                    for (Node sourceNode : sourceNodes) {
                        this.addNode(sourceNode);
                    }
                    for (Edge edge : reachingEdges) {
                        assert (!edge.isPartial());
                        if (edge.isConditional()) continue;
                        this.addEdge(edge);
                    }
                }
            }
        }

        public @NonNull Iterable<@NonNull CheckedCondition> analyze() {
            Node dispatchNode = BasicPartition2Mapping.this.regionAnalysis.basicGetDispatchNode();
            if (dispatchNode != null) {
                for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)dispatchNode)) {
                    Role edgeRole = BasicPartition2Mapping.this.partition.getRole(edge);
                    if (edgeRole == null || !edgeRole.isPredicated()) continue;
                    this.addEdge(edge);
                }
            }
            for (Node headNode : BasicPartition2Mapping.this.headNodes) {
                Role globalSuccessEdgeRole;
                SuccessEdge globalSuccessEdge;
                Role localSuccessEdgeRole;
                SuccessEdge localSuccessEdge = BasicPartition2Mapping.this.regionAnalysis.basicGetLocalSuccessEdge(headNode);
                if (localSuccessEdge != null && (localSuccessEdgeRole = BasicPartition2Mapping.this.partition.getRole((Edge)localSuccessEdge)) != null && localSuccessEdgeRole.isPredicated()) {
                    this.addEdge((Edge)localSuccessEdge);
                }
                if ((globalSuccessEdge = BasicPartition2Mapping.this.regionAnalysis.basicGetGlobalSuccessEdge(headNode)) == null || (globalSuccessEdgeRole = BasicPartition2Mapping.this.partition.getRole((Edge)globalSuccessEdge)) == null || !globalSuccessEdgeRole.isPredicated()) continue;
                this.addEdge((Edge)globalSuccessEdge);
            }
            for (Node node : QVTscheduleUtil.getOwnedNodes((Region)QVTscheduleUtil.getRegion((Partition)BasicPartition2Mapping.this.partition))) {
                Role role = BasicPartition2Mapping.this.partition.getRole(node);
                if (role == null || !role.isConstant() || !node.getIncomingEdges().isEmpty() || !node.getOutgoingEdges().isEmpty()) continue;
                OCLExpression exp = BasicPartition2Mapping.this.createVariableExp(node);
                CheckStatement checkStatement = BasicPartition2Mapping.this.createCheckStatement(exp);
                BasicPartition2Mapping.this.addTrace((Element)checkStatement, (GraphStringBuilder.GraphElement)node);
            }
            Set<@NonNull CheckedCondition> checkedConditions = BasicPartition2Mapping.this.checkedConditionAnalysis.computeCheckedConditions();
            int checkableSize = checkedConditions.size();
            ArrayList<@NonNull CheckedCondition> sortedCheckedConditions = new ArrayList<CheckedCondition>(checkedConditions);
            if (checkableSize > 1) {
                Collections.sort(sortedCheckedConditions, new CheckedConditionWeightComparator(BasicPartition2Mapping.this));
            }
            for (CheckedCondition checkedCondition : sortedCheckedConditions) {
                Node node;
                Iterable<@NonNull Edge> edges = checkedCondition.getEdges();
                if (edges != null) {
                    Iterator iterator = edges.iterator();
                    while (iterator.hasNext()) {
                        @NonNull Edge edge = (Edge)iterator.next();
                        if (edge.isConditional()) continue;
                        this.addEdge(edge);
                    }
                }
                if ((node = checkedCondition.getNode()) == null) continue;
                this.addNode(node);
            }
            Iterable<@NonNull SuccessEdge> speculatedEdges = BasicPartition2Mapping.this.checkedConditionAnalysis.getSpeculatedEdges();
            if (speculatedEdges != null) {
                for (SuccessEdge speculatedEdge : speculatedEdges) {
                    this.addNode(QVTscheduleUtil.getSourceNode((Edge)speculatedEdge));
                }
                for (SuccessEdge speculatedEdge : speculatedEdges) {
                    this.addEdge((Edge)speculatedEdge);
                }
            }
            ArrayList<Edge> residualEdges = null;
            for (Edge edge : BasicPartition2Mapping.this.checkedConditionAnalysis.getOldUnconditionalEdges()) {
                if (residualEdges == null) {
                    residualEdges = new ArrayList<Edge>();
                }
                residualEdges.add(edge);
            }
            if (residualEdges != null) {
                Collections.sort(residualEdges, BasicPartition2Mapping.this.reachabilityForest.getEdgeCostComparator());
                for (Edge edge : residualEdges) {
                    this.addEdge(edge);
                }
            }
            return sortedCheckedConditions;
        }

        protected void createConstantCheck(@NonNull Edge edge, @NonNull OCLExpression checkExpression) {
            Role edgeRole = BasicPartition2Mapping.this.partition.getRole(edge);
            assert (edgeRole != null);
            if (edgeRole.isSpeculated()) {
                assert (edge.isSuccess());
                boolean isInfallible = BasicPartition2Mapping.this.isInfallible();
                boolean isTerminating = BasicPartition2Mapping.this.isTerminating();
                if (!isInfallible) {
                    if (isTerminating) {
                        CheckStatement checkStatement = BasicPartition2Mapping.this.createCheckStatement(checkExpression);
                        BasicPartition2Mapping.this.addTrace((Element)checkStatement, (GraphStringBuilder.GraphElement)edge);
                    } else {
                        QVTruntimeUtil.errPrintln((String)("Speculation code omitted for " + BasicPartition2Mapping.this.partition));
                    }
                }
            } else {
                CheckStatement checkStatement = BasicPartition2Mapping.this.createCheckStatement(checkExpression);
                BasicPartition2Mapping.this.addTrace((Element)checkStatement, (GraphStringBuilder.GraphElement)edge);
            }
        }

        public void synthesize(@NonNull Iterable<@NonNull CheckedCondition> checkedConditions) {
            assert (BasicPartition2Mapping.this.mapping.getOwnedStatements().isEmpty());
            List<@NonNull Object> speculatedExpressions = null;
            List<@NonNull Object> speculatedEdges = null;
            for (Edge edge : this.edgeSchedule) {
                assert (!edge.isConditional());
                Role edgeRole = BasicPartition2Mapping.this.partition.getRole(edge);
                assert (edgeRole != null);
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                assert (!sourceNode.isConditional());
                Role sourceNodeRole = BasicPartition2Mapping.this.partition.getRole(sourceNode);
                assert (sourceNodeRole != null);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                assert (!targetNode.isConditional());
                Role targetNodeRole = BasicPartition2Mapping.this.partition.getRole(targetNode);
                assert (targetNodeRole != null);
                if (edgeRole.isSpeculated()) {
                    if (speculatedExpressions == null) {
                        speculatedExpressions = new ArrayList();
                        speculatedEdges = new ArrayList<SuccessEdge>();
                    } else assert (!speculatedExpressions.isEmpty()) : "Speculated edges must be scheduled in sequence";
                    SuccessEdge speculatedEdge = (SuccessEdge)edge;
                    assert (speculatedEdges != null);
                    speculatedEdges.add(speculatedEdge);
                    OCLExpression sourceExp = BasicPartition2Mapping.this.createVariableExp(sourceNode);
                    Property successProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)speculatedEdge);
                    PropertyCallExp propertyCallExp = BasicPartition2Mapping.this.helper.createPropertyCallExp(sourceExp, successProperty);
                    BasicPartition2Mapping.this.addTrace((Element)propertyCallExp, (GraphStringBuilder.GraphElement)edge);
                    if (targetNode instanceof BooleanLiteralNode) {
                        if (!((BooleanLiteralNode)targetNode).isBooleanValue()) continue;
                        speculatedExpressions.add(propertyCallExp);
                        continue;
                    }
                    OCLExpression valueExp = BasicPartition2Mapping.this.createVariableExp(targetNode);
                    propertyCallExp = BasicPartition2Mapping.this.helper.createOperationCallExp((OCLExpression)propertyCallExp, "=", new OCLExpression[]{valueExp});
                    speculatedExpressions.add(propertyCallExp);
                    continue;
                }
                if (speculatedExpressions != null && !speculatedExpressions.isEmpty()) {
                    assert (speculatedEdges != null);
                    BasicPartition2Mapping.this.createSpeculateStatement(speculatedExpressions, speculatedEdges);
                    speculatedExpressions = Collections.emptyList();
                    speculatedEdges = Collections.emptyList();
                }
                if (edge.isNavigation()) {
                    OCLExpression targetExpression;
                    VariableDeclaration nodeVariable;
                    NavigationEdge navigationEdge = (NavigationEdge)edge;
                    Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
                    OCLExpression sourceExp = BasicPartition2Mapping.this.createVariableExp(sourceNode);
                    Type sourceType = sourceExp.getType();
                    Class requiredType = property.getOwningClass();
                    if (requiredType != null && !sourceType.conformsTo(BasicPartition2Mapping.this.getMetamodelManager().getStandardLibrary(), (Type)requiredType)) {
                        String castName = "cast_" + sourceNode.getName();
                        DeclareStatement castStatement = BasicPartition2Mapping.this.createCheckedDeclareStatement(castName, sourceExp, (Type)requiredType);
                        sourceExp = BasicPartition2Mapping.this.helper.createVariableExp((VariableDeclaration)castStatement);
                    }
                    CallExp source2targetExp = BasicPartition2Mapping.this.createCallExp(sourceExp, property);
                    BasicPartition2Mapping.this.addTrace((Element)source2targetExp, (GraphStringBuilder.GraphElement)edge);
                    if (targetNode.isNullLiteral()) {
                        NullLiteralExp nullLiteralExp = BasicPartition2Mapping.this.helper.createNullLiteralExp();
                        BasicPartition2Mapping.this.addTrace((Element)nullLiteralExp, (GraphStringBuilder.GraphElement)targetNode);
                        BasicPartition2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "=", (OCLExpression)nullLiteralExp, (GraphStringBuilder.GraphElement)edge);
                        continue;
                    }
                    if (targetNodeRole.isConstant() && !sourceNodeRole.isNew()) {
                        nodeVariable = (VariableDeclaration)BasicPartition2Mapping.this.node2variable.get(targetNode);
                        if (navigationEdge.isPartial()) {
                            targetExpression = BasicPartition2Mapping.this.getExpression(targetNode);
                            BasicPartition2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "includes", targetExpression, (GraphStringBuilder.GraphElement)edge);
                            continue;
                        }
                        if (targetNode instanceof BooleanLiteralNode && ((BooleanLiteralNode)targetNode).isBooleanValue()) {
                            this.createConstantCheck(edge, (OCLExpression)source2targetExp);
                            continue;
                        }
                        if (targetNodeRole == Role.CONSTANT_SUCCESS_TRUE) {
                            this.createConstantCheck(edge, (OCLExpression)source2targetExp);
                            continue;
                        }
                        if (nodeVariable == null) {
                            QVTs2QVTiNodeVisitor expressionCreator = new QVTs2QVTiNodeVisitor(BasicPartition2Mapping.this);
                            OCLExpression targetExpression2 = expressionCreator.getExpression(targetNode);
                            BasicPartition2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "=", targetExpression2, (GraphStringBuilder.GraphElement)edge);
                            continue;
                        }
                        targetExpression = BasicPartition2Mapping.this.getExpression(targetNode);
                        BasicPartition2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "=", targetExpression, (GraphStringBuilder.GraphElement)edge);
                        continue;
                    }
                    nodeVariable = (VariableDeclaration)BasicPartition2Mapping.this.node2variable.get(targetNode);
                    if (nodeVariable == null) {
                        BasicPartition2Mapping.this.createDeclareStatement(targetNode, (OCLExpression)source2targetExp);
                        continue;
                    }
                    if (navigationEdge.isPartial()) {
                        targetExpression = BasicPartition2Mapping.this.getExpression(targetNode);
                        BasicPartition2Mapping.this.createCheckStatement((OCLExpression)source2targetExp, "includes", targetExpression, (GraphStringBuilder.GraphElement)edge);
                        continue;
                    }
                    if (edge.isNew()) continue;
                    targetExpression = BasicPartition2Mapping.this.getExpression(targetNode);
                    BasicPartition2Mapping.this.createCheckStatement(targetExpression, "=", (OCLExpression)source2targetExp, (GraphStringBuilder.GraphElement)edge);
                    continue;
                }
                if (edge instanceof PredicateEdge) {
                    OCLExpression sourceExpression = BasicPartition2Mapping.this.getExpression(sourceNode);
                    if (!(targetNode instanceof BooleanLiteralNode)) {
                        String edgeName = ((String)ClassUtil.nonNullState((Object)edge.getName())).trim();
                        if (edgeName.length() >= 2) {
                            edgeName = edgeName.substring(1, edgeName.length() - 1);
                        }
                        if ("equals".equals(edgeName)) {
                            edgeName = "=";
                        }
                        OCLExpression targetExpression = BasicPartition2Mapping.this.getExpression(targetNode);
                        BasicPartition2Mapping.this.createCheckStatement(sourceExpression, edgeName, targetExpression, (GraphStringBuilder.GraphElement)edge);
                        continue;
                    }
                    if (((BooleanLiteralNode)targetNode).isBooleanValue()) {
                        this.createConstantCheck(edge, sourceExpression);
                        continue;
                    }
                    BasicPartition2Mapping.this.createCheckStatement(sourceExpression, "=", (OCLExpression)BasicPartition2Mapping.this.helper.createBooleanLiteralExp(false), (GraphStringBuilder.GraphElement)edge);
                    continue;
                }
                if (!(edge instanceof ExpressionEdge)) continue;
                BasicPartition2Mapping.this.getVariableDeclaration(targetNode);
            }
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            boolean isFirst = true;
            for (Edge edge : this.edgeSchedule) {
                if (!isFirst) {
                    s.append("\n");
                }
                s.append(edge);
                isFirst = false;
            }
            return s.toString();
        }
    }
}

