/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.atl.tests;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.dsls.core.EMFTCSInjector;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.compiler.AtlResourceFactoryImpl;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.pivot.qvtimperative.model.QVTimperativeLibrary;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelation;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.junit.Test;

public class ATLExampleTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTrelation.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected @NonNull MyQVT createQVT(@NonNull String resultPrefix, @NonNull URI txURI) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(resultPrefix);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
    }

    protected void doATLExampleTest_CG(@NonNull String resultPrefix, @NonNull URI atlURI) throws Exception {
        String targetRelease = System.getProperty("targetRelease");
        System.err.println(String.valueOf(this.getTestName()) + " skipped for " + targetRelease + " - ANTLR version problems");
    }

    protected void setUp() throws Exception {
        QVTimperativeLibrary.install();
        XtextCompilerUtil.doQVTrelationSetup();
        super.setUp();
    }

    @Test
    public void testATL2QVTr_Families2Persons_CG() throws Exception {
        this.doATLExampleTest_CG("Families2Persons", this.getModelsURI("families2persons/Families2Persons.atl"));
    }

    protected static class MyQVT
    extends AbstractTestQVT {
        public static final @NonNull Map<Object, Object> defaultSavingOptions = new HashMap<Object, Object>();

        static {
            defaultSavingOptions.put("ENCODING", "UTF-8");
            defaultSavingOptions.put("LINE_DELIMITER", "\n");
            defaultSavingOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
            defaultSavingOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
            defaultSavingOptions.put("LINE_WIDTH", 132);
            defaultSavingOptions.put("NORMALIZE_CONTENTS", Boolean.TRUE);
        }

        public MyQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, @NonNull URI binFileURI) throws IOException {
            super(projectManager, testProject, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
            this.environmentFactory.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("atl", new AtlResourceFactoryImpl());
            AtlParser.class.getName();
            EMFModel.class.getName();
            EMFTCSInjector.class.getName();
            EmftvmFactory.class.getName();
        }

        protected void checkOutput(@NonNull Resource outputResource, @NonNull URI referenceModelURI) throws IOException, InterruptedException {
            Resource referenceResource = outputResource.getResourceSet().getResource(referenceModelURI, true);
            assert (referenceResource != null);
            ATLExampleTests.assertSameModel((Resource)referenceResource, (Resource)outputResource);
        }

        protected @NonNull AbstractCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            return new QVTrCompilerChain(this.getEnvironmentFactory(), txURI, intermediateFileNamePrefixURI, options);
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.atl.tests";
        }

        public @NonNull Map<Object, Object> getSaveOptions() {
            HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(defaultSavingOptions);
            saveOptions.put("NORMALIZE_CONTENTS", Boolean.TRUE);
            return saveOptions;
        }
    }
}

