/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.library;

import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.DeferredAssignmentListener;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.library.EObjectEStructuralFeaturePair;
import org.eclipse.m2m.internal.qvt.oml.library.QvtResolveUtil;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.ocl.utilities.Visitor;

public abstract class AbstractLateResolveTask
implements Runnable,
QvtResolveUtil.SavedSourceObjectHolder {
    private final ResolveExp myResolveExp;
    private final QvtOperationalEvaluationVisitor myVisitor;
    private final QvtOperationalEvaluationEnv myEvalEnv;
    private final EObjectEStructuralFeaturePair myLvalue;
    private Object mySourceObj;
    private final DeferredAssignmentListener myListener;

    public AbstractLateResolveTask(ResolveExp resolveExp, EObjectEStructuralFeaturePair lvalue, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv evalEnv, DeferredAssignmentListener deferredListener) {
        this.myResolveExp = resolveExp;
        this.myLvalue = lvalue;
        this.myVisitor = visitor;
        this.myEvalEnv = evalEnv.createDeferredExecutionEnvironment();
        if (this.myResolveExp.getSource() != null) {
            this.mySourceObj = this.myResolveExp.getSource().accept((Visitor)visitor);
        }
        this.myListener = deferredListener;
    }

    @Override
    public void run() {
        QvtOperationalEvaluationEnv oldEvalEnv = this.myVisitor.getOperationalEvaluationEnv();
        this.myVisitor.setOperationalEvaluationEnv(this.myEvalEnv);
        Object resolveResult = this.getResolveResult();
        try {
            AssignExp assignExp = QvtResolveUtil.getDeferredAssignmentFor(this.myResolveExp);
            if (assignExp != null && this.myLvalue != null) {
                this.myEvalEnv.callSetter(this.myLvalue.getEObject(), this.myLvalue.getEStructuralFeature(), resolveResult, QvtOperationalUtil.isUndefined(resolveResult, this.myEvalEnv), assignExp.isIsReset());
                if (this.myListener != null) {
                    this.myListener.notifyAfterDeferredAssign(assignExp, resolveResult);
                }
            }
        }
        finally {
            this.myVisitor.setOperationalEvaluationEnv(oldEvalEnv);
        }
    }

    protected abstract Object getResolveResult();

    public ResolveExp getResolveExp() {
        return this.myResolveExp;
    }

    public QvtOperationalEvaluationVisitor getVisitor() {
        return this.myVisitor;
    }

    public QvtOperationalEvaluationEnv getEvalEnv() {
        return this.myEvalEnv;
    }

    public EObjectEStructuralFeaturePair getLvalue() {
        return this.myLvalue;
    }

    @Override
    public Object getSourceObj() {
        return this.mySourceObj;
    }

    @Override
    public boolean isInDeferredExecution() {
        return true;
    }
}

