/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2m.tests.qvt.oml.util.SourceAnnotationReader;

class HyperLinkHelper {
    public static final String HYPERLINK_TAG = "link";
    public static final String HYPERLINK_REF_ATTR = "ref";
    public static final String HYPERLINK_MODULE_ATTR = "module";
    public static final String HYPERLINK_ELEMENT_URI_ATTR = "elementUri";
    public static final String REGION_TAG = "region";
    public static final String REGION_ID_ATTR = "id";
    private List<SourceHyperLink> fHLinks = new ArrayList<SourceHyperLink>();
    private Map<String, SourceAnnotationReader.AnnotationData> fTargetRegions = new HashMap<String, SourceAnnotationReader.AnnotationData>();

    HyperLinkHelper(List<SourceAnnotationReader.AnnotationData> annotations) {
        ArrayList<SourceAnnotationReader.AnnotationData> links = new ArrayList<SourceAnnotationReader.AnnotationData>();
        for (SourceAnnotationReader.AnnotationData a : annotations) {
            if (HYPERLINK_TAG.equals(a.getName())) {
                links.add(a);
                continue;
            }
            if (REGION_TAG.equals(a.getName())) {
                String id = a.getAttrValue(REGION_ID_ATTR);
                if (id == null || this.fTargetRegions.put(id, a) == null) continue;
                throw new RuntimeException("Region already defined. " + a);
            }
            throw new RuntimeException("Uknown test source annotation type");
        }
        for (SourceAnnotationReader.AnnotationData nextLink : links) {
            String refId = nextLink.getAttrValue(HYPERLINK_REF_ATTR);
            if (refId != null) {
                SourceAnnotationReader.AnnotationData targetReg = this.fTargetRegions.get(refId);
                if (targetReg == null && nextLink.getAttrValue(HYPERLINK_MODULE_ATTR) == null) {
                    throw new RuntimeException("No target region for link annotation found:" + nextLink);
                }
                if (nextLink.getAttrValue(HYPERLINK_MODULE_ATTR) != null) {
                    this.fHLinks.add(new SourceHyperLink(nextLink, nextLink.getAttrValue(HYPERLINK_MODULE_ATTR)));
                    continue;
                }
                this.fHLinks.add(new SourceHyperLink(nextLink, targetReg.getAnnotatedRegion()));
                continue;
            }
            if (nextLink.getAttrValue(HYPERLINK_ELEMENT_URI_ATTR) != null) {
                URI uri = URI.createURI((String)nextLink.getAttrValue(HYPERLINK_ELEMENT_URI_ATTR));
                this.fHLinks.add(new SourceHyperLink(nextLink, uri));
                continue;
            }
            throw new RuntimeException("Hyperlink annotation must specify 'ref' or 'elementUri' attribute");
        }
    }

    public List<SourceHyperLink> getHyperLinks() {
        return this.fHLinks;
    }

    public SourceAnnotationReader.AnnotationData getTargetRegion(String id) {
        return this.fTargetRegions.get(id);
    }

    static class SourceHyperLink {
        final SourceAnnotationReader.AnnotationData link;
        final IRegion targeRegion;
        final String targetModule;
        final URI targetElemenUri;

        SourceHyperLink(SourceAnnotationReader.AnnotationData link, final SourceAnnotationReader.RegionInfo target) {
            this.link = link;
            this.targeRegion = new IRegion(){

                public int getLength() {
                    return target.getLength();
                }

                public int getOffset() {
                    return target.getOffset();
                }
            };
            this.targetModule = null;
            this.targetElemenUri = null;
        }

        SourceHyperLink(SourceAnnotationReader.AnnotationData link, IRegion target) {
            this.link = link;
            this.targeRegion = target;
            this.targetModule = null;
            this.targetElemenUri = null;
        }

        SourceHyperLink(SourceAnnotationReader.AnnotationData link, URI targetElemenUri) {
            this.link = link;
            this.targetElemenUri = targetElemenUri;
            this.targetModule = null;
            this.targeRegion = null;
        }

        SourceHyperLink(SourceAnnotationReader.AnnotationData link, String sourceModule) {
            this.link = link;
            this.targetModule = sourceModule;
            this.targetElemenUri = null;
            this.targeRegion = null;
        }

        public String toString() {
            return this.link.toString();
        }
    }
}

