/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.completion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.common.io.FileUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProcessor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilder;
import org.eclipse.m2m.internal.tests.qvt.oml.ui.completion.AbstractCompletionTest;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.Typedef;
import org.eclipse.m2m.tests.qvt.oml.TestProject;
import org.eclipse.m2m.tests.qvt.oml.util.ReaderInputStream;
import org.eclipse.m2m.tests.qvt.oml.util.TestUtil;
import org.eclipse.ocl.ecore.MessageType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class CompletionTest
extends AbstractCompletionTest {
    private static final String EXTENSION_POINT = "javaBlackboxUnits";
    private static final String UNIT_ELEM = "unit";
    private int myOffset;
    protected final String myFolder;
    protected static TestProject myTestProject;
    private boolean isModeStrict = true;
    private final Set<String> myActualProposalStrings = new LinkedHashSet<String>();
    private final Set<String> myExpectedProposalStrings = new LinkedHashSet<String>();
    public static final String BUNDLE = "org.eclipse.m2m.tests.qvt.oml.ui";

    static {
        CompletionTest.initializeStandardLibrary();
        CompletionTest.enableQVTOCapabilities();
    }

    public CompletionTest(String folder) {
        super(folder);
        IConfigurationElement[] configurationElements;
        this.myFolder = folder;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", EXTENSION_POINT);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            String contributingBundleId;
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (UNIT_ELEM.equals(configurationElement.getName()) && !(contributingBundleId = configurationElement.getContributor().getName()).startsWith("org.eclipse.m2m")) {
                CompletionTest.fail((String)("Completion tests are not supported for org.eclipse.m2m.qvt.oml.javaBlackboxUnits in " + contributingBundleId + " - close project"));
            }
            ++n2;
        }
    }

    protected void setUp() throws Exception {
        this.initializeWorkspace();
        if (myTestProject == null) {
            this.initializeProject();
        }
        this.createTransformation();
        this.initializeProposalProvider();
        this.loadExpectedProposalStrings();
    }

    protected void tearDown() throws Exception {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) != null) {
            activePage.closeEditor(activeEditor, false);
        }
        FileUtil.delete((File)this.getTransfromationContainer().getRawLocation().toFile());
    }

    @Override
    protected Set<String> getActualProposalStrings() {
        return Collections.unmodifiableSet(this.myActualProposalStrings);
    }

    @Override
    protected Set<String> getExpectedProposalStrings() {
        return Collections.unmodifiableSet(this.myExpectedProposalStrings);
    }

    protected void initializeWorkspace() throws Exception {
        TestUtil.turnOffAutoBuildingAndJoinBuildJobs();
    }

    protected void initializeProject() throws Exception {
        myTestProject = new TestProject("CompletionTest", new String[0]);
    }

    protected void initializeProposalProvider() throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile transformationFile = this.getTransformationFile();
        QvtEditor editor = (QvtEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)transformationFile);
        QvtConfiguration qvtConfiguration = editor.getQvtConfiguration();
        ISourceViewer sourceViewer = editor.getEditorSourceViewer();
        IContentAssistant contentAssistant = qvtConfiguration.getContentAssistant(sourceViewer);
        QvtCompletionProcessor processor = (QvtCompletionProcessor)contentAssistant.getContentAssistProcessor("__dftl_partition_content_type");
        do {
            ICompletionProposal[] proposals;
            if ((proposals = processor.computeCompletionProposals((ITextViewer)sourceViewer, this.myOffset)) == null) continue;
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal completionProposal = iCompletionProposalArray[n2];
                if (completionProposal instanceof QvtCompletionProposal) {
                    String completionProposalStringPresentation = this.toString((QvtCompletionProposal)completionProposal, processor.getCurrentCategory().getId());
                    this.myActualProposalStrings.add(completionProposalStringPresentation);
                }
                ++n2;
            }
        } while (processor.getCurrentCategory() != processor.getLastCategory());
    }

    protected String saveActualProposalStrings() throws Exception {
        File folder = TestUtil.getPluginRelativeFile((String)BUNDLE, (String)("completionTestData/" + this.myFolder));
        File file = new File(folder, "expected.txt");
        String fileName = file.getAbsolutePath();
        PrintWriter writer = new PrintWriter(file);
        try {
            for (String proposal : this.myActualProposalStrings) {
                writer.println(proposal);
            }
            String string = fileName;
            return string;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void loadExpectedProposalStrings() throws Exception {
        FileInputStream contents = null;
        try {
            String line;
            if (!this.expectedProposalsFileExisits()) {
                String fileName = this.saveActualProposalStrings();
                System.out.println("Test creation mode: expected.txt successfully created [" + fileName + "]");
            }
            contents = new FileInputStream(this.getExpectedProposalsFile());
            BufferedReader reader = new BufferedReader(new InputStreamReader(contents));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith(".strict")) {
                    this.isModeStrict = true;
                    continue;
                }
                if (line.trim().startsWith(".inclusive")) {
                    this.isModeStrict = false;
                    continue;
                }
                this.myExpectedProposalStrings.add(line);
            }
            reader.close();
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String toString(QvtCompletionProposal completionProposal, String categoryId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QvtCompletionProposal[").append(categoryId).append("]: ");
        stringBuilder.append("replacementString = ").append(completionProposal.getReplacementString());
        stringBuilder.append(", displayString = ").append(completionProposal.getDisplayString());
        stringBuilder.append(", replacementOffsetDelta = ").append(this.myOffset - completionProposal.getReplacementOffset());
        stringBuilder.append(", replacementLength = ").append(completionProposal.getReplacementLength());
        stringBuilder.append(", cursorPosition = ").append(completionProposal.getCursorPosition());
        return stringBuilder.toString();
    }

    protected void createTransformation() throws Exception {
        File srcFolder = TestUtil.getPluginRelativeFile((String)BUNDLE, (String)("completionTestData/" + this.myFolder));
        File destFolder = myTestProject.getProject().getLocation().append(this.myFolder).toFile();
        destFolder.mkdirs();
        FileUtil.copyFolder((File)srcFolder, (File)destFolder);
        myTestProject.getProject().refreshLocal(2, null);
        FileInputStream inputStream = new FileInputStream(this.getAnnotatedTransformationFile());
        try {
            int read;
            StringBuffer contents = new StringBuffer();
            char[] buffer = new char[4096];
            InputStreamReader reader = new InputStreamReader(inputStream);
            while ((read = reader.read(buffer)) > 0) {
                contents.append(buffer, 0, read);
            }
            reader.close();
            this.myOffset = contents.indexOf("/*@*/");
            contents.replace(this.myOffset, this.myOffset + "/*@*/".length(), "");
            IFile transformation = this.getTransfromationContainer().getFile((IPath)new Path("t.qvto"));
            transformation.create((InputStream)new ReaderInputStream(contents.toString()), true, null);
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    protected IFile getTransformationFile() throws CoreException {
        return this.getTransfromationContainer().getFile((IPath)new Path("t.qvto"));
    }

    protected IContainer getTransfromationContainer() throws CoreException {
        return myTestProject.getProject().getFolder(this.myFolder);
    }

    protected String getTransformationContents() throws CoreException {
        return QVTOBuilder.getFileContents((IFile)this.getTransformationFile());
    }

    protected File getAnnotatedTransformationFile() throws IOException {
        return TestUtil.getPluginRelativeFile((String)BUNDLE, (String)("completionTestData/" + this.myFolder + "/" + "t.aqvto"));
    }

    protected File getExpectedProposalsFile() throws IOException {
        return TestUtil.getPluginRelativeFile((String)BUNDLE, (String)("completionTestData/" + this.myFolder + "/" + "expected.txt"));
    }

    protected boolean expectedProposalsFileExisits() throws IOException {
        Bundle bundle = Platform.getBundle((String)BUNDLE);
        URL url = bundle.getEntry("completionTestData/" + this.myFolder + "/" + "expected.txt");
        return url != null;
    }

    @Override
    protected boolean isStrict() {
        return this.isModeStrict;
    }

    private static void enableQVTOCapabilities() {
        String fakeQvtoPluginContributionId = WorkbenchActivityHelper.createUnifiedId((IPluginContribution)new IPluginContribution(){

            public String getLocalId() {
                return "fakeLocalId";
            }

            public String getPluginId() {
                return "org.eclipse.m2m.qvt.oml.fakePluginId";
            }
        });
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        Set activityIds = activityManager.getDefinedActivityIds();
        ArrayList<String> qvtoDisablingActivityIds = new ArrayList<String>();
        block0: for (String activityId : activityIds) {
            IActivity activity = activityManager.getActivity(activityId);
            Set activityPatternBindings = activity.getActivityPatternBindings();
            for (IActivityPatternBinding activityPatternBinding : activityPatternBindings) {
                Pattern pattern = activityPatternBinding.getPattern();
                if (activity.isEnabled() || !pattern.matcher(fakeQvtoPluginContributionId).matches()) continue;
                qvtoDisablingActivityIds.add(activityId);
                continue block0;
            }
        }
        if (!qvtoDisablingActivityIds.isEmpty()) {
            HashSet<String> enabledActivityIdsCopy = new HashSet<String>(activityManager.getEnabledActivityIds());
            for (String activityId : qvtoDisablingActivityIds) {
                enabledActivityIdsCopy.add(activityId);
            }
            PlatformUI.getWorkbench().getActivitySupport().setEnabledActivityIds(enabledActivityIdsCopy);
        }
    }

    @Deprecated
    private static void initializeStandardLibrary() {
        for (EClassifier classifier : QvtOperationalStdLibrary.INSTANCE.getStdLibModule().getEClassifiers()) {
            if (classifier instanceof PredefinedType) {
                PredefinedType predefinedType = (PredefinedType)classifier;
                predefinedType.oclOperations();
            }
            if (classifier instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)classifier;
                collectionType.getElementType();
                collectionType.oclIterators();
            }
            if (classifier instanceof MessageType) {
                MessageType messageType = (MessageType)classifier;
                messageType.oclProperties();
                messageType.getReferredOperation();
                messageType.getReferredSignal();
            }
            if (classifier instanceof TupleType) {
                TupleType tupleType = (TupleType)classifier;
                tupleType.oclProperties();
            }
            if (classifier instanceof OrderedTupleType) {
                OrderedTupleType orderedTupleType = (OrderedTupleType)classifier;
                orderedTupleType.getElementType();
            }
            if (classifier instanceof ModelType) {
                ModelType modelType = (ModelType)classifier;
                modelType.getAdditionalCondition();
                modelType.getMetamodel();
            }
            if (classifier instanceof DictionaryType) {
                DictionaryType dictionaryType = (DictionaryType)classifier;
                dictionaryType.getKeyType();
            }
            if (!(classifier instanceof Typedef)) continue;
            Typedef typedef = (Typedef)classifier;
            typedef.getBase();
            typedef.getCondition();
        }
    }
}

