/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.ExpressionInOCL;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;

public class OCLAnnotationSupport {
    private static final String OCL_SOURCE_URI = "http://www.eclipse.org/2007/OCL";
    private static final String BODY = "body";
    private static final String DERIVE = "derive";
    private OCL oclInstance = OCL.newInstance();
    private Map<EOperation, List<EOperationBinding>> operationMap = new HashMap<EOperation, List<EOperationBinding>>();
    private Map<ETypedElement, ExpressionInOCL> element2ExprMap = new HashMap<ETypedElement, ExpressionInOCL>();
    private ParseErrorHandler errorHandler;

    public void setErrorHandler(ParseErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public org.eclipse.ocl.ecore.OCLExpression getDerivedProperty(EStructuralFeature feature) {
        return this.getOCLExpression((ETypedElement)feature, feature.getEContainingClass(), DERIVE);
    }

    public org.eclipse.ocl.ecore.OCLExpression getBody(EOperation operation) {
        return this.getOCLExpression((ETypedElement)operation, operation, BODY);
    }

    public EOperation resolveDynamic(EOperation compiledOperation, EObject targetInstance) {
        return this.resolveRecursiveDepthLast(compiledOperation, targetInstance.eClass());
    }

    public static boolean isDynamicInstance(EObject instance) {
        return instance != null && instance.eClass() != null && instance.eClass().getInstanceClass() == null;
    }

    public static boolean isDynamicClassFeature(EStructuralFeature feature) {
        EClass owner = feature.getEContainingClass();
        return owner != null && owner.getInstanceClass() == null;
    }

    public static boolean isDynamicClassOperation(EOperation operation) {
        EClass owner = operation.getEContainingClass();
        return owner != null && owner.getInstanceClass() == null;
    }

    private org.eclipse.ocl.ecore.OCLExpression getOCLExpression(ETypedElement element, Object context, String kind) {
        ExpressionInOCL result = this.element2ExprMap.get(element);
        if (result != null) {
            return (org.eclipse.ocl.ecore.OCLExpression)result.getBodyExpression();
        }
        EAnnotation annotation = element.getEAnnotation(OCL_SOURCE_URI);
        if (annotation != null) {
            String body = (String)annotation.getDetails().get((Object)kind);
            if (body == null) {
                return null;
            }
            OCL.Helper oclHelper = this.oclInstance.createOCLHelper();
            if (context instanceof EClassifier) {
                oclHelper.setContext((Object)((EClassifier)context));
            } else if (context instanceof EOperation) {
                EOperation operation = (EOperation)context;
                oclHelper.setOperationContext((Object)operation.getEContainingClass(), (Object)operation);
            } else {
                throw new IllegalArgumentException("Unsupported OCL annotation context");
            }
            result = EcoreFactory.eINSTANCE.createExpressionInOCL();
            this.element2ExprMap.put(element, result);
            try {
                org.eclipse.ocl.ecore.OCLExpression parsedBody = oclHelper.createQuery(body);
                result.setBodyExpression((OCLExpression)parsedBody);
                return parsedBody;
            }
            catch (ParserException e) {
                if (this.errorHandler != null) {
                    result.setBodyExpression((OCLExpression)this.errorHandler.handleError(e, (EModelElement)element));
                }
                return (org.eclipse.ocl.ecore.OCLExpression)result.getBodyExpression();
            }
        }
        return null;
    }

    private EOperation resolveRecursiveDepthLast(EOperation compiledOperation, EClass targetType) {
        EOperation resolvedOper = this.resolveDynamic(compiledOperation, targetType);
        if (resolvedOper == null) {
            for (EClass superType : targetType.getESuperTypes()) {
                resolvedOper = this.resolveDynamic(compiledOperation, superType);
                if (resolvedOper == null) continue;
                List<EOperationBinding> infos = this.getOperInfos(compiledOperation);
                infos.add(new EOperationBinding(targetType, resolvedOper));
                infos = this.getOperInfos(resolvedOper);
                infos.add(new EOperationBinding(targetType, resolvedOper));
                return resolvedOper;
            }
            for (EClass superType : targetType.getESuperTypes()) {
                for (EClass nextSuperType : superType.getESuperTypes()) {
                    resolvedOper = this.resolveRecursiveDepthLast(compiledOperation, nextSuperType);
                    if (resolvedOper == null) continue;
                    List<EOperationBinding> infos = this.getOperInfos(compiledOperation);
                    infos.add(new EOperationBinding(superType, resolvedOper));
                    infos.add(new EOperationBinding(targetType, resolvedOper));
                    if (resolvedOper != compiledOperation) {
                        infos = this.getOperInfos(resolvedOper);
                        infos.add(new EOperationBinding(superType, resolvedOper));
                        infos.add(new EOperationBinding(targetType, resolvedOper));
                    }
                    return resolvedOper;
                }
            }
        }
        return resolvedOper;
    }

    private List<EOperationBinding> getOperInfos(EOperation operation) {
        List<EOperationBinding> bindings = this.operationMap.get(operation);
        if (bindings == null) {
            bindings = new LinkedList<EOperationBinding>();
            this.operationMap.put(operation, bindings);
        }
        return bindings;
    }

    private EOperation resolveDynamic(EOperation compiledOperation, EClass targetType) {
        EClass owner = compiledOperation.getEContainingClass();
        if (owner == null || targetType == null) {
            return null;
        }
        if (targetType == compiledOperation.getEContainingClass()) {
            return compiledOperation;
        }
        List<EOperationBinding> bindings = this.getOperInfos(compiledOperation);
        for (EOperationBinding operInfo : bindings) {
            if (operInfo.targetType != targetType) continue;
            return operInfo.operation;
        }
        EOperation actualOperation = this.findLocalOperationMatch(targetType, compiledOperation);
        if (actualOperation != null) {
            bindings.add(new EOperationBinding(targetType, actualOperation));
        }
        return actualOperation;
    }

    private EOperation findLocalOperationMatch(EClass targetType, EOperation operation) {
        EList opers = targetType.getEOperations();
        for (EOperation nextOper : opers) {
            if (!OCLAnnotationSupport.canOverride(nextOper, operation)) continue;
            return nextOper;
        }
        return null;
    }

    private static boolean canOverride(EOperation o1, EOperation o2) {
        if (OCLAnnotationSupport.safeEquals(o1.getName(), o2.getName()) && o1.getEParameters().size() == o2.getEParameters().size() && OCLAnnotationSupport.safeEquals(o1.getEType(), o2.getEType())) {
            EList params1 = o1.getEParameters();
            EList params2 = o2.getEParameters();
            assert (params1.size() == params2.size());
            int count = params1.size();
            int i = 0;
            while (i < count) {
                if (!OCLAnnotationSupport.matches((EParameter)params1.get(i), (EParameter)params2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean matches(EParameter p1, EParameter p2) {
        return OCLAnnotationSupport.safeEquals(p1.getEType(), p2.getEType()) && p1.isMany() == p2.isMany() && p1.isOrdered() == p2.isOrdered() && p1.isUnique() == p2.isUnique();
    }

    private static boolean safeEquals(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : (o2 != null ? o2.equals(o1) : o1 == o2);
    }

    private static class EOperationBinding {
        final EClass targetType;
        final EOperation operation;

        EOperationBinding(EClass targetType, EOperation operation) {
            assert (targetType != null && operation != null);
            this.targetType = targetType;
            this.operation = operation;
        }
    }

    public static interface ParseErrorHandler {
        public org.eclipse.ocl.ecore.OCLExpression handleError(ParserException var1, EModelElement var2);
    }
}

