/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.ImportHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.ModelTypeHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.ObjectPropertyHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.OperationHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.PathNameHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.ResolveInHyperlinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.ScopedIdentifierHyperLinkDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.VariableHyperlinkDetector;
import org.eclipse.ocl.cst.CSTNode;

public class QvtHyperlinkDetector
implements IHyperlinkDetector {
    private final QvtDocumentProvider myDocumentProvider;
    private final IHyperlinkDetectorHelper[] myHelpers;

    public QvtHyperlinkDetector(QvtDocumentProvider documentProvider) {
        this.myDocumentProvider = documentProvider;
        this.myHelpers = new IHyperlinkDetectorHelper[]{new ImportHyperlinkDetector(), new ModelTypeHyperlinkDetector(), new PathNameHyperlinkDetector(), new ObjectPropertyHyperlinkDetector(), new VariableHyperlinkDetector(), new ScopedIdentifierHyperLinkDetector(), new OperationHyperlinkDetector(), new ResolveInHyperlinkDetector()};
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        CompiledUnit compiledUnit = this.myDocumentProvider.getCompiledModule();
        if (compiledUnit == null) {
            return null;
        }
        List<CSTNode> elements = CSTHelper.selectTargetedElements((CSTNode)compiledUnit.getUnitCST(), region);
        Context context = new Context(this.myDocumentProvider.getCompiledModule(), region, textViewer);
        for (CSTNode element : elements) {
            IHyperlinkDetectorHelper[] iHyperlinkDetectorHelperArray = this.myHelpers;
            int n = this.myHelpers.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetectorHelper helper = iHyperlinkDetectorHelperArray[n2];
                context.syntaxElement = element;
                try {
                    IHyperlink hyperlink = helper.detectHyperlink(context);
                    if (hyperlink != null) {
                        return new IHyperlink[]{hyperlink};
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                ++n2;
            }
        }
        return null;
    }

    private static class Context
    implements IHyperlinkDetectorHelper.IDetectionContext {
        final CompiledUnit compiledUnit;
        final IRegion region;
        final ITextViewer textViewer;
        CSTNode syntaxElement;

        public Context(CompiledUnit unit, IRegion region, ITextViewer textViewer) {
            this.compiledUnit = unit;
            this.region = region;
            this.textViewer = textViewer;
        }

        public CompiledUnit getModule() {
            return this.compiledUnit;
        }

        public IRegion getRegion() {
            return this.region;
        }

        public CSTNode getSyntaxElement() {
            return this.syntaxElement;
        }

        public ITextViewer geTextViewer() {
            return this.textViewer;
        }
    }
}

