/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ProblemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalModuleEnv
extends QvtOperationalEnv {
    private Module myContextModule;

    QvtOperationalModuleEnv(EPackage.Registry registry, Resource resource) {
        super(registry, resource != null ? resource : new EcoreResourceFactoryImpl().createResource(URI.createURI((String)"qvto:/module.env")));
        this.setOption((Option)ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE, ProblemHandler.Severity.OK);
        this.setOption((Option)ProblemOption.STRING_CASE_CONVERSION, ProblemHandler.Severity.OK);
    }

    @Override
    protected void addedVariable(String name, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> elem, boolean isExplicit) {
        super.addedVariable(name, elem, isExplicit);
        if (name != null && name.equals("this") && this.myContextModule != null) {
            this.myContextModule.getOwnedVariable().add((Object)((Variable)elem));
        }
    }

    public void setContextModule(Module module) {
        this.deleteElement("this");
        this.myContextModule = null;
        if (module != null) {
            this.myContextModule = module;
            Variable thisVar = EcoreFactory.eINSTANCE.createVariable();
            thisVar.setName("this");
            thisVar.setType((Object)module);
            this.addElement("this", (org.eclipse.ocl.expressions.Variable)thisVar, false);
        }
        if (module instanceof OperationalTransformation) {
            this.registerModelParameters((OperationalTransformation)module);
        }
        this.getTypeResolver().getResource().getContents().add((Object)module);
    }

    public ModelParameter lookupModelParameter(String name, DirectionKind directionKind) {
        if (name == null) {
            return null;
        }
        List<ModelParameter> myModelParameters = this.getModelParameters();
        for (ModelParameter modelParam : myModelParameters) {
            String nextParamName;
            if (directionKind != DirectionKind.IN && modelParam.getKind() == DirectionKind.IN || (nextParamName = modelParam.getName()) == null || !nextParamName.equals(name)) continue;
            return modelParam;
        }
        return null;
    }

    public List<String> getAllExtentNames(DirectionKind directionKind) {
        List<ModelParameter> modelParameters = this.getModelParameters();
        ArrayList<String> result = new ArrayList<String>(modelParameters.size());
        for (ModelParameter modelParam : modelParameters) {
            String nextParam;
            if (directionKind != DirectionKind.IN && modelParam.getKind() == DirectionKind.IN || (nextParam = modelParam.getName()) == null || nextParam.length() <= 0) continue;
            result.add(nextParam);
        }
        return Collections.unmodifiableList(result);
    }

    public ModelParameter resolveModelParameter(EClassifier type, DirectionKind directionKind) {
        if (!this.isMayBelongToExtent(type)) {
            return null;
        }
        return QvtOperationalModuleEnv.findModelParameter(type, directionKind, this.getModelParameters());
    }

    public ModelParameter resolveModelParameterDeprecated(EClassifier type, DirectionKind directionKind) {
        if (!this.isMayBelongToExtent(type)) {
            return null;
        }
        return QvtOperationalModuleEnv.findModelParameterDeprecated(type, directionKind, this.getModelParameters());
    }

    static ModelParameter findModelParameter(EClassifier type, DirectionKind directionKind, Collection<ModelParameter> modelParameters) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)type);
        for (ModelParameter modelParam : modelParameters) {
            EList<EPackage> metamodels;
            ModelType modelType;
            if (directionKind != DirectionKind.IN && modelParam.getKind() == DirectionKind.IN || (modelType = QvtOperationalUtil.getModelType(modelParam)) == null || (metamodels = modelType.getMetamodel()).isEmpty() || rootContainer != metamodels.get(0)) continue;
            return modelParam;
        }
        for (ModelParameter modelParam : modelParameters) {
            if (directionKind != DirectionKind.IN && modelParam.getKind() == DirectionKind.IN) continue;
            return modelParam;
        }
        return null;
    }

    static ModelParameter findModelParameterDeprecated(EClassifier type, DirectionKind directionKind, Collection<ModelParameter> modelParameters) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)type);
        for (ModelParameter modelParam : modelParameters) {
            EList<EPackage> metamodels;
            ModelType modelType;
            if (directionKind == DirectionKind.OUT && modelParam.getKind() == DirectionKind.IN || (modelType = QvtOperationalUtil.getModelType(modelParam)) == null || (metamodels = modelType.getMetamodel()).isEmpty() || rootContainer != metamodels.get(0)) continue;
            return modelParam;
        }
        for (ModelParameter modelParam : modelParameters) {
            if (directionKind == DirectionKind.OUT && modelParam.getKind() == DirectionKind.IN) continue;
            return modelParam;
        }
        return null;
    }

    @Override
    public final Module getModuleContextType() {
        return this.myContextModule;
    }

    public String toString() {
        if (this.myContextModule != null && this.myContextModule.getName() != null) {
            return "Module env: <" + this.myContextModule.getName() + ">@" + Integer.toHexString(System.identityHashCode(this));
        }
        return super.toString();
    }

    private List<ModelParameter> getModelParameters() {
        if (!(this.getModuleContextType() instanceof OperationalTransformation)) {
            return Collections.emptyList();
        }
        OperationalTransformation transformation = (OperationalTransformation)this.getModuleContextType();
        EList<ModelParameter> myModelParameters = transformation.getModelParameter();
        return myModelParameters;
    }

    public boolean isMayBelongToExtent(EClassifier myType) {
        return myType != null && !IntermediateClassFactory.isIntermediateClass(myType) && this.getOCLStandardLibrary().getOclVoid() != myType && this.getOCLStandardLibrary().getOclInvalid() != myType;
    }

    private void registerModelParameters(OperationalTransformation module) {
        for (ModelParameter modelParam : module.getModelParameter()) {
            this.addElement(modelParam.getName(), (org.eclipse.ocl.expressions.Variable)modelParam, true);
        }
    }
}

