/*******************************************************************************
* Copyright (c) 2015 Zeligsoft (2009) Limited  and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.papyrusrt.codegen.xtumlrt.trans

import java.util.HashMap
import org.eclipse.emf.common.util.EList
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.common.util.BasicEList
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement
import java.util.Collection

/**
 * This class provides an API for accessing the generation properties given to
 * xtUMLrt elements vie the stereotypes of the corresponding UML elements.
 *
 * @author Ernesto Posse
 */
class GenerationProperties
{
    /** Maps each xtumlrt element to the list of UML stereotype applications from the C++ Properties Set profile */
    static val genProperties = new HashMap<CommonElement, EList<EObject>>

    static def setGenProperties
    (
        org.eclipse.uml2.uml.Element umlElement,
        CommonElement element
    )
    {
        if (umlElement === null || element === null || umlElement.applicableStereotypes === null)
            return;
        val stereotypeApplications =
            if (umlElement.stereotypeApplications !== null)
                umlElement.stereotypeApplications
            else
                new BasicEList<EObject>
        genProperties.put( element, stereotypeApplications )
    }

    static def getAllGenProperties( CommonElement element )
    {
        genProperties.get( element )
    }

    static dispatch def getProperty( CommonElement element, String stereotype, String property )
    {
        if (stereotype === null || property === null) return null;
        if (genProperties.containsKey( element ))
        {
            val elemStereotypes = genProperties.get( element )
            if (elemStereotypes !== null && ! elemStereotypes.empty)
            {
                val properties = elemStereotypes.findFirst [ it.eClass.name == stereotype ]
                val feature = properties?.eClass?.EAllStructuralFeatures?.findFirst[ it.name == property ]
                properties?.eGet( feature )
            }
        }
    }

    static dispatch def getProperty( CommonElement element, Collection<String> stereotypes, String property )
    {
        if (stereotypes === null || property === null) return null;
        if (genProperties.containsKey( element ))
        {
            val elemStereotypes = genProperties.get( element )
            if (elemStereotypes !== null && ! elemStereotypes.empty)
            {
                val properties = elemStereotypes.findFirst [ stereotypes.contains( it.eClass.name ) ]
                val feature = properties?.eClass?.EAllStructuralFeatures?.findFirst[ it.name == property ]
                properties?.eGet( feature )
            }
        }
    }

}