/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.web.ui.actions.JsElementActionProxy;

public class ShowHistoryAction
extends JsElementActionProxy {
    private IResource getHostResource(IJavaElement iJavaElement) {
        IProject iProject = iJavaElement.getJavaProject().getProject();
        Path path = new Path(iJavaElement.getHostPath().getPath());
        IResource iResource = iProject.getWorkspace().getRoot().findMember((IPath)path);
        return iResource;
    }

    public void run(IAction iAction) {
        IJavaElement[] iJavaElementArray = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        if (iJavaElementArray == null || iJavaElementArray.length == 0) {
            return;
        }
        IResource iResource = null;
        iResource = iJavaElementArray[0].isVirtual() ? this.getHostResource(iJavaElementArray[0]) : iJavaElementArray[0].getResource();
        if (iResource == null) {
            return;
        }
        try {
            IWorkbenchPage iWorkbenchPage = this.targetWorkbenchPart.getSite().getPage();
            IViewPart iViewPart = iWorkbenchPage.showView("org.eclipse.ui.views.ResourceNavigator");
            if (iViewPart instanceof ISetSelectionTarget) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iResource);
                ((ISetSelectionTarget)iViewPart).selectReveal((ISelection)structuredSelection);
            }
        }
        catch (PartInitException partInitException) {
            ExceptionHandler.handle((CoreException)((Object)partInitException), (Shell)this.targetWorkbenchPart.getSite().getShell(), (String)"Error Opening in Script View", (String)("Error while displaying element in Script View:\n" + (Object)((Object)partInitException)));
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setSelection(iSelection);
        IJavaElement[] iJavaElementArray = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        int n = 0;
        while (n < iJavaElementArray.length) {
            IResource iResource;
            if (iJavaElementArray[n].isVirtual() && ((iResource = this.getHostResource(iJavaElementArray[n])) == null || !iResource.exists())) {
                iAction.setEnabled(false);
            }
            ++n;
        }
    }
}

