/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;

class TypeBinding
implements ITypeBinding {
    protected static final IMethodBinding[] NO_METHOD_BINDINGS = new IMethodBinding[0];
    private static final String NO_NAME = "";
    protected static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    protected static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    private static final int VALID_MODIFIERS = 3103;
    org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding binding;
    private String key;
    private BindingResolver resolver;
    private IVariableBinding[] fields;
    private IAnnotationBinding[] annotations;
    private IMethodBinding[] methods;
    private ITypeBinding[] members;
    private ITypeBinding[] interfaces;
    private ITypeBinding[] typeArguments;
    private ITypeBinding[] bounds;
    private ITypeBinding[] typeParameters;

    public TypeBinding(BindingResolver bindingResolver, org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding) {
        this.binding = typeBinding;
        this.resolver = bindingResolver;
    }

    public ITypeBinding createArrayType(int n) {
        int n2 = n;
        if ((n2 += this.getDimensions()) < 1 || n2 > 255) {
            throw new IllegalArgumentException();
        }
        return this.resolver.resolveArrayType(this, n);
    }

    public IAnnotationBinding[] getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        if (this.binding.isAnnotationType() || this.binding.isClass() || this.binding.isEnum() || this.binding.isInterface()) {
            int n;
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding[] annotationBindingArray = referenceBinding.getAnnotations();
            int n2 = n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
            if (n != 0) {
                IAnnotationBinding[] iAnnotationBindingArray = new IAnnotationBinding[n];
                int n3 = 0;
                while (n3 < n) {
                    IAnnotationBinding iAnnotationBinding = this.resolver.getAnnotationInstance(annotationBindingArray[n3]);
                    if (iAnnotationBinding == null) {
                        return AnnotationBinding.NoAnnotations;
                    }
                    iAnnotationBindingArray[n3] = iAnnotationBinding;
                    ++n3;
                }
                this.annotations = iAnnotationBindingArray;
                return iAnnotationBindingArray;
            }
        }
        this.annotations = AnnotationBinding.NoAnnotations;
        return AnnotationBinding.NoAnnotations;
    }

    public String getBinaryName() {
        if (this.binding.isCapture()) {
            return null;
        }
        if (this.binding.isTypeVariable()) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding binding = typeVariableBinding.declaringElement;
            StringBuffer stringBuffer = new StringBuffer();
            switch (binding.kind()) {
                case 8: {
                    MethodBinding methodBinding = (MethodBinding)binding;
                    char[] cArray = methodBinding.declaringClass.constantPoolName();
                    if (cArray == null) {
                        return null;
                    }
                    stringBuffer.append(CharOperation.replaceOnCopy(cArray, '/', '.')).append('$').append(methodBinding.signature()).append('$').append(typeVariableBinding.sourceName);
                    break;
                }
                default: {
                    org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = (org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding;
                    char[] cArray = typeBinding.constantPoolName();
                    if (cArray == null) {
                        return null;
                    }
                    stringBuffer.append(CharOperation.replaceOnCopy(cArray, '/', '.')).append('$').append(typeVariableBinding.sourceName);
                }
            }
            return String.valueOf(stringBuffer);
        }
        char[] cArray = this.binding.constantPoolName();
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = CharOperation.replaceOnCopy(cArray, '/', '.');
        return new String(cArray2);
    }

    public ITypeBinding getBound() {
        if (this.binding.isWildcard()) {
            WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
            if (wildcardBinding.bound != null) {
                return this.resolver.getTypeBinding(wildcardBinding.bound);
            }
        }
        return null;
    }

    private IClassFile getClassFile(char[] cArray) {
        int n = CharOperation.indexOf('|', cArray);
        int n2 = CharOperation.lastIndexOf('/', cArray);
        if (n2 == -1) {
            n2 = CharOperation.lastIndexOf(File.separatorChar, cArray);
        }
        if (n != -1 && n2 < n) {
            n2 = n;
        }
        if (n2 == -1) {
            return null;
        }
        IPackageFragment iPackageFragment = this.getPackageFragment(cArray, n2, n);
        if (iPackageFragment == null) {
            return null;
        }
        int n3 = n2 + 1;
        return iPackageFragment.getClassFile(new String(cArray, n3, cArray.length - n3));
    }

    private ICompilationUnit getCompilationUnit(char[] cArray) {
        ICompilationUnit iCompilationUnit;
        char[] cArray2 = CharOperation.replaceOnCopy(cArray, File.separatorChar, '/');
        int n = CharOperation.lastIndexOf('/', cArray2);
        if (n == -1) {
            return null;
        }
        IPackageFragment iPackageFragment = this.getPackageFragment(cArray2, n, -1);
        if (iPackageFragment == null) {
            return null;
        }
        int n2 = n + 1;
        ICompilationUnit iCompilationUnit2 = iPackageFragment.getCompilationUnit(new String(cArray2, n2, cArray2.length - n2));
        if (this.resolver instanceof DefaultBindingResolver && (iCompilationUnit = iCompilationUnit2.findWorkingCopy(((DefaultBindingResolver)this.resolver).workingCopyOwner)) != null) {
            return iCompilationUnit;
        }
        return iCompilationUnit2;
    }

    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.elementsType());
    }

    public synchronized IVariableBinding[] getDeclaredFields() {
        if (this.fields != null) {
            return this.fields;
        }
        try {
            ReferenceBinding referenceBinding;
            FieldBinding[] fieldBindingArray;
            int n;
            if ((this.isClass() || this.isInterface() || this.isEnum()) && (n = (fieldBindingArray = (referenceBinding = (ReferenceBinding)this.binding).availableFields()).length) != 0) {
                IVariableBinding[] iVariableBindingArray = new IVariableBinding[n];
                int n2 = 0;
                while (n2 < n) {
                    IVariableBinding iVariableBinding = this.resolver.getVariableBinding(fieldBindingArray[n2]);
                    if (iVariableBinding == null) {
                        this.fields = NO_VARIABLE_BINDINGS;
                        return NO_VARIABLE_BINDINGS;
                    }
                    iVariableBindingArray[n2] = iVariableBinding;
                    ++n2;
                }
                this.fields = iVariableBindingArray;
                return iVariableBindingArray;
            }
        }
        catch (RuntimeException runtimeException) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declared fields");
        }
        this.fields = NO_VARIABLE_BINDINGS;
        return NO_VARIABLE_BINDINGS;
    }

    public synchronized IMethodBinding[] getDeclaredMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        try {
            ReferenceBinding referenceBinding;
            MethodBinding[] methodBindingArray;
            int n;
            if ((this.isClass() || this.isInterface() || this.isEnum()) && (n = (methodBindingArray = (referenceBinding = (ReferenceBinding)this.binding).availableMethods()).length) != 0) {
                int n2 = 0;
                IMethodBinding[] iMethodBindingArray = new IMethodBinding[n];
                int n3 = 0;
                while (n3 < n) {
                    IMethodBinding iMethodBinding;
                    MethodBinding methodBinding = methodBindingArray[n3];
                    if (!this.shouldBeRemoved(methodBinding) && (iMethodBinding = this.resolver.getMethodBinding(methodBinding)) != null) {
                        iMethodBindingArray[n2++] = iMethodBinding;
                    }
                    ++n3;
                }
                if (n2 != n) {
                    IMethodBinding[] iMethodBindingArray2 = iMethodBindingArray;
                    iMethodBindingArray = new IMethodBinding[n2];
                    System.arraycopy(iMethodBindingArray2, 0, iMethodBindingArray, 0, n2);
                }
                this.methods = iMethodBindingArray;
                return iMethodBindingArray;
            }
        }
        catch (RuntimeException runtimeException) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declared methods");
        }
        this.methods = NO_METHOD_BINDINGS;
        return NO_METHOD_BINDINGS;
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public synchronized ITypeBinding[] getDeclaredTypes() {
        if (this.members != null) {
            return this.members;
        }
        try {
            ReferenceBinding referenceBinding;
            ReferenceBinding[] referenceBindingArray;
            int n;
            if ((this.isClass() || this.isInterface() || this.isEnum()) && (n = (referenceBindingArray = (referenceBinding = (ReferenceBinding)this.binding).memberTypes()).length) != 0) {
                ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding iTypeBinding = this.resolver.getTypeBinding(referenceBindingArray[n2]);
                    if (iTypeBinding == null) {
                        this.members = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    iTypeBindingArray[n2] = iTypeBinding;
                    ++n2;
                }
                this.members = iTypeBindingArray;
                return iTypeBindingArray;
            }
        }
        catch (RuntimeException runtimeException) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declared methods");
        }
        this.members = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public synchronized IMethodBinding getDeclaringMethod() {
        if (this.binding instanceof LocalTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
            MethodBinding methodBinding = localTypeBinding.enclosingMethod;
            if (methodBinding != null) {
                try {
                    return this.resolver.getMethodBinding(localTypeBinding.enclosingMethod);
                }
                catch (RuntimeException runtimeException) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declaring method");
                }
            }
        } else if (this.binding.isTypeVariable()) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding binding = typeVariableBinding.declaringElement;
            if (binding instanceof MethodBinding) {
                try {
                    return this.resolver.getMethodBinding((MethodBinding)binding);
                }
                catch (RuntimeException runtimeException) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declaring method");
                }
            }
        }
        return null;
    }

    public synchronized ITypeBinding getDeclaringClass() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isNestedType()) {
                try {
                    return this.resolver.getTypeBinding(referenceBinding.enclosingType());
                }
                catch (RuntimeException runtimeException) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declaring class");
                }
            }
        } else if (this.binding.isTypeVariable()) {
            Binding binding;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding binding2 = binding = typeVariableBinding.isCapture() ? ((CaptureBinding)typeVariableBinding).sourceType : typeVariableBinding.declaringElement;
            if (binding instanceof ReferenceBinding) {
                try {
                    return this.resolver.getTypeBinding((ReferenceBinding)binding);
                }
                catch (RuntimeException runtimeException) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve declaring class");
                }
            }
        }
        return null;
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    public ITypeBinding getTypeDeclaration() {
        if (this.binding instanceof ParameterizedTypeBinding) {
            return this.resolver.getTypeBinding(((ParameterizedTypeBinding)this.binding).genericType());
        }
        return this;
    }

    public ITypeBinding getErasure() {
        return this.resolver.getTypeBinding(this.binding.erasure());
    }

    public synchronized ITypeBinding[] getInterfaces() {
        int n;
        if (this.interfaces != null) {
            return this.interfaces;
        }
        if (this.binding == null) {
            this.interfaces = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                this.interfaces = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding[] referenceBindingArray = null;
        try {
            referenceBindingArray = referenceBinding.superInterfaces();
        }
        catch (RuntimeException runtimeException) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve interfaces");
        }
        int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        if (n != 0) {
            ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                ITypeBinding iTypeBinding = this.resolver.getTypeBinding(referenceBindingArray[n4]);
                if (iTypeBinding != null) {
                    iTypeBindingArray[n3++] = iTypeBinding;
                }
                ++n4;
            }
            if (n != n3) {
                ITypeBinding[] iTypeBindingArray2 = iTypeBindingArray;
                iTypeBindingArray = new ITypeBinding[n3];
                System.arraycopy(iTypeBindingArray2, 0, iTypeBindingArray, 0, n3);
            }
            this.interfaces = iTypeBindingArray;
            return iTypeBindingArray;
        }
        this.interfaces = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public IJavaElement getJavaElement() {
        JavaElement javaElement = this.getUnresolvedJavaElement();
        if (javaElement == null) {
            return null;
        }
        return javaElement.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        return this.getUnresolvedJavaElement(this.binding);
    }

    private JavaElement getUnresolvedJavaElement(org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        switch (typeBinding.kind()) {
            case 68: {
                typeBinding = ((ArrayBinding)typeBinding).leafComponentType();
                return this.getUnresolvedJavaElement(typeBinding);
            }
            case 132: 
            case 516: {
                return null;
            }
        }
        if (typeBinding.isCapture()) {
            return null;
        }
        ReferenceBinding referenceBinding = typeBinding.isParameterizedType() || typeBinding.isRawType() ? (ReferenceBinding)typeBinding.erasure() : (ReferenceBinding)typeBinding;
        char[] cArray = referenceBinding.getFileName();
        if (referenceBinding.isLocalType() || referenceBinding.isAnonymousType()) {
            if (Util.isClassFileName(cArray)) {
                int n = CharOperation.indexOf('|', cArray);
                int n2 = CharOperation.lastIndexOf('/', cArray);
                if (n2 == -1) {
                    n2 = CharOperation.lastIndexOf(File.separatorChar, cArray);
                }
                if (n != -1 && n2 < n) {
                    n2 = n;
                }
                if (n2 == -1) {
                    return null;
                }
                IPackageFragment iPackageFragment = this.getPackageFragment(cArray, n2, n);
                char[] cArray2 = referenceBinding.constantPoolName();
                if (cArray2 == null) {
                    ClassFile classFile = (ClassFile)this.getClassFile(cArray);
                    return classFile == null ? null : (JavaElement)((Object)classFile.getType());
                }
                n2 = CharOperation.lastIndexOf('/', cArray2);
                char[] cArray3 = CharOperation.subarray(cArray2, n2 + 1, cArray2.length);
                ClassFile classFile = (ClassFile)iPackageFragment.getClassFile(String.valueOf(new String(cArray3)) + ".js");
                return (JavaElement)((Object)classFile.getType());
            }
            ICompilationUnit iCompilationUnit = this.getCompilationUnit(cArray);
            if (iCompilationUnit == null) {
                return null;
            }
            try {
                int n = ((LocalTypeBinding)referenceBinding).sourceStart;
                return (JavaElement)iCompilationUnit.getElementAt(n);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        if (referenceBinding.isTypeVariable()) {
            String string = new String(referenceBinding.sourceName());
            Binding binding = ((TypeVariableBinding)referenceBinding).declaringElement;
            IBinding iBinding = null;
            if (binding instanceof MethodBinding) {
                iBinding = this.resolver.getMethodBinding((MethodBinding)binding);
                IMethod iMethod = (IMethod)iBinding.getJavaElement();
                return (JavaElement)((Object)iMethod.getTypeParameter(string));
            }
            ITypeBinding iTypeBinding = this.resolver.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
            if (iTypeBinding == null) {
                return null;
            }
            iBinding = iTypeBinding;
            IType iType = (IType)iBinding.getJavaElement();
            return (JavaElement)((Object)iType.getTypeParameter(string));
        }
        if (cArray == null) {
            return null;
        }
        ITypeBinding iTypeBinding = null;
        iTypeBinding = this.isArray() ? this.getElementType().getDeclaringClass() : this.getDeclaringClass();
        if (iTypeBinding == null) {
            if (Util.isClassFileName(cArray)) {
                ClassFile classFile = (ClassFile)this.getClassFile(cArray);
                if (classFile == null) {
                    return null;
                }
                return (JavaElement)((Object)classFile.getType());
            }
            ICompilationUnit iCompilationUnit = this.getCompilationUnit(cArray);
            if (iCompilationUnit == null) {
                return null;
            }
            return (JavaElement)((Object)iCompilationUnit.getType(new String(referenceBinding.sourceName())));
        }
        IType iType = (IType)iTypeBinding.getJavaElement();
        if (iType == null) {
            return null;
        }
        return (JavaElement)((Object)iType.getType(new String(referenceBinding.sourceName())));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 2;
    }

    public int getModifiers() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            if (referenceBinding.isAnonymousType()) {
                return n & 0xFFFFFFEF;
            }
            return n;
        }
        if (this.isAnnotation()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            return n & 0xFFFFD9FF;
        }
        if (this.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            return n & 0xFFFFF9FF;
        }
        if (this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            return n & 0xFFFFBFFF;
        }
        return 0;
    }

    public String getName() {
        switch (this.binding.kind()) {
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(TypeConstants.WILDCARD_NAME);
                if (wildcardBinding.bound != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            stringBuffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            stringBuffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    stringBuffer.append(this.getBound().getName());
                }
                return String.valueOf(stringBuffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return NO_NAME;
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(parameterizedTypeBinding.sourceName());
                ITypeBinding[] iTypeBindingArray = this.getTypeArguments();
                int n = iTypeBindingArray.length;
                if (n != 0) {
                    stringBuffer.append('<');
                    int n2 = 0;
                    while (n2 < n) {
                        if (n2 > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(iTypeBindingArray[n2].getName());
                        ++n2;
                    }
                    stringBuffer.append('>');
                }
                return String.valueOf(stringBuffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getName();
            }
            case 68: {
                ITypeBinding iTypeBinding = this.getElementType();
                if (iTypeBinding.isLocal() || iTypeBinding.isAnonymous() || iTypeBinding.isCapture()) {
                    return NO_NAME;
                }
                int n = this.getDimensions();
                char[] cArray = new char[n * 2];
                int n3 = n * 2 - 1;
                while (n3 >= 0) {
                    cArray[n3] = 93;
                    cArray[n3 - 1] = 91;
                    n3 -= 2;
                }
                StringBuffer stringBuffer = new StringBuffer(iTypeBinding.getName());
                stringBuffer.append(cArray);
                return String.valueOf(stringBuffer);
            }
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isAnonymous()) {
            return NO_NAME;
        }
        return new String(this.binding.sourceName());
    }

    public IPackageBinding getPackage() {
        switch (this.binding.kind()) {
            case 68: 
            case 132: 
            case 516: 
            case 4100: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    private IPackageFragment getPackageFragment(char[] cArray, int n, int n2) {
        if (n2 != -1) {
            String string = new String(cArray, 0, n2);
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)JavaCore.create(string);
            if (n == n2) {
                return iPackageFragmentRoot.getPackageFragment(NO_NAME);
            }
            char[] cArray2 = CharOperation.subarray(cArray, n2 + 1, n);
            CharOperation.replace(cArray2, '/', '.');
            return iPackageFragmentRoot.getPackageFragment(new String(cArray2));
        }
        Path path = new Path(new String(cArray, 0, n));
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Object object = path.segmentCount() == 1 ? iWorkspaceRoot.getProject(path.lastSegment()) : iWorkspaceRoot.getFolder((IPath)path);
        IJavaElement iJavaElement = JavaCore.create((IResource)object);
        if (iJavaElement == null) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 4: {
                return (IPackageFragment)iJavaElement;
            }
            case 3: {
                return ((IPackageFragmentRoot)iJavaElement).getPackageFragment(NO_NAME);
            }
            case 2: {
                IPackageFragmentRoot iPackageFragmentRoot = ((IJavaProject)iJavaElement).getPackageFragmentRoot((IResource)object);
                if (iPackageFragmentRoot == null) {
                    return null;
                }
                return iPackageFragmentRoot.getPackageFragment(NO_NAME);
            }
        }
        return null;
    }

    public String getQualifiedName() {
        switch (this.binding.kind()) {
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(TypeConstants.WILDCARD_NAME);
                ITypeBinding iTypeBinding = this.getBound();
                if (iTypeBinding != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            stringBuffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            stringBuffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    stringBuffer.append(iTypeBinding.getQualifiedName());
                }
                return String.valueOf(stringBuffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getQualifiedName();
            }
            case 68: {
                ITypeBinding iTypeBinding = this.getElementType();
                if (iTypeBinding.isLocal() || iTypeBinding.isAnonymous() || iTypeBinding.isCapture()) {
                    return NO_NAME;
                }
                int n = this.getDimensions();
                char[] cArray = new char[n * 2];
                int n2 = n * 2 - 1;
                while (n2 >= 0) {
                    cArray[n2] = 93;
                    cArray[n2 - 1] = 91;
                    n2 -= 2;
                }
                StringBuffer stringBuffer = new StringBuffer(iTypeBinding.getQualifiedName());
                stringBuffer.append(cArray);
                return String.valueOf(stringBuffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return NO_NAME;
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.isMember()) {
                    stringBuffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
                    ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                    stringBuffer.append(parameterizedTypeBinding.sourceName());
                    ITypeBinding[] iTypeBindingArray = this.getTypeArguments();
                    int n = iTypeBindingArray.length;
                    if (n != 0) {
                        stringBuffer.append('<');
                        int n3 = 0;
                        while (n3 < n) {
                            if (n3 > 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(iTypeBindingArray[n3].getQualifiedName());
                            ++n3;
                        }
                        stringBuffer.append('>');
                    }
                    return String.valueOf(stringBuffer);
                }
                stringBuffer.append(this.getTypeDeclaration().getQualifiedName());
                ITypeBinding[] iTypeBindingArray = this.getTypeArguments();
                int n = iTypeBindingArray.length;
                if (n != 0) {
                    stringBuffer.append('<');
                    int n4 = 0;
                    while (n4 < n) {
                        if (n4 > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(iTypeBindingArray[n4].getQualifiedName());
                        ++n4;
                    }
                    stringBuffer.append('>');
                }
                return String.valueOf(stringBuffer);
            }
        }
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isMember()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
            stringBuffer.append(this.getName());
            return String.valueOf(stringBuffer);
        }
        PackageBinding packageBinding = this.binding.getPackage();
        StringBuffer stringBuffer = new StringBuffer();
        if (packageBinding != null && packageBinding.compoundName != CharOperation.NO_CHAR_CHAR) {
            stringBuffer.append(CharOperation.concatWith(packageBinding.compoundName, '.')).append('.');
        }
        stringBuffer.append(this.getName());
        return String.valueOf(stringBuffer);
    }

    public synchronized ITypeBinding getSuperclass() {
        if (this.binding == null) {
            return null;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return null;
            }
        }
        if (this.binding.isInterface()) {
            return null;
        }
        ReferenceBinding referenceBinding = null;
        try {
            referenceBinding = ((ReferenceBinding)this.binding).superclass();
        }
        catch (RuntimeException runtimeException) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(runtimeException, "Could not retrieve superclass");
            return this.resolver.resolveWellKnownType("Object");
        }
        if (referenceBinding == null) {
            return null;
        }
        return this.resolver.getTypeBinding(referenceBinding);
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding.isParameterizedType()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
            org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null) {
                int n = typeBindingArray.length;
                ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding iTypeBinding = this.resolver.getTypeBinding(typeBindingArray[n2]);
                    if (iTypeBinding == null) {
                        this.typeArguments = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    iTypeBindingArray[n2] = iTypeBinding;
                    ++n2;
                }
                this.typeArguments = iTypeBindingArray;
                return iTypeBindingArray;
            }
        }
        this.typeArguments = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.binding instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            ReferenceBinding referenceBinding = typeVariableBinding.superclass();
            org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = typeVariableBinding.firstBound;
            int n = 0;
            if (typeBinding != null) {
                if (typeBinding == referenceBinding) {
                    ++n;
                } else if (typeBinding.isArrayType()) {
                    ++n;
                } else {
                    typeBinding = null;
                }
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            int n2 = 0;
            if (referenceBindingArray != null) {
                n2 = referenceBindingArray.length;
                n += n2;
            }
            if (n != 0) {
                ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
                int n3 = 0;
                if (typeBinding != null) {
                    ITypeBinding iTypeBinding = this.resolver.getTypeBinding(typeBinding);
                    if (iTypeBinding == null) {
                        this.bounds = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    iTypeBindingArray[n3++] = iTypeBinding;
                }
                if (referenceBindingArray != null) {
                    int n4 = 0;
                    while (n4 < n2) {
                        ITypeBinding iTypeBinding = this.resolver.getTypeBinding(referenceBindingArray[n4]);
                        if (iTypeBinding == null) {
                            this.bounds = NO_TYPE_BINDINGS;
                            return NO_TYPE_BINDINGS;
                        }
                        iTypeBindingArray[n3] = iTypeBinding;
                        ++n4;
                        ++n3;
                    }
                }
                this.bounds = iTypeBindingArray;
                return iTypeBindingArray;
            }
        }
        this.bounds = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeParameters() {
        int n;
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        switch (this.binding.kind()) {
            case 260: 
            case 1028: {
                this.typeParameters = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
        }
        TypeVariableBinding[] typeVariableBindingArray = this.binding.typeVariables();
        int n2 = n = typeVariableBindingArray == null ? 0 : typeVariableBindingArray.length;
        if (n != 0) {
            ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
            int n3 = 0;
            while (n3 < n) {
                ITypeBinding iTypeBinding = this.resolver.getTypeBinding(typeVariableBindingArray[n3]);
                if (iTypeBinding == null) {
                    this.typeParameters = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
                iTypeBindingArray[n3] = iTypeBinding;
                ++n3;
            }
            this.typeParameters = iTypeBindingArray;
            return iTypeBindingArray;
        }
        this.typeParameters = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding getWildcard() {
        if (this.binding instanceof CaptureBinding) {
            CaptureBinding captureBinding = (CaptureBinding)this.binding;
            return this.resolver.getTypeBinding(captureBinding.wildcard);
        }
        return null;
    }

    public boolean isGenericType() {
        if (this.isRawType()) {
            return false;
        }
        TypeVariableBinding[] typeVariableBindingArray = this.binding.typeVariables();
        return typeVariableBindingArray != null && typeVariableBindingArray.length > 0;
    }

    public boolean isAnnotation() {
        return this.binding.isAnnotationType();
    }

    public boolean isAnonymous() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    public boolean isArray() {
        return this.binding.isArrayType();
    }

    public boolean isAssignmentCompatible(ITypeBinding iTypeBinding) {
        CompilationUnitScope compilationUnitScope;
        TypeBinding typeBinding;
        block7: {
            block6: {
                block5: {
                    try {
                        if (this != iTypeBinding) break block5;
                        return true;
                    }
                    catch (AbortCompilation abortCompilation) {
                        return false;
                    }
                }
                if (iTypeBinding instanceof TypeBinding) break block6;
                return false;
            }
            typeBinding = (TypeBinding)iTypeBinding;
            compilationUnitScope = this.resolver.scope();
            if (compilationUnitScope != null) break block7;
            return false;
        }
        return this.binding.isCompatibleWith(typeBinding.binding) || compilationUnitScope.isBoxingCompatibleWith(this.binding, typeBinding.binding);
    }

    public boolean isCapture() {
        return this.binding.isCapture();
    }

    public boolean isCastCompatible(ITypeBinding iTypeBinding) {
        CompilationUnitScope compilationUnitScope;
        Expression expression;
        block5: {
            block4: {
                try {
                    expression = new Expression(){

                        public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
                            return null;
                        }
                    };
                    compilationUnitScope = this.resolver.scope();
                    if (compilationUnitScope != null) break block4;
                    return false;
                }
                catch (AbortCompilation abortCompilation) {
                    return false;
                }
            }
            if (iTypeBinding instanceof TypeBinding) break block5;
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = ((TypeBinding)iTypeBinding).binding;
        typeBinding = typeBinding.capture(compilationUnitScope, 0);
        return expression.checkCastTypesCompatibility(compilationUnitScope, this.binding, typeBinding, null);
    }

    public boolean isClass() {
        return this.binding.isClass() && !this.binding.isTypeVariable() && !this.binding.isWildcard();
    }

    public boolean isDeprecated() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isEnum() {
        return this.binding.isEnum();
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (iBinding == null) {
            return false;
        }
        if (!(iBinding instanceof TypeBinding)) {
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = ((TypeBinding)iBinding).binding;
        return BindingComparator.isEqual(this.binding, typeBinding);
    }

    public boolean isFromSource() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isRawType()) {
                return !((RawTypeBinding)referenceBinding).genericType().isBinaryBinding();
            }
            if (referenceBinding.isParameterizedType()) {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
                org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = parameterizedTypeBinding.erasure();
                if (typeBinding instanceof ReferenceBinding) {
                    return !((ReferenceBinding)typeBinding).isBinaryBinding();
                }
                return false;
            }
            return !referenceBinding.isBinaryBinding();
        }
        if (this.isTypeVariable()) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding binding = typeVariableBinding.declaringElement;
            if (binding instanceof MethodBinding) {
                MethodBinding methodBinding = (MethodBinding)binding;
                return !methodBinding.declaringClass.isBinaryBinding();
            }
            org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = (org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding;
            if (typeBinding instanceof ReferenceBinding) {
                return !((ReferenceBinding)typeBinding).isBinaryBinding();
            }
            if (typeBinding instanceof ArrayBinding) {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding2 = arrayBinding.leafComponentType;
                if (typeBinding2 instanceof ReferenceBinding) {
                    return !((ReferenceBinding)typeBinding2).isBinaryBinding();
                }
            }
        } else if (this.isCapture()) {
            CaptureBinding captureBinding = (CaptureBinding)this.binding;
            return !captureBinding.sourceType.isBinaryBinding();
        }
        return false;
    }

    public boolean isInterface() {
        return this.binding.isInterface() && !this.binding.isTypeVariable() && !this.binding.isWildcard();
    }

    public boolean isLocal() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isMember() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isNested() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isNullType() {
        return this.binding == org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.NULL;
    }

    public boolean isParameterizedType() {
        return this.binding.isParameterizedType() && ((ParameterizedTypeBinding)this.binding).arguments != null;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    public boolean isRawType() {
        return this.binding.isRawType();
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSubTypeCompatible(ITypeBinding iTypeBinding) {
        TypeBinding typeBinding;
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (this != iTypeBinding) break block6;
                            return true;
                        }
                        catch (AbortCompilation abortCompilation) {
                            return false;
                        }
                    }
                    if (!this.binding.isBaseType()) break block7;
                    return false;
                }
                if (iTypeBinding instanceof TypeBinding) break block8;
                return false;
            }
            typeBinding = (TypeBinding)iTypeBinding;
            if (!typeBinding.binding.isBaseType()) break block9;
            return false;
        }
        return this.binding.isCompatibleWith(typeBinding.binding);
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isTopLevel() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isTypeVariable() {
        return this.binding.isTypeVariable() && !this.binding.isCapture();
    }

    public boolean isUpperbound() {
        return this.binding.isWildcard() && ((WildcardBinding)this.binding).boundKind == 1;
    }

    public boolean isWildcardType() {
        return this.binding.isWildcard();
    }

    private boolean shouldBeRemoved(MethodBinding methodBinding) {
        return methodBinding.isDefaultAbstract() || methodBinding.isSynthetic() || methodBinding.isConstructor() && this.isInterface();
    }

    public String toString() {
        return this.binding.toString();
    }

    public boolean isCompilationUnit() {
        return false;
    }
}

