/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.rewrite;

import java.util.Collections;
import java.util.List;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ListRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeInfoStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;

public final class ListRewrite {
    private ASTNode parent;
    private StructuralPropertyDescriptor childProperty;
    private ASTRewrite rewriter;

    ListRewrite(ASTRewrite aSTRewrite, ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        this.rewriter = aSTRewrite;
        this.parent = aSTNode;
        this.childProperty = structuralPropertyDescriptor;
    }

    private RewriteEventStore getRewriteStore() {
        return this.rewriter.getRewriteEventStore();
    }

    private ListRewriteEvent getEvent() {
        return this.getRewriteStore().getListEvent(this.parent, this.childProperty, true);
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public StructuralPropertyDescriptor getLocationInParent() {
        return this.childProperty;
    }

    public void remove(ASTNode aSTNode, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        RewriteEvent rewriteEvent = this.getEvent().removeEntry(aSTNode);
        if (textEditGroup != null) {
            this.getRewriteStore().setEventEditGroup(rewriteEvent, textEditGroup);
        }
    }

    public ASTRewrite getASTRewrite() {
        return this.rewriter;
    }

    public void replace(ASTNode aSTNode, ASTNode aSTNode2, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        RewriteEvent rewriteEvent = this.getEvent().replaceEntry(aSTNode, aSTNode2);
        if (textEditGroup != null) {
            this.getRewriteStore().setEventEditGroup(rewriteEvent, textEditGroup);
        }
    }

    public void insertAfter(ASTNode aSTNode, ASTNode aSTNode2, TextEditGroup textEditGroup) {
        if (aSTNode == null || aSTNode2 == null) {
            throw new IllegalArgumentException();
        }
        int n = this.getEvent().getIndex(aSTNode2, 3);
        if (n == -1) {
            throw new IllegalArgumentException("Node does not exist");
        }
        this.internalInsertAt(aSTNode, n + 1, true, textEditGroup);
    }

    public void insertBefore(ASTNode aSTNode, ASTNode aSTNode2, TextEditGroup textEditGroup) {
        if (aSTNode == null || aSTNode2 == null) {
            throw new IllegalArgumentException();
        }
        int n = this.getEvent().getIndex(aSTNode2, 3);
        if (n == -1) {
            throw new IllegalArgumentException("Node does not exist");
        }
        this.internalInsertAt(aSTNode, n, false, textEditGroup);
    }

    public void insertFirst(ASTNode aSTNode, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        this.internalInsertAt(aSTNode, 0, false, textEditGroup);
    }

    public void insertLast(ASTNode aSTNode, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        this.internalInsertAt(aSTNode, -1, true, textEditGroup);
    }

    public void insertAt(ASTNode aSTNode, int n, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        this.internalInsertAt(aSTNode, n, this.isInsertBoundToPreviousByDefault(aSTNode), textEditGroup);
    }

    private void internalInsertAt(ASTNode aSTNode, int n, boolean bl, TextEditGroup textEditGroup) {
        RewriteEvent rewriteEvent = this.getEvent().insert(aSTNode, n);
        if (bl) {
            this.getRewriteStore().setInsertBoundToPrevious(aSTNode);
        }
        if (textEditGroup != null) {
            this.getRewriteStore().setEventEditGroup(rewriteEvent, textEditGroup);
        }
    }

    private ASTNode createTargetNode(ASTNode aSTNode, ASTNode aSTNode2, boolean bl, ASTNode aSTNode3, TextEditGroup textEditGroup) {
        if (aSTNode == null || aSTNode2 == null) {
            throw new IllegalArgumentException();
        }
        NodeInfoStore nodeInfoStore = this.rewriter.getNodeStore();
        ASTNode aSTNode4 = nodeInfoStore.newPlaceholderNode(aSTNode.getNodeType());
        if (aSTNode4 == null) {
            throw new IllegalArgumentException("Creating a target node is not supported for nodes of type" + aSTNode.getClass().getName());
        }
        Block block = nodeInfoStore.createCollapsePlaceholder();
        RewriteEventStore.CopySourceInfo copySourceInfo = this.getRewriteStore().createRangeCopy(this.parent, this.childProperty, aSTNode, aSTNode2, bl, block, aSTNode3, textEditGroup);
        nodeInfoStore.markAsCopyTarget(aSTNode4, copySourceInfo);
        return aSTNode4;
    }

    public final ASTNode createCopyTarget(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == aSTNode2) {
            return this.rewriter.createCopyTarget(aSTNode);
        }
        return this.createTargetNode(aSTNode, aSTNode2, false, null, null);
    }

    public final ASTNode createMoveTarget(ASTNode aSTNode, ASTNode aSTNode2) {
        return this.createMoveTarget(aSTNode, aSTNode2, null, null);
    }

    public final ASTNode createMoveTarget(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, TextEditGroup textEditGroup) {
        if (aSTNode == aSTNode2) {
            this.replace(aSTNode, aSTNode3, textEditGroup);
            return this.rewriter.createMoveTarget(aSTNode);
        }
        return this.createTargetNode(aSTNode, aSTNode2, true, aSTNode3, textEditGroup);
    }

    private boolean isInsertBoundToPreviousByDefault(ASTNode aSTNode) {
        return aSTNode instanceof Statement || aSTNode instanceof FieldDeclaration;
    }

    public List getOriginalList() {
        List list = (List)this.getEvent().getOriginalValue();
        return Collections.unmodifiableList(list);
    }

    public List getRewrittenList() {
        List list = (List)this.getEvent().getNewValue();
        return Collections.unmodifiableList(list);
    }
}

