/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist;

import java.util.Stack;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TryStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;

public class ThrownExceptionFinder
extends ASTVisitor {
    private SimpleSet thrownExceptions;
    private Stack exceptionsStack;

    public ReferenceBinding[] find(TryStatement tryStatement, BlockScope blockScope) {
        this.thrownExceptions = new SimpleSet();
        this.exceptionsStack = new Stack();
        tryStatement.traverse(this, blockScope);
        this.removeCaughtExceptions(tryStatement);
        Object[] objectArray = new ReferenceBinding[this.thrownExceptions.elementSize];
        this.thrownExceptions.asArray(objectArray);
        return objectArray;
    }

    private void acceptException(ReferenceBinding referenceBinding) {
        if (referenceBinding != null && referenceBinding.isValidBinding()) {
            this.thrownExceptions.add(referenceBinding);
        }
    }

    public void endVisit(MessageSend messageSend, BlockScope blockScope) {
        if (messageSend.binding != null) {
            this.endVisitMethodInvocation(messageSend.binding);
        }
        super.endVisit(messageSend, blockScope);
    }

    public void endVisit(AllocationExpression allocationExpression, BlockScope blockScope) {
        if (allocationExpression.binding != null) {
            this.endVisitMethodInvocation(allocationExpression.binding);
        }
        super.endVisit(allocationExpression, blockScope);
    }

    public void endVisit(ThrowStatement throwStatement, BlockScope blockScope) {
        this.acceptException((ReferenceBinding)throwStatement.exception.resolvedType);
        super.endVisit(throwStatement, blockScope);
    }

    private void endVisitMethodInvocation(MethodBinding methodBinding) {
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        int n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.acceptException(referenceBindingArray[n2]);
            ++n2;
        }
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
        return this.visitType(typeDeclaration);
    }

    public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
        return this.visitType(typeDeclaration);
    }

    public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
        return this.visitType(typeDeclaration);
    }

    private boolean visitType(TypeDeclaration typeDeclaration) {
        return false;
    }

    public boolean visit(TryStatement tryStatement, BlockScope blockScope) {
        SimpleSet simpleSet;
        this.exceptionsStack.push(this.thrownExceptions);
        this.thrownExceptions = simpleSet = new SimpleSet();
        tryStatement.tryBlock.traverse(this, blockScope);
        this.removeCaughtExceptions(tryStatement);
        this.thrownExceptions = (SimpleSet)this.exceptionsStack.pop();
        Object[] objectArray = simpleSet.values;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                this.thrownExceptions.add(objectArray[n]);
            }
            ++n;
        }
        Block[] blockArray = tryStatement.catchBlocks;
        int n2 = blockArray == null ? 0 : blockArray.length;
        int n3 = 0;
        while (n3 < n2) {
            blockArray[n3].traverse(this, blockScope);
            ++n3;
        }
        return false;
    }

    private void removeCaughtExceptions(TryStatement tryStatement) {
        Argument[] argumentArray = tryStatement.catchArguments;
        int n = argumentArray == null ? 0 : argumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding typeBinding = argumentArray[n2].type.resolvedType;
            if (typeBinding != null && typeBinding.isValidBinding()) {
                this.removeCaughtException((ReferenceBinding)typeBinding);
            }
            ++n2;
        }
    }

    private void removeCaughtException(ReferenceBinding referenceBinding) {
        Object[] objectArray = this.thrownExceptions.values;
        int n = 0;
        while (n < objectArray.length) {
            ReferenceBinding referenceBinding2 = (ReferenceBinding)objectArray[n];
            if (referenceBinding2 != null && (referenceBinding2 == referenceBinding || referenceBinding.isSuperclassOf(referenceBinding2))) {
                this.thrownExceptions.remove(referenceBinding2);
            }
            ++n;
        }
    }
}

