/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public abstract class AbstractMethodDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;
    public InferredType inferredType;
    public InferredMethod inferredMethod;
    public boolean errorInSignature = false;
    public int exprStackPtr;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, categorizedProblem);
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode((Scope)blockScope, flowContext, flowInfo);
    }

    public abstract FlowInfo analyseCode(Scope var1, FlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null) {
            Object object;
            ReferenceBinding referenceBinding;
            if (this.binding == null) {
                int n = 0;
                int n2 = this.arguments.length;
                while (n < n2) {
                    this.arguments[n].bind(this.scope, null, true);
                    ++n;
                }
                return;
            }
            if (this.arguments.length > 0 && this.binding.parameters.length == 0 && (referenceBinding = this.binding.declaringClass) instanceof CompilationUnitBinding) {
                object = (CompilationUnitBinding)referenceBinding;
                ((SourceTypeBinding)object).resolveTypesFor(this.binding);
            }
            boolean bl = this.binding.isAbstract() || this.binding.isNative();
            object = null;
            int n = 0;
            int n3 = this.arguments.length;
            while (n < n3) {
                Argument argument = this.arguments[n];
                argument.bind(this.scope, this.binding.parameters[n], bl);
                if (argument.annotations != null) {
                    this.binding.tagBits |= 0x400L;
                    if (object == null) {
                        object = new AnnotationBinding[n3][];
                    }
                    object[n] = argument.binding.getAnnotations();
                }
                ++n;
            }
            if (object != null) {
                this.binding.setParameterAnnotations((AnnotationBinding[][])object);
            }
        }
    }

    public void bindThrownExceptions() {
        block9: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block9;
            int n = this.binding.thrownExceptions.length;
            int n2 = this.thrownExceptions.length;
            if (n == n2) {
                int n3 = 0;
                while (n3 < n) {
                    this.thrownExceptions[n3].resolvedType = this.binding.thrownExceptions[n3];
                    ++n3;
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                while (n5 < n2 && n4 < n) {
                    TypeReference typeReference = this.thrownExceptions[n5];
                    ReferenceBinding referenceBinding = this.binding.thrownExceptions[n4];
                    char[][] cArray = referenceBinding.compoundName;
                    if (cArray != null) {
                        if (typeReference instanceof SingleTypeReference) {
                            int n6 = cArray.length;
                            char[] cArray2 = typeReference.getTypeName()[0];
                            if (CharOperation.equals(cArray2, cArray[n6 - 1])) {
                                typeReference.resolvedType = referenceBinding;
                                ++n4;
                            }
                        } else if (CharOperation.equals(typeReference.getTypeName(), cArray)) {
                            typeReference.resolvedType = referenceBinding;
                            ++n4;
                        }
                    }
                    ++n5;
                }
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        classFile.codeStream.wideMode = false;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n2 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n2];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n2);
            classFile.addProblemMethod(this, this.binding, categorizedProblemArray2);
            return;
        }
        try {
            n = classFile.contentsOffset;
            this.generateCode(classFile);
        }
        catch (AbortMethod abortMethod) {
            if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classFile);
                }
                catch (AbortMethod abortMethod2) {
                    CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int n3 = categorizedProblemArray.length;
                    CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n3];
                    System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray3, 0, n3);
                    classFile.addProblemMethod(this, this.binding, categorizedProblemArray3, n);
                }
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n4 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray4 = new CategorizedProblem[n4];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray4, 0, n4);
            classFile.addProblemMethod(this, this.binding, categorizedProblemArray4, n);
        }
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n3;
            int n4;
            int n5 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            this.scope.computeLocalVariablePositions(this.binding.isStatic() ? 0 : 1, codeStream);
            if (this.arguments != null) {
                n4 = 0;
                n3 = this.arguments.length;
                while (n4 < n3) {
                    LocalVariableBinding localVariableBinding = this.arguments[n4].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    ++n4;
                }
            }
            if (this.statements != null) {
                n4 = 0;
                n3 = this.statements.length;
                while (n4 < n3) {
                    this.statements[n4].generateCode(this.scope, codeStream);
                    ++n4;
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.declarationSourceEnd);
            classFile.completeCodeAttribute(n5);
            ++n2;
        } else {
            this.checkArgumentsSize();
        }
        classFile.completeMethodInfo(n, n2);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    private void checkArgumentsSize() {
        TypeBinding[] typeBindingArray = this.binding.parameters;
        int n = 1;
        int n2 = 0;
        int n3 = typeBindingArray.length;
        while (n2 < n3) {
            TypeBinding typeBinding = typeBindingArray[n2];
            n = typeBinding == TypeBinding.LONG || typeBinding == TypeBinding.DOUBLE ? (n += 2) : ++n;
            if (n > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(this.scope.locals[n2], this.scope.locals[n2].declaration);
            }
            ++n2;
        }
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer);
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        AbstractMethodDeclaration.printIndent(n, stringBuffer);
        AbstractMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        stringBuffer.append("function ");
        if (this.selector != null) {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            int n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append(')');
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return stringBuffer.append(';');
        }
        stringBuffer.append(" {");
        if (this.statements != null) {
            int n2 = 0;
            while (n2 < this.statements.length) {
                stringBuffer.append('\n');
                this.statements[n2].printStatement(n, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append('\n');
        AbstractMethodDeclaration.printIndent(n == 0 ? 0 : n - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public StringBuffer printReturnType(int n, StringBuffer stringBuffer) {
        return stringBuffer;
    }

    public void resolve(Scope scope) {
        if (this.scope == null) {
            CompilationUnitBinding compilationUnitBinding;
            MethodBinding methodBinding;
            this.scope = new MethodScope(scope, this, false);
            if (this.selector != null && (methodBinding = this.scope.createMethod(this, this.selector, compilationUnitBinding = scope.enclosingCompilationUnit(), false, true)) != null) {
                this.binding = methodBinding;
                if ((methodBinding = compilationUnitBinding.resolveTypesFor(methodBinding)) != null) {
                    MethodScope methodScope = scope.enclosingMethodScope();
                    if (methodScope != null) {
                        methodScope.addLocalMethod(methodBinding);
                    } else {
                        compilationUnitBinding.addMethod(methodBinding);
                        scope.environment().defaultPackage.addBinding(methodBinding, methodBinding.selector, 8);
                    }
                }
            }
        }
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.resolveJavadoc();
            this.resolveStatements();
            if (this.binding != null && (this.binding.getAnnotationTagBits() & 0x400000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.scope.problemReporter().missingDeprecatedAnnotationForMethod(this);
            }
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int n = 0;
            int n2 = this.statements.length;
            while (n < n2) {
                this.statements[n].resolve(this.scope);
                ++n;
            }
        } else if ((this.bits & 8) != 0) {
            this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, Scope scope) {
    }

    public TypeParameter[] typeParameters() {
        return null;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
    }

    public void resolve(BlockScope blockScope) {
        this.resolve((Scope)blockScope);
    }

    public boolean isInferred() {
        return this.inferredMethod != null;
    }
}

