/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SuperReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public boolean isDefaultConstructor = false;
    public TypeParameter[] typeParameters;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        this.analyseCode(classScope, initializationFlowContext, flowInfo, 0);
    }

    public FlowInfo analyseCode(Scope scope, FlowContext flowContext, FlowInfo flowInfo) {
        this.analyseCode((ClassScope)scope, (InitializationFlowContext)flowContext, flowInfo, 0);
        return flowInfo;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo, int n) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        int n2 = flowInfo.reachMode();
        flowInfo.setReachMode(n);
        Object object = this.binding;
        if (!(object == null || this.isDefaultConstructor || ((MethodBinding)object).isUsed() || (((MethodBinding)object).isPrivate() ? (this.binding.declaringClass.tagBits & 0x10000000000000L) == 0L : (this.binding.declaringClass.tagBits & 0x30L) != 16L))) {
            this.scope.problemReporter().unusedPrivateConstructor(this);
        }
        if (this.isRecursive(null)) {
            this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
        }
        try {
            Object object2;
            int n3;
            FieldBinding[] fieldBindingArray;
            object = new ExceptionHandlingFlowContext(initializationFlowContext.parent, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            initializationFlowContext.checkInitializerExceptions(this.scope, (FlowContext)object, flowInfo);
            if (this.binding.declaringClass.isAnonymousType() && (fieldBindingArray = ((ExceptionHandlingFlowContext)object).extendedExceptions) != null && (n3 = fieldBindingArray.size()) > 0) {
                ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n3];
                fieldBindingArray.toArray(referenceBindingArray);
                this.binding.thrownExceptions = referenceBindingArray;
            }
            if (this.arguments != null) {
                int n4 = 0;
                n3 = this.arguments.length;
                while (n4 < n3) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[n4].binding);
                    ++n4;
                }
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    fieldBindingArray = this.binding.declaringClass.fields();
                    n3 = 0;
                    int n5 = fieldBindingArray.length;
                    while (n3 < n5) {
                        object2 = fieldBindingArray[n3];
                        if (!((FieldBinding)object2).isStatic()) {
                            flowInfo.markAsDefinitelyAssigned((FieldBinding)object2);
                        }
                        ++n3;
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.scope, (FlowContext)object, flowInfo);
            }
            flowInfo.setReachMode(n2);
            if (this.statements != null) {
                boolean bl = false;
                n3 = 0;
                int n6 = this.statements.length;
                while (n3 < n6) {
                    object2 = this.statements[n3];
                    if (!((Statement)object2).complainIfUnreachable(flowInfo, this.scope, bl)) {
                        flowInfo = ((Statement)object2).analyseCode(this.scope, (FlowContext)object, flowInfo);
                    } else {
                        bl = true;
                    }
                    ++n3;
                }
            }
            this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            flowInfo.setReachMode(n);
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(((ExceptionHandlingFlowContext)object).initsOnReturn);
                FieldBinding[] fieldBindingArray2 = this.binding.declaringClass.fields();
                n3 = 0;
                int n7 = fieldBindingArray2.length;
                while (n3 < n7) {
                    object2 = fieldBindingArray2[n3];
                    if (!((FieldBinding)object2).isStatic() && ((VariableBinding)object2).isFinal() && !flowInfo.isDefinitelyAssigned(fieldBindingArray2[n3])) {
                        this.scope.problemReporter().uninitializedBlankFinalField((FieldBinding)object2, this.isDefaultConstructor ? this.scope.referenceType() : this);
                    }
                    ++n3;
                }
            }
            ((ExceptionHandlingFlowContext)object).complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n2 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n2];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n2);
            classFile.addProblemConstructor(this, this.binding, categorizedProblemArray2);
            return;
        }
        try {
            n = classFile.contentsOffset;
            this.internalGenerateCode(classScope, classFile);
        }
        catch (AbortMethod abortMethod) {
            if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.internalGenerateCode(classScope, classFile);
                }
                catch (AbortMethod abortMethod2) {
                    CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int n3 = categorizedProblemArray.length;
                    CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n3];
                    System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray3, 0, n3);
                    classFile.addProblemConstructor(this, this.binding, categorizedProblemArray3, n);
                }
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n4 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray4 = new CategorizedProblem[n4];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray4, 0, n4);
            classFile.addProblemConstructor(this, this.binding, categorizedProblemArray4, n);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding;
        if (!referenceBinding.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)referenceBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = nestedTypeBinding.syntheticEnclosingInstances();
        int n = 0;
        int n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        while (n < n2) {
            syntheticArgumentBinding = syntheticArgumentBindingArray[n];
            if (syntheticArgumentBinding.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArgumentBinding);
                codeStream.putfield(syntheticArgumentBinding.matchingField);
            }
            ++n;
        }
        syntheticArgumentBindingArray = nestedTypeBinding.syntheticOuterLocalVariables();
        n = 0;
        n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        while (n < n2) {
            syntheticArgumentBinding = syntheticArgumentBindingArray[n];
            if (syntheticArgumentBinding.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArgumentBinding);
                codeStream.putfield(syntheticArgumentBinding.matchingField);
            }
            ++n;
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n3;
            boolean bl;
            int n4;
            Object object;
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            int n5 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            ReferenceBinding referenceBinding = this.binding.declaringClass;
            int n6 = referenceBinding.isEnum() ? 2 : 0;
            int n7 = 1 + n6;
            if (referenceBinding.isNestedType()) {
                object = (NestedTypeBinding)referenceBinding;
                this.scope.extraSyntheticArguments = ((NestedTypeBinding)object).syntheticOuterLocalVariables();
                this.scope.computeLocalVariablePositions(((NestedTypeBinding)object).enclosingInstancesSlotSize + 1 + n6, codeStream);
                n7 += ((NestedTypeBinding)object).enclosingInstancesSlotSize;
                n7 += ((NestedTypeBinding)object).outerLocalVariablesSlotSize;
            } else {
                this.scope.computeLocalVariablePositions(1 + n6, codeStream);
            }
            if (this.arguments != null) {
                int n8 = 0;
                n4 = this.arguments.length;
                while (n8 < n4) {
                    LocalVariableBinding localVariableBinding = this.arguments[n8].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    TypeBinding typeBinding = localVariableBinding.type;
                    n7 = typeBinding == TypeBinding.LONG || typeBinding == TypeBinding.DOUBLE ? (n7 += 2) : ++n7;
                    ++n8;
                }
            }
            object = typeDeclaration.initializerScope;
            ((MethodScope)object).computeLocalVariablePositions(n7, codeStream);
            n4 = this.constructorCall != null && this.constructorCall.accessMode == 3 ? 0 : 1;
            boolean bl2 = bl = this.scope.compilerOptions().targetJDK >= 0x300000L;
            if (n4 != 0 && bl) {
                this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
            }
            if (this.constructorCall != null) {
                this.constructorCall.generateCode(this.scope, codeStream);
            }
            if (n4 != 0) {
                if (!bl) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
                }
                if (typeDeclaration.fields != null) {
                    int n9 = 0;
                    n3 = typeDeclaration.fields.length;
                    while (n9 < n3) {
                        FieldDeclaration fieldDeclaration = typeDeclaration.fields[n9];
                        if (!fieldDeclaration.isStatic()) {
                            fieldDeclaration.generateCode((BlockScope)object, codeStream);
                        }
                        ++n9;
                    }
                }
            }
            if (this.statements != null) {
                int n10 = 0;
                n3 = this.statements.length;
                while (n10 < n3) {
                    this.statements[n10].generateCode(this.scope, codeStream);
                    ++n10;
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd);
            classFile.completeCodeAttribute(n5);
            ++n2;
        }
        classFile.completeMethodInfo(n, n2);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isDefaultConstructor() {
        return this.isDefaultConstructor;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList arrayList) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (this == constructorDeclaration) {
            return true;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int n = arrayList.indexOf(this);
            if (n >= 0) {
                return n == 0;
            }
        }
        arrayList.add(this);
        return constructorDeclaration.isRecursive(arrayList);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isDefaultConstructor && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, compilationUnitDeclaration);
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        stringBuffer.append(" {");
        if (this.constructorCall != null) {
            stringBuffer.append('\n');
            this.constructorCall.printStatement(n, stringBuffer);
        }
        if (this.statements != null) {
            int n2 = 0;
            while (n2 < this.statements.length) {
                stringBuffer.append('\n');
                this.statements[n2].printStatement(n, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append('\n');
        ConstructorDeclaration.printIndent(n == 0 ? 0 : n - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if (!this.isDefaultConstructor) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        SourceTypeBinding sourceTypeBinding = this.scope.enclosingSourceType();
        if (!CharOperation.equals(sourceTypeBinding.sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.typeParameters != null) {
            int n = 0;
            int n2 = this.typeParameters.length;
            while (n < n2) {
                this.typeParameters[n].resolve(this.scope);
                ++n;
            }
        }
        if (this.binding != null && !this.binding.isPrivate()) {
            sourceTypeBinding.tagBits |= 0x10000000000000L;
        }
        if (this.constructorCall != null) {
            if (sourceTypeBinding.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else {
                this.constructorCall.resolve(this.scope);
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.javadoc != null) {
                this.javadoc.traverse(aSTVisitor, this.scope);
            }
            if (this.annotations != null) {
                n2 = this.annotations.length;
                n = 0;
                while (n < n2) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                n = 0;
                while (n < n2) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                n = 0;
                while (n < n2) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(aSTVisitor, this.scope);
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                n = 0;
                while (n < n2) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

