/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ThrowStatement
extends Statement {
    public Expression exception;
    public TypeBinding exceptionType;

    public ThrowStatement(Expression expression, int n, int n2) {
        this.exception = expression;
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.exception.analyseCode(blockScope, flowContext, flowInfo);
        flowContext.checkExceptionHandlers(this.exceptionType, (ASTNode)this, flowInfo, blockScope);
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        this.exception.generateCode(blockScope, codeStream, true);
        codeStream.athrow();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ThrowStatement.printIndent(n, stringBuffer).append("throw ");
        this.exception.printExpression(0, stringBuffer);
        return stringBuffer.append(';');
    }

    public void resolve(BlockScope blockScope) {
        this.exceptionType = this.exception.resolveType(blockScope);
        if (this.exceptionType != null) {
            this.exceptionType.isValidBinding();
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.exception.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

