/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.codegen;

public class DoubleCache {
    private double[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public DoubleCache() {
        this(13);
    }

    public DoubleCache(int n) {
        this.keyTable = new double[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0.0;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(double d) {
        if (d == 0.0) {
            int n = 0;
            int n2 = this.elementSize;
            while (n < n2) {
                if (this.keyTable[n] == 0.0) {
                    long l = Double.doubleToLongBits(d);
                    long l2 = Double.doubleToLongBits(this.keyTable[n]);
                    if (l == Long.MIN_VALUE && l2 == Long.MIN_VALUE) {
                        return true;
                    }
                    if (l == 0L && l2 == 0L) {
                        return true;
                    }
                }
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.elementSize;
            while (n < n3) {
                if (this.keyTable[n] == d) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public int put(double d, int n) {
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new double[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = d;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return n;
    }

    public int putIfAbsent(double d, int n) {
        if (d == 0.0) {
            int n2 = 0;
            int n3 = this.elementSize;
            while (n2 < n3) {
                if (this.keyTable[n2] == 0.0) {
                    long l = Double.doubleToLongBits(d);
                    long l2 = Double.doubleToLongBits(this.keyTable[n2]);
                    if (l == Long.MIN_VALUE && l2 == Long.MIN_VALUE) {
                        return this.valueTable[n2];
                    }
                    if (l == 0L && l2 == 0L) {
                        return this.valueTable[n2];
                    }
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = this.elementSize;
            while (n4 < n5) {
                if (this.keyTable[n4] == d) {
                    return this.valueTable[n4];
                }
                ++n4;
            }
        }
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new double[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = d;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return -n;
    }

    public String toString() {
        int n = this.elementSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 < n) {
            if (this.keyTable[n2] != 0.0 || this.keyTable[n2] == 0.0 && this.valueTable[n2] != 0) {
                stringBuffer.append(this.keyTable[n2]).append("->").append(this.valueTable[n2]);
            }
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

