/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.codegen;

public class LongCache {
    public long[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public LongCache() {
        this(13);
    }

    public LongCache(int n) {
        this.threshold = (int)((double)n * 0.66);
        this.keyTable = new long[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0L;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(long l) {
        int n = this.hash(l);
        int n2 = this.keyTable.length;
        while (this.keyTable[n] != 0L || this.keyTable[n] == 0L && this.valueTable[n] != 0) {
            if (this.keyTable[n] == l) {
                return true;
            }
            if (++n != n2) continue;
            n = 0;
        }
        return false;
    }

    public int hash(long l) {
        return ((int)l & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(long l, int n) {
        int n2 = this.hash(l);
        int n3 = this.keyTable.length;
        while (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == l) {
                this.valueTable[n2] = n;
                return this.valueTable[n2];
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        this.keyTable[n2] = l;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    public int putIfAbsent(long l, int n) {
        int n2 = this.hash(l);
        int n3 = this.keyTable.length;
        while (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == l) {
                return this.valueTable[n2];
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        this.keyTable[n2] = l;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return -n;
    }

    private void rehash() {
        LongCache longCache = new LongCache(this.keyTable.length * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            long l = this.keyTable[n];
            int n2 = this.valueTable[n];
            if (l == 0L && (l != 0L || n2 == 0)) continue;
            longCache.put(l, n2);
        }
        this.keyTable = longCache.keyTable;
        this.valueTable = longCache.valueTable;
        this.threshold = longCache.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 < n) {
            if (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
                stringBuffer.append(this.keyTable[n2]).append("->").append(this.valueTable[n2]);
            }
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

