/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    char[] signature;
    public long tagBits;

    protected MethodBinding() {
    }

    public MethodBinding(int n, char[] cArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this.modifiers = n;
        this.selector = cArray;
        this.returnType = typeBinding;
        this.parameters = typeBindingArray == null || typeBindingArray.length == 0 ? Binding.NO_PARAMETERS : typeBindingArray;
        this.thrownExceptions = referenceBindingArray == null || referenceBindingArray.length == 0 ? Binding.NO_EXCEPTIONS : referenceBindingArray;
        this.declaringClass = referenceBinding;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int n, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this(n, TypeConstants.INIT, TypeBinding.UNKNOWN, typeBindingArray, referenceBindingArray, referenceBinding);
    }

    public MethodBinding(MethodBinding methodBinding, ReferenceBinding referenceBinding) {
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
        this.thrownExceptions = methodBinding.thrownExceptions;
        this.declaringClass = referenceBinding;
        referenceBinding.storeAnnotationHolder(this, methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true));
    }

    public final boolean areParameterErasuresEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.parameters[n2] != typeBindingArray[n2] && this.parameters[n2].erasure() != typeBindingArray[n2].erasure()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.parameters[n2] != typeBindingArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] typeBindingArray) {
        int n;
        int n2 = this.parameters.length;
        int n3 = n = typeBindingArray.length;
        if (this.isVarargs()) {
            TypeBinding typeBinding;
            n3 = n2 - 1;
            if (n2 == n) {
                typeBinding = this.parameters[n3];
                TypeBinding typeBinding2 = typeBindingArray[n3];
                if (typeBinding != typeBinding2 && !typeBinding2.isCompatibleWith(typeBinding)) {
                    return false;
                }
            } else if (n2 < n) {
                typeBinding = ((ArrayBinding)this.parameters[n3]).elementsType();
                int n4 = n3;
                while (n4 < n) {
                    if (typeBinding != typeBindingArray[n4] && !typeBindingArray[n4].isCompatibleWith(typeBinding)) {
                        return false;
                    }
                    ++n4;
                }
            } else if (n3 != n) {
                return false;
            }
        }
        int n5 = 0;
        while (n5 < n3) {
            if (this.parameters[n5] != typeBindingArray[n5] && !typeBindingArray[n5].isCompatibleWith(this.parameters[n5])) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding methodBinding) {
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (this.typeVariables == typeVariableBindingArray) {
            return true;
        }
        int n = this.typeVariables.length;
        if (n != typeVariableBindingArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.typeVariables[n2] != typeVariableBindingArray[n2] && this.typeVariables[n2].erasure() != typeVariableBindingArray[n2].erasure()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            referenceBinding2 = referenceBinding3.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            return referenceBinding == referenceBinding3;
        }
        return sourceTypeBinding.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            TypeBinding typeBinding2 = typeBinding.erasure();
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.declaringClass.erasure();
            int n = 0;
            do {
                if (referenceBinding.findSuperTypeWithSameErasure(referenceBinding2) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                    if (referenceBinding == typeBinding2 || typeBinding2.findSuperTypeWithSameErasure(referenceBinding) != null) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                }
                ++n;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(typeBinding == this.declaringClass || typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding = sourceTypeBinding;
                ReferenceBinding referenceBinding3 = referenceBinding.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                ReferenceBinding referenceBinding4 = (ReferenceBinding)this.declaringClass.erasure();
                referenceBinding3 = referenceBinding4.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding4 = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                if (referenceBinding != referenceBinding4) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding packageBinding = this.declaringClass.fPackage;
        if (sourceTypeBinding.fPackage != packageBinding) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (this.declaringClass == referenceBinding) {
                return true;
            }
            PackageBinding packageBinding2 = referenceBinding.fPackage;
            if (packageBinding2 == null || packageBinding2 == packageBinding) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    MethodBinding computeSubstitutedMethod(MethodBinding methodBinding, LookupEnvironment lookupEnvironment) {
        int n = this.typeVariables.length;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (n != typeVariableBindingArray.length) {
            return null;
        }
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = lookupEnvironment.createParameterizedGenericMethod(methodBinding, this.typeVariables);
        int n2 = 0;
        while (n2 < n) {
            if (!this.typeVariables[n2].isInterchangeableWith(typeVariableBindingArray[n2], parameterizedGenericMethodBinding)) {
                return null;
            }
            ++n2;
        }
        return parameterizedGenericMethodBinding;
    }

    public char[] computeUniqueKey(boolean bl) {
        boolean bl2;
        boolean bl3;
        char[] cArray = this.declaringClass.computeUniqueKey(false);
        int n = cArray.length;
        int n2 = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] cArray2 = this.genericSignature();
        boolean bl4 = bl3 = cArray2 != null;
        if (!bl3) {
            cArray2 = this.signature();
        }
        int n3 = cArray2.length;
        int n4 = this.thrownExceptions.length;
        int n5 = 0;
        Object object = null;
        boolean bl5 = bl2 = n4 > 0 && (!bl3 || CharOperation.lastIndexOf('^', cArray2) < 0);
        if (bl2) {
            object = new char[n4][];
            int n6 = 0;
            while (n6 < n4) {
                if (this.thrownExceptions[n6] != null) {
                    object[n6] = this.thrownExceptions[n6].signature();
                    n5 += object[n6].length + 1;
                }
                ++n6;
            }
        }
        char[] cArray3 = new char[n + 1 + n2 + n3 + n5];
        int n7 = 0;
        System.arraycopy(cArray, 0, cArray3, n7, n);
        n7 = n;
        cArray3[n7++] = 46;
        System.arraycopy(this.selector, 0, cArray3, n7, n2);
        System.arraycopy(cArray2, 0, cArray3, n7 += n2, n3);
        if (n5 > 0) {
            n7 += n3;
            int n8 = 0;
            while (n8 < n4) {
                char[] cArray4 = object[n8];
                if (cArray4 != null) {
                    cArray3[n7++] = 124;
                    int n9 = cArray4.length;
                    System.arraycopy(cArray4, 0, cArray3, n7, n9);
                    n7 += n9;
                }
                ++n8;
            }
        }
        return cArray3;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append('<');
            n2 = 0;
            n = this.typeVariables.length;
            while (n2 < n) {
                stringBuffer.append(this.typeVariables[n2].genericSignature());
                ++n2;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append('(');
        n2 = 0;
        n = this.parameters.length;
        while (n2 < n) {
            stringBuffer.append(this.parameters[n2].genericTypeSignature());
            ++n2;
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.genericTypeSignature());
        }
        n2 = 0;
        n = this.thrownExceptions.length;
        int n3 = 0;
        while (n3 < n) {
            if ((this.thrownExceptions[n3].modifiers & 0x40000000) != 0) {
                n2 = 1;
                break;
            }
            ++n3;
        }
        if (n2 != 0) {
            n3 = 0;
            while (n3 < n) {
                stringBuffer.append('^');
                stringBuffer.append(this.thrownExceptions[n3].genericTypeSignature());
                ++n3;
            }
        }
        n3 = stringBuffer.length();
        char[] cArray = new char[n3];
        stringBuffer.getChars(0, n3, cArray, 0);
        return cArray;
    }

    public AnnotationBinding[] getAnnotations() {
        MethodBinding methodBinding = this.original();
        return methodBinding.declaringClass.retrieveAnnotations(methodBinding);
    }

    public AnnotationBinding[] getParameterAnnotations(int n) {
        MethodBinding methodBinding = this.original();
        AnnotationHolder annotationHolder = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getParameterAnnotations(n);
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public long getAnnotationTagBits() {
        TypeDeclaration typeDeclaration;
        AbstractMethodDeclaration abstractMethodDeclaration;
        ClassScope classScope;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x200000000L) == 0L && methodBinding.declaringClass instanceof SourceTypeBinding && (classScope = ((SourceTypeBinding)methodBinding.declaringClass).classScope) != null && (abstractMethodDeclaration = (typeDeclaration = classScope.referenceContext).declarationOf(methodBinding)) != null) {
            ASTNode.resolveAnnotations(abstractMethodDeclaration.scope, abstractMethodDeclaration.annotations, methodBinding);
        }
        return methodBinding.tagBits;
    }

    public Object getDefaultValue() {
        Object object;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x8000000000000L) == 0L) {
            if (methodBinding.declaringClass instanceof SourceTypeBinding) {
                AbstractMethodDeclaration abstractMethodDeclaration;
                object = (SourceTypeBinding)methodBinding.declaringClass;
                if (((SourceTypeBinding)object).scope != null && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null && abstractMethodDeclaration.isAnnotationMethod()) {
                    abstractMethodDeclaration.resolve(((SourceTypeBinding)object).scope);
                }
            }
            methodBinding.tagBits |= 0x8000000000000L;
        }
        return (object = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true)) == null ? null : ((AnnotationHolder)object).getDefaultValue();
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        int n = this.typeVariables.length;
        while (--n >= 0) {
            if (!CharOperation.equals(this.typeVariables[n].sourceName, cArray)) continue;
            return this.typeVariables[n];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding typeBinding;
        return this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 9) != 0 && TypeBinding.VOID == this.returnType && this.parameters.length == 1 && (typeBinding = this.parameters[0]).dimensions() == 1 && typeBinding.leafComponentType().id == 11;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this;
    }

    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.sourceName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n = 0;
            int n2 = this.parameters.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n].sourceName());
                ++n;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString().toCharArray();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.declaringClass.storeAnnotations(this, annotationBindingArray);
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2, Object object) {
        this.declaringClass.storeAnnotationHolder(this, AnnotationHolder.storeAnnotations(annotationBindingArray, annotationBindingArray2, object));
    }

    public void setDefaultValue(Object object) {
        MethodBinding methodBinding = this.original();
        methodBinding.tagBits |= 0x8000000000000L;
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, null, object);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationHolder.getParameterAnnotations(), object);
        }
    }

    public void setParameterAnnotations(AnnotationBinding[][] annotationBindingArray) {
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, annotationBindingArray, null);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationBindingArray, annotationHolder.getDefaultValue());
        }
    }

    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.shortReadableName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            n = 0;
            int n2 = this.parameters.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n].shortReadableName());
                ++n;
            }
        }
        stringBuffer.append(')');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    protected final void setSelector(char[] cArray) {
        this.selector = cArray;
        this.signature = null;
    }

    public final char[] signature() {
        int n;
        int n2;
        Binding[] bindingArray;
        boolean bl;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl2 = this.isConstructor();
        if (bl2 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl3 = bl = bl2 && this.declaringClass.isNestedType();
        if (bl) {
            bindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (bindingArray != null) {
                n2 = 0;
                n = bindingArray.length;
                while (n2 < n) {
                    stringBuffer.append(((ReferenceBinding)bindingArray[n2]).signature());
                    ++n2;
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            int n3 = 0;
            while (n3 < typeBindingArray.length) {
                stringBuffer.append(typeBindingArray[n3].signature());
                ++n3;
            }
        }
        if (bl) {
            bindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n2 = bindingArray == null ? 0 : bindingArray.length;
            n = 0;
            while (n < n2) {
                stringBuffer.append(((SyntheticArgumentBinding)bindingArray[n]).type.signature());
                ++n;
            }
            n = typeBindingArray.length;
            int n4 = this.parameters.length;
            while (n < n4) {
                stringBuffer.append(this.parameters[n].signature());
                ++n;
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.signature());
        }
        int n5 = stringBuffer.length();
        this.signature = new char[n5];
        stringBuffer.getChars(0, n5, this.signature, 0);
        return this.signature;
    }

    public final char[] signature(ClassFile classFile) {
        boolean bl;
        if (this.signature != null) {
            if ((this.tagBits & 0x200L) != 0L) {
                Object object;
                Object object2;
                boolean bl2;
                boolean bl3 = this.isConstructor();
                TypeBinding[] typeBindingArray = this.parameters;
                boolean bl4 = bl2 = bl3 && this.declaringClass.isNestedType();
                if (bl2) {
                    object2 = this.declaringClass.syntheticEnclosingInstanceTypes();
                    if (object2 != null) {
                        int n = 0;
                        int n2 = ((ReferenceBinding[])object2).length;
                        while (n < n2) {
                            object = object2[n];
                            if (((TypeBinding)object).isNestedType()) {
                                classFile.recordInnerClasses((TypeBinding)object);
                            }
                            ++n;
                        }
                    }
                    if (this instanceof SyntheticMethodBinding) {
                        typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
                    }
                }
                if (typeBindingArray != Binding.NO_PARAMETERS) {
                    int n = 0;
                    while (n < typeBindingArray.length) {
                        TypeBinding typeBinding = typeBindingArray[n];
                        TypeBinding typeBinding2 = typeBinding.leafComponentType();
                        if (typeBinding2.isNestedType()) {
                            classFile.recordInnerClasses(typeBinding2);
                        }
                        ++n;
                    }
                }
                if (bl2) {
                    int n = typeBindingArray.length;
                    int n3 = this.parameters.length;
                    while (n < n3) {
                        TypeBinding typeBinding = this.parameters[n];
                        object = typeBinding.leafComponentType();
                        if (((TypeBinding)object).isNestedType()) {
                            classFile.recordInnerClasses((TypeBinding)object);
                        }
                        ++n;
                    }
                }
                if (this.returnType != null && ((TypeBinding)(object2 = this.returnType.leafComponentType())).isNestedType()) {
                    classFile.recordInnerClasses((TypeBinding)object2);
                }
            }
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl5 = this.isConstructor();
        if (bl5 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl6 = bl = bl5 && this.declaringClass.isNestedType();
        if (bl) {
            ReferenceBinding[] referenceBindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (referenceBindingArray != null) {
                int n = 0;
                int n4 = referenceBindingArray.length;
                while (n < n4) {
                    ReferenceBinding referenceBinding = referenceBindingArray[n];
                    if (referenceBinding.isNestedType()) {
                        this.tagBits |= 0x200L;
                        classFile.recordInnerClasses(referenceBinding);
                    }
                    stringBuffer.append(referenceBinding.signature());
                    ++n;
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            int n = 0;
            while (n < typeBindingArray.length) {
                TypeBinding typeBinding = typeBindingArray[n];
                TypeBinding typeBinding3 = typeBinding.leafComponentType();
                if (typeBinding3.isNestedType()) {
                    this.tagBits |= 0x200L;
                    classFile.recordInnerClasses(typeBinding3);
                }
                stringBuffer.append(typeBinding.signature());
                ++n;
            }
        }
        if (bl) {
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = this.declaringClass.syntheticOuterLocalVariables();
            int n = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            int n5 = 0;
            while (n5 < n) {
                stringBuffer.append(syntheticArgumentBindingArray[n5].type.signature());
                ++n5;
            }
            n5 = typeBindingArray.length;
            int n6 = this.parameters.length;
            while (n5 < n6) {
                TypeBinding typeBinding = this.parameters[n5];
                TypeBinding typeBinding4 = typeBinding.leafComponentType();
                if (typeBinding4.isNestedType()) {
                    this.tagBits |= 0x200L;
                    classFile.recordInnerClasses(typeBinding4);
                }
                stringBuffer.append(typeBinding.signature());
                ++n5;
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            TypeBinding typeBinding = this.returnType.leafComponentType();
            if (typeBinding.isNestedType()) {
                this.tagBits |= 0x200L;
                classFile.recordInnerClasses(typeBinding);
            }
            stringBuffer.append(this.returnType.signature());
        }
        int n = stringBuffer.length();
        this.signature = new char[n];
        stringBuffer.getChars(0, n, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceTypeBinding;
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (sourceTypeBinding != null) {
            return sourceTypeBinding.sourceMethod(this);
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceStart;
    }

    public String toString() {
        int n;
        int n2;
        String string = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        string = String.valueOf(string) + "(";
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                n2 = 0;
                n = this.parameters.length;
                while (n2 < n) {
                    if (n2 > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + (this.parameters[n2] != null ? this.parameters[n2].debugName() : "NULL TYPE");
                    ++n2;
                }
            }
        } else {
            string = String.valueOf(string) + "NULL PARAMETERS";
        }
        string = String.valueOf(string) + ") ";
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != Binding.NO_EXCEPTIONS) {
                string = String.valueOf(string) + "throws ";
                n2 = 0;
                n = this.thrownExceptions.length;
                while (n2 < n) {
                    if (n2 > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + (this.thrownExceptions[n2] != null ? this.thrownExceptions[n2].debugName() : "NULL TYPE");
                    ++n2;
                }
            }
        } else {
            string = String.valueOf(string) + "NULL THROWN EXCEPTIONS";
        }
        return string;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }
}

