/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class WildcardBinding
extends ReferenceBinding {
    ReferenceBinding genericType;
    int rank;
    public TypeBinding bound;
    public TypeBinding[] otherBounds;
    char[] genericSignature;
    public int boundKind;
    ReferenceBinding superclass;
    ReferenceBinding[] superInterfaces;
    TypeVariableBinding typeVariable;
    LookupEnvironment environment;

    public WildcardBinding(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, LookupEnvironment lookupEnvironment) {
        this.genericType = referenceBinding;
        this.rank = n;
        this.boundKind = n2;
        this.modifiers = 0x40000001;
        this.environment = lookupEnvironment;
        this.initialize(referenceBinding, typeBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
        }
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        }
        this.tagBits |= 0x1000000L;
    }

    public int kind() {
        return 516;
    }

    public boolean boundCheck(TypeBinding typeBinding) {
        switch (this.boundKind) {
            case 0: {
                return true;
            }
            case 1: {
                if (typeBinding.isCompatibleWith(this.bound)) {
                    return true;
                }
                int n = 0;
                int n2 = this.otherBounds == null ? 0 : this.otherBounds.length;
                while (n < n2) {
                    if (typeBinding.isCompatibleWith(this.otherBounds[n])) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
        }
        return typeBinding.isCompatibleWith(this.bound);
    }

    public boolean canBeInstantiated() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        block59: {
            if ((this.tagBits & 0x20000000L) == 0L) {
                return;
            }
            if (typeBinding == TypeBinding.NULL) {
                return;
            }
            if (typeBinding.isCapture()) {
                CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                typeBinding = captureBinding.wildcard;
            }
            block0 : switch (n) {
                case 1: {
                    switch (this.boundKind) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (typeBinding.isWildcard()) {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                switch (wildcardBinding.boundKind) {
                                    case 0: {
                                        return;
                                    }
                                    case 1: {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 1);
                                        int n2 = 0;
                                        int n3 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                        while (n2 < n3) {
                                            this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[n2], inferenceContext, 1);
                                            ++n2;
                                        }
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                            this.bound.collectSubstitutes(scope, typeBinding, inferenceContext, 1);
                            return;
                        }
                        case 2: {
                            if (typeBinding.isWildcard()) {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                switch (wildcardBinding.boundKind) {
                                    case 0: {
                                        return;
                                    }
                                    case 1: {
                                        return;
                                    }
                                    case 2: {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                                        int n4 = 0;
                                        int n5 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                        while (n4 < n5) {
                                            this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[n4], inferenceContext, 2);
                                            ++n4;
                                        }
                                        return;
                                    }
                                }
                                return;
                            }
                            this.bound.collectSubstitutes(scope, typeBinding, inferenceContext, 2);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 0: {
                    switch (this.boundKind) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    return;
                                }
                                case 1: {
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 0);
                                    int n6 = 0;
                                    int n7 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    while (n6 < n7) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[n6], inferenceContext, 0);
                                        ++n6;
                                    }
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        case 2: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                                case 2: {
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 0);
                                    int n8 = 0;
                                    int n9 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    while (n8 < n9) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[n8], inferenceContext, 0);
                                        ++n8;
                                    }
                                    break;
                                }
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.boundKind) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                                    int n10 = 0;
                                    int n11 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    while (n10 < n11) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[n10], inferenceContext, 2);
                                        ++n10;
                                    }
                                    break block59;
                                }
                                default: {
                                    break;
                                }
                            }
                            break block59;
                        }
                        case 2: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    break block0;
                                }
                                case 1: {
                                    break block0;
                                }
                                case 2: {
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                                    int n12 = 0;
                                    int n13 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    while (n12 < n13) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[n12], inferenceContext, 2);
                                        ++n12;
                                    }
                                    break block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        char[] cArray2 = this.genericType.computeUniqueKey(false);
        switch (this.boundKind) {
            case 0: {
                cArray = TypeConstants.WILDCARD_STAR;
                break;
            }
            case 1: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.computeUniqueKey(false));
                break;
            }
            default: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.computeUniqueKey(false));
            }
        }
        return CharOperation.concat(cArray2, cArray);
    }

    public char[] constantPoolName() {
        return this.erasure().constantPoolName();
    }

    public String debugName() {
        return this.toString();
    }

    public TypeBinding erasure() {
        if (this.otherBounds == null) {
            if (this.boundKind == 1) {
                return this.bound.erasure();
            }
            return this.typeVariable().erasure();
        }
        return this.bound.id == 1 ? this.otherBounds[0].erasure() : this.bound.erasure();
    }

    public char[] genericTypeSignature() {
        if (this.genericSignature == null) {
            switch (this.boundKind) {
                case 0: {
                    this.genericSignature = TypeConstants.WILDCARD_STAR;
                    break;
                }
                case 1: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.genericTypeSignature());
                    break;
                }
                default: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.genericTypeSignature());
                }
            }
        }
        return this.genericSignature;
    }

    public int hashCode() {
        return this.genericType.hashCode();
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding typeBinding, TypeBinding[] typeBindingArray) {
        this.genericType = referenceBinding;
        this.bound = typeBinding;
        this.otherBounds = typeBindingArray;
        if (referenceBinding != null) {
            this.fPackage = referenceBinding.getPackage();
        }
        if (typeBinding != null) {
            this.tagBits |= typeBinding.tagBits & 0x20000000L;
        }
    }

    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        if (this.boundKind == 2) {
            if (this.bound instanceof ReferenceBinding) {
                return ((ReferenceBinding)this.bound).isSuperclassOf(referenceBinding);
            }
            return referenceBinding.id == 1;
        }
        return false;
    }

    public boolean isIntersectionType() {
        return this.otherBounds != null;
    }

    public boolean isUnboundWildcard() {
        return this.boundKind == 0;
    }

    public boolean isWildcard() {
        return true;
    }

    public char[] readableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.readableName());
                }
                StringBuffer stringBuffer = new StringBuffer(10);
                stringBuffer.append(this.bound.readableName());
                int n = 0;
                int n2 = this.otherBounds.length;
                while (n < n2) {
                    stringBuffer.append('&').append(this.otherBounds[n].readableName());
                    ++n;
                }
                n = stringBuffer.length();
                char[] cArray = new char[n];
                stringBuffer.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.readableName());
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        BinaryTypeBinding.resolveType(this.genericType, this.environment, null, 0);
        switch (this.boundKind) {
            case 1: 
            case 2: {
                BinaryTypeBinding.resolveType(this.bound, this.environment, null, 0);
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.shortReadableName());
                }
                StringBuffer stringBuffer = new StringBuffer(10);
                stringBuffer.append(this.bound.shortReadableName());
                int n = 0;
                int n2 = this.otherBounds.length;
                while (n < n2) {
                    stringBuffer.append('&').append(this.otherBounds[n].shortReadableName());
                    ++n;
                }
                n = stringBuffer.length();
                char[] cArray = new char[n];
                stringBuffer.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.shortReadableName());
    }

    public char[] signature() {
        if (this.signature == null) {
            switch (this.boundKind) {
                case 1: {
                    return this.bound.signature();
                }
            }
            return this.typeVariable().signature();
        }
        return this.signature;
    }

    public char[] sourceName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.sourceName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.sourceName());
    }

    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            TypeBinding typeBinding = null;
            if (this.boundKind == 1 && !this.bound.isInterface()) {
                typeBinding = this.bound;
            } else {
                TypeVariableBinding typeVariableBinding = this.typeVariable();
                if (typeVariableBinding != null) {
                    typeBinding = typeVariableBinding.firstBound;
                }
            }
            this.superclass = typeBinding instanceof ReferenceBinding && !typeBinding.isInterface() ? (ReferenceBinding)typeBinding : this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            this.superInterfaces = this.typeVariable() != null ? this.typeVariable.superInterfaces() : Binding.NO_SUPERINTERFACES;
            if (this.boundKind == 1) {
                int n;
                if (this.bound.isInterface()) {
                    n = this.superInterfaces.length;
                    this.superInterfaces = new ReferenceBinding[n + 1];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 1, n);
                    this.superInterfaces[0] = (ReferenceBinding)this.bound;
                }
                if (this.otherBounds != null) {
                    n = this.superInterfaces.length;
                    int n2 = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[n + n2];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 0, n);
                    int n3 = 0;
                    while (n3 < n2) {
                        this.superInterfaces[n + n3] = (ReferenceBinding)this.otherBounds[n3];
                        ++n3;
                    }
                }
            }
        }
        return this.superInterfaces;
    }

    public ReferenceBinding[] superInterfaces2() {
        if (this.superInterfaces == null) {
            if (this.boundKind == 1) {
                if (this.bound.isInterface()) {
                    if (this.otherBounds != null) {
                        int n = this.otherBounds.length;
                        this.superInterfaces = new ReferenceBinding[n + 1];
                        System.arraycopy(this.otherBounds, 0, this.superInterfaces, 1, n);
                        this.superInterfaces[0] = (ReferenceBinding)this.bound;
                    } else {
                        this.superInterfaces = new ReferenceBinding[]{(ReferenceBinding)this.bound};
                    }
                } else if (this.otherBounds != null) {
                    int n = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[n];
                    System.arraycopy(this.otherBounds, 0, this.superInterfaces, 0, n);
                } else {
                    this.superInterfaces = Binding.NO_SUPERINTERFACES;
                }
            } else {
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
            }
        }
        return this.superInterfaces;
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.genericType == unresolvedReferenceBinding) {
            this.genericType = referenceBinding;
            bl = true;
        } else if (this.bound == unresolvedReferenceBinding) {
            this.bound = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            bl = true;
        }
        if (bl) {
            this.initialize(this.genericType, this.bound, this.otherBounds);
        }
    }

    public String toString() {
        switch (this.boundKind) {
            case 0: {
                return new String(TypeConstants.WILDCARD_NAME);
            }
            case 1: {
                if (this.otherBounds == null) {
                    return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.debugName().toCharArray()));
                }
                StringBuffer stringBuffer = new StringBuffer(this.bound.debugName());
                int n = 0;
                int n2 = this.otherBounds.length;
                while (n < n2) {
                    stringBuffer.append('&').append(this.otherBounds[n].debugName());
                    ++n;
                }
                return stringBuffer.toString();
            }
        }
        return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.debugName().toCharArray()));
    }

    public TypeVariableBinding typeVariable() {
        TypeVariableBinding[] typeVariableBindingArray;
        if (this.typeVariable == null && this.rank < (typeVariableBindingArray = this.genericType.typeVariables()).length) {
            this.typeVariable = typeVariableBindingArray[this.rank];
        }
        return this.typeVariable;
    }
}

