/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.util;

public final class SimpleLookupTable
implements Cloneable {
    public Object[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    public int threshold;

    public SimpleLookupTable() {
        this(13);
    }

    public SimpleLookupTable(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.5f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Object[n2];
        this.valueTable = new Object[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleLookupTable simpleLookupTable = (SimpleLookupTable)super.clone();
        simpleLookupTable.elementSize = this.elementSize;
        simpleLookupTable.threshold = this.threshold;
        int n = this.keyTable.length;
        simpleLookupTable.keyTable = new Object[n];
        System.arraycopy(this.keyTable, 0, simpleLookupTable.keyTable, 0, n);
        n = this.valueTable.length;
        simpleLookupTable.valueTable = new Object[n];
        System.arraycopy(this.valueTable, 0, simpleLookupTable.valueTable, 0, n);
        return simpleLookupTable;
    }

    public boolean containsKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Object get(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public Object getKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return object2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return object;
    }

    public Object keyForValue(Object object) {
        if (object != null) {
            int n = 0;
            int n2 = this.keyTable.length;
            while (n < n2) {
                if (this.keyTable[n] != null && object.equals(this.valueTable[n])) {
                    return this.keyTable[n];
                }
                ++n;
            }
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object3 = this.keyTable[n2]) != null) {
            if (object3.equals(object)) {
                this.valueTable[n2] = object2;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = object;
        this.valueTable[n2] = object2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object2;
    }

    public Object removeKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                --this.elementSize;
                Object object3 = this.valueTable[n2];
                this.keyTable[n2] = null;
                this.valueTable[n2] = null;
                if (this.keyTable[n2 + 1 == n ? 0 : n2 + 1] != null) {
                    this.rehash();
                }
                return object3;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public void removeValue(Object object) {
        boolean bl = false;
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            Object object2 = this.valueTable[n];
            if (object2 != null && object2.equals(object)) {
                --this.elementSize;
                this.keyTable[n] = null;
                this.valueTable[n] = null;
                if (!bl && this.keyTable[n + 1 == n2 ? 0 : n + 1] != null) {
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            this.rehash();
        }
    }

    private void rehash() {
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Object object = this.keyTable[n];
            if (object == null) continue;
            simpleLookupTable.put(object, this.valueTable[n]);
        }
        this.keyTable = simpleLookupTable.keyTable;
        this.valueTable = simpleLookupTable.valueTable;
        this.elementSize = simpleLookupTable.elementSize;
        this.threshold = simpleLookupTable.threshold;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            Object object = this.valueTable[n];
            if (object != null) {
                string = String.valueOf(string) + this.keyTable[n].toString() + " -> " + object.toString() + "\n";
            }
            ++n;
        }
        return string;
    }
}

