/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;

public class BecomeWorkingCopyOperation
extends JavaModelOperation {
    IProblemRequestor problemRequestor;

    public BecomeWorkingCopyOperation(CompilationUnit compilationUnit, IProblemRequestor iProblemRequestor) {
        super(new IJavaElement[]{compilationUnit});
        this.problemRequestor = iProblemRequestor;
    }

    protected void executeOperation() throws JavaModelException {
        CompilationUnit compilationUnit = this.getWorkingCopy();
        JavaModelManager.getJavaModelManager().getPerWorkingCopyInfo(compilationUnit, true, true, this.problemRequestor);
        compilationUnit.openWhenClosed(compilationUnit.createElementInfo(), this.progressMonitor);
        if (!compilationUnit.isPrimary()) {
            JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
            javaElementDelta.added(compilationUnit);
            this.addDelta(javaElementDelta);
        } else if (compilationUnit.getResource().isAccessible()) {
            JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
            javaElementDelta.changed(compilationUnit, 65536);
            this.addDelta(javaElementDelta);
        } else {
            JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
            javaElementDelta.added(compilationUnit, 65536);
            this.addDelta(javaElementDelta);
        }
        this.resultElements = new IJavaElement[]{compilationUnit};
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

