/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class CreateTypeMemberOperation
extends CreateElementInCUOperation {
    protected String source = null;
    protected String alteredName;
    protected ASTNode createdNode;

    public CreateTypeMemberOperation(IJavaElement iJavaElement, String string, boolean bl) {
        super(iJavaElement);
        this.source = string;
        this.force = bl;
    }

    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode aSTNode) {
        switch (aSTNode.getNodeType()) {
            case 15: {
                if (this.createdNode instanceof AbstractTypeDeclaration) {
                    return CompilationUnit.TYPES_PROPERTY;
                }
                return CompilationUnit.STATEMENTS_PROPERTY;
            }
            case 71: {
                return EnumDeclaration.BODY_DECLARATIONS_PROPERTY;
            }
            case 81: {
                return AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY;
            }
        }
        return TypeDeclaration.BODY_DECLARATIONS_PROPERTY;
    }

    protected ASTNode generateElementAST(ASTRewrite aSTRewrite, IDocument iDocument, ICompilationUnit iCompilationUnit) throws JavaModelException {
        if (this.createdNode == null) {
            String string;
            ASTNode aSTNode;
            this.source = this.removeIndentAndNewLines(this.source, iDocument, iCompilationUnit);
            ASTParser aSTParser = ASTParser.newParser(3);
            aSTParser.setSource(this.source.toCharArray());
            aSTParser.setProject(this.getCompilationUnit().getJavaProject());
            aSTParser.setKind(4);
            ASTNode aSTNode2 = aSTParser.createAST(this.progressMonitor);
            if (aSTNode2.getNodeType() == 15) {
                aSTNode = (CompilationUnit)aSTNode2;
                this.createdNode = (ASTNode)((CompilationUnit)aSTNode).statements().iterator().next();
                string = this.source;
            } else if (aSTNode2.getNodeType() == 55) {
                aSTNode = (TypeDeclaration)aSTNode2;
                this.createdNode = (ASTNode)((AbstractTypeDeclaration)aSTNode).bodyDeclarations().iterator().next();
                string = this.source;
            } else {
                string = this.generateSyntaxIncorrectAST();
                if (this.createdNode == null) {
                    throw new JavaModelException(new JavaModelStatus(984));
                }
            }
            if (this.alteredName != null) {
                aSTNode = this.createdNode.getAST().newSimpleName(this.alteredName);
                SimpleName simpleName = this.rename(this.createdNode, (SimpleName)aSTNode);
                int n = simpleName.getStartPosition();
                int n2 = n + simpleName.getLength();
                StringBuffer stringBuffer = new StringBuffer();
                if (this.source.equals(string)) {
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(this.alteredName);
                    stringBuffer.append(string.substring(n2));
                } else {
                    int n3 = this.createdNode.getStartPosition();
                    int n4 = n3 + this.createdNode.getLength();
                    stringBuffer.append(string.substring(n3, n));
                    stringBuffer.append(this.alteredName);
                    stringBuffer.append(string.substring(n2, n4));
                }
                this.source = stringBuffer.toString();
            }
        }
        if (aSTRewrite == null) {
            return this.createdNode;
        }
        return aSTRewrite.createStringPlaceholder(this.source, this.createdNode.getNodeType());
    }

    private String removeIndentAndNewLines(String string, IDocument iDocument, ICompilationUnit iCompilationUnit) {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        Map map = iJavaProject.getOptions(true);
        int n = IndentManipulation.getTabWidth(map);
        int n2 = IndentManipulation.getIndentWidth(map);
        int n3 = IndentManipulation.measureIndentUnits(string, n, n2);
        int n4 = -1;
        int n5 = string.length();
        while (n4 < n5 - 1) {
            if (!ScannerHelper.isWhitespace(string.charAt(++n4))) break;
        }
        int n6 = n5;
        while (n6 > 0) {
            if (!ScannerHelper.isWhitespace(string.charAt(--n6))) break;
        }
        String string2 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        return IndentManipulation.changeIndent(string.substring(n4, n6 + 1), n3, n, n2, "", string2);
    }

    protected abstract SimpleName rename(ASTNode var1, SimpleName var2);

    protected String generateSyntaxIncorrectAST() {
        StringBuffer stringBuffer = new StringBuffer();
        IType iType = this.getType();
        Util.getLineSeparator(this.source, iType == null ? null : iType.getJavaProject());
        stringBuffer.append(this.source);
        ASTParser aSTParser = ASTParser.newParser(3);
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        List list = compilationUnit.statements();
        if (list.size() != 0) {
            this.createdNode = (ASTNode)list.iterator().next();
        }
        return stringBuffer.toString();
    }

    protected IType getType() {
        IJavaElement iJavaElement = this.getParentElement();
        return iJavaElement instanceof IType ? (IType)iJavaElement : null;
    }

    protected void setAlteredName(String string) {
        this.alteredName = string;
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        if (this.source == null) {
            return new JavaModelStatus(984);
        }
        if (!this.force) {
            try {
                ICompilationUnit iCompilationUnit = this.getCompilationUnit();
                this.generateElementAST(null, this.getDocument(iCompilationUnit), iCompilationUnit);
            }
            catch (JavaModelException javaModelException) {
                return javaModelException.getJavaModelStatus();
            }
            return this.verifyNameCollision();
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected IJavaModelStatus verifyNameCollision() {
        return JavaModelStatus.VERIFIED_OK;
    }
}

