/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.wst.jsdt.internal.core.LRUCacheEnumerator;
import org.eclipse.wst.jsdt.internal.core.OverflowingLRUCache;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public abstract class OverflowingLRUCache
extends LRUCache {
    protected int fOverflow = 0;
    protected boolean fTimestampsOn = true;
    protected double fLoadFactor = 0.333;

    public OverflowingLRUCache(int n) {
        this(n, 0);
    }

    public OverflowingLRUCache(int n, int n2) {
        super(n);
        this.fOverflow = n2;
    }

    public Object clone() {
        OverflowingLRUCache overflowingLRUCache = (OverflowingLRUCache)this.newInstance(this.fSpaceLimit, this.fOverflow);
        LRUCache.LRUCacheEntry lRUCacheEntry = this.fEntryQueueTail;
        while (lRUCacheEntry != null) {
            overflowingLRUCache.privateAdd(lRUCacheEntry._fKey, lRUCacheEntry._fValue, lRUCacheEntry._fSpace);
            lRUCacheEntry = lRUCacheEntry._fPrevious;
        }
        return overflowingLRUCache;
    }

    protected abstract boolean close(LRUCache.LRUCacheEntry var1);

    public Enumeration elements() {
        if (this.fEntryQueue == null) {
            return new LRUCacheEnumerator(null);
        }
        LRUCacheEnumerator.LRUEnumeratorElement lRUEnumeratorElement = new LRUCacheEnumerator.LRUEnumeratorElement(this.fEntryQueue._fValue);
        LRUCache.LRUCacheEntry lRUCacheEntry = this.fEntryQueue._fNext;
        LRUCacheEnumerator.LRUEnumeratorElement lRUEnumeratorElement2 = lRUEnumeratorElement;
        while (lRUCacheEntry != null) {
            lRUEnumeratorElement2 = lRUEnumeratorElement2.fNext = new LRUCacheEnumerator.LRUEnumeratorElement(lRUCacheEntry._fValue);
            lRUCacheEntry = lRUCacheEntry._fNext;
        }
        return new LRUCacheEnumerator(lRUEnumeratorElement);
    }

    public double fillingRatio() {
        return (double)(this.fCurrentSpace + this.fOverflow) * 100.0 / (double)this.fSpaceLimit;
    }

    public Hashtable getEntryTable() {
        return this.fEntryTable;
    }

    public double getLoadFactor() {
        return this.fLoadFactor;
    }

    public int getOverflow() {
        return this.fOverflow;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean makeSpace(int n) {
        int n2 = this.fSpaceLimit;
        if (this.fOverflow == 0 && this.fCurrentSpace + n <= n2) {
            return true;
        }
        int n3 = (int)((1.0 - this.fLoadFactor) * (double)n2);
        n3 = n3 > n ? n3 : n;
        LRUCache.LRUCacheEntry lRUCacheEntry = this.fEntryQueueTail;
        try {
            this.fTimestampsOn = false;
            while (this.fCurrentSpace + n3 > n2 && lRUCacheEntry != null) {
                this.privateRemoveEntry(lRUCacheEntry, false, false);
                lRUCacheEntry = lRUCacheEntry._fPrevious;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fTimestampsOn = true;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fTimestampsOn = true;
            if (this.fCurrentSpace + n <= n2) {
                this.fOverflow = 0;
                return true;
            }
            this.fOverflow = this.fCurrentSpace + n - n2;
            return false;
        }
    }

    protected abstract LRUCache newInstance(int var1, int var2);

    public void printStats() {
        Class<?> clazz;
        int n = 0;
        LRUCache.LRUCacheEntry lRUCacheEntry = this.fEntryQueue;
        while (lRUCacheEntry != null) {
            ++n;
            lRUCacheEntry = lRUCacheEntry._fNext;
        }
        System.out.println("Forward length: " + n);
        int n2 = 0;
        lRUCacheEntry = this.fEntryQueueTail;
        while (lRUCacheEntry != null) {
            ++n2;
            lRUCacheEntry = lRUCacheEntry._fPrevious;
        }
        System.out.println("Backward length: " + n2);
        Enumeration enumeration = this.fEntryTable.keys();
        class Temp {
            public Class fClass;
            public int fCount;
            final /* synthetic */ OverflowingLRUCache this$0;

            public Temp(OverflowingLRUCache overflowingLRUCache, Class clazz) {
                this.this$0 = overflowingLRUCache;
                this.fClass = clazz;
                this.fCount = 1;
            }

            public String toString() {
                return "Class: " + this.fClass + " has " + this.fCount + " entries.";
            }
        }
        HashMap<Object, Temp> hashMap = new HashMap<Object, Temp>();
        while (enumeration.hasMoreElements()) {
            lRUCacheEntry = (LRUCache.LRUCacheEntry)this.fEntryTable.get(enumeration.nextElement());
            clazz = lRUCacheEntry._fValue.getClass();
            Temp temp = (Temp)hashMap.get(clazz);
            if (temp == null) {
                hashMap.put(clazz, new Temp(this, clazz));
                continue;
            }
            ++temp.fCount;
        }
        clazz = hashMap.values().iterator();
        while (clazz.hasNext()) {
            System.out.println(clazz.next());
        }
    }

    protected void privateRemoveEntry(LRUCache.LRUCacheEntry lRUCacheEntry, boolean bl) {
        this.privateRemoveEntry(lRUCacheEntry, bl, true);
    }

    protected void privateRemoveEntry(LRUCache.LRUCacheEntry lRUCacheEntry, boolean bl, boolean bl2) {
        if (!bl) {
            if (bl2) {
                this.fEntryTable.remove(lRUCacheEntry._fKey);
                this.fCurrentSpace -= lRUCacheEntry._fSpace;
            } else {
                if (!this.close(lRUCacheEntry)) {
                    return;
                }
                if (this.fEntryTable.get(lRUCacheEntry._fKey) == null) {
                    return;
                }
                this.fEntryTable.remove(lRUCacheEntry._fKey);
                this.fCurrentSpace -= lRUCacheEntry._fSpace;
            }
        }
        LRUCache.LRUCacheEntry lRUCacheEntry2 = lRUCacheEntry._fPrevious;
        LRUCache.LRUCacheEntry lRUCacheEntry3 = lRUCacheEntry._fNext;
        if (lRUCacheEntry2 == null) {
            this.fEntryQueue = lRUCacheEntry3;
        } else {
            lRUCacheEntry2._fNext = lRUCacheEntry3;
        }
        if (lRUCacheEntry3 == null) {
            this.fEntryQueueTail = lRUCacheEntry2;
        } else {
            lRUCacheEntry3._fPrevious = lRUCacheEntry2;
        }
    }

    public Object put(Object object, Object object2) {
        if (this.fOverflow > 0) {
            this.shrink();
        }
        int n = this.spaceFor(object2);
        LRUCache.LRUCacheEntry lRUCacheEntry = (LRUCache.LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCacheEntry != null) {
            int n2 = lRUCacheEntry._fSpace;
            int n3 = this.fCurrentSpace - n2 + n;
            if (n3 <= this.fSpaceLimit) {
                this.updateTimestamp(lRUCacheEntry);
                lRUCacheEntry._fValue = object2;
                lRUCacheEntry._fSpace = n;
                this.fCurrentSpace = n3;
                this.fOverflow = 0;
                return object2;
            }
            this.privateRemoveEntry(lRUCacheEntry, false, false);
        }
        this.makeSpace(n);
        this.privateAdd(object, object2, n);
        return object2;
    }

    public Object remove(Object object) {
        return this.removeKey(object);
    }

    public void setLoadFactor(double d) throws IllegalArgumentException {
        if (!(d <= 1.0) || !(d > 0.0)) {
            throw new IllegalArgumentException(Messages.cache_invalidLoadFactor);
        }
        this.fLoadFactor = d;
    }

    public void setSpaceLimit(int n) {
        if (n < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - n);
        }
        this.fSpaceLimit = n;
    }

    public boolean shrink() {
        if (this.fOverflow > 0) {
            return this.makeSpace(0);
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRation("OverflowingLRUCache ")) + this.toStringContents();
    }

    protected void updateTimestamp(LRUCache.LRUCacheEntry lRUCacheEntry) {
        if (this.fTimestampsOn) {
            lRUCacheEntry._fTimestamp = this.fTimestampCounter++;
            if (this.fEntryQueue != lRUCacheEntry) {
                this.privateRemoveEntry(lRUCacheEntry, true);
                this.privateAddEntry(lRUCacheEntry, true);
            }
        }
    }
}

