/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.wst.jsdt.internal.codeassist.SelectionEngine;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryField;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceField;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceType;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SelectionRequestor
implements ISelectionRequestor {
    protected NameLookup nameLookup;
    protected Openable openable;
    protected IJavaElement[] elements = JavaElement.NO_ELEMENTS;
    protected int elementIndex = -1;
    protected HandleFactory handleFactory = new HandleFactory();
    private static final char[] js = new char[]{'.', 'j', 's'};

    public SelectionRequestor(NameLookup nameLookup, Openable openable) {
        this.nameLookup = nameLookup;
        this.openable = openable;
    }

    private void acceptBinaryMethod(IType iType, IMethod iMethod, char[] cArray, boolean bl) {
        try {
            if (!bl || ((JavaElement)((Object)iMethod)).getSourceMapper() == null) {
                if (cArray != null) {
                    ResolvedBinaryMethod resolvedBinaryMethod = new ResolvedBinaryMethod((JavaElement)iMethod.getParent(), iMethod.getElementName(), iMethod.getParameterTypes(), new String(cArray));
                    resolvedBinaryMethod.occurrenceCount = iMethod.getOccurrenceCount();
                    iMethod = resolvedBinaryMethod;
                }
                this.addElement(iMethod);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(iMethod.toString());
                    System.out.println(")");
                }
            } else {
                ISourceRange iSourceRange = iMethod.getSourceRange();
                if (iSourceRange.getOffset() != -1 && iSourceRange.getLength() != 0) {
                    if (cArray != null) {
                        ResolvedBinaryMethod resolvedBinaryMethod = new ResolvedBinaryMethod((JavaElement)iMethod.getParent(), iMethod.getElementName(), iMethod.getParameterTypes(), new String(cArray));
                        resolvedBinaryMethod.occurrenceCount = iMethod.getOccurrenceCount();
                        iMethod = resolvedBinaryMethod;
                    }
                    this.addElement(iMethod);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept method(");
                        System.out.print(iMethod.toString());
                        System.out.println(")");
                    }
                } else {
                    this.addElement(iType);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept type(");
                        System.out.print(iType.toString());
                        System.out.println(")");
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void acceptBinaryMethod(IType iType, char[] cArray, char[][] cArray2, char[][] cArray3, String[] stringArray, char[][] cArray4, char[][][] cArray5, char[] cArray6, boolean bl) {
        IMethod iMethod = iType.getMethod(new String(cArray), stringArray);
        if (iMethod.exists()) {
            IMethod[] iMethodArray;
            if (cArray4 != null && cArray4.length != 0 && (iMethodArray = iType.findMethods(iMethod)).length > 1) {
                int n = 0;
                while (n < iMethodArray.length) {
                    if (this.areTypeParametersCompatible(iMethodArray[n], cArray4, cArray5)) {
                        this.acceptBinaryMethod(iType, iMethod, cArray6, bl);
                    }
                    ++n;
                }
                return;
            }
            this.acceptBinaryMethod(iType, iMethod, cArray6, bl);
        }
    }

    public void acceptType(char[] cArray, char[] cArray2, int n, boolean bl, char[] cArray3, int n2, int n3) {
        int n4 = 0;
        int n5 = n & 0x6200;
        switch (n5) {
            case 8192: 
            case 8704: {
                n4 = 16;
                break;
            }
            case 16384: {
                n4 = 8;
                break;
            }
            case 512: {
                n4 = 4;
                break;
            }
            default: {
                n4 = 2;
            }
        }
        IType iType = null;
        if (bl) {
            iType = this.resolveTypeByLocation(cArray, cArray2, n4, n2, n3);
        } else {
            iType = this.resolveType(cArray, cArray2, n4);
            if (iType != null) {
                String string = cArray3 == null ? iType.getKey() : new String(cArray3);
                ResolvedSourceType resolvedSourceType = new ResolvedSourceType((JavaElement)iType.getParent(), iType.getElementName(), string);
                resolvedSourceType.occurrenceCount = iType.getOccurrenceCount();
                iType = resolvedSourceType;
            }
        }
        if (iType != null) {
            this.addElement(iType);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(iType.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptError(CategorizedProblem categorizedProblem) {
    }

    public void acceptField(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, char[] cArray4, int n, int n2) {
        if (bl) {
            IType iType = this.resolveTypeByLocation(cArray, cArray2, 30, n, n2);
            if (iType != null) {
                try {
                    IField[] iFieldArray = iType.getFields();
                    int n3 = 0;
                    while (n3 < iFieldArray.length) {
                        IField iField = iFieldArray[n3];
                        ISourceRange iSourceRange = iField.getNameRange();
                        if (iSourceRange.getOffset() <= n && iSourceRange.getOffset() + iSourceRange.getLength() >= n2 && iField.getElementName().equals(new String(cArray3))) {
                            this.addElement(iFieldArray[n3]);
                            if (SelectionEngine.DEBUG) {
                                System.out.print("SELECTION - accept field(");
                                System.out.print(iField.toString());
                                System.out.println(")");
                            }
                            return;
                        }
                        ++n3;
                    }
                }
                catch (JavaModelException javaModelException) {
                    return;
                }
            }
        } else {
            IField iField;
            IType iType = this.resolveType(cArray, cArray2, 30);
            if (iType != null && (iField = iType.getField(new String(cArray3))).exists()) {
                if (cArray4 != null) {
                    ResolvedSourceField resolvedSourceField = new ResolvedSourceField((JavaElement)iField.getParent(), iField.getElementName(), new String(cArray4));
                    resolvedSourceField.occurrenceCount = iField.getOccurrenceCount();
                    iField = resolvedSourceField;
                }
                this.addElement(iField);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept field(");
                    System.out.print(iField.toString());
                    System.out.println(")");
                }
            }
        }
    }

    public void acceptLocalField(FieldBinding fieldBinding) {
        IField iField;
        IJavaElement iJavaElement;
        Object object;
        if (fieldBinding.declaringClass instanceof ParameterizedTypeBinding) {
            object = (LocalTypeBinding)((ParameterizedTypeBinding)fieldBinding.declaringClass).genericType();
            iJavaElement = this.findLocalElement(((SourceTypeBinding)object).sourceStart());
        } else {
            object = (SourceTypeBinding)fieldBinding.declaringClass;
            iJavaElement = this.findLocalElement(((SourceTypeBinding)object).sourceStart());
        }
        if (iJavaElement != null && iJavaElement.getElementType() == 7 && (iField = (object = (IType)iJavaElement).getField(new String(fieldBinding.name))).exists()) {
            char[] cArray = fieldBinding.computeUniqueKey();
            if (iField.isBinary()) {
                ResolvedBinaryField resolvedBinaryField = new ResolvedBinaryField((JavaElement)iField.getParent(), iField.getElementName(), new String(cArray));
                resolvedBinaryField.occurrenceCount = iField.getOccurrenceCount();
                iField = resolvedBinaryField;
            } else {
                ResolvedSourceField resolvedSourceField = new ResolvedSourceField((JavaElement)iField.getParent(), iField.getElementName(), new String(cArray));
                resolvedSourceField.occurrenceCount = iField.getOccurrenceCount();
                iField = resolvedSourceField;
            }
            this.addElement(iField);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept field(");
                System.out.print(iField.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalMethod(MethodBinding methodBinding) {
        IJavaElement iJavaElement = this.findLocalElement(methodBinding.sourceStart());
        if (iJavaElement != null) {
            if (iJavaElement.getElementType() == 9) {
                IMethod iMethod = (IMethod)iJavaElement;
                char[] cArray = methodBinding.computeUniqueKey();
                if (iMethod.isBinary()) {
                    ResolvedBinaryMethod resolvedBinaryMethod = new ResolvedBinaryMethod((JavaElement)iJavaElement.getParent(), iMethod.getElementName(), iMethod.getParameterTypes(), new String(cArray));
                    resolvedBinaryMethod.occurrenceCount = iMethod.getOccurrenceCount();
                    iJavaElement = resolvedBinaryMethod;
                } else {
                    ResolvedSourceMethod resolvedSourceMethod = new ResolvedSourceMethod((JavaElement)iJavaElement.getParent(), iMethod.getElementName(), iMethod.getParameterTypes(), new String(cArray));
                    resolvedSourceMethod.occurrenceCount = iMethod.getOccurrenceCount();
                    iJavaElement = resolvedSourceMethod;
                }
                this.addElement(iJavaElement);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(iJavaElement.toString());
                    System.out.println(")");
                }
            } else if (methodBinding.selector == TypeConstants.INIT && iJavaElement.getElementType() == 7) {
                iJavaElement = ((JavaElement)iJavaElement).resolved(methodBinding.declaringClass);
                this.addElement(iJavaElement);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept type(");
                    System.out.print(iJavaElement.toString());
                    System.out.println(")");
                }
            }
        }
    }

    public void acceptLocalType(TypeBinding typeBinding) {
        IJavaElement iJavaElement = null;
        if (typeBinding instanceof ParameterizedTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)((ParameterizedTypeBinding)typeBinding).genericType();
            iJavaElement = this.findLocalElement(localTypeBinding.sourceStart());
        } else if (typeBinding instanceof SourceTypeBinding) {
            iJavaElement = this.findLocalElement(((SourceTypeBinding)typeBinding).sourceStart());
        }
        if (iJavaElement != null && iJavaElement.getElementType() == 7) {
            iJavaElement = ((JavaElement)iJavaElement).resolved(typeBinding);
            this.addElement(iJavaElement);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(iJavaElement.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalTypeParameter(TypeVariableBinding typeVariableBinding) {
        ITypeParameter iTypeParameter;
        IJavaElement iJavaElement;
        Object object;
        if (typeVariableBinding.declaringElement instanceof ParameterizedTypeBinding) {
            object = (LocalTypeBinding)((ParameterizedTypeBinding)typeVariableBinding.declaringElement).genericType();
            iJavaElement = this.findLocalElement(((SourceTypeBinding)object).sourceStart());
        } else {
            object = (SourceTypeBinding)typeVariableBinding.declaringElement;
            iJavaElement = this.findLocalElement(((SourceTypeBinding)object).sourceStart());
        }
        if (iJavaElement != null && iJavaElement.getElementType() == 7 && (iTypeParameter = (object = (IType)iJavaElement).getTypeParameter(new String(typeVariableBinding.sourceName))).exists()) {
            this.addElement(iTypeParameter);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type parameter(");
                System.out.print(iTypeParameter.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalMethodTypeParameter(TypeVariableBinding typeVariableBinding) {
        IMethod iMethod;
        ITypeParameter iTypeParameter;
        MethodBinding methodBinding = (MethodBinding)typeVariableBinding.declaringElement;
        IJavaElement iJavaElement = this.findLocalElement(methodBinding.sourceStart());
        if (iJavaElement != null && iJavaElement.getElementType() == 9 && (iTypeParameter = (iMethod = (IMethod)iJavaElement).getTypeParameter(new String(typeVariableBinding.sourceName))).exists()) {
            this.addElement(iTypeParameter);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type parameter(");
                System.out.print(iTypeParameter.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalVariable(LocalVariableBinding localVariableBinding) {
        Object object;
        Object object2;
        Object object3;
        LocalDeclaration localDeclaration = localVariableBinding.declaration;
        if (localDeclaration == null) {
            return;
        }
        IJavaElement iJavaElement = null;
        if (localVariableBinding.declaringScope instanceof CompilationUnitScope) {
            object3 = (CompilationUnitScope)localVariableBinding.declaringScope;
            object2 = CharOperation.concatWith(((CompilationUnitScope)object3).currentPackageName, '.');
            iJavaElement = this.resolveCompilationUnit((char[])object2, (char[])(object = ((CompilationUnitScope)object3).referenceContext.compilationUnitBinding.qualifiedSourceName()));
            if (iJavaElement == null) {
                iJavaElement = this.resolveCompilationUnit(new char[0], (char[])object);
            }
        } else {
            iJavaElement = this.findLocalElement(localDeclaration.sourceStart);
        }
        object3 = null;
        if (iJavaElement != null) {
            object2 = new String(localDeclaration.name);
            if (iJavaElement instanceof SourceField) {
                object = (SourceField)iJavaElement;
                if (((SourceField)object).name.equals(object2)) {
                    iJavaElement = ((JavaElement)object).getParent();
                }
            }
            object3 = new LocalVariable((JavaElement)iJavaElement, (String)object2, localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd, localDeclaration.sourceStart, localDeclaration.sourceEnd, Util.typeSignature(localDeclaration.type));
        }
        if (object3 != null) {
            this.addElement((IJavaElement)object3);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept local variable(");
                System.out.print(object3.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptMethod(char[] cArray, char[] cArray2, String string, char[] cArray3, char[][] cArray4, char[][] cArray5, String[] stringArray, char[][] cArray6, char[][][] cArray7, boolean bl, boolean bl2, char[] cArray8, int n, int n2) {
        IJavaElement iJavaElement;
        IJavaElement[] iJavaElementArray = this.elements;
        int n3 = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        boolean bl3 = SelectionRequestor.isFileName(cArray2);
        if (bl2) {
            iJavaElement = this.resolveTypeByLocation(cArray, cArray2, 30, n, n2);
            this.acceptMethodDeclaration((IType)iJavaElement, cArray3, n, n2);
        } else {
            iJavaElement = !bl3 ? this.resolveType(cArray, cArray2, 30) : this.resolveCompilationUnit(cArray, cArray2);
            this.acceptSourceMethod(iJavaElement, cArray3, cArray4, cArray5, stringArray, cArray6, cArray7, cArray8);
        }
        if (n3 > -1) {
            int n4 = this.elementIndex + n3 + 2;
            if (n4 > this.elements.length) {
                this.elements = new IJavaElement[n4 * 2 + 1];
                System.arraycopy(this.elements, 0, this.elements, 0, this.elementIndex + 1);
            }
            System.arraycopy(iJavaElementArray, 0, this.elements, this.elementIndex + 1, n3 + 1);
            this.elementIndex += n3 + 1;
        }
    }

    private static boolean isFileName(char[] cArray) {
        return CharOperation.endsWith(cArray, js) && CharOperation.contains('/', cArray);
    }

    public void acceptPackage(char[] cArray) {
        IPackageFragment[] iPackageFragmentArray = this.nameLookup.findPackageFragments(new String(cArray), false);
        if (iPackageFragmentArray != null) {
            int n = 0;
            int n2 = iPackageFragmentArray.length;
            while (n < n2) {
                this.addElement(iPackageFragmentArray[n]);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept package(");
                    System.out.print(iPackageFragmentArray[n].toString());
                    System.out.println(")");
                }
                ++n;
            }
        }
    }

    protected void acceptSourceMethod(IJavaElement iJavaElement, char[] cArray, char[][] cArray2, char[][] cArray3, String[] stringArray, char[][] cArray4, char[][][] cArray5, char[] cArray6) {
        String string = new String(cArray);
        IMethod[] iMethodArray = null;
        try {
            if (iJavaElement instanceof IType) {
                iMethodArray = ((IType)iJavaElement).getMethods();
            } else if (iJavaElement instanceof ICompilationUnit) {
                iMethodArray = ((ICompilationUnit)iJavaElement).getMethods();
            } else if (iJavaElement instanceof IClassFile) {
                iMethodArray = ((IClassFile)iJavaElement).getMethods();
            }
            if (iMethodArray != null) {
                int n = 0;
                while (n < iMethodArray.length) {
                    if (iMethodArray[n].getElementName().equals(string)) {
                        IMethod iMethod = iMethodArray[n];
                        if (cArray6 != null) {
                            ResolvedSourceMethod resolvedSourceMethod = new ResolvedSourceMethod((JavaElement)iMethod.getParent(), iMethod.getElementName(), iMethod.getParameterTypes(), new String(cArray6));
                            resolvedSourceMethod.occurrenceCount = iMethod.getOccurrenceCount();
                            iMethod = resolvedSourceMethod;
                        }
                        this.addElement(iMethod);
                    }
                    ++n;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        if (this.elementIndex == -1) {
            this.addElement(iJavaElement);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(iJavaElement.toString());
                System.out.println(")");
            }
            return;
        }
        if (this.elementIndex == 0) {
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(this.elements[0].toString());
                System.out.println(")");
            }
            return;
        }
        IJavaElement[] iJavaElementArray = this.elements;
        int n = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        int n2 = 0;
        while (n2 <= n) {
            IMethod iMethod = (IMethod)iJavaElementArray[n2];
            String[] stringArray2 = iMethod.getParameterTypes();
            boolean bl = true;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                char[] cArray7;
                String string2 = Signature.getSimpleName(Signature.toString(Signature.getTypeErasure(stringArray2[n3])));
                if (!string2.equals(new String(cArray7 = CharOperation.lastSegment(cArray3[n3], '.')))) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl && !this.areTypeParametersCompatible(iMethod, cArray4, cArray5)) {
                bl = false;
            }
            if (bl) {
                this.addElement(iMethod);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(iMethod.toString());
                    System.out.println(")");
                }
            }
            ++n2;
        }
    }

    protected void acceptMethodDeclaration(IType iType, char[] cArray, int n, int n2) {
        String string = new String(cArray);
        IMethod[] iMethodArray = null;
        try {
            if (iType != null) {
                iMethodArray = iType.getMethods();
            } else if (this.openable instanceof CompilationUnit) {
                iMethodArray = ((CompilationUnit)this.openable).getMethods();
            } else if (this.openable instanceof ClassFile) {
                iMethodArray = ((ClassFile)this.openable).getMethods();
            }
            int n3 = 0;
            while (n3 < iMethodArray.length) {
                ISourceRange iSourceRange = iMethodArray[n3].getNameRange();
                if (iSourceRange.getOffset() <= n && iSourceRange.getOffset() + iSourceRange.getLength() >= n2 && iMethodArray[n3].getElementName().equals(string)) {
                    this.addElement(iMethodArray[n3]);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept method(");
                        System.out.print(this.elements[0].toString());
                        System.out.println(")");
                    }
                    return;
                }
                ++n3;
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        this.addElement(iType);
        if (SelectionEngine.DEBUG) {
            System.out.print("SELECTION - accept type(");
            System.out.print(iType.toString());
            System.out.println(")");
        }
    }

    public void acceptTypeParameter(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, int n, int n2) {
        IType iType = bl ? this.resolveTypeByLocation(cArray, cArray2, 30, n, n2) : this.resolveType(cArray, cArray2, 30);
        if (iType != null) {
            ITypeParameter iTypeParameter = iType.getTypeParameter(new String(cArray3));
            if (iTypeParameter == null) {
                this.addElement(iType);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept type(");
                    System.out.print(iType.toString());
                    System.out.println(")");
                }
            } else {
                this.addElement(iTypeParameter);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept type parameter(");
                    System.out.print(iTypeParameter.toString());
                    System.out.println(")");
                }
            }
        }
    }

    public void acceptMethodTypeParameter(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, char[] cArray4, boolean bl, int n3, int n4) {
        IType iType = this.resolveTypeByLocation(cArray, cArray2, 30, n, n2);
        if (iType != null) {
            IMethod iMethod = null;
            String string = new String(cArray3);
            IMethod[] iMethodArray = null;
            try {
                iMethodArray = iType.getMethods();
                int n5 = 0;
                while (n5 < iMethodArray.length) {
                    ISourceRange iSourceRange = iMethodArray[n5].getNameRange();
                    if (iSourceRange.getOffset() >= n && iSourceRange.getOffset() + iSourceRange.getLength() <= n2 && iMethodArray[n5].getElementName().equals(string)) {
                        iMethod = iMethodArray[n5];
                        break;
                    }
                    ++n5;
                }
            }
            catch (JavaModelException javaModelException) {}
            if (iMethod == null) {
                this.addElement(iType);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept type(");
                    System.out.print(iType.toString());
                    System.out.println(")");
                }
            } else {
                ITypeParameter iTypeParameter = iMethod.getTypeParameter(new String(cArray4));
                if (iTypeParameter == null) {
                    this.addElement(iMethod);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept method(");
                        System.out.print(iMethod.toString());
                        System.out.println(")");
                    }
                } else {
                    this.addElement(iTypeParameter);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept method type parameter(");
                        System.out.print(iTypeParameter.toString());
                        System.out.println(")");
                    }
                }
            }
        }
    }

    protected void addElement(IJavaElement iJavaElement) {
        int n = this.elementIndex + 1;
        if (n == this.elements.length) {
            this.elements = new IJavaElement[n * 2 + 1];
            System.arraycopy(this.elements, 0, this.elements, 0, n);
        }
        this.elements[++this.elementIndex] = iJavaElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areTypeParametersCompatible(IMethod iMethod, char[][] cArray, char[][][] cArray2) {
        try {
            int n;
            ITypeParameter[] iTypeParameterArray = iMethod.getTypeParameters();
            int n2 = iTypeParameterArray == null ? 0 : iTypeParameterArray.length;
            int n3 = n = cArray == null ? 0 : cArray.length;
            if (n2 != n) {
                return false;
            }
            int n4 = 0;
            block2: while (true) {
                int n5;
                if (n4 >= n2) {
                    return true;
                }
                ITypeParameter iTypeParameter = iTypeParameterArray[n4];
                String string = iTypeParameter.getElementName();
                if (!string.equals(new String(cArray[n4]))) {
                    return false;
                }
                String[] stringArray = iTypeParameter.getBounds();
                int n6 = n5 = cArray2[n4] == null ? 0 : cArray2[n4].length;
                if (stringArray.length != n5) {
                    return false;
                }
                int n7 = 0;
                while (true) {
                    if (n7 >= n5) {
                        ++n4;
                        continue block2;
                    }
                    String string2 = Signature.getSimpleName(stringArray[n7]);
                    int n8 = string2.indexOf(60);
                    if (n8 != -1) {
                        string2 = string2.substring(0, n8);
                    }
                    if (!string2.equals(new String(cArray2[n4][n7]))) {
                        return false;
                    }
                    ++n7;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected IJavaElement findLocalElement(int n) {
        IJavaElement iJavaElement = null;
        if (this.openable instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)((Object)this.openable);
            try {
                iJavaElement = iCompilationUnit.getElementAt(n);
            }
            catch (JavaModelException javaModelException) {}
        } else if (this.openable instanceof ClassFile) {
            ClassFile classFile = (ClassFile)this.openable;
            try {
                iJavaElement = classFile.getElementAtConsideringSibling(n);
            }
            catch (JavaModelException javaModelException) {}
        }
        return iJavaElement;
    }

    public IJavaElement[] getElements() {
        int n = this.elementIndex + 1;
        if (this.elements.length != n) {
            this.elements = new IJavaElement[n];
            System.arraycopy(this.elements, 0, this.elements, 0, n);
        }
        return this.elements;
    }

    protected IType resolveType(char[] cArray, char[] cArray2, int n) {
        int n2;
        IPackageFragment[] iPackageFragmentArray;
        IJavaElement iJavaElement = null;
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isWorkingCopy()) {
            iPackageFragmentArray = (IPackageFragment[])this.openable;
            try {
                if ((cArray == null || cArray.length == 0) && iPackageFragmentArray.getPackageDeclarations().length == 0 || cArray != null && cArray.length != 0 && iPackageFragmentArray.getPackageDeclaration(new String(cArray)).exists()) {
                    char[][] cArray3 = CharOperation.splitOn('.', cArray2);
                    if (cArray3.length > 0) {
                        iJavaElement = iPackageFragmentArray.getType(new String(cArray3[0]));
                        n2 = 1;
                        int n3 = cArray3.length;
                        while (n2 < n3) {
                            iJavaElement = iJavaElement.getType(new String(cArray3[n2]));
                            ++n2;
                        }
                    }
                    if (iJavaElement != null && !iJavaElement.exists()) {
                        iJavaElement = null;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (iJavaElement == null) {
            iPackageFragmentArray = this.nameLookup.findPackageFragments(cArray == null || cArray.length == 0 ? "" : new String(cArray), false);
            int n4 = 0;
            n2 = iPackageFragmentArray == null ? 0 : iPackageFragmentArray.length;
            while (n4 < n2) {
                iJavaElement = this.nameLookup.findType(new String(cArray2), iPackageFragmentArray[n4], false, n, true);
                if (iJavaElement != null) break;
                ++n4;
            }
            if (iJavaElement == null) {
                String string = "";
                if (cArray != null) {
                    string = new String(cArray);
                }
                if (this.openable != null && this.openable.getParent().getElementName().equals(string)) {
                    String string2 = new String(cArray2);
                    string2 = string2.replace('.', '$');
                    IType[] iTypeArray = null;
                    try {
                        ArrayList arrayList = this.openable.getChildrenOfType(7);
                        iTypeArray = new IType[arrayList.size()];
                        arrayList.toArray(iTypeArray);
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                    int n5 = 0;
                    while (n5 < iTypeArray.length) {
                        if (iTypeArray[n5].getTypeQualifiedName().equals(string2)) {
                            return iTypeArray[n5];
                        }
                        ++n5;
                    }
                }
            }
        }
        return iJavaElement;
    }

    protected IJavaElement resolveCompilationUnit(char[] cArray, char[] cArray2) {
        IJavaElement iJavaElement = null;
        String string = new String(cArray2);
        Path path = new Path(string);
        String string2 = path.lastSegment();
        if ((this.openable instanceof CompilationUnit || this.openable instanceof ClassFile) && (string2.equals(this.openable.getElementName()) && new String(cArray).equals(this.openable.getParent().getElementName()) || string.startsWith("http:") && string.equals(this.openable.getElementName()))) {
            return this.openable;
        }
        IPackageFragment[] iPackageFragmentArray = this.nameLookup.findPackageFragments(cArray == null || cArray.length == 0 ? "" : new String(cArray), false);
        int n = 0;
        int n2 = iPackageFragmentArray == null ? 0 : iPackageFragmentArray.length;
        while (n < n2) {
            ICompilationUnit iCompilationUnit = iPackageFragmentArray[n].getCompilationUnit(string2);
            if (iCompilationUnit.exists()) {
                return iCompilationUnit;
            }
            IClassFile iClassFile = iPackageFragmentArray[n].getClassFile(string2);
            if (iClassFile.exists()) {
                return iClassFile;
            }
            ++n;
        }
        return iJavaElement;
    }

    protected IType resolveTypeByLocation(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        IType[] iTypeArray;
        Object object;
        Object object2;
        IType iType = null;
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isOpen()) {
            object2 = (CompilationUnit)this.openable;
            try {
                if ((cArray == null || cArray.length == 0) && ((CompilationUnit)object2).getPackageDeclarations().length == 0 || cArray != null && cArray.length != 0 && ((CompilationUnit)object2).getPackageDeclaration(new String(cArray)).exists()) {
                    object = CharOperation.splitOn('.', cArray2);
                    if (((char[][])object).length > 0) {
                        iTypeArray = ((CompilationUnit)object2).getTypes();
                        int n4 = 0;
                        int n5 = 0;
                        while (n4 < iTypeArray.length) {
                            ISourceRange iSourceRange = iTypeArray[n4].getSourceRange();
                            if (iSourceRange.getOffset() <= n2 && iSourceRange.getOffset() + iSourceRange.getLength() >= n3 && iTypeArray[n4].getElementName().equals(new String((char[])object[n5]))) {
                                if (n5 == ((Object)object).length - 1) {
                                    iType = iTypeArray[n4];
                                    break;
                                }
                                iTypeArray = iTypeArray[n4].getTypes();
                                n4 = 0;
                                ++n5;
                                continue;
                            }
                            ++n4;
                        }
                    }
                    if (iType != null && !iType.exists()) {
                        iType = null;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (iType == null && cArray2 != null && (iType = this.nameLookup.findType(new String(cArray2), false, n)) == null) {
            object2 = "";
            if (cArray != null) {
                object2 = new String(cArray);
            }
            if (this.openable != null && this.openable.getParent().getElementName().equals(object2)) {
                object = new String(cArray2);
                object = object.replace('.', '$');
                iTypeArray = null;
                try {
                    ArrayList arrayList = this.openable.getChildrenOfType(7);
                    iTypeArray = new IType[arrayList.size()];
                    arrayList.toArray(iTypeArray);
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                int n6 = 0;
                while (n6 < iTypeArray.length) {
                    if (iTypeArray[n6].getTypeQualifiedName().equals(object)) {
                        return iTypeArray[n6];
                    }
                    ++n6;
                }
            }
        }
        return iType;
    }
}

