/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.util.ReferenceInfoAdapter;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceMapper
extends ReferenceInfoAdapter
implements ISourceElementRequestor,
SuffixConstants {
    public static boolean VERBOSE = false;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return Util.isJavaLikeFileName(string);
        }
    };
    protected ArrayList rootPaths;
    protected BinaryType binaryType;
    protected IPath sourcePath;
    protected String rootPath = "";
    protected HashMap parameterNames;
    protected HashMap sourceRanges;
    protected HashMap categories;
    public static final SourceRange UNKNOWN_RANGE = new SourceRange(-1, 0);
    protected int[] memberDeclarationStart;
    protected SourceRange[] memberNameRange;
    protected String[] memberName;
    protected char[][][] methodParameterNames;
    protected char[][][] methodParameterTypes;
    protected IJavaElement searchedElement;
    private HashMap importsTable;
    private HashMap importsCounterTable;
    IType[] types;
    int[] typeDeclarationStarts;
    SourceRange[] typeNameRanges;
    int[] typeModifiers;
    int typeDepth;
    int anonymousCounter;
    int anonymousClassName;
    String encoding;
    Map options;
    private boolean areRootPathsComputed = false;

    public SourceMapper() {
    }

    public SourceMapper(IPath iPath, String string, Map map) {
        this.options = map;
        try {
            this.encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {}
        if (string != null) {
            this.rootPaths = new ArrayList();
            this.rootPaths.add(string);
        }
        this.sourcePath = iPath;
        this.sourceRanges = new HashMap();
        this.parameterNames = new HashMap();
        this.importsTable = new HashMap();
        this.importsCounterTable = new HashMap();
    }

    public void acceptImport(int n, int n2, char[][] cArray, boolean bl, int n3) {
        int n4;
        Object object = (char[][])this.importsTable.get(this.binaryType);
        if (object == null) {
            object = new char[5][];
            n4 = 0;
        } else {
            n4 = (Integer)this.importsCounterTable.get(this.binaryType);
        }
        if (((char[][])object).length == n4) {
            Object object2 = object;
            char[][] cArrayArray = new char[n4 * 2][];
            object = cArrayArray;
            System.arraycopy(object2, 0, cArrayArray, 0, n4);
        }
        char[] cArray2 = CharOperation.concatWith(cArray, '.');
        if (bl) {
            int n5 = cArray2.length;
            char[] cArray3 = cArray2;
            cArray2 = new char[n5 + 2];
            System.arraycopy(cArray3, 0, cArray2, 0, n5);
            cArray2[n5] = 46;
            cArray2[n5 + 1] = 42;
        }
        object[n4++] = cArray2;
        this.importsTable.put(this.binaryType, object);
        this.importsCounterTable.put(this.binaryType, new Integer(n4));
    }

    public void acceptLineSeparatorPositions(int[] nArray) {
    }

    public void acceptPackage(int n, int n2, char[] cArray) {
    }

    public void acceptProblem(CategorizedProblem categorizedProblem) {
    }

    private void addCategories(IJavaElement iJavaElement, char[][] cArray) {
        if (cArray == null) {
            return;
        }
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        this.categories.put(iJavaElement, CharOperation.toStrings(cArray));
    }

    public void close() {
        this.sourceRanges = null;
        this.parameterNames = null;
    }

    private String[] convertTypeNamesToSigs(char[][] cArray) {
        if (cArray == null) {
            return CharOperation.NO_STRINGS;
        }
        int n = cArray.length;
        if (n == 0) {
            return CharOperation.NO_STRINGS;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            char[] cArray2 = Signature.createCharArrayTypeSignature(cArray[n2], false);
            StringBuffer stringBuffer = null;
            int n3 = 0;
            int n4 = -1;
            int n5 = cArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                switch (cArray2[n6]) {
                    case 'Q': {
                        if (stringBuffer != null) {
                            stringBuffer.append(cArray2, n3, n6 - n3);
                        }
                        n3 = n6;
                        break;
                    }
                    case '.': {
                        n4 = n6;
                        break;
                    }
                    case ';': 
                    case '<': {
                        if (n4 <= n3) break;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer().append(cArray2, 0, n3);
                        }
                        stringBuffer.append('Q');
                        stringBuffer.append(cArray2, n4 + 1, n6 - n4 - 1);
                        n3 = n6;
                    }
                }
                ++n6;
            }
            if (stringBuffer == null) {
                stringArray[n2] = new String(cArray2);
            } else {
                stringBuffer.append(cArray2, n3, n5 - n3);
                stringArray[n2] = stringBuffer.toString();
            }
            ++n2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void computeAllRootPaths(IType iType) {
        int n;
        Object object;
        Object object2;
        long l;
        HashSet<Object> hashSet;
        block48: {
            block47: {
                Object object3;
                boolean bl;
                HashSet<String> hashSet2;
                block50: {
                    ZipFile zipFile;
                    block46: {
                        IPackageFragmentRoot iPackageFragmentRoot;
                        block49: {
                            if (this.areRootPathsComputed) {
                                return;
                            }
                            iPackageFragmentRoot = (IPackageFragmentRoot)iType.getPackageFragment().getParent();
                            hashSet = new HashSet<Object>();
                            l = 0L;
                            if (VERBOSE) {
                                System.out.println("compute all root paths for " + iPackageFragmentRoot.getElementName());
                                l = System.currentTimeMillis();
                            }
                            hashSet2 = new HashSet<String>();
                            bl = false;
                            if (!iPackageFragmentRoot.isArchive()) break block49;
                            object3 = (JarPackageFragmentRoot)iPackageFragmentRoot;
                            object2 = ((JavaElement)object3).getJavaProject();
                            object = null;
                            String string = null;
                            JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
                            zipFile = null;
                            try {
                                try {
                                    zipFile = javaModelManager.getZipFile(((JarPackageFragmentRoot)object3).getPath());
                                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                                    while (enumeration.hasMoreElements()) {
                                        ZipEntry zipEntry = enumeration.nextElement();
                                        String string2 = zipEntry.getName();
                                        if (zipEntry.isDirectory()) continue;
                                        int n2 = string2.indexOf(47);
                                        if (n2 != -1 && org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string2)) {
                                            IStatus iStatus;
                                            String string3 = string2.substring(0, n2);
                                            if (hashSet2.contains(string3)) continue;
                                            if (object == null) {
                                                object = object2.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
                                                string = object2.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                                            }
                                            if (!(iStatus = JavaConventions.validatePackageName(string3, (String)object, string)).isOK() && iStatus.getSeverity() != 2) continue;
                                            hashSet2.add(string3);
                                            continue;
                                        }
                                        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string2)) continue;
                                        bl = true;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            catch (Throwable throwable) {
                                Object var20_35 = null;
                                javaModelManager.closeZipFile(zipFile);
                                throw throwable;
                            }
                            {
                                Object var20_36 = null;
                                javaModelManager.closeZipFile(zipFile);
                                break block46;
                            }
                        }
                        object3 = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iPackageFragmentRoot.getPath(), true);
                        if (object3 instanceof IResource) {
                            object2 = (IResource)object3;
                            if (object2 instanceof IContainer) {
                                try {
                                    object = ((IContainer)object2).members();
                                    int n3 = 0;
                                    int n4 = ((IResource[])object).length;
                                    while (n3 < n4) {
                                        zipFile = object[n3];
                                        if (zipFile.getType() == 2) {
                                            hashSet2.add(zipFile.getName());
                                        } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(zipFile.getName())) {
                                            bl = true;
                                        }
                                        ++n3;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                        } else if (object3 instanceof File && ((File)(object2 = (File)object3)).isDirectory()) {
                            object = ((File)object2).listFiles();
                            int n5 = 0;
                            int n6 = ((IResource[])object).length;
                            while (n5 < n6) {
                                zipFile = object[n5];
                                if (((File)((Object)zipFile)).isDirectory()) {
                                    hashSet2.add(((File)((Object)zipFile)).getName());
                                } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(((File)((Object)zipFile)).getName())) {
                                    bl = true;
                                }
                                ++n5;
                            }
                        }
                    }
                    if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block50;
                    object3 = JavaModelManager.getJavaModelManager();
                    object2 = null;
                    try {
                        try {
                            object2 = ((JavaModelManager)object3).getZipFile(this.sourcePath);
                            object = ((ZipFile)object2).entries();
                            while (object.hasMoreElements()) {
                                String string;
                                ZipEntry zipEntry = (ZipEntry)object.nextElement();
                                if (zipEntry.isDirectory() || !Util.isJavaLikeFileName(string = zipEntry.getName())) continue;
                                zipFile = new Path(string);
                                int n7 = zipFile.segmentCount();
                                if (n7 > 1) {
                                    int n8 = 0;
                                    int n9 = zipFile.segmentCount() - 1;
                                    while (n8 < n9) {
                                        if (hashSet2.contains(zipFile.segment(n8))) {
                                            hashSet.add(zipFile.uptoSegment(n8));
                                        }
                                        if (n8 == n9 - 1 && bl) {
                                            hashSet.add(zipFile.uptoSegment(n9));
                                        }
                                        ++n8;
                                    }
                                    continue;
                                }
                                if (!bl) continue;
                                hashSet.add(new Path(""));
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    catch (Throwable throwable) {
                        Object var17_29 = null;
                        ((JavaModelManager)object3).closeZipFile((ZipFile)object2);
                        throw throwable;
                    }
                    {
                        Object var17_30 = null;
                        ((JavaModelManager)object3).closeZipFile((ZipFile)object2);
                        break block47;
                    }
                }
                object3 = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
                if (object3 instanceof IResource) {
                    if (object3 instanceof IContainer) {
                        this.computeRootPath((IContainer)object3, hashSet2, bl, hashSet);
                    }
                } else if (object3 instanceof File && ((File)(object2 = (File)object3)).isDirectory()) {
                    this.computeRootPath((File)object2, (HashSet)hashSet2, bl, (Set)hashSet);
                }
            }
            n = hashSet.size();
            if (this.rootPaths != null) {
                object2 = this.rootPaths.iterator();
                while (true) {
                    if (!object2.hasNext()) {
                        this.rootPaths.clear();
                        break block48;
                    }
                    hashSet.add(new Path((String)object2.next()));
                }
            }
            this.rootPaths = new ArrayList(n);
        }
        n = hashSet.size();
        if (n > 0) {
            object2 = new ArrayList(hashSet);
            if (n > 1) {
                Collections.sort(object2, new Comparator(){

                    public int compare(Object object, Object object2) {
                        IPath iPath = (IPath)object;
                        IPath iPath2 = (IPath)object2;
                        return iPath.segmentCount() - iPath2.segmentCount();
                    }
                });
            }
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                IPath iPath = (IPath)object.next();
                this.rootPaths.add(iPath.toString());
            }
        }
        this.areRootPathsComputed = true;
        if (VERBOSE) {
            System.out.println("Spent " + (System.currentTimeMillis() - l) + "ms");
            System.out.println("Found " + n + " root paths");
            int n10 = 0;
            object = this.rootPaths.iterator();
            while (object.hasNext()) {
                System.out.println("root[" + n10 + "]=" + (String)object.next());
                ++n10;
            }
        }
    }

    private void computeRootPath(File file, HashSet hashSet, boolean bl, Set set) {
        File[] fileArray = file.listFiles();
        boolean bl2 = false;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            IPath iPath;
            File file2;
            File file3 = fileArray[n];
            if (file3.isDirectory()) {
                bl2 = true;
                if (hashSet.contains(file3.getName())) {
                    file2 = new Path(file3.getParentFile().getPath());
                    iPath = file2.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                    set.add(iPath);
                    break;
                }
                this.computeRootPath(file3, hashSet, bl, set);
            } else if (n == n2 - 1 && !bl2 && bl && (file2 = file3.getParentFile()).list(FILENAME_FILTER).length != 0) {
                iPath = new Path(file2.getPath());
                IPath iPath2 = iPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                set.add(iPath2);
            }
            ++n;
        }
    }

    private void computeRootPath(IContainer iContainer, HashSet hashSet, boolean bl, Set set) {
        try {
            IResource[] iResourceArray = iContainer.members();
            boolean bl2 = false;
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                IResource iResource = iResourceArray[n];
                if (iResource.getType() == 2) {
                    bl2 = true;
                    if (hashSet.contains(iResource.getName())) {
                        IPath iPath = iContainer.getFullPath();
                        IPath iPath2 = iPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        set.add(iPath2);
                        break;
                    }
                    this.computeRootPath((IContainer)((IFolder)iResource), hashSet, bl, set);
                }
                if (n == n2 - 1 && !bl2 && bl) {
                    boolean bl3 = false;
                    int n3 = 0;
                    while (n3 < n2) {
                        if (Util.isJavaLikeFileName(iResourceArray[n].getName())) {
                            bl3 = true;
                            break;
                        }
                        ++n3;
                    }
                    if (bl3) {
                        IPath iPath = iContainer.getFullPath();
                        IPath iPath3 = iPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        set.add(iPath3);
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        ++this.typeDepth;
        if (this.typeDepth == this.types.length) {
            this.types = new IType[this.typeDepth * 2];
            System.arraycopy(this.types, 0, this.types, 0, this.typeDepth);
            this.typeNameRanges = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.typeNameRanges, 0, this.typeNameRanges, 0, this.typeDepth);
            this.typeDeclarationStarts = new int[this.typeDepth * 2];
            System.arraycopy(this.typeDeclarationStarts, 0, this.typeDeclarationStarts, 0, this.typeDepth);
            this.memberName = new String[this.typeDepth * 2];
            System.arraycopy(this.memberName, 0, this.memberName, 0, this.typeDepth);
            this.memberDeclarationStart = new int[this.typeDepth * 2];
            System.arraycopy(this.memberDeclarationStart, 0, this.memberDeclarationStart, 0, this.typeDepth);
            this.memberNameRange = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.memberNameRange, 0, this.memberNameRange, 0, this.typeDepth);
            char[][][] cArrayArray = new char[this.typeDepth * 2][][];
            this.methodParameterTypes = cArrayArray;
            System.arraycopy(this.methodParameterTypes, 0, cArrayArray, 0, this.typeDepth);
            char[][][] cArrayArray2 = new char[this.typeDepth * 2][][];
            this.methodParameterNames = cArrayArray2;
            System.arraycopy(this.methodParameterNames, 0, cArrayArray2, 0, this.typeDepth);
            this.typeModifiers = new int[this.typeDepth * 2];
            System.arraycopy(this.typeModifiers, 0, this.typeModifiers, 0, this.typeDepth);
        }
        if (typeInfo.name.length == 0) {
            ++this.anonymousCounter;
            this.types[this.typeDepth] = this.anonymousCounter == this.anonymousClassName ? this.getType(this.binaryType.getElementName()) : this.getType(new String(typeInfo.name));
        } else {
            this.types[this.typeDepth] = this.getType(new String(typeInfo.name));
        }
        this.typeNameRanges[this.typeDepth] = new SourceRange(typeInfo.nameSourceStart, typeInfo.nameSourceEnd - typeInfo.nameSourceStart + 1);
        this.typeDeclarationStarts[this.typeDepth] = typeInfo.declarationStart;
        IType iType = this.types[this.typeDepth];
        if (typeInfo.typeParameters != null) {
            int n = 0;
            int n2 = typeInfo.typeParameters.length;
            while (n < n2) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[n];
                ITypeParameter iTypeParameter = iType.getTypeParameter(new String(typeParameterInfo.name));
                this.setSourceRange(iTypeParameter, new SourceRange(typeParameterInfo.declarationStart, typeParameterInfo.declarationEnd - typeParameterInfo.declarationStart + 1), new SourceRange(typeParameterInfo.nameSourceStart, typeParameterInfo.nameSourceEnd - typeParameterInfo.nameSourceStart + 1));
                ++n;
            }
        }
        this.typeModifiers[this.typeDepth] = typeInfo.modifiers;
        this.addCategories(iType, typeInfo.categories);
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        if (this.typeDepth >= 0) {
            String string;
            this.memberDeclarationStart[this.typeDepth] = fieldInfo.declarationStart;
            this.memberNameRange[this.typeDepth] = new SourceRange(fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd - fieldInfo.nameSourceStart + 1);
            this.memberName[this.typeDepth] = string = new String(fieldInfo.name);
            IType iType = this.types[this.typeDepth];
            IField iField = iType.getField(string);
            this.addCategories(iField, fieldInfo.categories);
        }
    }

    public void enterInitializer(int n, int n2) {
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbstractMethod(methodInfo);
    }

    private void enterAbstractMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        if (this.typeDepth >= 0) {
            Object object;
            IMember iMember;
            this.memberName[this.typeDepth] = new String(methodInfo.name);
            this.memberNameRange[this.typeDepth] = new SourceRange(methodInfo.nameSourceStart, methodInfo.nameSourceEnd - methodInfo.nameSourceStart + 1);
            this.memberDeclarationStart[this.typeDepth] = methodInfo.declarationStart;
            IType iType = this.types[this.typeDepth];
            int n = this.typeModifiers[this.typeDepth];
            char[][] cArray = methodInfo.parameterTypes;
            if (cArray != null && methodInfo.isConstructor && iType.getDeclaringType() != null && !Flags.isStatic(n)) {
                iMember = iType.getDeclaringType();
                String string = iMember.getElementName();
                if (string.length() == 0) {
                    IClassFile iClassFile = iMember.getClassFile();
                    int n2 = cArray.length;
                    object = new char[n2 + 1][];
                    string = iClassFile.getElementName();
                    string = string.substring(0, string.indexOf(46));
                    object[0] = string.toCharArray();
                    System.arraycopy(cArray, 0, object, 1, n2);
                    this.methodParameterTypes[this.typeDepth] = object;
                } else {
                    int n3 = cArray.length;
                    char[][] cArrayArray = new char[n3 + 1][];
                    cArrayArray[0] = string.toCharArray();
                    System.arraycopy(cArray, 0, cArrayArray, 1, n3);
                    this.methodParameterTypes[this.typeDepth] = cArrayArray;
                }
            } else {
                this.methodParameterTypes[this.typeDepth] = cArray;
            }
            this.methodParameterNames[this.typeDepth] = methodInfo.parameterNames;
            iMember = iType.getMethod(this.memberName[this.typeDepth], this.convertTypeNamesToSigs(this.methodParameterTypes[this.typeDepth]));
            if (methodInfo.typeParameters != null) {
                int n4 = 0;
                int n5 = methodInfo.typeParameters.length;
                while (n4 < n5) {
                    ISourceElementRequestor.TypeParameterInfo typeParameterInfo = methodInfo.typeParameters[n4];
                    object = iMember.getTypeParameter(new String(typeParameterInfo.name));
                    this.setSourceRange((IJavaElement)object, new SourceRange(typeParameterInfo.declarationStart, typeParameterInfo.declarationEnd - typeParameterInfo.declarationStart + 1), new SourceRange(typeParameterInfo.nameSourceStart, typeParameterInfo.nameSourceEnd - typeParameterInfo.nameSourceStart + 1));
                    ++n4;
                }
            }
            this.addCategories(iMember, methodInfo.categories);
        }
    }

    public void exitType(int n) {
        if (this.typeDepth >= 0) {
            IType iType = this.types[this.typeDepth];
            this.setSourceRange(iType, new SourceRange(this.typeDeclarationStarts[this.typeDepth], n - this.typeDeclarationStarts[this.typeDepth] + 1), this.typeNameRanges[this.typeDepth]);
            --this.typeDepth;
        }
    }

    public void exitCompilationUnit(int n) {
    }

    public void exitConstructor(int n) {
        this.exitAbstractMethod(n);
    }

    public void exitField(int n, int n2, int n3) {
        if (this.typeDepth >= 0) {
            IType iType = this.types[this.typeDepth];
            this.setSourceRange(iType.getField(this.memberName[this.typeDepth]), new SourceRange(this.memberDeclarationStart[this.typeDepth], n2 - this.memberDeclarationStart[this.typeDepth] + 1), this.memberNameRange[this.typeDepth]);
        }
    }

    public void exitInitializer(int n) {
    }

    public void exitMethod(int n, int n2, int n3) {
        this.exitAbstractMethod(n);
    }

    private void exitAbstractMethod(int n) {
        if (this.typeDepth >= 0) {
            IType iType = this.types[this.typeDepth];
            SourceRange sourceRange = new SourceRange(this.memberDeclarationStart[this.typeDepth], n - this.memberDeclarationStart[this.typeDepth] + 1);
            IMethod iMethod = iType.getMethod(this.memberName[this.typeDepth], this.convertTypeNamesToSigs(this.methodParameterTypes[this.typeDepth]));
            this.setSourceRange(iMethod, sourceRange, this.memberNameRange[this.typeDepth]);
            this.setMethodParameterNames(iMethod, this.methodParameterNames[this.typeDepth]);
        }
    }

    public char[] findSource(IType iType, IBinaryType iBinaryType) {
        if (!iType.isBinary()) {
            return null;
        }
        String string = ((BinaryType)iType).getSourceFileName(iBinaryType);
        if (string == null) {
            return null;
        }
        return this.findSource(iType, string);
    }

    public char[] findSource(IType iType, String string) {
        long l = 0L;
        if (VERBOSE) {
            l = System.currentTimeMillis();
        }
        PackageFragment packageFragment = (PackageFragment)iType.getPackageFragment();
        String string2 = Util.concatWith(packageFragment.names, string, '/');
        char[] cArray = null;
        if (this.rootPath != null) {
            cArray = this.getSourceForRootPath(this.rootPath, string2);
        }
        if (cArray == null) {
            this.computeAllRootPaths(iType);
            if (this.rootPaths != null) {
                Iterator iterator = this.rootPaths.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3.equals(this.rootPath) || (cArray = this.getSourceForRootPath(string3, string2)) == null) continue;
                    this.rootPath = string3;
                    break;
                }
            }
        }
        if (VERBOSE) {
            System.out.println("spent " + (System.currentTimeMillis() - l) + "ms for " + iType.getElementName());
        }
        return cArray;
    }

    private char[] getSourceForRootPath(String string, String string2) {
        String string3 = !string.equals("") ? (string.endsWith("/") ? String.valueOf(string) + string2 : String.valueOf(string) + '/' + string2) : string2;
        return this.findSource(string3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] findSource(String string) {
        char[] cArray;
        block11: {
            cArray = null;
            if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block11;
            ZipEntry zipEntry = null;
            ZipFile zipFile = null;
            JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
            try {
                try {
                    zipFile = javaModelManager.getZipFile(this.sourcePath);
                    zipEntry = zipFile.getEntry(string);
                    if (zipEntry != null) {
                        cArray = this.readSource(zipEntry, zipFile);
                    }
                }
                catch (CoreException coreException) {
                    Object var6_10 = null;
                    javaModelManager.closeZipFile(zipFile);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                javaModelManager.closeZipFile(zipFile);
                throw throwable;
            }
            {
                Object var6_12 = null;
                javaModelManager.closeZipFile(zipFile);
                return cArray;
            }
        }
        Object object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
        if (object instanceof IResource) {
            if (!(object instanceof IContainer)) return cArray;
            IResource iResource = ((IContainer)object).findMember(string);
            if (!(iResource instanceof IFile)) return cArray;
            try {
                return Util.getResourceContentsAsCharArray((IFile)iResource);
            }
            catch (JavaModelException javaModelException) {
                return cArray;
            }
        }
        if (!(object instanceof File)) return cArray;
        File file = (File)object;
        if (!file.isDirectory()) return cArray;
        File file2 = new File(file, string);
        if (!file2.isFile()) return cArray;
        try {
            return org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(file2, this.encoding);
        }
        catch (IOException iOException) {}
        return cArray;
    }

    public SourceRange getNameRange(IJavaElement object) {
        Object[] objectArray;
        switch (object.getElementType()) {
            case 9: {
                if (!((IMember)object).isBinary()) break;
                objectArray = this.getUnqualifiedMethodHandle((IMethod)object, false);
                if (objectArray[1] != null && this.sourceRanges.get(objectArray[0]) == null) {
                    object = this.getUnqualifiedMethodHandle((IMethod)object, true)[0];
                    break;
                }
                object = objectArray[0];
                break;
            }
            case 15: {
                IMethod iMethod;
                objectArray = object.getParent();
                if (objectArray.getElementType() != 9 || !(iMethod = (IMethod)objectArray).isBinary()) break;
                IJavaElement[] iJavaElementArray = this.getUnqualifiedMethodHandle(iMethod, false);
                iMethod = iJavaElementArray[1] != null && this.sourceRanges.get(iJavaElementArray[0]) == null ? (IMethod)this.getUnqualifiedMethodHandle(iMethod, true)[0] : (IMethod)iJavaElementArray[0];
                object = iMethod.getTypeParameter(object.getElementName());
            }
        }
        objectArray = (SourceRange[])this.sourceRanges.get(object);
        if (objectArray == null) {
            return UNKNOWN_RANGE;
        }
        return objectArray[1];
    }

    public char[][] getMethodParameterNames(IMethod iMethod) {
        Object object;
        if (iMethod.isBinary()) {
            object = this.getUnqualifiedMethodHandle(iMethod, false);
            iMethod = object[1] != null && this.parameterNames.get(object[0]) == null ? (IMethod)this.getUnqualifiedMethodHandle(iMethod, true)[0] : (IMethod)object[0];
        }
        if ((object = (Object)((char[][])this.parameterNames.get(iMethod))) == null) {
            return null;
        }
        return object;
    }

    public SourceRange getSourceRange(IJavaElement object) {
        Object[] objectArray;
        if (!this.areRootPathsComputed && object instanceof ISourceReference) {
            try {
                return (SourceRange)((ISourceReference)object).getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                Util.log((Throwable)((Object)javaModelException), "error getting source range");
                return UNKNOWN_RANGE;
            }
        }
        switch (object.getElementType()) {
            case 9: {
                if (!((IMember)object).isBinary()) break;
                objectArray = this.getUnqualifiedMethodHandle((IMethod)object, false);
                if (objectArray[1] != null && this.sourceRanges.get(objectArray[0]) == null) {
                    object = this.getUnqualifiedMethodHandle((IMethod)object, true)[0];
                    break;
                }
                object = objectArray[0];
                break;
            }
            case 15: {
                IMethod iMethod;
                objectArray = object.getParent();
                if (objectArray.getElementType() != 9 || !(iMethod = (IMethod)objectArray).isBinary()) break;
                IJavaElement[] iJavaElementArray = this.getUnqualifiedMethodHandle(iMethod, false);
                iMethod = iJavaElementArray[1] != null && this.sourceRanges.get(iJavaElementArray[0]) == null ? (IMethod)this.getUnqualifiedMethodHandle(iMethod, true)[0] : (IMethod)iJavaElementArray[0];
                object = iMethod.getTypeParameter(object.getElementName());
            }
        }
        objectArray = (SourceRange[])this.sourceRanges.get(object);
        if (objectArray == null) {
            return UNKNOWN_RANGE;
        }
        return objectArray[0];
    }

    protected IType getType(String string) {
        if (string.length() == 0) {
            IJavaElement iJavaElement = this.binaryType.getParent();
            String string2 = iJavaElement.getElementName();
            StringBuffer stringBuffer = new StringBuffer();
            int n = string2.lastIndexOf(36);
            int n2 = 0;
            while (n2 <= n) {
                stringBuffer.append(string2.charAt(n2));
                ++n2;
            }
            stringBuffer.append(Integer.toString(this.anonymousCounter));
            PackageFragment packageFragment = (PackageFragment)iJavaElement.getParent();
            return new BinaryType(new ClassFile(packageFragment, stringBuffer.toString()), string);
        }
        if (this.binaryType.getElementName().equals(string)) {
            return this.binaryType;
        }
        return this.binaryType.getType(string);
    }

    protected IJavaElement[] getUnqualifiedMethodHandle(IMethod iMethod, boolean bl) {
        boolean bl2 = false;
        String[] stringArray = iMethod.getParameterTypes();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer();
            this.getUnqualifiedTypeSignature(stringArray[n], 0, stringArray[n].length(), stringBuffer, bl);
            stringArray2[n] = stringBuffer.toString();
            bl2 |= stringArray2[n].lastIndexOf(36) != -1;
            ++n;
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[2];
        iJavaElementArray[0] = ((IType)iMethod.getParent()).getMethod(iMethod.getElementName(), stringArray2);
        if (bl2) {
            iJavaElementArray[1] = iJavaElementArray[0];
        }
        return iJavaElementArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getUnqualifiedTypeSignature(String string, int n, int n2, StringBuffer stringBuffer, boolean bl) {
        char c;
        char c2 = string.charAt(n);
        int n3 = n + 1;
        boolean bl2 = false;
        int n4 = n;
        block15: while (n4 < n2) {
            c = string.charAt(n4);
            switch (c) {
                case '+': 
                case '-': 
                case '[': {
                    stringBuffer.append(c);
                    n = n4 + 1;
                    n3 = n + 1;
                    c2 = string.charAt(n);
                    break;
                }
                case 'L': 
                case 'Q': 
                case 'T': {
                    if (bl2) break;
                    n = ++n4;
                    bl2 = true;
                    break;
                }
                case ';': 
                case '<': {
                    n3 = n4;
                    break block15;
                }
                case '*': {
                    stringBuffer.append(c);
                    n = n4 + 1;
                    n3 = n + 1;
                    c2 = string.charAt(n);
                    break;
                }
                case '>': {
                    return n4;
                }
                case '.': {
                    n = ++n4;
                }
            }
            ++n4;
        }
        switch (c2) {
            case 'L': 
            case 'Q': 
            case 'T': {
                stringBuffer.append('Q');
                if (bl && (n4 = string.lastIndexOf(36, n3)) > n) {
                    n = n4 + 1;
                }
                n4 = n;
                while (n4 < n2) {
                    c = string.charAt(n4);
                    switch (c) {
                        case '<': {
                            stringBuffer.append(c);
                            ++n4;
                            while (string.charAt(n4 = this.getUnqualifiedTypeSignature(string, n4, n2, stringBuffer, bl)) != '>') {
                            }
                            stringBuffer.append('>');
                            break;
                        }
                        case ';': {
                            stringBuffer.append(c);
                            return n4 + 1;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                    ++n4;
                }
                return n2;
            }
        }
        stringBuffer.append(string.substring(n, n3));
        return n3;
    }

    public void mapSource(IType iType, char[] cArray, IBinaryType iBinaryType) {
        this.mapSource(iType, cArray, iBinaryType, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized ISourceRange mapSource(IType var1_1, char[] var2_2, IBinaryType var3_3, IJavaElement var4_4) {
        block14: {
            this.binaryType = (BinaryType)var1_1;
            if (this.sourceRanges.get(var1_1) != null) {
                return var4_4 != null ? this.getNameRange(var4_4) : null;
            }
            this.importsTable.remove(this.binaryType);
            this.importsCounterTable.remove(this.binaryType);
            this.searchedElement = var4_4;
            this.types = new IType[1];
            this.typeDeclarationStarts = new int[1];
            this.typeNameRanges = new SourceRange[1];
            this.typeModifiers = new int[1];
            this.typeDepth = -1;
            this.memberDeclarationStart = new int[1];
            this.memberName = new String[1];
            this.memberNameRange = new SourceRange[1];
            this.methodParameterTypes = new char[1][][];
            this.methodParameterNames = new char[1][][];
            this.anonymousCounter = 0;
            var5_5 = (HashMap)this.sourceRanges.clone();
            try {
                var6_6 = new DefaultProblemFactory();
                var7_7 = null;
                this.anonymousClassName = 0;
                if (var3_3 != null) break block14;
                try {
                    var3_3 = (IBinaryType)this.binaryType.getElementInfo();
                }
                catch (JavaModelException v0) {
                    while (true) {
                        var13_8 = null;
                        if (var4_4 != null) {
                            this.sourceRanges = var5_5;
                        }
                        this.binaryType = null;
                        this.searchedElement = null;
                        this.types = null;
                        this.typeDeclarationStarts = null;
                        this.typeNameRanges = null;
                        this.typeDepth = -1;
                        return null;
                    }
                }
            }
            catch (Throwable var14_18) {
                var13_10 = null;
                if (var4_4 != null) {
                    this.sourceRanges = var5_5;
                }
                this.binaryType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                throw var14_18;
            }
        }
        var8_11 = var3_3.isAnonymous();
        var9_12 = var3_3.getName();
        if (var8_11) {
            var10_13 = this.binaryType.getParent().getElementName();
            var10_13 = var10_13.substring(var10_13.lastIndexOf(36) + 1, var10_13.length());
            try {
                this.anonymousClassName = Integer.parseInt(var10_13);
            }
            catch (NumberFormatException v1) {}
        }
        var10_14 = this.hasToRetrieveSourceRangesForLocalClass(var9_12);
        var7_7 = new SourceElementParser(this, var6_6, new CompilerOptions(this.options), var10_14, true);
        var7_7.javadocParser.checkDocComment = false;
        var11_15 /* !! */  = this.binaryType.getCompilationUnit();
        if (var11_15 /* !! */  == null) {
            var11_15 /* !! */  = this.binaryType.getParent();
        }
        var7_7.parseCompilationUnit(new BasicCompilationUnit(var2_2, null, this.binaryType.sourceFileName(var3_3), var11_15 /* !! */ ), var10_14);
        if (var4_4 == null) ** continue;
        var15_17 = var12_16 = this.getNameRange(var4_4);
        var13_9 = null;
        if (var4_4 != null) {
            this.sourceRanges = var5_5;
        }
        this.binaryType = null;
        this.searchedElement = null;
        this.types = null;
        this.typeDeclarationStarts = null;
        this.typeNameRanges = null;
        this.typeDepth = -1;
        return var15_17;
    }

    private char[] readSource(ZipEntry zipEntry, ZipFile zipFile) {
        try {
            byte[] byArray = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(zipEntry, zipFile);
            if (byArray != null) {
                return org.eclipse.wst.jsdt.internal.compiler.util.Util.bytesToChar(byArray, this.encoding);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    protected void setMethodParameterNames(IMethod iMethod, char[][] cArray) {
        if (cArray == null) {
            cArray = CharOperation.NO_CHAR_CHAR;
        }
        this.parameterNames.put(iMethod, cArray);
    }

    protected void setSourceRange(IJavaElement iJavaElement, SourceRange sourceRange, SourceRange sourceRange2) {
        this.sourceRanges.put(iJavaElement, new SourceRange[]{sourceRange, sourceRange2});
    }

    public char[][] getImports(BinaryType binaryType) {
        Object object = (char[][])this.importsTable.get(binaryType);
        if (object != null) {
            int n = (Integer)this.importsCounterTable.get(binaryType);
            if (((char[][])object).length != n) {
                char[][] cArray = object;
                char[][] cArrayArray = new char[n][];
                object = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, n);
            }
            this.importsTable.put(binaryType, object);
        }
        return object;
    }

    private boolean hasToRetrieveSourceRangesForLocalClass(char[] cArray) {
        if (cArray == null) {
            return false;
        }
        int n = cArray.length;
        int n2 = CharOperation.indexOf('$', cArray, 0);
        while (n2 != -1) {
            int n3 = n2 + 1;
            if (n3 == n) {
                return false;
            }
            if (Character.isDigit(cArray[n3])) {
                return true;
            }
            n2 = CharOperation.indexOf('$', cArray, n3);
        }
        return false;
    }
}

