/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.SourceRefElementInfo;
import org.eclipse.wst.jsdt.internal.core.util.DOMFinder;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public abstract class SourceRefElement
extends JavaElement
implements ISourceReference {
    public int occurrenceCount = 1;

    protected SourceRefElement(JavaElement javaElement) {
        super(javaElement);
    }

    protected void closing(Object object) throws JavaModelException {
    }

    protected Object createElementInfo() {
        return null;
    }

    public void copy(IJavaElement iJavaElement, IJavaElement iJavaElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElement == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        IJavaElement[] iJavaElementArray2 = new IJavaElement[]{iJavaElement};
        IJavaElement[] iJavaElementArray3 = null;
        if (iJavaElement2 != null) {
            iJavaElementArray3 = new IJavaElement[]{iJavaElement2};
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.getJavaModel().copy(iJavaElementArray, iJavaElementArray2, iJavaElementArray3, stringArray, bl, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        this.getJavaModel().delete(iJavaElementArray, bl, iProgressMonitor);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourceRefElement)) {
            return false;
        }
        return this.occurrenceCount == ((SourceRefElement)object).occurrenceCount && super.equals(object);
    }

    public ASTNode findNode(CompilationUnit compilationUnit) {
        DOMFinder dOMFinder = new DOMFinder(compilationUnit, this, false);
        try {
            return dOMFinder.search();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected void generateInfos(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable == null) {
            return;
        }
        JavaElementInfo javaElementInfo = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(openable);
        if (javaElementInfo == null) {
            openable.generateInfos(openable.createElementInfo(), hashMap, iProgressMonitor);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getAncestor(5);
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return null;
    }

    public IJavaElement getHandleFromMemento(String string, MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        switch (string.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(mementoTokenizer, workingCopyOwner);
            }
        }
        return this;
    }

    protected void getHandleMemento(StringBuffer stringBuffer) {
        super.getHandleMemento(stringBuffer);
        if (this.occurrenceCount > 1) {
            stringBuffer.append('!');
            stringBuffer.append(this.occurrenceCount);
        }
    }

    public IJavaElement getHandleUpdatingCountFromMemento(MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        if (!mementoTokenizer.hasMoreTokens()) {
            return this;
        }
        this.occurrenceCount = Integer.parseInt(mementoTokenizer.nextToken());
        if (!mementoTokenizer.hasMoreTokens()) {
            return this;
        }
        String string = mementoTokenizer.nextToken();
        return this.getHandleFromMemento(string, mementoTokenizer, workingCopyOwner);
    }

    public int getOccurrenceCount() {
        return this.occurrenceCount;
    }

    public IOpenable getOpenableParent() {
        IJavaElement iJavaElement = this.getParent();
        while (iJavaElement != null) {
            if (iJavaElement instanceof IOpenable) {
                return (IOpenable)((Object)iJavaElement);
            }
            iJavaElement = iJavaElement.getParent();
        }
        return null;
    }

    public IPath getPath() {
        return this.getParent().getPath();
    }

    public IResource getResource() {
        return this.getParent().getResource();
    }

    public String getSource() throws JavaModelException {
        IOpenable iOpenable = this.getOpenableParent();
        IBuffer iBuffer = iOpenable.getBuffer();
        if (iBuffer == null) {
            return null;
        }
        ISourceRange iSourceRange = this.getSourceRange();
        int n = iSourceRange.getOffset();
        int n2 = iSourceRange.getLength();
        if (n == -1 || n2 == 0) {
            return null;
        }
        try {
            return iBuffer.getText(n, n2);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        SourceRefElementInfo sourceRefElementInfo = (SourceRefElementInfo)this.getElementInfo();
        return sourceRefElementInfo.getSourceRange();
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getParent().getUnderlyingResource();
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return true;
    }

    public void move(IJavaElement iJavaElement, IJavaElement iJavaElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElement == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        if (this.getClassFile() != null) {
            throw new JavaModelException(new JavaModelStatus(976, this));
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        IJavaElement[] iJavaElementArray2 = new IJavaElement[]{iJavaElement};
        IJavaElement[] iJavaElementArray3 = null;
        if (iJavaElement2 != null) {
            iJavaElementArray3 = new IJavaElement[]{iJavaElement2};
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.getJavaModel().move(iJavaElementArray, iJavaElementArray2, iJavaElementArray3, stringArray, bl, iProgressMonitor);
    }

    public void rename(String string, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        if (this.getClassFile() != null) {
            throw new JavaModelException(new JavaModelStatus(976, this));
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        IJavaElement[] iJavaElementArray2 = new IJavaElement[]{this.getParent()};
        String[] stringArray = new String[]{string};
        this.getJavaModel().rename(iJavaElementArray, iJavaElementArray2, stringArray, bl, iProgressMonitor);
    }

    protected void toStringName(StringBuffer stringBuffer) {
        super.toStringName(stringBuffer);
        if (this.occurrenceCount > 1) {
            stringBuffer.append("#");
            stringBuffer.append(this.occurrenceCount);
        }
    }
}

