/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClasspathDirectory
extends ClasspathLocation {
    IContainer binaryFolder;
    boolean isOutputFolder;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];
    AccessRuleSet accessRuleSet;

    ClasspathDirectory(IContainer iContainer, boolean bl, AccessRuleSet accessRuleSet) {
        this.binaryFolder = iContainer;
        this.isOutputFolder = bl;
        this.directoryCache = new SimpleLookupTable(5);
        this.accessRuleSet = accessRuleSet;
    }

    public void cleanup() {
        this.directoryCache = null;
    }

    String[] directoryList(String string) {
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder) {
            return null;
        }
        if (stringArray != null) {
            return stringArray;
        }
        try {
            IResource iResource = this.binaryFolder.findMember(string);
            if (iResource instanceof IContainer) {
                IResource[] iResourceArray = ((IContainer)iResource).members();
                stringArray = new String[iResourceArray.length];
                int n = 0;
                int n2 = 0;
                int n3 = iResourceArray.length;
                while (n2 < n3) {
                    IResource iResource2 = iResourceArray[n2];
                    if (iResource2.getType() == 1 && org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(iResource2.getName())) {
                        stringArray[n++] = iResource2.getName();
                    }
                    ++n2;
                }
                if (n < stringArray.length) {
                    String[] stringArray2 = stringArray;
                    stringArray = new String[n];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                }
                this.directoryCache.put(string, stringArray);
                return stringArray;
            }
        }
        catch (CoreException coreException) {}
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String string, String string2, String string3) {
        String[] stringArray = this.directoryList(string2);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClasspathDirectory)) {
            return false;
        }
        ClasspathDirectory classpathDirectory = (ClasspathDirectory)object;
        if (!(this.accessRuleSet == classpathDirectory.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(classpathDirectory.accessRuleSet))) {
            return false;
        }
        return this.binaryFolder.equals((Object)classpathDirectory.binaryFolder);
    }

    public NameEnvironmentAnswer findClass(String string, String string2, String string3) {
        if (!this.doesFileExist(string, string2, string3)) {
            return null;
        }
        ClassFileReader classFileReader = null;
        try {
            classFileReader = Util.newClassFileReader((IResource)this.binaryFolder.getFile((IPath)new Path(string3)));
        }
        catch (CoreException coreException) {
            return null;
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (classFileReader != null) {
            if (this.accessRuleSet == null) {
                return new NameEnvironmentAnswer(classFileReader, null);
            }
            String string4 = string3.substring(0, string3.length() - SuffixConstants.SUFFIX_CLASS.length);
            return new NameEnvironmentAnswer(classFileReader, this.accessRuleSet.getViolatedRestriction(string4.toCharArray()));
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        return this.binaryFolder.getProjectRelativePath();
    }

    protected boolean isExcluded(IResource iResource) {
        return false;
    }

    public boolean isOutputFolder() {
        return this.isOutputFolder;
    }

    public boolean isPackage(String string) {
        return this.directoryList(string) != null;
    }

    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        String string = "Binary classpath directory " + this.binaryFolder.getFullPath().toString();
        if (this.accessRuleSet == null) {
            return string;
        }
        return String.valueOf(string) + " with " + this.accessRuleSet;
    }

    public String debugPathString() {
        return this.binaryFolder.getFullPath().toString();
    }
}

